/*
 * Decompiled with CFR 0.152.
 */
package option.zima2.shape.main.creator;

import java.awt.Color;
import java.util.Vector;
import model.parts.Parts;
import option.zima2.common.entity.TerraceInfo;
import option.zima2.common.entity.TerracesInfo;
import option.zima2.common.entity.ZM2Entities;
import option.zima2.common.service.common.ZM2Color;
import option.zima2.common.type.EnforcementDirType;
import option.zima2.common.type.EnforcementType;
import option.zima2.common.type.TerraceWidthType;
import option.zima2.shape.main.creator.ZM2TerraceUnitCreator;
import option.zima2.shape.main.item.AbstractTerraceUnitItem;
import option.zima2.shape.main.item.MsItemTerrace;
import option.zima2.shape.main.parts.PTarukiGake;

public class MsUnitTarukiGakeCreator
extends ZM2TerraceUnitCreator {
    @Override
    public void create(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        TerracesInfo terracesInfo = abstractTerraceUnitItem.getTerraceItem().getEntities().mTerracesInfo;
        EnforcementType enforcementType = terracesInfo.mEnforcementType;
        if (enforcementType == EnforcementType.STD || enforcementType == EnforcementType.BUBUN_IRISUMI) {
            this.createStandard(abstractTerraceUnitItem, parts);
        } else if (enforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI) {
            this.createKutaiDehabaChigai(abstractTerraceUnitItem, parts);
        }
    }

    private void createStandard(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        double d = terraceInfo.mWidth.floatValue() / 2.0f;
        double d2 = -d - 31.2;
        double d3 = d + 31.2;
        double d4 = 0.0;
        double d5 = msItemTerrace.getFloorlevel() + this.mPartsFigureService.getWallHeight(msItemTerrace);
        this.createTarukiGake(d2, d3, d4, d5, 0.0, parts);
    }

    private void createKutaiDehabaChigai(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        double d;
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        double d2 = msItemTerrace.getFloorlevel() + this.mPartsFigureService.getWallHeight(msItemTerrace);
        double d3 = terraceInfo.mWidth.floatValue() / 2.0f;
        double d4 = -d3 - 31.2;
        double d5 = d3 + 31.2;
        double d6 = 0.0;
        double d7 = d2;
        double d8 = 0.0;
        double d9 = 0.0;
        if (terraceInfo.mIsStarting.booleanValue()) {
            if (terraceInfo.mLeftWidthType == TerraceWidthType.DEPTH || terraceInfo.mRightWidthType == TerraceWidthType.DEPTH) {
                d9 = 0.0;
                d8 = terracesInfo.mEnforcementDirType == EnforcementDirType.R ? (double)terraceInfo.mRightWidth.floatValue() : (double)terraceInfo.mLeftWidth.floatValue();
            } else if (terracesInfo.mEnforcementDirType == EnforcementDirType.R) {
                d9 = terracesInfo.mDepth.floatValue() - terraceInfo.mRightDepth.floatValue();
                d8 = terraceInfo.mRightWidth.floatValue();
            } else {
                d9 = terracesInfo.mDepth.floatValue() - terraceInfo.mLeftDepth.floatValue();
                d8 = terraceInfo.mLeftWidth.floatValue();
            }
        } else {
            d9 = terracesInfo.mDepth.floatValue() - terraceInfo.mDepth.floatValue();
            d8 = 0.0;
        }
        double d10 = Math.tan(Math.toRadians(5.0));
        double d11 = abstractTerraceUnitItem.getPrev() == null ? 31.2 : 0.0;
        double d12 = d = abstractTerraceUnitItem.getNext() == null ? 31.2 : 0.0;
        if (terracesInfo.mEnforcementDirType == EnforcementDirType.R) {
            if (terraceInfo.mIsStarting.booleanValue()) {
                d4 = -d3 - d11;
                d5 = d3 - d8 + 31.2;
                this.createTarukiGake(d4, d5, d6, d7, 0.0, parts);
                d4 = d5;
                d5 = d3 + d;
                d6 = -d9;
                this.createTarukiGake(d4, d5, d6, d7 += d6 * d10, 0.0, parts);
            } else {
                d4 = -d3 - d11;
                d5 = d3 + d;
                double d13 = d7 - d9 * d10;
                this.createTarukiGake(d4, d5, d6 - d9, d13, 0.0, parts);
            }
        } else if (terraceInfo.mIsStarting.booleanValue()) {
            d4 = -d3 - d11;
            d5 = -d3 + d8 - 31.2;
            d6 = -d9;
            this.createTarukiGake(d4, d5, d6, d7 += d6 * d10, 0.0, parts);
            d7 = d2;
            d4 = d5;
            d5 = d3 + d;
            d6 = 0.0;
            this.createTarukiGake(d4, d5, d6, d7, 0.0, parts);
        } else {
            d4 = -d3 - d11;
            d5 = d3 + d;
            double d14 = d7 - d9 * d10;
            this.createTarukiGake(d4, d5, d6 - d9, d14, 0.0, parts);
        }
    }

    private void createTarukiGake(double d, double d2, double d3, double d4, double d5, Parts parts) {
        Vector vector = parts.getChildren(true);
        Color color = ZM2Color.getColor(this.mShapeColorManager.getColor(0));
        PTarukiGake pTarukiGake = new PTarukiGake();
        pTarukiGake.set(d, d2, d3, d4, d5, color);
        vector.add(pTarukiGake);
    }
}

