/*
 * Decompiled with CFR 0.152.
 */
package option.zima2.shape.main.creator;

import java.awt.Color;
import java.util.List;
import java.util.Vector;
import model.parts.Parts;
import option.gad.core.util.GdMutableTypeUtil;
import option.zima2.common.entity.TerraceInfo;
import option.zima2.common.entity.ZM2Entities;
import option.zima2.common.entity.option.GeneralOptionInfo;
import option.zima2.common.entity.option.OptionInfo;
import option.zima2.common.service.common.ZM2Color;
import option.zima2.common.type.NokiPlusSideType;
import option.zima2.common.type.SupportFrameSizeType;
import option.zima2.shape.main.creator.ZM2TerraceUnitCreator;
import option.zima2.shape.main.item.AbstractTerraceUnitItem;
import option.zima2.shape.main.item.MsItemTerrace;
import option.zima2.shape.main.parts.PSupportFrameGrating;
import option.zima2.shape.main.parts.PSupportFrameGratingCenterBase;
import option.zima2.shape.main.parts.PSupportFrameGratingEdgeBaseL;
import option.zima2.shape.main.parts.PSupportFrameGratingEdgeBaseR;

public class MsUnitSupportFrameGratingCreator
extends ZM2TerraceUnitCreator {
    @Override
    public void create(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        ZM2Entities zM2Entities = abstractTerraceUnitItem.getTerraceItem().getEntities();
        GeneralOptionInfo generalOptionInfo = this.mOptionCommonService.findSupportFrame(zM2Entities.mOptionInfoList);
        if (generalOptionInfo == null) {
            return;
        }
        SupportFrameSizeType supportFrameSizeType = this.mOptionCommonService.findSupportFrameSizeType(zM2Entities.mOptionInfoList);
        if (supportFrameSizeType == SupportFrameSizeType.T0) {
            this.createT0(abstractTerraceUnitItem, generalOptionInfo, vector);
        } else if (supportFrameSizeType == SupportFrameSizeType.T100) {
            this.createT100(abstractTerraceUnitItem, generalOptionInfo, vector);
        } else if (supportFrameSizeType == SupportFrameSizeType.T400) {
            this.createT400(abstractTerraceUnitItem, generalOptionInfo, vector);
        }
    }

    protected void createT0(AbstractTerraceUnitItem abstractTerraceUnitItem, GeneralOptionInfo generalOptionInfo, List<Parts> list) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        float[] fArray = this.makeGratingPitch(abstractTerraceUnitItem);
        float f = this.calcX1(terraceInfo);
        this.calcX2(terraceInfo);
        float f2 = this.calcY1(terraceInfo, zM2Entities.mOptionInfoList);
        float f3 = this.calcY2(terraceInfo, zM2Entities.mOptionInfoList);
        float f4 = this.calcZ(msItemTerrace);
        this.createGrating(f, f2, f3, f4, -60.0f, fArray, generalOptionInfo, list);
    }

    protected void createT100(AbstractTerraceUnitItem abstractTerraceUnitItem, GeneralOptionInfo generalOptionInfo, List<Parts> list) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        float[] fArray = this.makeGratingPitch(abstractTerraceUnitItem);
        float f = this.calcX1(terraceInfo);
        this.calcX2(terraceInfo);
        float f2 = this.calcY1(terraceInfo, zM2Entities.mOptionInfoList);
        float f3 = this.calcY2(terraceInfo, zM2Entities.mOptionInfoList);
        float f4 = this.calcZ(msItemTerrace);
        float f5 = 65.0f;
        this.createGrating(f, f2, f3, f4, f5, fArray, generalOptionInfo, list);
    }

    protected void createT400(AbstractTerraceUnitItem abstractTerraceUnitItem, GeneralOptionInfo generalOptionInfo, List<Parts> list) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        float[] fArray = this.makeGratingPitch(abstractTerraceUnitItem);
        float f = this.calcX1(terraceInfo);
        this.calcX2(terraceInfo);
        float f2 = this.calcY1(terraceInfo, zM2Entities.mOptionInfoList);
        float f3 = this.calcY2(terraceInfo, zM2Entities.mOptionInfoList);
        float f4 = this.calcZ(msItemTerrace);
        this.createGrating(f, f2, f3, f4, 0.0f, fArray, generalOptionInfo, list);
    }

    protected float[] makeGratingPitch(AbstractTerraceUnitItem abstractTerraceUnitItem) {
        int n;
        int n2;
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        float[] fArray = abstractTerraceUnitItem.getPitches();
        int n3 = 0;
        int n4 = fArray.length;
        if (GdMutableTypeUtil.matchOR(terraceInfo.mNokiPlusSideType, NokiPlusSideType.L, NokiPlusSideType.BOTH)) {
            n2 = 0;
            n = 0;
            while (n < fArray.length) {
                if ((float)(n2 = (int)((float)n2 + fArray[n])) <= terraceInfo.mLeftWidth.floatValue()) {
                    ++n3;
                }
                ++n;
            }
        }
        if (GdMutableTypeUtil.matchOR(terraceInfo.mNokiPlusSideType, NokiPlusSideType.R, NokiPlusSideType.BOTH)) {
            n2 = 0;
            n = fArray.length - 1;
            while (n >= 0) {
                if ((float)(n2 = (int)((float)n2 + fArray[n])) <= terraceInfo.mRightWidth.floatValue()) {
                    --n4;
                }
                --n;
            }
        }
        n2 = n4 - n3;
        float[] fArray2 = new float[n2];
        int n5 = 0;
        while (n5 < n2) {
            fArray2[n5] = fArray[n5 + n3];
            ++n5;
        }
        return fArray2;
    }

    protected void createGrating(float f, float f2, float f3, float f4, float f5, float[] fArray, GeneralOptionInfo generalOptionInfo, List<Parts> list) {
        float f6 = f;
        int n = 0;
        while (n < fArray.length) {
            float f7 = f6;
            float f8 = f7 + fArray[n];
            if (n == 0) {
                f7 += 32.5f - f5;
            }
            if (n == fArray.length - 1) {
                f8 -= 32.5f - f5;
            }
            this.createGrating(f7 + 4.0f, f8 - 4.0f, f2, f3, f4, generalOptionInfo, list);
            boolean bl = n == 0;
            boolean bl2 = n == fArray.length - 1;
            this.createGratingBase(f7 + 4.0f, f8 - 4.0f, f2, f3, f4, bl, bl2, f5, generalOptionInfo, list);
            f6 += fArray[n];
            ++n;
        }
    }

    protected void createGrating(float f, float f2, float f3, float f4, float f5, GeneralOptionInfo generalOptionInfo, List<Parts> list) {
        Color color = ZM2Color.getColor(generalOptionInfo.mColorType);
        PSupportFrameGrating pSupportFrameGrating = new PSupportFrameGrating();
        pSupportFrameGrating.set(f, f2, f3, f4, f5, color);
        list.add(pSupportFrameGrating);
    }

    protected void createGratingBase(float f, float f2, float f3, float f4, float f5, boolean bl, boolean bl2, float f6, GeneralOptionInfo generalOptionInfo, List<Parts> list) {
        float f7;
        float f8;
        float f9;
        Color color = ZM2Color.getColor(generalOptionInfo.mColorType);
        float f10 = f2 - f;
        float f11 = f + f10 / 3.0f;
        float f12 = f + f10 / 3.0f * 2.0f;
        float f13 = Math.abs(f4 - f3);
        float f14 = f5 - 30.0f;
        this.createGratingCenterBase(f11, f3, f14, f13, color, list);
        this.createGratingCenterBase(f12, f3, f14, f13, color, list);
        if (bl) {
            f9 = 58.0f + f6;
            f8 = f13 - 120.0f;
            f7 = 120.0f;
            if (f8 > 0.0f) {
                this.createGratingEdgeBaseLeft(f - 2.0f, f3, f14, f8, color, list);
            }
            if (f7 > 0.0f) {
                this.createGratingEdgeBaseLeft(f - 2.0f + f9, f3 - f8, f14, f7, color, list);
            }
        } else {
            this.createGratingEdgeBaseLeft(f - 2.0f, f3, f14, f13, color, list);
        }
        if (bl2) {
            f9 = 58.0f + f6;
            f8 = f13 - 120.0f;
            f7 = 120.0f;
            if (f8 > 0.0f) {
                this.createGratingEdgeBaseRight(f2 + 2.0f, f3, f14, f8, color, list);
            }
            if (f7 > 0.0f) {
                this.createGratingEdgeBaseRight(f2 + 2.0f - f9, f3 - f8, f14, f7, color, list);
            }
        } else {
            this.createGratingEdgeBaseRight(f2 + 2.0f, f3, f14, f13, color, list);
        }
    }

    protected void createGratingCenterBase(float f, float f2, float f3, float f4, Color color, List<Parts> list) {
        PSupportFrameGratingCenterBase pSupportFrameGratingCenterBase = new PSupportFrameGratingCenterBase();
        pSupportFrameGratingCenterBase.set(f, f2, f3, f4, color);
        list.add(pSupportFrameGratingCenterBase);
    }

    protected void createGratingEdgeBaseLeft(float f, float f2, float f3, float f4, Color color, List<Parts> list) {
        PSupportFrameGratingEdgeBaseL pSupportFrameGratingEdgeBaseL = new PSupportFrameGratingEdgeBaseL();
        pSupportFrameGratingEdgeBaseL.set(f, f2, f3, f4, color);
        list.add(pSupportFrameGratingEdgeBaseL);
    }

    protected void createGratingEdgeBaseRight(float f, float f2, float f3, float f4, Color color, List<Parts> list) {
        PSupportFrameGratingEdgeBaseR pSupportFrameGratingEdgeBaseR = new PSupportFrameGratingEdgeBaseR();
        pSupportFrameGratingEdgeBaseR.set(f, f2, f3, f4, color);
        list.add(pSupportFrameGratingEdgeBaseR);
    }

    protected float calcX1(TerraceInfo terraceInfo) {
        float f = -terraceInfo.mWidth.floatValue() / 2.0f;
        if (GdMutableTypeUtil.matchOR(terraceInfo.mNokiPlusSideType, NokiPlusSideType.L, NokiPlusSideType.BOTH)) {
            f += terraceInfo.mLeftWidth.floatValue();
        }
        return f;
    }

    protected float calcX2(TerraceInfo terraceInfo) {
        float f = terraceInfo.mWidth.floatValue() / 2.0f;
        if (GdMutableTypeUtil.matchOR(terraceInfo.mNokiPlusSideType, NokiPlusSideType.R, NokiPlusSideType.BOTH)) {
            f -= terraceInfo.mRightWidth.floatValue();
        }
        return f;
    }

    protected float calcY1(TerraceInfo terraceInfo, List<OptionInfo> list) {
        float f = this.mOptionCommonService.getSupportFrameDeph(list);
        return f;
    }

    protected float calcY2(TerraceInfo terraceInfo, List<OptionInfo> list) {
        float f = 0.0f;
        return f;
    }

    protected float calcZ(MsItemTerrace msItemTerrace) {
        float f = msItemTerrace.getFloorlevel() + 46.0f;
        return f;
    }

    protected float calcDepth(TerraceInfo terraceInfo) {
        float f = 0.0f;
        return f;
    }
}

