/*
 * Decompiled with CFR 0.152.
 */
package option.zima2.shape.main.creator;

import java.awt.Color;
import java.util.Vector;
import model.parts.Parts;
import option.zima2.common.entity.BasicInfo;
import option.zima2.common.entity.TerraceInfo;
import option.zima2.common.entity.TerracesInfo;
import option.zima2.common.entity.ZM2Entities;
import option.zima2.common.entity.type.TypeTerraceDepthInfo;
import option.zima2.common.service.common.ZM2Color;
import option.zima2.common.type.EnforcementDirType;
import option.zima2.common.type.EnforcementType;
import option.zima2.common.type.StrengthType;
import option.zima2.common.type.TerraceDepthType;
import option.zima2.shape.main.creator.ZM2TerraceUnitCreator;
import option.zima2.shape.main.item.AbstractTerraceUnitItem;
import option.zima2.shape.main.item.MsItemTerrace;
import option.zima2.shape.main.parts.PNobuchi;

public class MsUnitNobuchiCreator
extends ZM2TerraceUnitCreator {
    private static final float OFFSET_H = -12.0f;

    @Override
    public void create(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        ZM2Entities zM2Entities = abstractTerraceUnitItem.getTerraceItem().getEntities();
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        double[] dArray = this.getNobuchiPich(zM2Entities.mBasicInfo, terracesInfo, terraceInfo);
        if (dArray == null) {
            return;
        }
        EnforcementType enforcementType = terracesInfo.mEnforcementType;
        if (enforcementType == EnforcementType.STD || enforcementType == EnforcementType.BUBUN_IRISUMI) {
            this.createStandard(abstractTerraceUnitItem, parts, dArray);
        } else if (enforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI) {
            this.createKutaiDehabaChigai(abstractTerraceUnitItem, parts, dArray);
        }
    }

    private void createStandard(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts, double[] dArray) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        float[] fArray = abstractTerraceUnitItem.getPitches();
        int[] nArray = new int[2];
        nArray[1] = fArray.length - 1;
        int[] nArray2 = nArray;
        double d = terraceInfo.mWidth.floatValue() / 2.0f;
        double d2 = -d;
        double d3 = d;
        double d4 = 0.0;
        double d5 = 5.0;
        double d6 = Math.tan(Math.toRadians(5.0));
        int n = dArray.length;
        double d7 = msItemTerrace.getFloorlevel() + this.mPartsFigureService.getWallHeight(msItemTerrace);
        double d8 = 0.0;
        int n2 = 0;
        while (n2 < n) {
            d8 -= dArray[n2];
            if (!(dArray[n2] < 0.0)) {
                d4 = d8 * d6 + d7 + -12.0;
                this.createNobuchi(d2, d3, d8, d4, d5, 0.0, fArray, nArray2, parts);
            }
            ++n2;
        }
    }

    private void createKutaiDehabaChigai(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts, double[] dArray) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        float[] fArray = abstractTerraceUnitItem.getPitches();
        int[] nArray = new int[2];
        nArray[1] = fArray.length - 1;
        int[] nArray2 = nArray;
        double d = terraceInfo.mDepth.floatValue();
        double d2 = terraceInfo.mWidth.floatValue() / 2.0f;
        double d3 = -d2;
        double d4 = d2;
        double d5 = 0.0;
        double d6 = 5.0;
        double d7 = Math.tan(Math.toRadians(5.0));
        int n = dArray.length;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = msItemTerrace.getFloorlevel() + this.mPartsFigureService.getWallHeight(msItemTerrace);
        if (terraceInfo.mIsMaster.booleanValue()) {
            d = terracesInfo.mDepth.floatValue();
            if (terracesInfo.mEnforcementDirType == EnforcementDirType.R) {
                d9 = d - (double)terraceInfo.mRightDepth.floatValue();
                d8 = terraceInfo.mRightWidth.floatValue();
            } else {
                d9 = d - (double)terraceInfo.mLeftDepth.floatValue();
                d8 = terraceInfo.mLeftWidth.floatValue();
            }
            double d11 = 0.0;
            int n2 = 0;
            while (n2 < n) {
                d5 = (d11 -= dArray[n2]) * d7 + d10 + -12.0;
                double d12 = d3;
                double d13 = d4;
                if (terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
                    if (Math.abs(d11) <= d9) {
                        d12 = d3 + d8;
                    }
                } else if (Math.abs(d11) <= d9) {
                    d13 = d4 - d8;
                }
                this.findTarukiPitchIndex(d12 - d3, d13 - d3, fArray, nArray2);
                this.createNobuchi(d12, d13, d11, d5, d6, 0.0, fArray, nArray2, parts);
                ++n2;
            }
        } else {
            d9 = terracesInfo.mDepth.floatValue() - terraceInfo.mDepth.floatValue();
            double d14 = 0.0;
            int n3 = 0;
            while (n3 < n) {
                d5 = (d14 -= dArray[n3]) * d7 + d10 + -12.0;
                if (!(Math.abs(d14) <= d9)) {
                    this.createNobuchi(d3, d4, d14, d5, d6, 0.0, fArray, nArray2, parts);
                }
                ++n3;
            }
        }
    }

    private void findTarukiPitchIndex(double d, double d2, float[] fArray, int[] nArray) {
        nArray[0] = fArray.length - 1;
        nArray[1] = 0;
        double d3 = 0.0;
        int n = 0;
        while (n < fArray.length) {
            double d4 = fArray[n];
            double d5 = d3 + d4 / 2.0;
            if (d5 >= d && d5 <= d2) {
                if (nArray[0] > n) {
                    nArray[0] = n;
                }
                if (nArray[1] < n) {
                    nArray[1] = n;
                }
            }
            d3 += d4;
            ++n;
        }
    }

    private void createNobuchi(double d, double d2, double d3, double d4, double d5, double d6, Parts parts) {
        Vector vector = parts.getChildren(true);
        Color color = ZM2Color.getColor(this.mShapeColorManager.getColor(0));
        PNobuchi pNobuchi = new PNobuchi();
        pNobuchi.set(d, d2, d3, d4, d5, d6, color);
        vector.add(pNobuchi);
    }

    private void createNobuchi(double d, double d2, double d3, double d4, double d5, double d6, float[] fArray, int[] nArray, Parts parts) {
        double d7 = d;
        int n = nArray[0];
        while (n <= nArray[1]) {
            double d8 = d7 + 31.2;
            double d9 = d7 + (double)fArray[n] - 31.2;
            this.createNobuchi(d8, d9, d3, d4, d5, d6, parts);
            d7 += (double)fArray[n];
            ++n;
        }
    }

    protected double[] getNobuchiPich(BasicInfo basicInfo, TerracesInfo terracesInfo, TerraceInfo terraceInfo) {
        if (terracesInfo.mEnforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI) {
            TerraceDepthType terraceDepthType = this.mPartsFigureService.getDepthType(terracesInfo.mDepthType, terracesInfo.mDepth);
            return this.getNobuchiPich(terraceDepthType, terracesInfo.mDepth.floatValue(), basicInfo.mStrengthType, 0.0f);
        }
        TerraceDepthType terraceDepthType = this.mPartsFigureService.getDepthType(terraceInfo.mDepthType, terraceInfo.mDepth);
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneByType(terraceDepthType);
        float f = typeTerraceDepthInfo.length.floatValue() - terraceInfo.mDepth.floatValue();
        return this.getNobuchiPich(terraceDepthType, typeTerraceDepthInfo.length.floatValue(), basicInfo.mStrengthType, f);
    }

    double[] getNobuchiPich(TerraceDepthType terraceDepthType, float f, StrengthType strengthType, float f2) {
        double[] dArray = null;
        if (terraceDepthType == TerraceDepthType.T6) {
            dArray = strengthType == StrengthType.T600 ? new double[]{f / 2.0f} : new double[]{f / 3.0f, f / 3.0f};
        } else if (terraceDepthType == TerraceDepthType.T8) {
            dArray = strengthType == StrengthType.T600 ? new double[]{f / 3.0f, f / 3.0f} : new double[]{f / 4.0f, f / 4.0f, f / 4.0f};
        } else if (terraceDepthType == TerraceDepthType.T10) {
            dArray = new double[]{f / 3.0f, f / 3.0f};
        }
        if (dArray != null && f2 != 0.0f && dArray.length > 0 && f2 > 0.0f) {
            boolean bl = false;
            int n = 0;
            while (n < dArray.length) {
                if (dArray[n] <= (double)f2) {
                    f2 = (float)((double)f2 - dArray[n]);
                    dArray[n] = 0.0;
                    bl = true;
                } else {
                    int n2 = n;
                    dArray[n2] = dArray[n2] - (double)f2;
                    f2 = 0.0f;
                }
                if (f2 <= 0.0f) break;
                ++n;
            }
            if (bl) {
                double[] dArray2 = new double[dArray.length];
                int n3 = 0;
                int n4 = 0;
                while (n4 < dArray.length) {
                    if (dArray[n4] != 0.0) {
                        dArray2[n3] = dArray[n4];
                        ++n3;
                    }
                    ++n4;
                }
                if (n3 <= 0) {
                    dArray = null;
                } else {
                    dArray = new double[n3];
                    n4 = 0;
                    while (n4 < n3) {
                        dArray[n4] = dArray2[n4];
                        ++n4;
                    }
                }
            }
        }
        return dArray;
    }
}

