/*
 * Decompiled with CFR 0.152.
 */
package option.zima2.shape.main.creator;

import java.awt.Color;
import java.util.List;
import java.util.Vector;
import model.parts.Parts;
import option.zima2.common.entity.PartsFigureInfo;
import option.zima2.common.entity.TerraceInfo;
import option.zima2.common.entity.TerracesInfo;
import option.zima2.common.entity.ZM2Entities;
import option.zima2.common.service.common.ZM2Color;
import option.zima2.common.type.EnforcementType;
import option.zima2.common.type.KetaType;
import option.zima2.common.type.ZM2ColorType;
import option.zima2.shape.main.creator.ZM2TerraceUnitCreator;
import option.zima2.shape.main.item.AbstractTerraceUnitItem;
import option.zima2.shape.main.item.MsItemTerrace;
import option.zima2.shape.main.parts.PMakuita;
import option.zima2.shape.main.parts.PMakuitaLarge;

public class MsUnitMakuitaCreator
extends ZM2TerraceUnitCreator {
    private static final float OFFSET_HEIGHT = 36.5f;

    @Override
    public void create(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        if (this.mPartsFigureService.isLeftCreateOK(abstractTerraceUnitItem)) {
            this.createLeft(abstractTerraceUnitItem, parts);
        }
        if (this.mPartsFigureService.isRightCreateOK(abstractTerraceUnitItem)) {
            this.createRight(abstractTerraceUnitItem, parts);
        }
        this.createFront(abstractTerraceUnitItem, parts);
    }

    protected void createLeft(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        TerracesInfo terracesInfo = abstractTerraceUnitItem.getTerraceItem().getEntities().mTerracesInfo;
        if (terracesInfo.mEnforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI) {
            this.createLeftKutaiDehabaChigai(abstractTerraceUnitItem, parts);
        } else if (terracesInfo.mEnforcementType == EnforcementType.BUBUN_IRISUMI) {
            this.createLeftBubunIrisumi(abstractTerraceUnitItem, parts);
        } else {
            this.createLeftStandard(abstractTerraceUnitItem, parts);
        }
    }

    private void createLeftStandard(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        PartsFigureInfo partsFigureInfo = zM2Entities.mPartsFigureInfo;
        float f = this.calcX1(zM2Entities, terraceInfo, true);
        float f2 = 0.0f;
        float f3 = -partsFigureInfo.mKutaiPillarCoreDepth.floatValue() - 47.5f;
        float f4 = msItemTerrace.getFloorlevel() + this.mPartsFigureService.getFrontPoleHeight(msItemTerrace) + 36.5f;
        float f5 = f2 - f3;
        this.createMakuita(f, (f2 + f3) / 2.0f, f4, f5, -90.0f, zM2Entities.mBasicInfo.mKetaType, false, true, zM2Entities.mBasicInfo.mMakuitaColorType, parts);
    }

    private void createLeftKutaiDehabaChigai(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        PartsFigureInfo partsFigureInfo = zM2Entities.mPartsFigureInfo;
        float f = this.calcX1(zM2Entities, terraceInfo, true);
        float f2 = 0.0f;
        float f3 = -partsFigureInfo.mKutaiPillarCoreDepth.floatValue() - 47.5f;
        float f4 = msItemTerrace.getFloorlevel() + this.mPartsFigureService.getFrontPoleHeight(msItemTerrace) + 36.5f;
        f2 = terraceInfo.mIsStarting != false ? terraceInfo.mLeftDepth.floatValue() - terracesInfo.mDepth.floatValue() : terraceInfo.mDepth.floatValue() - terracesInfo.mDepth.floatValue();
        float f5 = f2 - f3;
        this.createMakuita(f, (f2 + f3) / 2.0f, f4, f5, -90.0f, zM2Entities.mBasicInfo.mKetaType, false, true, zM2Entities.mBasicInfo.mMakuitaColorType, parts);
    }

    private void createLeftBubunIrisumi(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        PartsFigureInfo partsFigureInfo = zM2Entities.mPartsFigureInfo;
        float f = this.calcX1(zM2Entities, terraceInfo, true);
        float f2 = 0.0f;
        float f3 = -partsFigureInfo.mKutaiPillarCoreDepth.floatValue() - 47.5f;
        float f4 = msItemTerrace.getFloorlevel() + this.mPartsFigureService.getFrontPoleHeight(msItemTerrace) + 36.5f;
        if (terraceInfo.mIsStarting.booleanValue()) {
            f2 = terraceInfo.mLeftDepth.floatValue() - terracesInfo.mDepth.floatValue();
        }
        float f5 = f2 - f3;
        this.createMakuita(f, (f2 + f3) / 2.0f, f4, f5, -90.0f, zM2Entities.mBasicInfo.mKetaType, false, true, zM2Entities.mBasicInfo.mMakuitaColorType, parts);
    }

    protected void createRight(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        TerracesInfo terracesInfo = abstractTerraceUnitItem.getTerraceItem().getEntities().mTerracesInfo;
        if (terracesInfo.mEnforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI) {
            this.createRightKutaiDehabaChigai(abstractTerraceUnitItem, parts);
        } else if (terracesInfo.mEnforcementType == EnforcementType.BUBUN_IRISUMI) {
            this.createRightBubunIrisumi(abstractTerraceUnitItem, parts);
        } else {
            this.createRightStandard(abstractTerraceUnitItem, parts);
        }
    }

    private void createRightStandard(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        PartsFigureInfo partsFigureInfo = zM2Entities.mPartsFigureInfo;
        float f = this.calcX2(zM2Entities, terraceInfo, true);
        float f2 = 0.0f;
        float f3 = -partsFigureInfo.mKutaiPillarCoreDepth.floatValue() - 47.5f;
        float f4 = msItemTerrace.getFloorlevel() + this.mPartsFigureService.getFrontPoleHeight(msItemTerrace) + 36.5f;
        float f5 = f2 - f3;
        this.createMakuita(f, (f2 + f3) / 2.0f, f4, f5, 90.0f, zM2Entities.mBasicInfo.mKetaType, true, false, zM2Entities.mBasicInfo.mMakuitaColorType, parts);
    }

    private void createRightKutaiDehabaChigai(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        PartsFigureInfo partsFigureInfo = zM2Entities.mPartsFigureInfo;
        float f = this.calcX2(zM2Entities, terraceInfo, true);
        float f2 = 0.0f;
        float f3 = -partsFigureInfo.mKutaiPillarCoreDepth.floatValue() - 47.5f;
        float f4 = msItemTerrace.getFloorlevel() + this.mPartsFigureService.getFrontPoleHeight(msItemTerrace) + 36.5f;
        f2 = terraceInfo.mIsStarting != false ? terraceInfo.mRightDepth.floatValue() - terracesInfo.mDepth.floatValue() : terraceInfo.mDepth.floatValue() - terracesInfo.mDepth.floatValue();
        float f5 = f2 - f3;
        this.createMakuita(f, (f2 + f3) / 2.0f, f4, f5, 90.0f, zM2Entities.mBasicInfo.mKetaType, true, false, zM2Entities.mBasicInfo.mMakuitaColorType, parts);
    }

    private void createRightBubunIrisumi(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        PartsFigureInfo partsFigureInfo = zM2Entities.mPartsFigureInfo;
        float f = this.calcX2(zM2Entities, terraceInfo, true);
        float f2 = 0.0f;
        float f3 = -partsFigureInfo.mKutaiPillarCoreDepth.floatValue() - 47.5f;
        float f4 = msItemTerrace.getFloorlevel() + this.mPartsFigureService.getFrontPoleHeight(msItemTerrace) + 36.5f;
        if (terraceInfo.mIsStarting.booleanValue()) {
            f2 = terraceInfo.mRightDepth.floatValue() - terracesInfo.mDepth.floatValue();
        }
        float f5 = f2 - f3;
        this.createMakuita(f, (f2 + f3) / 2.0f, f4, f5, 90.0f, zM2Entities.mBasicInfo.mKetaType, true, false, zM2Entities.mBasicInfo.mMakuitaColorType, parts);
    }

    private void createFront(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        PartsFigureInfo partsFigureInfo = zM2Entities.mPartsFigureInfo;
        boolean bl = this.mPartsFigureService.isLeftCreateOK(abstractTerraceUnitItem);
        boolean bl2 = this.mPartsFigureService.isRightCreateOK(abstractTerraceUnitItem);
        float f = this.calcX1(zM2Entities, terraceInfo, bl);
        float f2 = this.calcX2(zM2Entities, terraceInfo, bl2);
        float f3 = (f + f2) / 2.0f;
        float f4 = -partsFigureInfo.mKutaiPillarCoreDepth.floatValue() - 47.5f;
        float f5 = msItemTerrace.getFloorlevel() + this.mPartsFigureService.getFrontPoleHeight(msItemTerrace) + 36.5f;
        float f6 = f2 - f;
        this.createMakuita(f3, f4, f5, f6, 0.0f, zM2Entities.mBasicInfo.mKetaType, bl, bl2, zM2Entities.mBasicInfo.mMakuitaColorType, parts);
    }

    private float calcX1(ZM2Entities zM2Entities, TerraceInfo terraceInfo, boolean bl) {
        float f = -terraceInfo.mWidth.floatValue() / 2.0f;
        if (bl) {
            f -= -12.5f;
            f -= 45.0f;
        } else if (this.mPartsFigureService.isLeftSode(zM2Entities, terraceInfo)) {
            f -= 32.5f;
        }
        return f;
    }

    private float calcX2(ZM2Entities zM2Entities, TerraceInfo terraceInfo, boolean bl) {
        float f = terraceInfo.mWidth.floatValue() / 2.0f;
        if (bl) {
            f += -12.5f;
            f += 45.0f;
        } else if (this.mPartsFigureService.isRightSode(zM2Entities, terraceInfo)) {
            f += 32.5f;
        }
        return f;
    }

    private void createMakuita(float f, float f2, float f3, float f4, float f5, KetaType ketaType, boolean bl, boolean bl2, ZM2ColorType zM2ColorType, Parts parts) {
        Vector vector = parts.getChildren(true);
        Color color = ZM2Color.getColor(zM2ColorType);
        if (ketaType == KetaType.LARGE) {
            this.createMakuitaLarge(f, f2, f3, f4, f5, bl, bl2, color, vector);
        } else {
            this.createMakuitaNormal(f, f2, f3, f4, f5, bl, bl2, color, vector);
        }
    }

    private void createMakuitaNormal(float f, float f2, float f3, float f4, float f5, boolean bl, boolean bl2, Color color, List<Parts> list) {
        PMakuita pMakuita = new PMakuita();
        pMakuita.set(f, f2, f3, f4, f5, bl, bl2, color);
        list.add(pMakuita);
    }

    private void createMakuitaLarge(float f, float f2, float f3, float f4, float f5, boolean bl, boolean bl2, Color color, List<Parts> list) {
        PMakuitaLarge pMakuitaLarge = new PMakuitaLarge();
        pMakuitaLarge.set(f, f2, f3, f4, f5, bl, bl2, color);
        list.add(pMakuitaLarge);
    }
}

