/*
 * Decompiled with CFR 0.152.
 */
package option.zima2.shape.main.creator;

import java.awt.Color;
import java.util.List;
import java.util.Vector;
import model.parts.Parts;
import option.zima2.common.entity.TerraceInfo;
import option.zima2.common.entity.TerracesInfo;
import option.zima2.common.entity.ZM2Entities;
import option.zima2.common.service.common.ZM2Color;
import option.zima2.common.type.KetaType;
import option.zima2.common.type.NokiPlusFrontType;
import option.zima2.common.type.NokiPlusSideType;
import option.zima2.common.type.TerraceDepthType;
import option.zima2.shape.main.creator.ZM2TerraceUnitCreator;
import option.zima2.shape.main.item.AbstractTerraceUnitItem;
import option.zima2.shape.main.item.MsItemTerrace;
import option.zima2.shape.main.parts.PKetaEx;
import option.zima2.shape.main.parts.PKetaExLarge;

public class MsUnitKetaExCreator
extends ZM2TerraceUnitCreator {
    @Override
    public void create(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        if (terracesInfo.mNokiPlusFrontType == NokiPlusFrontType.EXIST) {
            float f = this.calcX1(abstractTerraceUnitItem);
            float f2 = this.calcX2(abstractTerraceUnitItem);
            float f3 = this.calcY(abstractTerraceUnitItem);
            float f4 = msItemTerrace.getFloorlevel() + terracesInfo.mHeight.floatValue();
            this.createKetaEx(f, f2, f3, f4, zM2Entities.mBasicInfo.mKetaType, vector);
        }
    }

    private float calcX1(AbstractTerraceUnitItem abstractTerraceUnitItem) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        float f = -terraceInfo.mWidth.floatValue() / 2.0f;
        if (terracesInfo.mNokiPlusSideType == NokiPlusSideType.L || terracesInfo.mNokiPlusSideType == NokiPlusSideType.BOTH) {
            f += terraceInfo.mLeftWidth.floatValue();
            f += 57.5f;
        } else if (abstractTerraceUnitItem.getPrev() == null) {
            f -= -57.5f;
        }
        return f;
    }

    private float calcX2(AbstractTerraceUnitItem abstractTerraceUnitItem) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        float f = terraceInfo.mWidth.floatValue() / 2.0f;
        if (terracesInfo.mNokiPlusSideType == NokiPlusSideType.R || terracesInfo.mNokiPlusSideType == NokiPlusSideType.BOTH) {
            f -= terraceInfo.mRightWidth.floatValue();
            f -= 57.5f;
        } else if (abstractTerraceUnitItem.getNext() == null) {
            f += -57.5f;
        }
        return f;
    }

    private float calcY(AbstractTerraceUnitItem abstractTerraceUnitItem) {
        ZM2Entities zM2Entities = abstractTerraceUnitItem.getTerraceItem().getEntities();
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        float f = -terraceInfo.mDepth.floatValue() + 690.0f + 45.0f;
        if (terraceInfo.mDepthType == TerraceDepthType.T8) {
            f = -terraceInfo.mDepth.floatValue() + 690.0f + 45.0f;
        } else if (terraceInfo.mDepthType == TerraceDepthType.T10) {
            f = -terraceInfo.mDepth.floatValue() + 730.0f + 45.0f;
        }
        if (terracesInfo.mNokiPlusFrontType == NokiPlusFrontType.EXIST) {
            f -= 39.0f;
            f -= 34.0f;
        }
        return f;
    }

    private void createKetaEx(float f, float f2, float f3, float f4, KetaType ketaType, List<Parts> list) {
        Color color = ZM2Color.getColor(this.mShapeColorManager.getColor(0));
        float f5 = (f + f2) / 2.0f;
        float f6 = Math.abs(f2 - f);
        if (ketaType == KetaType.LARGE) {
            this.createKetaExLarge(f5, f3, f4, f6, color, list);
        } else {
            this.createKetaExNormal(f5, f3, f4, f6, color, list);
        }
    }

    private void createKetaExNormal(float f, float f2, float f3, float f4, Color color, List<Parts> list) {
        PKetaEx pKetaEx = new PKetaEx();
        pKetaEx.set(f, f2, f3, f4, color);
        list.add(pKetaEx);
    }

    private void createKetaExLarge(float f, float f2, float f3, float f4, Color color, List<Parts> list) {
        PKetaExLarge pKetaExLarge = new PKetaExLarge();
        pKetaExLarge.set(f, f2, f3, f4, color);
        list.add(pKetaExLarge);
    }
}

