/*
 * Decompiled with CFR 0.152.
 */
package option.zima2.shape.main.creator;

import java.awt.Color;
import java.util.Vector;
import model.parts.Parts;
import option.zima2.common.entity.TerraceInfo;
import option.zima2.common.entity.TerracesInfo;
import option.zima2.common.entity.ZM2Entities;
import option.zima2.common.service.common.ZM2Color;
import option.zima2.common.type.EnforcementType;
import option.zima2.common.type.KetaType;
import option.zima2.common.type.NokiPlusFrontType;
import option.zima2.common.type.TerraceDepthType;
import option.zima2.shape.main.creator.ZM2TerraceUnitCreator;
import option.zima2.shape.main.item.AbstractTerraceUnitItem;
import option.zima2.shape.main.item.MsItemTerrace;
import option.zima2.shape.main.parts.PHoutate;

public class MsUnitHoutateUpperCreator
extends ZM2TerraceUnitCreator {
    @Override
    public void create(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        TerracesInfo terracesInfo = abstractTerraceUnitItem.getTerraceItem().getEntities().mTerracesInfo;
        if (this.mPartsFigureService.isLeftCreateOK(abstractTerraceUnitItem) || terracesInfo.mNokiPlusFrontType == NokiPlusFrontType.EXIST) {
            this.createLeft(abstractTerraceUnitItem, parts);
        }
        if (this.mPartsFigureService.isRightCreateOK(abstractTerraceUnitItem) || terracesInfo.mNokiPlusFrontType == NokiPlusFrontType.EXIST) {
            this.createRight(abstractTerraceUnitItem, parts);
        }
    }

    protected void createLeft(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        TerracesInfo terracesInfo = abstractTerraceUnitItem.getTerraceItem().getEntities().mTerracesInfo;
        if (terracesInfo.mEnforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI) {
            this.createLeftKutaiDehabaChigai(abstractTerraceUnitItem, parts);
        } else if (terracesInfo.mEnforcementType == EnforcementType.BUBUN_IRISUMI) {
            this.createLeftBubunIrisumi(abstractTerraceUnitItem, parts);
        } else {
            this.createLeftStandard(abstractTerraceUnitItem, parts);
        }
    }

    public void createLeftStandard(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        float f = this.getRanmaHeight(zM2Entities.mTerracesInfo, terraceInfo, zM2Entities.mBasicInfo.mKetaType);
        if (f <= 0.0f) {
            return;
        }
        float f2 = -terraceInfo.mWidth.floatValue() / 2.0f - -12.5f;
        float f3 = 0.0f;
        float f4 = msItemTerrace.getFloorlevel() + terracesInfo.mHeight.floatValue();
        float f5 = f4 + f;
        this.createUpperHoutate(f2, f3, f4, f5, parts);
    }

    public void createLeftKutaiDehabaChigai(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        float f = this.getLeftRanmaHeight(terracesInfo, terraceInfo, zM2Entities.mBasicInfo.mKetaType);
        if (f <= 0.0f) {
            return;
        }
        float f2 = -terraceInfo.mWidth.floatValue() / 2.0f - -12.5f;
        float f3 = 0.0f;
        float f4 = msItemTerrace.getFloorlevel() + terracesInfo.mHeight.floatValue();
        float f5 = f4 + f;
        f3 = terraceInfo.mIsStarting != false ? terraceInfo.mLeftDepth.floatValue() - terracesInfo.mDepth.floatValue() : terraceInfo.mDepth.floatValue() - terracesInfo.mDepth.floatValue();
        this.createUpperHoutate(f2, f3, f4, f5, parts);
    }

    public void createLeftBubunIrisumi(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        float f = this.getLeftRanmaHeight(terracesInfo, terraceInfo, zM2Entities.mBasicInfo.mKetaType);
        if (f <= 0.0f) {
            return;
        }
        float f2 = -terraceInfo.mWidth.floatValue() / 2.0f - -12.5f;
        float f3 = 0.0f;
        float f4 = msItemTerrace.getFloorlevel() + terracesInfo.mHeight.floatValue();
        float f5 = f4 + f;
        if (terraceInfo.mIsStarting.booleanValue()) {
            f3 = terraceInfo.mLeftDepth.floatValue() - terracesInfo.mDepth.floatValue();
        }
        this.createUpperHoutate(f2, f3, f4, f5, parts);
    }

    protected void createRight(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        TerracesInfo terracesInfo = abstractTerraceUnitItem.getTerraceItem().getEntities().mTerracesInfo;
        if (terracesInfo.mEnforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI) {
            this.createRightKutaiDehabaChigai(abstractTerraceUnitItem, parts);
        } else if (terracesInfo.mEnforcementType == EnforcementType.BUBUN_IRISUMI) {
            this.createRightBubunIrisumi(abstractTerraceUnitItem, parts);
        } else {
            this.createRightStandard(abstractTerraceUnitItem, parts);
        }
    }

    public void createRightStandard(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        float f = this.getRanmaHeight(zM2Entities.mTerracesInfo, terraceInfo, zM2Entities.mBasicInfo.mKetaType);
        if (f <= 0.0f) {
            return;
        }
        float f2 = terraceInfo.mWidth.floatValue() / 2.0f + -12.5f;
        float f3 = 0.0f;
        float f4 = msItemTerrace.getFloorlevel() + terracesInfo.mHeight.floatValue();
        float f5 = f4 + f;
        this.createUpperHoutate(f2, f3, f4, f5, parts);
    }

    public void createRightKutaiDehabaChigai(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        float f = this.getRightRanmaHeight(terracesInfo, terraceInfo, zM2Entities.mBasicInfo.mKetaType);
        if (f <= 0.0f) {
            return;
        }
        float f2 = terraceInfo.mWidth.floatValue() / 2.0f + -12.5f;
        float f3 = 0.0f;
        float f4 = msItemTerrace.getFloorlevel() + terracesInfo.mHeight.floatValue();
        float f5 = f4 + f;
        f3 = terraceInfo.mIsStarting != false ? terraceInfo.mRightDepth.floatValue() - terracesInfo.mDepth.floatValue() : terraceInfo.mDepth.floatValue() - terracesInfo.mDepth.floatValue();
        this.createUpperHoutate(f2, f3, f4, f5, parts);
    }

    public void createRightBubunIrisumi(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        float f = this.getRightRanmaHeight(terracesInfo, terraceInfo, zM2Entities.mBasicInfo.mKetaType);
        if (f <= 0.0f) {
            return;
        }
        float f2 = terraceInfo.mWidth.floatValue() / 2.0f + -12.5f;
        float f3 = 0.0f;
        float f4 = msItemTerrace.getFloorlevel() + terracesInfo.mHeight.floatValue();
        float f5 = f4 + f;
        if (terraceInfo.mIsStarting.booleanValue()) {
            f3 = terraceInfo.mRightDepth.floatValue() - terracesInfo.mDepth.floatValue();
        }
        this.createUpperHoutate(f2, f3, f4, f5, parts);
    }

    private void createUpperHoutate(float f, float f2, float f3, float f4, Parts parts) {
        Vector vector = parts.getChildren(true);
        Color color = ZM2Color.getColor(this.mShapeColorManager.getColor(0));
        PHoutate pHoutate = new PHoutate();
        pHoutate.set(f, f2, f3, f4, color);
        vector.add(pHoutate);
    }

    private float getRanmaHeight(TerracesInfo terracesInfo, TerraceInfo terraceInfo, KetaType ketaType) {
        float f = this.getRanmaHeight(terraceInfo.mDepthType, terraceInfo.mDepth.floatValue(), ketaType) + this.mPartsFigureService.calcDehabaCutOffsetHeight(terracesInfo);
        return f;
    }

    private float getRanmaHeight(TerraceDepthType terraceDepthType, float f, KetaType ketaType) {
        float f2 = (float)((double)f * Math.tan(Math.toRadians(5.0)));
        if (terraceDepthType == TerraceDepthType.T6) {
            f2 = 259.9f;
        } else if (terraceDepthType == TerraceDepthType.T8) {
            f2 = 312.8f;
        } else if (terraceDepthType == TerraceDepthType.T10) {
            f2 = 365.8f;
        }
        if (ketaType == KetaType.LARGE) {
            f2 += 45.0f;
        }
        return f2;
    }

    private float getLeftRanmaHeight(TerracesInfo terracesInfo, TerraceInfo terraceInfo, KetaType ketaType) {
        float f = this.getRanmaHeight(terraceInfo.mDepthType, terraceInfo.mLeftDepth.floatValue(), ketaType);
        if (terraceInfo.mIsMaster.booleanValue()) {
            f -= (float)((double)(terracesInfo.mDepth.floatValue() - terraceInfo.mLeftDepth.floatValue()) * Math.tan(Math.toRadians(5.0)));
        }
        return f;
    }

    private float getRightRanmaHeight(TerracesInfo terracesInfo, TerraceInfo terraceInfo, KetaType ketaType) {
        float f = this.getRanmaHeight(terraceInfo.mDepthType, terraceInfo.mRightDepth.floatValue(), ketaType);
        if (terraceInfo.mIsMaster.booleanValue()) {
            f -= (float)((double)(terracesInfo.mDepth.floatValue() - terraceInfo.mRightDepth.floatValue()) * Math.tan(Math.toRadians(5.0)));
        }
        return f;
    }
}

