/*
 * Decompiled with CFR 0.152.
 */
package option.zima2.shape.main.creator;

import java.awt.Color;
import java.util.Vector;
import model.parts.Parts;
import option.zima2.common.entity.TerraceInfo;
import option.zima2.common.entity.TerracesInfo;
import option.zima2.common.entity.ZM2Entities;
import option.zima2.common.service.common.ZM2Color;
import option.zima2.common.type.EnforcementType;
import option.zima2.shape.main.creator.ZM2TerraceUnitCreator;
import option.zima2.shape.main.item.AbstractTerraceUnitItem;
import option.zima2.shape.main.item.MsItemTerrace;
import option.zima2.shape.main.parts.PHoutateA;

public class MsUnitHoutateCreator
extends ZM2TerraceUnitCreator {
    @Override
    public void create(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        if (this.mPartsFigureService.isLeftCreateOK(abstractTerraceUnitItem)) {
            this.createLeft(abstractTerraceUnitItem, parts);
        }
        if (this.mPartsFigureService.isRightCreateOK(abstractTerraceUnitItem)) {
            this.createRight(abstractTerraceUnitItem, parts);
        }
    }

    protected void createLeft(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        TerracesInfo terracesInfo = abstractTerraceUnitItem.getTerraceItem().getEntities().mTerracesInfo;
        if (terracesInfo.mEnforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI) {
            this.createLeftKutaiDehabaChigai(abstractTerraceUnitItem, parts);
        } else if (terracesInfo.mEnforcementType == EnforcementType.BUBUN_IRISUMI) {
            this.createLeftBubunIrisumi(abstractTerraceUnitItem, parts);
        } else {
            this.createLeftStandard(abstractTerraceUnitItem, parts);
        }
    }

    public void createLeftStandard(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        float f = this.mSidePanelShapeService.calcLeftPanelX(msItemTerrace, terraceInfo);
        float f2 = 0.0f;
        float f3 = msItemTerrace.getFloorlevel();
        float f4 = f3 + terracesInfo.mHeight.floatValue();
        this.createPanelHoutate(f, f2, f3, f4, parts);
    }

    public void createLeftKutaiDehabaChigai(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        float f = -terraceInfo.mWidth.floatValue() / 2.0f - -32.5f;
        float f2 = 0.0f;
        float f3 = msItemTerrace.getFloorlevel();
        float f4 = f3 + terracesInfo.mHeight.floatValue();
        f2 = terraceInfo.mIsStarting != false ? terraceInfo.mLeftDepth.floatValue() - terracesInfo.mDepth.floatValue() : terraceInfo.mDepth.floatValue() - terracesInfo.mDepth.floatValue();
        this.createPanelHoutate(f, f2, f3, f4, parts);
    }

    public void createLeftBubunIrisumi(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        float f = -terraceInfo.mWidth.floatValue() / 2.0f - -32.5f;
        float f2 = 0.0f;
        float f3 = msItemTerrace.getFloorlevel();
        float f4 = f3 + terracesInfo.mHeight.floatValue();
        if (terraceInfo.mIsStarting.booleanValue()) {
            f2 = terraceInfo.mLeftDepth.floatValue() - terracesInfo.mDepth.floatValue();
        }
        this.createPanelHoutate(f, f2, f3, f4, parts);
    }

    protected void createRight(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        TerracesInfo terracesInfo = abstractTerraceUnitItem.getTerraceItem().getEntities().mTerracesInfo;
        if (terracesInfo.mEnforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI) {
            this.createRightKutaiDehabaChigai(abstractTerraceUnitItem, parts);
        } else if (terracesInfo.mEnforcementType == EnforcementType.BUBUN_IRISUMI) {
            this.createRightBubunIrisumi(abstractTerraceUnitItem, parts);
        } else {
            this.createRightStandard(abstractTerraceUnitItem, parts);
        }
    }

    public void createRightStandard(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        float f = this.mSidePanelShapeService.calcRightPanelX(msItemTerrace, terraceInfo);
        float f2 = 0.0f;
        float f3 = msItemTerrace.getFloorlevel();
        float f4 = f3 + terracesInfo.mHeight.floatValue();
        this.createPanelHoutate(f, f2, f3, f4, parts);
    }

    public void createRightKutaiDehabaChigai(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        float f = terraceInfo.mWidth.floatValue() / 2.0f + -32.5f;
        float f2 = 0.0f;
        float f3 = msItemTerrace.getFloorlevel();
        float f4 = f3 + terracesInfo.mHeight.floatValue();
        f2 = terraceInfo.mIsStarting != false ? terraceInfo.mRightDepth.floatValue() - terracesInfo.mDepth.floatValue() : terraceInfo.mDepth.floatValue() - terracesInfo.mDepth.floatValue();
        this.createPanelHoutate(f, f2, f3, f4, parts);
    }

    public void createRightBubunIrisumi(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        float f = terraceInfo.mWidth.floatValue() / 2.0f + -32.5f;
        float f2 = 0.0f;
        float f3 = msItemTerrace.getFloorlevel();
        float f4 = f3 + terracesInfo.mHeight.floatValue();
        if (terraceInfo.mIsStarting.booleanValue()) {
            f2 = terraceInfo.mRightDepth.floatValue() - terracesInfo.mDepth.floatValue();
        }
        this.createPanelHoutate(f, f2, f3, f4, parts);
    }

    private void createPanelHoutate(float f, float f2, float f3, float f4, Parts parts) {
        Vector vector = parts.getChildren(true);
        Color color = ZM2Color.getColor(this.mShapeColorManager.getColor(0));
        PHoutateA pHoutateA = new PHoutateA();
        pHoutateA.set(f, f2, f3, f4, color);
        vector.add(pHoutateA);
    }
}

