/*
 * Decompiled with CFR 0.152.
 */
package option.zima2.shape.main.creator;

import java.awt.Color;
import java.util.List;
import java.util.Vector;
import model.parts.Parts;
import option.gad.core.util.GdMutableTypeUtil;
import option.zima2.common.entity.TerraceInfo;
import option.zima2.common.entity.TerracesInfo;
import option.zima2.common.entity.ZM2Entities;
import option.zima2.common.service.common.ZM2Color;
import option.zima2.common.type.KetaType;
import option.zima2.common.type.NokiPlusSideType;
import option.zima2.common.type.TerraceDepthType;
import option.zima2.shape.main.creator.ZM2TerraceUnitCreator;
import option.zima2.shape.main.item.AbstractTerraceUnitItem;
import option.zima2.shape.main.item.MsItemTerrace;
import option.zima2.shape.main.parts.PHoutate;

public class MsUnitHoudateExCreator
extends ZM2TerraceUnitCreator {
    @Override
    public void create(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        float f = this.getHeight(terraceInfo, zM2Entities.mBasicInfo.mKetaType);
        if (f <= 0.0f) {
            return;
        }
        if (msItemTerrace.getFirstUnit() == abstractTerraceUnitItem && GdMutableTypeUtil.matchOR(terraceInfo.mNokiPlusSideType, NokiPlusSideType.L, NokiPlusSideType.BOTH)) {
            this.createLeftInside(abstractTerraceUnitItem, parts, f);
        }
        if (msItemTerrace.getLastUnit() == abstractTerraceUnitItem && GdMutableTypeUtil.matchOR(terraceInfo.mNokiPlusSideType, NokiPlusSideType.R, NokiPlusSideType.BOTH)) {
            this.createRightInside(abstractTerraceUnitItem, parts, f);
        }
    }

    public void createLeftInside(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts, float f) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        float f2 = -terraceInfo.mWidth.floatValue() / 2.0f + terraceInfo.mLeftWidth.floatValue() - -12.5f;
        float f3 = 0.0f;
        float f4 = msItemTerrace.getFloorlevel() + terracesInfo.mHeight.floatValue();
        float f5 = f4 + f;
        this.createHoudate(f2, f3, f4, f5, vector);
    }

    public void createRightInside(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts, float f) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        float f2 = terraceInfo.mWidth.floatValue() / 2.0f - terraceInfo.mRightWidth.floatValue() + -12.5f;
        float f3 = 0.0f;
        float f4 = msItemTerrace.getFloorlevel() + terracesInfo.mHeight.floatValue();
        float f5 = f4 + f;
        this.createHoudate(f2, f3, f4, f5, vector);
    }

    private void createHoudate(float f, float f2, float f3, float f4, List<Parts> list) {
        Color color = ZM2Color.getColor(this.mShapeColorManager.getColor(0));
        PHoutate pHoutate = new PHoutate();
        pHoutate.set(f, f2, f3, f4, color);
        list.add(pHoutate);
    }

    private float getHeight(TerraceInfo terraceInfo, KetaType ketaType) {
        float f = 0.0f;
        if (terraceInfo.mDepthType == TerraceDepthType.T6) {
            f = 259.9f;
        } else if (terraceInfo.mDepthType == TerraceDepthType.T8) {
            f = 312.8f;
        } else if (terraceInfo.mDepthType == TerraceDepthType.T10) {
            f = 365.8f;
        }
        if (ketaType == KetaType.LARGE) {
            f += 45.0f;
        }
        return f;
    }
}

