/*
 * Decompiled with CFR 0.152.
 */
package option.zima2.shape.common.service;

import java.util.LinkedList;
import java.util.List;
import option.gad.core.inject.GdInject;
import option.gad.core.util.GdMutableTypeUtil;
import option.zima2.common.entity.SidePanelInfo;
import option.zima2.common.entity.TerraceInfo;
import option.zima2.common.entity.TerracesInfo;
import option.zima2.common.entity.ZM2Entities;
import option.zima2.common.service.parts.SidePanelCommonService;
import option.zima2.common.type.NokiPlusFrontType;
import option.zima2.common.type.NokiPlusSideType;
import option.zima2.common.type.OpeningPanelType;
import option.zima2.shape.common.service.CommonShapeService;
import option.zima2.shape.main.item.AbstractTerraceUnitItem;
import option.zima2.shape.main.item.MsItemTerrace;

public class SidePanelShapeService
extends SidePanelCommonService {
    @GdInject
    private CommonShapeService mCommonShapeService;
    private static final float PANEL_OFFSET_X = 32.5f;

    public boolean isUsed(MsItemTerrace msItemTerrace, OpeningPanelType openingPanelType) {
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        return this.isUsed(zM2Entities.mLeftPanelInfoList, zM2Entities.mRightPanelInfoList, openingPanelType);
    }

    public boolean isUsed(LinkedList<SidePanelInfo> linkedList, LinkedList<SidePanelInfo> linkedList2, OpeningPanelType openingPanelType) {
        for (SidePanelInfo sidePanelInfo : linkedList) {
            if (sidePanelInfo.mPanelType != openingPanelType) continue;
            return true;
        }
        for (SidePanelInfo sidePanelInfo : linkedList2) {
            if (sidePanelInfo.mPanelType != openingPanelType) continue;
            return true;
        }
        return false;
    }

    public boolean isUsed(LinkedList<SidePanelInfo> linkedList, OpeningPanelType openingPanelType) {
        for (SidePanelInfo sidePanelInfo : linkedList) {
            if (sidePanelInfo.mPanelType != openingPanelType) continue;
            return true;
        }
        return false;
    }

    public SidePanelInfo findSidePanelInfo(LinkedList<SidePanelInfo> linkedList, OpeningPanelType openingPanelType, int n, int n2) {
        for (SidePanelInfo sidePanelInfo : linkedList) {
            if (sidePanelInfo.mPanelType != openingPanelType || sidePanelInfo.mTerraceId != n || sidePanelInfo.mIndex != n2) continue;
            return sidePanelInfo;
        }
        return null;
    }

    public SidePanelInfo findSidePanel(LinkedList<SidePanelInfo> linkedList, int n) {
        for (SidePanelInfo sidePanelInfo : linkedList) {
            if (sidePanelInfo.mIndex != n) continue;
            return sidePanelInfo;
        }
        return null;
    }

    public boolean hasLeftPanel(AbstractTerraceUnitItem abstractTerraceUnitItem, MsItemTerrace msItemTerrace) {
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        return this.hasLeftPanel(abstractTerraceUnitItem, msItemTerrace, zM2Entities.mLeftPanelInfoList);
    }

    public boolean hasLeftPanel(AbstractTerraceUnitItem abstractTerraceUnitItem, MsItemTerrace msItemTerrace, LinkedList<SidePanelInfo> linkedList) {
        AbstractTerraceUnitItem abstractTerraceUnitItem2 = this.mCommonShapeService.getFirstUnit(msItemTerrace);
        return this.hasSidePanel(linkedList, abstractTerraceUnitItem, abstractTerraceUnitItem2);
    }

    public boolean hasRightPanel(AbstractTerraceUnitItem abstractTerraceUnitItem, MsItemTerrace msItemTerrace) {
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        return this.hasRightPanel(abstractTerraceUnitItem, msItemTerrace, zM2Entities.mRightPanelInfoList);
    }

    public boolean hasRightPanel(AbstractTerraceUnitItem abstractTerraceUnitItem, MsItemTerrace msItemTerrace, LinkedList<SidePanelInfo> linkedList) {
        AbstractTerraceUnitItem abstractTerraceUnitItem2 = this.mCommonShapeService.getLastUnit(msItemTerrace);
        return this.hasSidePanel(linkedList, abstractTerraceUnitItem, abstractTerraceUnitItem2);
    }

    private boolean hasSidePanel(LinkedList<SidePanelInfo> linkedList, AbstractTerraceUnitItem abstractTerraceUnitItem, AbstractTerraceUnitItem abstractTerraceUnitItem2) {
        if (linkedList.size() == 0) {
            return false;
        }
        return abstractTerraceUnitItem == abstractTerraceUnitItem2;
    }

    public float getLeftPanelWidth(MsItemTerrace msItemTerrace) {
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        List<AbstractTerraceUnitItem> list = msItemTerrace.getUnits();
        for (AbstractTerraceUnitItem abstractTerraceUnitItem : list) {
            if (!this.hasLeftPanel(abstractTerraceUnitItem, msItemTerrace)) continue;
            float f = abstractTerraceUnitItem.getCx() + abstractTerraceUnitItem.getWidthL() - 125.0f;
            if (GdMutableTypeUtil.matchOR(terracesInfo.mNokiPlusSideType, NokiPlusSideType.L, NokiPlusSideType.BOTH)) {
                f += abstractTerraceUnitItem.getTerraceInfo().mLeftWidth.floatValue();
            }
            return f;
        }
        return 0.0f;
    }

    public float getRightPanelWidth(MsItemTerrace msItemTerrace) {
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        List<AbstractTerraceUnitItem> list = msItemTerrace.getUnits();
        for (AbstractTerraceUnitItem abstractTerraceUnitItem : list) {
            if (!this.hasRightPanel(abstractTerraceUnitItem, msItemTerrace)) continue;
            float f = abstractTerraceUnitItem.getCx() + abstractTerraceUnitItem.getWidthR() + 125.0f;
            if (GdMutableTypeUtil.matchOR(terracesInfo.mNokiPlusSideType, NokiPlusSideType.R, NokiPlusSideType.BOTH)) {
                f -= abstractTerraceUnitItem.getTerraceInfo().mRightWidth.floatValue();
            }
            return f;
        }
        return 0.0f;
    }

    public float calcLeftPanelX(MsItemTerrace msItemTerrace, TerraceInfo terraceInfo) {
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        float f = -terraceInfo.mWidth.floatValue() / 2.0f + 32.5f;
        if (msItemTerrace.getFirstUnit().getTerraceInfo().mId == terraceInfo.mId && (terracesInfo.mNokiPlusSideType == NokiPlusSideType.L || terracesInfo.mNokiPlusSideType == NokiPlusSideType.BOTH)) {
            f = -terraceInfo.mWidth.floatValue() / 2.0f + terraceInfo.mLeftWidth.floatValue() + 32.5f;
        }
        return f;
    }

    public float calcRightPanelX(MsItemTerrace msItemTerrace, TerraceInfo terraceInfo) {
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        float f = terraceInfo.mWidth.floatValue() / 2.0f - 32.5f;
        if (msItemTerrace.getLastUnit().getTerraceInfo().mId == terraceInfo.mId && (terracesInfo.mNokiPlusSideType == NokiPlusSideType.R || terracesInfo.mNokiPlusSideType == NokiPlusSideType.BOTH)) {
            f = terraceInfo.mWidth.floatValue() / 2.0f - terraceInfo.mRightWidth.floatValue() - 32.5f;
        }
        return f;
    }

    public float calcLeftKutaiSidePanelY(AbstractTerraceUnitItem abstractTerraceUnitItem, LinkedList<SidePanelInfo> linkedList, float f) {
        return this.calcCommonKutaiSidePanelY(abstractTerraceUnitItem, linkedList, f);
    }

    public float calcRightKutaiSidePanelY(AbstractTerraceUnitItem abstractTerraceUnitItem, LinkedList<SidePanelInfo> linkedList, float f) {
        return this.calcCommonKutaiSidePanelY(abstractTerraceUnitItem, linkedList, f);
    }

    private float calcCommonKutaiSidePanelY(AbstractTerraceUnitItem abstractTerraceUnitItem, LinkedList<SidePanelInfo> linkedList, float f) {
        ZM2Entities zM2Entities = abstractTerraceUnitItem.getTerraceItem().getEntities();
        float f2 = -f + 39.0f + 34.0f;
        if (zM2Entities.mTerracesInfo.mNokiPlusFrontType == NokiPlusFrontType.EXIST) {
            f2 = -zM2Entities.mPartsFigureInfo.mNokiPulusFSizeD3.floatValue();
        }
        for (SidePanelInfo sidePanelInfo : linkedList) {
            if (sidePanelInfo == null) continue;
            f2 += sidePanelInfo.mWidth.floatValue();
        }
        return f2;
    }

    public double calcAngleForOpenOrido(double d, double d2, double d3) {
        double d4 = d3 / 2.0;
        double d5 = Math.sqrt(d * d + d2 * d2);
        double d6 = Math.asin(d4 / d5);
        double d7 = Math.atan2(d2, d);
        return d6 - d7;
    }

    public int getMaisu(LinkedList<SidePanelInfo> linkedList, int n) {
        int n2 = 0;
        for (SidePanelInfo sidePanelInfo : linkedList) {
            if (sidePanelInfo.mGroupId != n) continue;
            ++n2;
        }
        return n2;
    }
}

