/*
 * Decompiled with CFR 0.152.
 */
package option.zima2.shape.common.service;

import java.util.LinkedList;
import option.gad.core.inject.GdInject;
import option.gad.core.inject.GdInjector;
import option.zima2.common.entity.FrontPanelInfo;
import option.zima2.common.entity.TerraceInfo;
import option.zima2.common.entity.TerracesInfo;
import option.zima2.common.entity.ZM2Entities;
import option.zima2.common.service.parts.FrontPanelCommonService;
import option.zima2.common.type.EnforcementType;
import option.zima2.common.type.NokiPlusFrontType;
import option.zima2.common.type.NokiPlusSideType;
import option.zima2.common.type.OpeningPanelType;
import option.zima2.shape.common.service.CommonShapeService;
import option.zima2.shape.main.item.AbstractTerraceUnitItem;
import option.zima2.shape.main.item.MsItemTerrace;

public class FrontPanelShapeService
extends FrontPanelCommonService {
    @GdInject
    private CommonShapeService mCommonShapeService;

    public FrontPanelShapeService() {
        GdInjector.getInstance().inject((Object)this);
    }

    public boolean isUsed(MsItemTerrace msItemTerrace, OpeningPanelType openingPanelType, int n) {
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        return this.isUsed(zM2Entities.mFrontPanelInfoList, openingPanelType, n);
    }

    public boolean isUsed(LinkedList<FrontPanelInfo> linkedList, OpeningPanelType openingPanelType, int n) {
        for (FrontPanelInfo frontPanelInfo : linkedList) {
            if (frontPanelInfo.mPanelType != openingPanelType || frontPanelInfo.mTerraceId != n) continue;
            return true;
        }
        return false;
    }

    public FrontPanelInfo findFrontPanelInfo(LinkedList<FrontPanelInfo> linkedList, OpeningPanelType openingPanelType, int n, int n2) {
        for (FrontPanelInfo frontPanelInfo : linkedList) {
            if (frontPanelInfo.mPanelType != openingPanelType || frontPanelInfo.mTerraceId != n || frontPanelInfo.mIndex != n2) continue;
            return frontPanelInfo;
        }
        return null;
    }

    public int getFrontPanelCount(LinkedList<FrontPanelInfo> linkedList, int n) {
        int n2 = 0;
        for (FrontPanelInfo frontPanelInfo : linkedList) {
            if (frontPanelInfo.mTerraceId != n) continue;
            ++n2;
        }
        return n2;
    }

    public FrontPanelInfo findOneFrontPanelByIndex(LinkedList<FrontPanelInfo> linkedList, int n, int n2) {
        for (FrontPanelInfo frontPanelInfo : linkedList) {
            if (frontPanelInfo.mTerraceId != n || frontPanelInfo.mIndex != n2) continue;
            return frontPanelInfo;
        }
        return null;
    }

    public boolean hasFrontPanel(LinkedList<FrontPanelInfo> linkedList, int n) {
        for (FrontPanelInfo frontPanelInfo : linkedList) {
            if (frontPanelInfo.mTerraceId != n) continue;
            return true;
        }
        return false;
    }

    public boolean hasFrontPanel(AbstractTerraceUnitItem abstractTerraceUnitItem) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        return this.hasFrontPanel(zM2Entities.mFrontPanelInfoList, terraceInfo.mId);
    }

    public float calcFrontPanelY(MsItemTerrace msItemTerrace, TerraceInfo terraceInfo) {
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        float f = -terraceInfo.mDepth.floatValue() + 150.0f;
        if (terracesInfo.mEnforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI) {
            f = -terracesInfo.mDepth.floatValue() + 150.0f;
        }
        if (terracesInfo.mNokiPlusFrontType == NokiPlusFrontType.EXIST) {
            f = -zM2Entities.mPartsFigureInfo.mNokiPulusFSizeD3.floatValue() + 25.0f - 39.0f - 34.0f;
        }
        return f;
    }

    public float calcFrontPanelStartX(MsItemTerrace msItemTerrace, TerraceInfo terraceInfo) {
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        float f = -terraceInfo.mWidth.floatValue() / 2.0f + 73.0f;
        if (msItemTerrace.getFirstUnit().getTerraceInfo().mId == terraceInfo.mId && (terracesInfo.mNokiPlusSideType == NokiPlusSideType.L || terracesInfo.mNokiPlusSideType == NokiPlusSideType.BOTH)) {
            f = -terraceInfo.mWidth.floatValue() / 2.0f + terraceInfo.mLeftWidth.floatValue() + 73.0f;
        }
        return f;
    }

    public float calcFrontPanelEndX(MsItemTerrace msItemTerrace, TerraceInfo terraceInfo) {
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        float f = terraceInfo.mWidth.floatValue() / 2.0f - 73.0f;
        if (msItemTerrace.getLastUnit().getTerraceInfo().mId == terraceInfo.mId && (terracesInfo.mNokiPlusSideType == NokiPlusSideType.R || terracesInfo.mNokiPlusSideType == NokiPlusSideType.BOTH)) {
            f = terraceInfo.mWidth.floatValue() / 2.0f - terraceInfo.mRightWidth.floatValue() - 73.0f;
        }
        return f;
    }
}

