/*
 * Decompiled with CFR 0.152.
 */
package option.zima2.shape.common.dao;

import com.kt.annotation.Reflectable;
import com.kt.util.tree.ObjectFolder;
import com.kt.util.tree.ObjectNode;
import java.util.Collection;
import java.util.LinkedList;
import option.gad.core.annotation.GdProperty;
import option.gad.core.dao.GdAbstractSaveFileDao;
import option.gad.core.inject.GdInject;
import option.gad.core.util.ObjectFolderUtil;
import option.zima2.common.dxo.ZM2SaveDataConverter;
import option.zima2.common.entity.BasicInfo;
import option.zima2.common.entity.FloorInfo;
import option.zima2.common.entity.FrontPanelInfo;
import option.zima2.common.entity.IBasicInfo;
import option.zima2.common.entity.IFloorInfo;
import option.zima2.common.entity.IFrontPanelInfo;
import option.zima2.common.entity.ISidePanelInfo;
import option.zima2.common.entity.ITerraceInfo;
import option.zima2.common.entity.ITerracesInfo;
import option.zima2.common.entity.PartsFigureInfo;
import option.zima2.common.entity.SidePanelInfo;
import option.zima2.common.entity.TerraceInfo;
import option.zima2.common.entity.TerracesInfo;
import option.zima2.common.entity.ZM2Entities;
import option.zima2.common.entity.ZM2Infos;
import option.zima2.common.entity.option.IOptionInfo;
import option.zima2.common.entity.option.OptionInfo;
import option.zima2.shape.common.modelset.NodeNameZima2;
import option.zima2.shape.main.item.MsItemTerrace;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Reflectable
public abstract class ZM2ModelSetDao<PER, DOC, TSI extends ITerracesInfo, TI extends ITerraceInfo, BI extends IBasicInfo, FI extends IFloorInfo, FPI extends IFrontPanelInfo, FPIS extends Collection<FPI>, LSPI extends ISidePanelInfo, LSPIS extends Collection<LSPI>, RSPI extends ISidePanelInfo, RSPIS extends Collection<RSPI>, OPI extends IOptionInfo, OPIS extends Collection<OPI>>
extends GdAbstractSaveFileDao<PER, PER, DOC> {
    @GdInject
    private ZM2SaveDataConverter mConverter;
    private static final Log mLog = LogFactory.getLog(ZM2ModelSetDao.class);

    protected ZM2ModelSetDao() {
    }

    public void save(ObjectFolder objectFolder, MsItemTerrace msItemTerrace) {
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        this.saveFolder(objectFolder, NodeNameZima2.BASICINFO.name(), zM2Entities.mBasicInfo);
        this.saveFolder(objectFolder, NodeNameZima2.FLOORINFO.name(), zM2Entities.mFloorInfo);
        this.saveFolders(objectFolder, NodeNameZima2.FRONTPANELINFOS.name(), NodeNameZima2.FRONTPANELINFO.name(), zM2Entities.mFrontPanelInfoList);
        this.saveFolders(objectFolder, NodeNameZima2.LEFTPANELINFOS.name(), NodeNameZima2.LEFTPANELINFO.name(), zM2Entities.mLeftPanelInfoList);
        this.saveFolders(objectFolder, NodeNameZima2.RIGHTPANELINFOS.name(), NodeNameZima2.RIGHTPANELINFO.name(), zM2Entities.mRightPanelInfoList);
        ObjectFolder objectFolder2 = new ObjectFolder(NodeNameZima2.TERRACEINFOS.name());
        for (TerraceInfo terraceInfo : zM2Entities.mTerraceInfoList) {
            objectFolder2.addChild((ObjectNode)ObjectFolderUtil.createFolder((Object)terraceInfo, (String)NodeNameZima2.TERRACEINFO.name(), GdProperty.class), true);
        }
        ObjectFolderUtil.addObject((ObjectFolder)objectFolder2, (Object)zM2Entities.mTerracesInfo, GdProperty.class);
        objectFolder.addChild((ObjectNode)objectFolder2);
        this.saveFolders(objectFolder, NodeNameZima2.OPTIONINFOS.name(), NodeNameZima2.OPTIONINFO.name(), zM2Entities.mOptionInfoList);
    }

    public void load(ObjectFolder objectFolder, MsItemTerrace msItemTerrace) {
        BI BI = this.loadBasicInfo(objectFolder);
        FI FI = this.loadFloorInfo(objectFolder);
        TSI TSI = this.loadTerracesInfo(objectFolder);
        Collection<TI> collection = this.loadTerraceInfos(objectFolder);
        Collection<FPI> collection2 = this.loadFrontPanelInfo(objectFolder);
        Collection<LSPI> collection3 = this.loadLeftPanelInfo(objectFolder);
        Collection<RSPI> collection4 = this.loadRighrPanelInfo(objectFolder);
        Collection<OPI> collection5 = this.loadOptionInfo(objectFolder);
        ZM2Infos zM2Infos = ZM2Infos.newInstance();
        zM2Infos.value1 = TSI;
        zM2Infos.value2 = collection;
        zM2Infos.value3 = BI;
        zM2Infos.value4 = collection2;
        zM2Infos.value5 = collection3;
        zM2Infos.value6 = collection4;
        zM2Infos.value7 = FI;
        zM2Infos.value12 = collection5;
        this.repair((IBasicInfo)zM2Infos.value3, (ITerracesInfo)zM2Infos.value1, (Collection)zM2Infos.value2, (Collection)zM2Infos.value4, (Collection)zM2Infos.value5, (Collection)zM2Infos.value6, (IFloorInfo)zM2Infos.value7, (Collection)zM2Infos.value12);
        ZM2Infos zM2Infos2 = (ZM2Infos)this.mConverter.convert(msItemTerrace.getVersion(), zM2Infos);
        this.restore(msItemTerrace, (BasicInfo)zM2Infos2.value3, (TerracesInfo)zM2Infos2.value1, (Collection)zM2Infos2.value2, (Collection)zM2Infos2.value4, (Collection)zM2Infos2.value5, (Collection)zM2Infos2.value6, (FloorInfo)zM2Infos2.value7, (Collection)zM2Infos2.value12);
    }

    protected BI loadBasicInfo(ObjectFolder objectFolder) {
        return (BI)((IBasicInfo)this.loadFolder(objectFolder, NodeNameZima2.BASICINFO.name()));
    }

    protected FI loadFloorInfo(ObjectFolder objectFolder) {
        return (FI)((IFloorInfo)this.loadFolder(objectFolder, NodeNameZima2.FLOORINFO.name()));
    }

    protected Collection<FPI> loadFrontPanelInfo(ObjectFolder objectFolder) {
        return this.loadFolders(objectFolder, NodeNameZima2.FRONTPANELINFOS.name(), NodeNameZima2.FRONTPANELINFO.name());
    }

    protected Collection<LSPI> loadLeftPanelInfo(ObjectFolder objectFolder) {
        return this.loadFolders(objectFolder, NodeNameZima2.LEFTPANELINFOS.name(), NodeNameZima2.LEFTPANELINFO.name());
    }

    protected Collection<RSPI> loadRighrPanelInfo(ObjectFolder objectFolder) {
        return this.loadFolders(objectFolder, NodeNameZima2.RIGHTPANELINFOS.name(), NodeNameZima2.RIGHTPANELINFO.name());
    }

    protected TSI loadTerracesInfo(ObjectFolder objectFolder) {
        return (TSI)((ITerracesInfo)this.loadFolder(objectFolder, NodeNameZima2.TERRACEINFOS.name()));
    }

    protected Collection<TI> loadTerraceInfos(ObjectFolder objectFolder) {
        ObjectFolder objectFolder22;
        Collection collection = ObjectFolderUtil.findChildFolders((ObjectFolder)objectFolder, (String)NodeNameZima2.TERRACEINFO.name());
        ObjectFolder objectFolder3 = new ObjectFolder(NodeNameZima2.TERRACEINFOS.name());
        objectFolder3.addChild(new ObjectNode("type", (Object)"java.util.ArrayList"));
        for (ObjectFolder objectFolder22 : collection) {
            objectFolder3.addChild((ObjectNode)objectFolder22, true);
        }
        objectFolder22 = new ObjectFolder("root");
        objectFolder22.addChild((ObjectNode)objectFolder3);
        return this.loadFolders(objectFolder22, NodeNameZima2.TERRACEINFOS.name(), NodeNameZima2.TERRACEINFO.name(), TerraceInfo.class);
    }

    protected Collection<OPI> loadOptionInfo(ObjectFolder objectFolder) {
        return this.loadFolders(objectFolder, NodeNameZima2.OPTIONINFOS.name(), NodeNameZima2.OPTIONINFO.name());
    }

    protected void repair(BI BI, TSI TSI, Collection<TI> collection, Collection<FPI> collection2, Collection<LSPI> collection3, Collection<RSPI> collection4, FI FI, Collection<OPI> collection5) {
    }

    protected void restore(MsItemTerrace msItemTerrace, BasicInfo basicInfo, TerracesInfo terracesInfo, Collection<TerraceInfo> collection, Collection<FrontPanelInfo> collection2, Collection<SidePanelInfo> collection3, Collection<SidePanelInfo> collection4, FloorInfo floorInfo, Collection<OptionInfo> collection5) {
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        zM2Entities.mBasicInfo = basicInfo;
        zM2Entities.mTerracesInfo = terracesInfo;
        zM2Entities.mTerraceInfoList = new LinkedList<TerraceInfo>(collection);
        zM2Entities.mFrontPanelInfoList = new LinkedList<FrontPanelInfo>(collection2);
        zM2Entities.mLeftPanelInfoList = new LinkedList<SidePanelInfo>(collection3);
        zM2Entities.mRightPanelInfoList = new LinkedList<SidePanelInfo>(collection4);
        zM2Entities.mFloorInfo = floorInfo;
        zM2Entities.mOptionInfoList = new LinkedList<OptionInfo>(collection5);
        zM2Entities.mPartsFigureInfo = new PartsFigureInfo();
    }
}

