/*
 * Decompiled with CFR 0.152.
 */
package option.zima2.common.service.parts;

import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import option.gad.core.util.NumberUtil;
import option.zima2.common.entity.BasicInfo;
import option.zima2.common.entity.TerraceInfo;
import option.zima2.common.entity.TerracesInfo;
import option.zima2.common.entity.ZM2Entities;
import option.zima2.common.type.SubProductType;

public class TerraceFigureCommonService {
    public static final float CORNER_EXTENTION = 97.5f;

    public float calcTurningAngle(List<TerraceInfo> list, int n) {
        float f = 0.0f;
        int n2 = 0;
        while (n2 < list.size()) {
            TerraceInfo terraceInfo = list.get(n2);
            if (n2 == 0) {
                f += ((Float)NumberUtil.emptyToDefault((Object)terraceInfo.mTurningAngle, (Object)Float.valueOf(0.0f))).floatValue();
            }
            if (terraceInfo.mId.equals(n)) break;
            if (n2 > 0) {
                f += ((Float)NumberUtil.emptyToDefault((Object)terraceInfo.mTurningAngle, (Object)Float.valueOf(0.0f))).floatValue();
            }
            ++n2;
        }
        return f;
    }

    public float calcGroupWidth(List<TerraceInfo> list, int n) {
        return this.calcGroupWidth(list, n, true);
    }

    public float calcGroupWidth(List<TerraceInfo> list, int n, boolean bl) {
        return this.calcGroupWidth(list, n, bl, true);
    }

    public float calcGroupWidth(List<TerraceInfo> list, int n, boolean bl, boolean bl2) {
        float f = 0.0f;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        for (TerraceInfo terraceInfo : list) {
            if (!terraceInfo.mGroupId.equals(n)) continue;
            f += terraceInfo.mWidth.floatValue();
            n2 = Math.min(n2, terraceInfo.mId);
            n3 = Math.max(n3, terraceInfo.mId);
        }
        if (bl2) {
            f += 97.5f;
        }
        return f;
    }

    public float calcTotalWidth(List<TerraceInfo> list, boolean bl, boolean bl2) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (TerraceInfo terraceInfo : list) {
            treeSet.add(terraceInfo.mGroupId);
        }
        float f = 0.0f;
        for (Integer n : treeSet) {
            f += this.calcGroupWidth(list, n, bl, bl2);
        }
        return f;
    }

    public float calcDepthInner(ZM2Entities zM2Entities) {
        return zM2Entities.mTerracesInfo.mDepth.floatValue() - 35.0f;
    }

    public int calcFrontSpanNum(ZM2Entities zM2Entities, boolean bl) {
        return this.calcFrontSpanNum(zM2Entities.mBasicInfo, zM2Entities.mTerracesInfo, zM2Entities.mTerraceInfoList, bl);
    }

    public int calcFrontSpanNum(ZM2Entities zM2Entities, TerraceInfo terraceInfo, boolean bl) {
        return this.calcFrontSpanNum(zM2Entities.mBasicInfo, zM2Entities.mTerracesInfo, terraceInfo, bl);
    }

    public int calcFrontSpanNum(BasicInfo basicInfo, TerracesInfo terracesInfo, LinkedList<TerraceInfo> linkedList, boolean bl) {
        int n = 0;
        for (TerraceInfo terraceInfo : linkedList) {
            n += this.calcFrontSpanNum(basicInfo, terracesInfo, terraceInfo, bl);
        }
        return n;
    }

    public int calcFrontSpanNum(BasicInfo basicInfo, TerracesInfo terracesInfo, TerraceInfo terraceInfo, boolean bl) {
        float f = 0.0f;
        f = bl ? terraceInfo.mDefaultWidth.floatValue() : terraceInfo.mDefaultWidth.floatValue();
        return this.calcFrontSpanNum(f, basicInfo.mKenLen.floatValue() / 2.0f, basicInfo.mSubProductType);
    }

    public int calcFrontSpanNum(float f, float f2, SubProductType subProductType) {
        return this.calcFrontSpanNum(f, f2);
    }

    public int calcFrontSpanNum(float f, float f2) {
        return (int)Math.ceil(f / f2);
    }

    public int calcSideSpanNum(float f, BasicInfo basicInfo, boolean bl) {
        return this.calcSideSpanNum(f, basicInfo.mSubProductType, bl);
    }

    public int calcSideSpanNum(float f, SubProductType subProductType, boolean bl) {
        return this.calcSideSpanNum(f);
    }

    public int calcSideSpanNum(float f) {
        return (int)Math.ceil(f / 303.0f);
    }

    public float calcFrontBaseHeight(ZM2Entities zM2Entities, TerraceInfo terraceInfo, int n) {
        float f = 0.0f;
        f = zM2Entities.mPartsFigureInfo.mYukaHeight.floatValue();
        return f;
    }

    public float calcSideBaseHeight(ZM2Entities zM2Entities, TerraceInfo terraceInfo, int n, boolean bl) {
        float f = 0.0f;
        f = zM2Entities.mPartsFigureInfo.mYukaHeight.floatValue();
        return f;
    }
}

