/*
 * Decompiled with CFR 0.152.
 */
package option.zima2.common.service.parts;

import com.kt.annotation.Reflectable;
import java.util.LinkedList;
import java.util.List;
import option.gad.core.inject.GdInject;
import option.gad.core.util.GdMutableTypeUtil;
import option.zima2.common.dao.cache.spec.SpecBuildingSizeComboCacheDao;
import option.zima2.common.dao.cache.type.TypeTerraceDepthCacheDao;
import option.zima2.common.dao.cache.type.TypeTerraceWidthCacheDao;
import option.zima2.common.dxo.TerraceWidthTypeDxo;
import option.zima2.common.entity.BasicInfo;
import option.zima2.common.entity.TerraceInfo;
import option.zima2.common.entity.TerracesInfo;
import option.zima2.common.entity.ZM2Entities;
import option.zima2.common.entity.type.TypeTerraceDepthInfo;
import option.zima2.common.entity.type.TypeTerraceWidthInfo;
import option.zima2.common.service.floor.DomaTileCommonService;
import option.zima2.common.service.material.TerraceInfoService;
import option.zima2.common.type.DirectionType;
import option.zima2.common.type.EnforcementDirType;
import option.zima2.common.type.EnforcementType;
import option.zima2.common.type.MiddlePillarPosType;
import option.zima2.common.type.NokiPlusFrontType;
import option.zima2.common.type.NokiPlusSideType;
import option.zima2.common.type.ProductType;
import option.zima2.common.type.SodePosType;
import option.zima2.common.type.TerraceDepthType;
import option.zima2.common.type.TerraceWidthType;
import option.zima2.common.type.factory.TerraceDepthTypeFactory;
import option.zima2.common.type.factory.TerraceWidthTypeFactory;
import option.zima2.server.dxo.TerraceDepthTypeDxo;

@Reflectable
public class TerraceCommonService {
    @GdInject
    protected TerraceInfoService mTerraceInfoService;
    @GdInject
    protected DomaTileCommonService mDomaTileAppletService;
    @GdInject
    protected TypeTerraceDepthCacheDao mTypeTerraceDepthCacheDao;
    @GdInject
    protected TypeTerraceWidthCacheDao mTypeTerraceWidthCacheDao;
    @GdInject
    protected SpecBuildingSizeComboCacheDao specBuildingSizeComboCacheDao;

    public void initWidth(ZM2Entities zM2Entities) {
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        EnforcementType enforcementType = terracesInfo.mEnforcementType;
        TerraceWidthType terraceWidthType = enforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI ? TerraceWidthType.T05 : TerraceWidthType.T00;
        terracesInfo.mWidthGapType = terraceWidthType;
        terracesInfo.mWidthGap = this.mTypeTerraceWidthCacheDao.findOneByType((TerraceWidthType)terraceWidthType).length;
        this.updateNokiPlusSideByTerrace(zM2Entities);
        this.updateWidth(zM2Entities);
    }

    public void updateNokiPlusSideByTerrace(ZM2Entities zM2Entities) {
        LinkedList<TerraceInfo> linkedList = zM2Entities.mTerraceInfoList;
        NokiPlusSideType nokiPlusSideType = zM2Entities.mTerracesInfo.mNokiPlusSideType;
        if (linkedList.size() == 1) {
            TerraceInfo terraceInfo = linkedList.get(0);
            terraceInfo.mNokiPlusSideType = this.convToTerraceNokiPlusSideType(nokiPlusSideType, 1, 0);
        } else if (linkedList.size() == 2) {
            TerraceInfo terraceInfo = this.findLeftEdgeTerrace(linkedList);
            TerraceInfo terraceInfo2 = this.findRightEdgeTerrace(linkedList);
            terraceInfo.mNokiPlusSideType = this.convToTerraceNokiPlusSideType(nokiPlusSideType, 2, 0);
            terraceInfo2.mNokiPlusSideType = this.convToTerraceNokiPlusSideType(nokiPlusSideType, 2, 1);
        }
    }

    public NokiPlusSideType convToTerraceNokiPlusSideType(NokiPlusSideType nokiPlusSideType, int n, int n2) {
        if (n == 1) {
            return nokiPlusSideType;
        }
        if (n == 2) {
            if (nokiPlusSideType == NokiPlusSideType.L) {
                return n2 == 0 ? NokiPlusSideType.L : NokiPlusSideType.NONE;
            }
            if (nokiPlusSideType == NokiPlusSideType.R) {
                return n2 == 0 ? NokiPlusSideType.NONE : NokiPlusSideType.R;
            }
            if (nokiPlusSideType == NokiPlusSideType.BOTH) {
                return n2 == 0 ? NokiPlusSideType.L : NokiPlusSideType.R;
            }
            return NokiPlusSideType.NONE;
        }
        return NokiPlusSideType.NONE;
    }

    public void changeWidth(ZM2Entities zM2Entities, List<TerraceWidthType> list, float f) {
        LinkedList<TerraceInfo> linkedList = zM2Entities.mTerraceInfoList;
        if (!(linkedList.size() == 1 && list.size() == 1 || linkedList.size() == 2 && list.size() == 2)) {
            if (linkedList.size() == 1 && list.size() == 2) {
                this.mTerraceInfoService.addTerrace(zM2Entities, DirectionType.RIGHT);
            } else {
                this.mTerraceInfoService.removeTerrace(zM2Entities, DirectionType.LEFT);
            }
        }
        int n = 0;
        while (n < linkedList.size()) {
            TerraceInfo terraceInfo = linkedList.get(n);
            TerraceWidthType terraceWidthType = list.get(n);
            TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType);
            terraceInfo.mWidthType = terraceWidthType;
            terraceInfo.mDefaultWidth = typeTerraceWidthInfo.length;
            terraceInfo.mWidth = typeTerraceWidthInfo.length;
            ++n;
        }
        TerraceInfo terraceInfo = this.findMasterTerraceInfo(linkedList);
        terraceInfo.mWidth = Float.valueOf(f);
        this.initWidth(zM2Entities);
    }

    public void changeKutaiDehabachigaiWidth(ZM2Entities zM2Entities, TerraceWidthType terraceWidthType, Float f) {
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        terracesInfo.mWidthGapType = terraceWidthType;
        terracesInfo.mWidthGap = f;
        this.updateWidth(zM2Entities);
    }

    public void updateWidth(ZM2Entities zM2Entities) {
        BasicInfo basicInfo = zM2Entities.mBasicInfo;
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        LinkedList<TerraceInfo> linkedList = zM2Entities.mTerraceInfoList;
        ProductType productType = basicInfo.mProductType;
        NokiPlusSideType nokiPlusSideType = terracesInfo.mNokiPlusSideType;
        EnforcementType enforcementType = terracesInfo.mEnforcementType;
        if (productType == ProductType.TERRACE) {
            for (TerraceInfo terraceInfo : linkedList) {
                terraceInfo.mRoomWidthType = TerraceWidthType.T00;
                terraceInfo.mRoomWidth = Float.valueOf(0.0f);
            }
        } else {
            for (TerraceInfo terraceInfo : linkedList) {
                terraceInfo.mRoomWidthType = terraceInfo.mWidthType;
                terraceInfo.mRoomWidth = terraceInfo.mWidth;
            }
        }
        if (nokiPlusSideType != NokiPlusSideType.NONE) {
            this.initWidthByNokiPlusSide(zM2Entities);
        } else if (enforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI) {
            this.updateWidthByKutaiDehabachigai(zM2Entities);
        } else {
            for (TerraceInfo terraceInfo : linkedList) {
                terraceInfo.mLeftWidthType = TerraceWidthType.T00;
                terraceInfo.mLeftWidth = Float.valueOf(0.0f);
                terraceInfo.mRightWidthType = TerraceWidthType.T00;
                terraceInfo.mRightWidth = Float.valueOf(0.0f);
            }
        }
        this.updateTerracesInfo(basicInfo, terracesInfo, linkedList);
    }

    public void initWidthByNokiPlusSide(ZM2Entities zM2Entities) {
        this.changeNokiWidth(zM2Entities, TerraceWidthType.T05, TerraceWidthType.T05);
    }

    public void changeNokiWidth(ZM2Entities zM2Entities, TerraceWidthType terraceWidthType, TerraceWidthType terraceWidthType2) {
        LinkedList<TerraceInfo> linkedList = zM2Entities.mTerraceInfoList;
        float f = this.mTypeTerraceWidthCacheDao.findOneByType((TerraceWidthType)terraceWidthType).length.floatValue();
        float f2 = this.mTypeTerraceWidthCacheDao.findOneByType((TerraceWidthType)terraceWidthType2).length.floatValue();
        for (TerraceInfo terraceInfo : linkedList) {
            if (terraceInfo.mNokiPlusSideType == NokiPlusSideType.L) {
                terraceInfo.mLeftWidthType = terraceWidthType;
                terraceInfo.mLeftWidth = Float.valueOf(f);
                terraceInfo.mRightWidthType = TerraceWidthType.T00;
                terraceInfo.mRightWidth = Float.valueOf(0.0f);
                continue;
            }
            if (terraceInfo.mNokiPlusSideType == NokiPlusSideType.R) {
                terraceInfo.mLeftWidthType = TerraceWidthType.T00;
                terraceInfo.mLeftWidth = Float.valueOf(0.0f);
                terraceInfo.mRightWidthType = terraceWidthType2;
                terraceInfo.mRightWidth = Float.valueOf(f2);
                continue;
            }
            if (terraceInfo.mNokiPlusSideType == NokiPlusSideType.BOTH) {
                terraceInfo.mLeftWidthType = terraceWidthType;
                terraceInfo.mLeftWidth = Float.valueOf(f);
                terraceInfo.mRightWidthType = terraceWidthType2;
                terraceInfo.mRightWidth = Float.valueOf(f2);
                continue;
            }
            terraceInfo.mLeftWidthType = TerraceWidthType.T00;
            terraceInfo.mLeftWidth = Float.valueOf(0.0f);
            terraceInfo.mRightWidthType = TerraceWidthType.T00;
            terraceInfo.mRightWidth = Float.valueOf(0.0f);
        }
        this.updateWidthByNoki(zM2Entities);
    }

    public void updateWidthByNoki(ZM2Entities zM2Entities) {
        LinkedList<TerraceInfo> linkedList = zM2Entities.mTerraceInfoList;
        for (TerraceInfo terraceInfo : linkedList) {
            TerraceWidthType terraceWidthType;
            TerraceWidthType terraceWidthType2 = TerraceWidthType.T00;
            TerraceWidthType terraceWidthType3 = TerraceWidthType.T00;
            if (terraceInfo.mNokiPlusSideType == NokiPlusSideType.L) {
                terraceWidthType2 = terraceInfo.mLeftWidthType;
            } else if (terraceInfo.mNokiPlusSideType == NokiPlusSideType.R) {
                terraceWidthType3 = terraceInfo.mRightWidthType;
            } else if (terraceInfo.mNokiPlusSideType == NokiPlusSideType.BOTH) {
                terraceWidthType2 = terraceInfo.mLeftWidthType;
                terraceWidthType3 = terraceInfo.mRightWidthType;
            }
            int n = terraceInfo.mWidthType.id() - terraceWidthType2.id() - terraceWidthType3.id();
            n = Math.max(n, 3);
            terraceInfo.mRoomWidthType = terraceWidthType = TerraceWidthTypeDxo.convert(n);
            terraceInfo.mRoomWidth = this.mTypeTerraceWidthCacheDao.findOneByType((TerraceWidthType)terraceWidthType).length;
            int n2 = terraceWidthType.id() + terraceWidthType2.id() + terraceWidthType3.id();
            TerraceWidthType terraceWidthType4 = TerraceWidthTypeDxo.convert(n2);
            float f = this.mTypeTerraceWidthCacheDao.findOneByType((TerraceWidthType)terraceWidthType4).length.floatValue();
            terraceInfo.mWidthType = terraceWidthType4;
            terraceInfo.mWidth = Float.valueOf(f);
            terraceInfo.mDefaultWidth = Float.valueOf(f);
        }
    }

    public void updateWidthByKutaiDehabachigai(ZM2Entities zM2Entities) {
        TerraceWidthType terraceWidthType;
        TerraceWidthType terraceWidthType2;
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        LinkedList<TerraceInfo> linkedList = zM2Entities.mTerraceInfoList;
        TerraceInfo terraceInfo = this.findMasterTerraceInfo(linkedList);
        float f = terracesInfo.mWidthGap.floatValue();
        if (terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
            terraceInfo.mLeftWidth = Float.valueOf(terraceInfo.mWidth.floatValue() - f);
            terraceInfo.mRightWidth = Float.valueOf(f);
        } else if (terracesInfo.mEnforcementDirType == EnforcementDirType.R) {
            terraceInfo.mLeftWidth = Float.valueOf(f);
            terraceInfo.mRightWidth = Float.valueOf(terraceInfo.mWidth.floatValue() - f);
        }
        TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByLength(terraceInfo.mLeftWidth);
        terraceInfo.mLeftWidthType = terraceWidthType2 = (TerraceWidthType)TerraceWidthTypeFactory.getInstance().getTypeById(typeTerraceWidthInfo.typeTerraceWidthId);
        TypeTerraceWidthInfo typeTerraceWidthInfo2 = this.mTypeTerraceWidthCacheDao.findOneByLength(terraceInfo.mRightWidth);
        terraceInfo.mRightWidthType = terraceWidthType = (TerraceWidthType)TerraceWidthTypeFactory.getInstance().getTypeById(typeTerraceWidthInfo2.typeTerraceWidthId);
    }

    public void initDepth(ZM2Entities zM2Entities) {
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        NokiPlusFrontType nokiPlusFrontType = terracesInfo.mNokiPlusFrontType;
        TerraceDepthType terraceDepthType = null;
        terraceDepthType = nokiPlusFrontType == NokiPlusFrontType.NONE ? TerraceDepthType.T6 : TerraceDepthType.T8;
        float f = TerraceDepthTypeDxo.convertToLength(terraceDepthType).floatValue();
        this.changeDepth(zM2Entities, terraceDepthType, f);
    }

    public void changeDepth(ZM2Entities zM2Entities, TerraceDepthType terraceDepthType, float f) {
        BasicInfo basicInfo = zM2Entities.mBasicInfo;
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        LinkedList<TerraceInfo> linkedList = zM2Entities.mTerraceInfoList;
        terracesInfo.mDepthType = terraceDepthType;
        terracesInfo.mDepth = Float.valueOf(f);
        this.mTerraceInfoService.adjustDepth(zM2Entities);
        this.updateAllDepth(basicInfo, terracesInfo, linkedList);
    }

    public void changeDepthGap(BasicInfo basicInfo, TerracesInfo terracesInfo, LinkedList<TerraceInfo> linkedList, float f) {
        terracesInfo.mDepthGap = Float.valueOf(f);
        this.updateAllDepth(basicInfo, terracesInfo, linkedList);
    }

    public void updateAllDepth(BasicInfo basicInfo, TerracesInfo terracesInfo, LinkedList<TerraceInfo> linkedList) {
        EnforcementType enforcementType = terracesInfo.mEnforcementType;
        EnforcementDirType enforcementDirType = terracesInfo.mEnforcementDirType;
        SodePosType sodePosType = terracesInfo.mSodePosType;
        float f = terracesInfo.mDepth.floatValue();
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneByLength(Float.valueOf(f));
        float f2 = typeTerraceDepthInfo.length.floatValue();
        TerraceDepthType terraceDepthType = (TerraceDepthType)TerraceDepthTypeFactory.getInstance().getTypeById(typeTerraceDepthInfo.typeTerraceDepthId);
        float f3 = terracesInfo.mDepthGap.floatValue();
        float f4 = f - f3;
        TypeTerraceDepthInfo typeTerraceDepthInfo2 = this.mTypeTerraceDepthCacheDao.findOneByLength(Float.valueOf(f4));
        float f5 = typeTerraceDepthInfo2.length.floatValue();
        TerraceDepthType terraceDepthType2 = (TerraceDepthType)TerraceDepthTypeFactory.getInstance().getTypeById(typeTerraceDepthInfo2.typeTerraceDepthId);
        TerraceDepthType terraceDepthType3 = null;
        TerraceDepthType terraceDepthType4 = null;
        if (terracesInfo.mNokiPlusFrontType == NokiPlusFrontType.EXIST) {
            terraceDepthType4 = TerraceDepthType.T2;
            terraceDepthType3 = (TerraceDepthType)TerraceDepthTypeFactory.getInstance().getTypeById(terraceDepthType.id() - terraceDepthType4.id());
        } else if (basicInfo.mProductType == ProductType.ENCLOSE) {
            terraceDepthType4 = TerraceDepthType.T0;
            terraceDepthType3 = terracesInfo.mDepthType;
        } else {
            terraceDepthType4 = terracesInfo.mDepthType;
            terraceDepthType3 = TerraceDepthType.T0;
        }
        float f6 = TerraceDepthTypeDxo.convertToLength(terraceDepthType4).floatValue();
        float f7 = TerraceDepthTypeDxo.convertToLength(terraceDepthType3).floatValue();
        for (TerraceInfo terraceInfo : linkedList) {
            terraceInfo.mFrontDepthType = terraceDepthType4;
            terraceInfo.mFrontDepth = Float.valueOf(f6);
            terraceInfo.mBackDepthType = terraceDepthType3;
            terraceInfo.mBackDepth = Float.valueOf(f7);
            if (enforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI) {
                if (enforcementDirType == EnforcementDirType.L && terraceInfo.mId < 0 || enforcementDirType == EnforcementDirType.R && terraceInfo.mId > 0) {
                    terraceInfo.mDepthType = terraceDepthType2;
                    terraceInfo.mDefaultDepth = Float.valueOf(f5);
                    terraceInfo.mDepth = Float.valueOf(f4);
                    terraceInfo.mLeftDepthType = terraceDepthType2;
                    terraceInfo.mLeftDepth = Float.valueOf(f4);
                    terraceInfo.mRightDepthType = terraceDepthType2;
                    terraceInfo.mRightDepth = Float.valueOf(f4);
                } else if (enforcementDirType == EnforcementDirType.L && terraceInfo.mId == 0) {
                    terraceInfo.mDepthType = terraceDepthType;
                    terraceInfo.mDefaultDepth = Float.valueOf(f2);
                    terraceInfo.mDepth = Float.valueOf(f);
                    terraceInfo.mLeftDepthType = terraceDepthType2;
                    terraceInfo.mLeftDepth = Float.valueOf(f4);
                    terraceInfo.mRightDepthType = terraceDepthType;
                    terraceInfo.mRightDepth = Float.valueOf(f);
                } else if (enforcementDirType == EnforcementDirType.R && terraceInfo.mId == 0) {
                    terraceInfo.mDepthType = terraceDepthType;
                    terraceInfo.mDefaultDepth = Float.valueOf(f2);
                    terraceInfo.mDepth = Float.valueOf(f);
                    terraceInfo.mLeftDepthType = terraceDepthType;
                    terraceInfo.mLeftDepth = Float.valueOf(f);
                    terraceInfo.mRightDepthType = terraceDepthType2;
                    terraceInfo.mRightDepth = Float.valueOf(f4);
                } else {
                    terraceInfo.mDepthType = terraceDepthType;
                    terraceInfo.mDefaultDepth = Float.valueOf(f2);
                    terraceInfo.mDepth = Float.valueOf(f);
                    terraceInfo.mLeftDepthType = terraceDepthType;
                    terraceInfo.mLeftDepth = Float.valueOf(f);
                    terraceInfo.mRightDepthType = terraceDepthType;
                    terraceInfo.mRightDepth = Float.valueOf(f);
                }
            } else {
                terraceInfo.mDepthType = terraceDepthType;
                terraceInfo.mDefaultDepth = Float.valueOf(f2);
                terraceInfo.mDepth = Float.valueOf(f);
                terraceInfo.mLeftDepthType = terraceDepthType;
                terraceInfo.mLeftDepth = Float.valueOf(f);
                terraceInfo.mRightDepthType = terraceDepthType;
                terraceInfo.mRightDepth = Float.valueOf(f);
            }
            if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.BUBUN_IRISUMI) && GdMutableTypeUtil.matchOR(sodePosType, SodePosType.L)) {
                terraceInfo.mLeftDepth = Float.valueOf(terraceInfo.mDepth.floatValue() - terracesInfo.mPartialDepth.floatValue());
                terraceInfo.mRightDepth = terraceInfo.mDepth;
                continue;
            }
            if (!GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.BUBUN_IRISUMI) || !GdMutableTypeUtil.matchOR(sodePosType, SodePosType.R)) continue;
            terraceInfo.mLeftDepth = terraceInfo.mDepth;
            terraceInfo.mRightDepth = Float.valueOf(terraceInfo.mDepth.floatValue() - terracesInfo.mPartialDepth.floatValue());
        }
        this.updateTerracesInfo(basicInfo, terracesInfo, linkedList);
    }

    public void updateTerracesInfo(ZM2Entities zM2Entities) {
        this.updateTerracesInfo(zM2Entities.mBasicInfo, zM2Entities.mTerracesInfo, zM2Entities.mTerraceInfoList);
    }

    public void updateTerracesInfo(BasicInfo basicInfo, TerracesInfo terracesInfo, List<TerraceInfo> list) {
        float f = 0.0f;
        for (TerraceInfo terraceInfo : list) {
            f += terraceInfo.mWidth.floatValue();
        }
        float f2 = 0.0f;
        for (TerraceInfo terraceInfo : list) {
            f2 = Math.max(f2, terraceInfo.mDepth.floatValue());
        }
        terracesInfo.mWidth = Float.valueOf(f);
        terracesInfo.mWidthType = TerraceWidthTypeDxo.convert(f);
        terracesInfo.mDepth = Float.valueOf(f2);
        terracesInfo.mDepthType = TerraceDepthTypeDxo.convert(f2);
    }

    public TerraceInfo findMasterTerraceInfo(LinkedList<TerraceInfo> linkedList) {
        for (TerraceInfo terraceInfo : linkedList) {
            if (!terraceInfo.mIsMaster.booleanValue()) continue;
            return terraceInfo;
        }
        return null;
    }

    public TerraceInfo findTerraceInfoByIndex(List<TerraceInfo> list, int n) {
        for (TerraceInfo terraceInfo : list) {
            if (terraceInfo.mId != n) continue;
            return terraceInfo;
        }
        return null;
    }

    public TerraceInfo findTerraceInfoByMaxWidthType(BasicInfo basicInfo, TerracesInfo terracesInfo, LinkedList<TerraceInfo> linkedList, boolean bl) {
        TerraceInfo terraceInfo = this.findMasterTerraceInfo(linkedList);
        TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(TerraceWidthType.T05);
        Float f = Float.valueOf(0.0f);
        if (typeTerraceWidthInfo != null) {
            f = typeTerraceWidthInfo.length;
        }
        for (TerraceInfo terraceInfo2 : linkedList) {
            TypeTerraceWidthInfo typeTerraceWidthInfo2 = this.mTypeTerraceWidthCacheDao.findOneByType(terraceInfo2.mWidthType);
            if (typeTerraceWidthInfo2 == null) continue;
            float f2 = typeTerraceWidthInfo2.length.floatValue();
            if (!(f.floatValue() < f2)) continue;
            f = Float.valueOf(f2);
            terraceInfo = terraceInfo2;
        }
        return terraceInfo;
    }

    public TerraceInfo findTerraceInfoByMaxWidthType(BasicInfo basicInfo, TerracesInfo terracesInfo, LinkedList<TerraceInfo> linkedList) {
        return this.findTerraceInfoByMaxWidthType(basicInfo, terracesInfo, linkedList, false);
    }

    public TerraceInfo findTerraceInfoByMaxDepthType(LinkedList<TerraceInfo> linkedList) {
        TerraceInfo terraceInfo = this.findMasterTerraceInfo(linkedList);
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneByType(TerraceDepthType.T2);
        Float f = Float.valueOf(0.0f);
        if (typeTerraceDepthInfo != null) {
            f = typeTerraceDepthInfo.length;
        }
        for (TerraceInfo terraceInfo2 : linkedList) {
            TypeTerraceDepthInfo typeTerraceDepthInfo2 = this.mTypeTerraceDepthCacheDao.findOneByType(terraceInfo2.mDepthType);
            if (typeTerraceDepthInfo2 == null || !(f.floatValue() < typeTerraceDepthInfo2.length.floatValue())) continue;
            f = typeTerraceDepthInfo2.length;
            terraceInfo = terraceInfo2;
        }
        return terraceInfo;
    }

    public int findMaxIndex(List<TerraceInfo> list) {
        int n = Integer.MIN_VALUE;
        for (TerraceInfo terraceInfo : list) {
            if (n >= terraceInfo.mId) continue;
            n = terraceInfo.mId;
        }
        return n;
    }

    public int findMinIndex(List<TerraceInfo> list) {
        int n = Integer.MAX_VALUE;
        for (TerraceInfo terraceInfo : list) {
            if (n <= terraceInfo.mId) continue;
            n = terraceInfo.mId;
        }
        return n;
    }

    public boolean judgeMaxIndexTerrace(List<TerraceInfo> list, TerraceInfo terraceInfo) {
        int n = this.findMaxIndex(list);
        return terraceInfo.mId == n;
    }

    public boolean judgeMinIndexTerrace(List<TerraceInfo> list, TerraceInfo terraceInfo) {
        int n = this.findMinIndex(list);
        return terraceInfo.mId == n;
    }

    public int compare(TerraceDepthType terraceDepthType, TerraceDepthType terraceDepthType2) {
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneByType(terraceDepthType);
        TypeTerraceDepthInfo typeTerraceDepthInfo2 = this.mTypeTerraceDepthCacheDao.findOneByType(terraceDepthType2);
        if (typeTerraceDepthInfo.length.floatValue() > typeTerraceDepthInfo2.length.floatValue()) {
            return 1;
        }
        if (typeTerraceDepthInfo.length.floatValue() < typeTerraceDepthInfo2.length.floatValue()) {
            return -1;
        }
        return 0;
    }

    public boolean isRentou(TerracesInfo terracesInfo, List<TerraceInfo> list, TerraceInfo terraceInfo) {
        if (list.size() <= 1) {
            return false;
        }
        return !this.judgeMinIndexTerrace(list, terraceInfo);
    }

    public boolean isStartingWidthType(List<TerraceInfo> list, TerraceWidthType terraceWidthType) {
        for (TerraceInfo terraceInfo : list) {
            if (!terraceInfo.mIsStarting.booleanValue() || terraceInfo.mWidthType != terraceWidthType) continue;
            return true;
        }
        return false;
    }

    public boolean isRentou(LinkedList<TerraceInfo> linkedList) {
        return linkedList.size() > 1;
    }

    public TerraceInfo findLeftEdgeTerrace(LinkedList<TerraceInfo> linkedList) {
        for (TerraceInfo terraceInfo : linkedList) {
            if (!terraceInfo.mIsLeftEnd.booleanValue()) continue;
            return terraceInfo;
        }
        return null;
    }

    public TerraceInfo findRightEdgeTerrace(LinkedList<TerraceInfo> linkedList) {
        for (TerraceInfo terraceInfo : linkedList) {
            if (!terraceInfo.mIsRightEnd.booleanValue()) continue;
            return terraceInfo;
        }
        return null;
    }

    public TerraceDepthType judgeLeftOptionDepthType(TerracesInfo terracesInfo, TerraceInfo terraceInfo) {
        float f = terraceInfo.mLeftDepth.floatValue();
        for (TerraceDepthType terraceDepthType : TerraceDepthTypeFactory.getInstance().values()) {
            TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneById(terraceDepthType.id());
            if (f != typeTerraceDepthInfo.length.floatValue()) continue;
            return terraceDepthType;
        }
        return null;
    }

    public TerraceDepthType judgeRightOptionDepthType(TerracesInfo terracesInfo, TerraceInfo terraceInfo) {
        float f = terraceInfo.mRightDepth.floatValue();
        for (TerraceDepthType terraceDepthType : TerraceDepthTypeFactory.getInstance().values()) {
            TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneById(terraceDepthType.id());
            if (f != typeTerraceDepthInfo.length.floatValue()) continue;
            return terraceDepthType;
        }
        return null;
    }

    public boolean existTerraceWidthType(List<TerraceInfo> list, TerraceWidthType terraceWidthType) {
        for (TerraceInfo terraceInfo : list) {
            if (terraceInfo.mWidthType != terraceWidthType) continue;
            return true;
        }
        return false;
    }

    public float calcSideLength(TerracesInfo terracesInfo, boolean bl, boolean bl2, boolean bl3) {
        EnforcementType enforcementType = terracesInfo.mEnforcementType;
        EnforcementDirType enforcementDirType = terracesInfo.mEnforcementDirType;
        SodePosType sodePosType = terracesInfo.mSodePosType;
        float f = terracesInfo.mDepth.floatValue();
        if (bl2 && terracesInfo.mNokiPlusFrontType == NokiPlusFrontType.EXIST) {
            f -= 605.0f;
        }
        if (enforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI) {
            if (enforcementDirType == EnforcementDirType.L == bl3) {
                f -= terracesInfo.mDepthGap.floatValue();
            }
        } else if (enforcementType == EnforcementType.BUBUN_IRISUMI && !bl && sodePosType == SodePosType.L == bl3) {
            f -= terracesInfo.mPartialDepth.floatValue();
        }
        return f;
    }

    public float calcLeftTotalWidth(LinkedList<TerraceInfo> linkedList) {
        TerraceInfo terraceInfo = this.findMasterTerraceInfo(linkedList);
        float f = terraceInfo.mLeftWidth.floatValue();
        for (TerraceInfo terraceInfo2 : linkedList) {
            if (terraceInfo2.mId >= 0) continue;
            f += terraceInfo2.mWidth.floatValue();
        }
        return f;
    }

    public float calcRightTotalWidth(LinkedList<TerraceInfo> linkedList) {
        TerraceInfo terraceInfo = this.findMasterTerraceInfo(linkedList);
        float f = terraceInfo.mRightWidth.floatValue();
        for (TerraceInfo terraceInfo2 : linkedList) {
            if (terraceInfo2.mId <= 0) continue;
            f += terraceInfo2.mWidth.floatValue();
        }
        return f;
    }

    public float calcRoomWidth(BasicInfo basicInfo, TerracesInfo terracesInfo, LinkedList<TerraceInfo> linkedList) {
        ProductType productType = basicInfo.mProductType;
        if (productType != ProductType.ENCLOSE) {
            return 0.0f;
        }
        return this.calcRightRoomX(terracesInfo, linkedList) - this.calcLeftRoomX(terracesInfo, linkedList);
    }

    public float calcLeftRoomX(TerracesInfo terracesInfo, LinkedList<TerraceInfo> linkedList) {
        float f = -terracesInfo.mWidth.floatValue() / 2.0f;
        if (terracesInfo.mNokiPlusSideType != NokiPlusSideType.NONE) {
            TerraceInfo terraceInfo = this.findLeftEdgeTerrace(linkedList);
            f += terraceInfo.mLeftWidth.floatValue();
        }
        return f;
    }

    public float calcRightRoomX(TerracesInfo terracesInfo, LinkedList<TerraceInfo> linkedList) {
        float f = terracesInfo.mWidth.floatValue() / 2.0f;
        if (terracesInfo.mNokiPlusSideType != NokiPlusSideType.NONE) {
            TerraceInfo terraceInfo = this.findRightEdgeTerrace(linkedList);
            f -= terraceInfo.mRightWidth.floatValue();
        }
        return f;
    }

    public float calcRoomDepth(BasicInfo basicInfo, TerracesInfo terracesInfo, LinkedList<TerraceInfo> linkedList) {
        if (basicInfo.mProductType == ProductType.ENCLOSE) {
            if (terracesInfo.mNokiPlusFrontType == NokiPlusFrontType.EXIST) {
                TerraceInfo terraceInfo = this.findMasterTerraceInfo(linkedList);
                return terraceInfo.mBackDepth.floatValue();
            }
            return terracesInfo.mDepth.floatValue();
        }
        return 0.0f;
    }

    public float calcCutDepth(ZM2Entities zM2Entities) {
        TerraceInfo terraceInfo = this.findMasterTerraceInfo(zM2Entities.mTerraceInfoList);
        return terraceInfo.mDefaultDepth.floatValue() - terraceInfo.mDepth.floatValue();
    }

    public float calcCutWidth(ZM2Entities zM2Entities) {
        return this.calcCutWidth(zM2Entities.mTerraceInfoList);
    }

    public float calcCutWidth(LinkedList<TerraceInfo> linkedList) {
        TerraceInfo terraceInfo = this.findMasterTerraceInfo(linkedList);
        return terraceInfo.mDefaultWidth.floatValue() - terraceInfo.mWidth.floatValue();
    }

    public int countMiddlePillar(List<TerraceInfo> list) {
        int n = 0;
        for (TerraceInfo terraceInfo : list) {
            MiddlePillarPosType middlePillarPosType = terraceInfo.mMiddlePillarPosType;
            if (middlePillarPosType == MiddlePillarPosType.BOTH) {
                n += 2;
                continue;
            }
            if (!GdMutableTypeUtil.matchOR(middlePillarPosType, MiddlePillarPosType.L, MiddlePillarPosType.R, MiddlePillarPosType.CENTER)) continue;
            ++n;
        }
        return n;
    }

    public DirectionType judgeWidthCutDir(int n, int n2) {
        DirectionType directionType = null;
        if (n == 0) {
            directionType = DirectionType.LEFT;
        } else if (n + 1 == n2) {
            directionType = DirectionType.RIGHT;
        }
        return directionType;
    }

    public DirectionType judgeDepthCutDir(int n, float f, float f2) {
        DirectionType directionType = null;
        if (n == 0 && Float.compare(f, f2) != 0) {
            directionType = DirectionType.LEFT;
        }
        return directionType;
    }
}

