/*
 * Decompiled with CFR 0.152.
 */
package option.zima2.common.service.parts;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import option.gad.core.inject.GdInject;
import option.gad.core.util.GdMutableTypeUtil;
import option.zima2.common.dao.cache.spec.SpecMeasurementDepthCacheDao;
import option.zima2.common.dao.cache.type.TypeTerraceDepthCacheDao;
import option.zima2.common.entity.BasicInfo;
import option.zima2.common.entity.SidePanelInfo;
import option.zima2.common.entity.TerraceInfo;
import option.zima2.common.entity.TerracesInfo;
import option.zima2.common.entity.ZM2Entities;
import option.zima2.common.entity.spec.SpecMeasurementDepthInfo;
import option.zima2.common.entity.type.TypeTerraceDepthInfo;
import option.zima2.common.service.common.MessageCommonService;
import option.zima2.common.service.parts.TerraceCommonService;
import option.zima2.common.service.parts.TerraceFigureCommonService;
import option.zima2.common.type.AdjustmentFixType;
import option.zima2.common.type.BodyPanelType;
import option.zima2.common.type.EnforcementDirType;
import option.zima2.common.type.EnforcementType;
import option.zima2.common.type.NokiPlusFrontType;
import option.zima2.common.type.OpeningPanelType;
import option.zima2.common.type.ProductType;
import option.zima2.common.type.SodePosType;
import option.zima2.common.type.TerraceDepthType;
import option.zima2.common.type.constant.CutLenType;
import option.zima2.server.dxo.TerraceDepthTypeDxo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SidePanelCommonService {
    private Log mLog = LogFactory.getLog(SidePanelCommonService.class);
    @GdInject
    protected TerraceCommonService mTerraceCommonService;
    @GdInject
    protected TerraceFigureCommonService mTerraceFigureCommonService;
    @GdInject
    private MessageCommonService mMessageService;
    @GdInject
    protected TypeTerraceDepthCacheDao mTypeTerraceDepthCacheDao;
    @GdInject
    protected SpecMeasurementDepthCacheDao mSpecMeasurementDepthCacheDao;

    public OpeningPanelType toOpeningPanelType(BodyPanelType bodyPanelType, boolean bl) {
        if (bodyPanelType == BodyPanelType.BOTH_ORIDO) {
            return OpeningPanelType.ORIDO;
        }
        if (bodyPanelType == BodyPanelType.LEFT_FIX) {
            return bl ? OpeningPanelType.FIX : OpeningPanelType.ORIDO;
        }
        if (bodyPanelType == BodyPanelType.RIGHT_FIX) {
            return bl ? OpeningPanelType.ORIDO : OpeningPanelType.FIX;
        }
        if (bodyPanelType == BodyPanelType.BOTH_FIX) {
            return OpeningPanelType.FIX;
        }
        return OpeningPanelType.FIX;
    }

    public OpeningPanelType toOpeningPanelType(AdjustmentFixType adjustmentFixType, boolean bl) {
        if (adjustmentFixType == AdjustmentFixType.BOTH_NOMAL) {
            return OpeningPanelType.ADJUSTMENT_FIX;
        }
        if (adjustmentFixType == AdjustmentFixType.LEFT_KANKI) {
            return bl ? OpeningPanelType.LOUVER : OpeningPanelType.ADJUSTMENT_FIX;
        }
        if (adjustmentFixType == AdjustmentFixType.RIGHT_KANKI) {
            return bl ? OpeningPanelType.ADJUSTMENT_FIX : OpeningPanelType.LOUVER;
        }
        if (adjustmentFixType == AdjustmentFixType.BOTH_KANKI) {
            return OpeningPanelType.LOUVER;
        }
        return OpeningPanelType.ADJUSTMENT_FIX;
    }

    public BodyPanelType toBodyPanelType(OpeningPanelType openingPanelType, OpeningPanelType openingPanelType2) {
        if (openingPanelType == OpeningPanelType.ORIDO && openingPanelType2 == OpeningPanelType.ORIDO) {
            return BodyPanelType.BOTH_ORIDO;
        }
        if (openingPanelType == OpeningPanelType.FIX && openingPanelType2 == OpeningPanelType.ORIDO) {
            return BodyPanelType.LEFT_FIX;
        }
        if (openingPanelType == OpeningPanelType.ORIDO && openingPanelType2 == OpeningPanelType.FIX) {
            return BodyPanelType.RIGHT_FIX;
        }
        if (openingPanelType == OpeningPanelType.FIX && openingPanelType2 == OpeningPanelType.FIX) {
            return BodyPanelType.BOTH_FIX;
        }
        return BodyPanelType.BOTH_FIX;
    }

    public AdjustmentFixType toAdjustmentFixType(OpeningPanelType openingPanelType, OpeningPanelType openingPanelType2) {
        if (openingPanelType == OpeningPanelType.ADJUSTMENT_FIX && openingPanelType2 == OpeningPanelType.ADJUSTMENT_FIX) {
            return AdjustmentFixType.BOTH_NOMAL;
        }
        if (openingPanelType == OpeningPanelType.LOUVER && openingPanelType2 == OpeningPanelType.ADJUSTMENT_FIX) {
            return AdjustmentFixType.LEFT_KANKI;
        }
        if (openingPanelType == OpeningPanelType.ADJUSTMENT_FIX && openingPanelType2 == OpeningPanelType.LOUVER) {
            return AdjustmentFixType.RIGHT_KANKI;
        }
        if (openingPanelType == OpeningPanelType.LOUVER && openingPanelType2 == OpeningPanelType.LOUVER) {
            return AdjustmentFixType.BOTH_KANKI;
        }
        return AdjustmentFixType.BOTH_NOMAL;
    }

    public boolean isValidBodyPanel(ZM2Entities zM2Entities, OpeningPanelType openingPanelType, boolean bl) {
        boolean bl2;
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        ProductType productType = zM2Entities.mBasicInfo.mProductType;
        float f = this.calcSideRoomLength(terracesInfo, bl);
        TerraceDepthType terraceDepthType = terracesInfo.mDepthType;
        if (terracesInfo.mNokiPlusFrontType == NokiPlusFrontType.EXIST) {
            terraceDepthType = TerraceDepthTypeDxo.convert(f);
        }
        boolean bl3 = bl ? !zM2Entities.mLeftPanelInfoList.isEmpty() : (bl2 = !zM2Entities.mRightPanelInfoList.isEmpty());
        if (openingPanelType == OpeningPanelType.FIX && !bl2) {
            return false;
        }
        EnforcementType enforcementType = this.judgeOpeningEnforcement(zM2Entities, bl);
        return this.isValidLength(productType, enforcementType, terraceDepthType, f, openingPanelType);
    }

    public boolean isValidAdjustment(ZM2Entities zM2Entities, OpeningPanelType openingPanelType, boolean bl) {
        boolean bl2;
        boolean bl3 = bl ? !zM2Entities.mLeftPanelInfoList.isEmpty() : !zM2Entities.mRightPanelInfoList.isEmpty();
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneByType(zM2Entities.mTerracesInfo.mDepthType);
        float f = this.calcSideOpeningLength(zM2Entities.mTerracesInfo, bl);
        boolean bl4 = bl2 = typeTerraceDepthInfo.length.floatValue() > f;
        if (openingPanelType == OpeningPanelType.LOUVER) {
            return bl3 && !bl2;
        }
        return true;
    }

    public boolean isValidBodyPanelType(ZM2Entities zM2Entities, BodyPanelType bodyPanelType) {
        OpeningPanelType openingPanelType = this.toOpeningPanelType(bodyPanelType, true);
        OpeningPanelType openingPanelType2 = this.toOpeningPanelType(bodyPanelType, false);
        return this.isValidBodyPanel(zM2Entities, openingPanelType, true) && this.isValidBodyPanel(zM2Entities, openingPanelType2, false);
    }

    public boolean isValidAdjustmentFixType(ZM2Entities zM2Entities, AdjustmentFixType adjustmentFixType) {
        OpeningPanelType openingPanelType = this.toOpeningPanelType(adjustmentFixType, true);
        OpeningPanelType openingPanelType2 = this.toOpeningPanelType(adjustmentFixType, false);
        return this.isValidAdjustment(zM2Entities, openingPanelType, true) && this.isValidAdjustment(zM2Entities, openingPanelType2, false);
    }

    public EnforcementType judgeOpeningEnforcement(ZM2Entities zM2Entities, boolean bl) {
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        EnforcementType enforcementType = terracesInfo.mEnforcementType;
        EnforcementDirType enforcementDirType = terracesInfo.mEnforcementDirType;
        SodePosType sodePosType = terracesInfo.mSodePosType;
        EnforcementType enforcementType2 = EnforcementType.STD;
        if (bl) {
            if (enforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI) {
                if (enforcementDirType == EnforcementDirType.L) {
                    enforcementType2 = EnforcementType.KUTAI_DEHABA_CHIGAI;
                }
            } else if (enforcementType == EnforcementType.BUBUN_IRISUMI && sodePosType == SodePosType.L) {
                enforcementType2 = EnforcementType.BUBUN_IRISUMI;
            }
        } else if (enforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI) {
            if (enforcementDirType == EnforcementDirType.R) {
                enforcementType2 = EnforcementType.KUTAI_DEHABA_CHIGAI;
            }
        } else if (enforcementType == EnforcementType.BUBUN_IRISUMI && sodePosType == SodePosType.R) {
            enforcementType2 = EnforcementType.BUBUN_IRISUMI;
        }
        return enforcementType2;
    }

    public void updateSidePanelTypes(ZM2Entities zM2Entities) {
        this.updateLeftSidePanelTypes(zM2Entities);
        this.updateRightSidePanelTypes(zM2Entities);
    }

    public void updateLeftSidePanelTypes(ZM2Entities zM2Entities) {
        BasicInfo basicInfo = zM2Entities.mBasicInfo;
        OpeningPanelType openingPanelType = OpeningPanelType.ORIDO;
        OpeningPanelType openingPanelType2 = OpeningPanelType.ADJUSTMENT_FIX;
        if (GdMutableTypeUtil.matchOR(basicInfo.mBodyPanelType, BodyPanelType.LEFT_FIX, BodyPanelType.BOTH_FIX)) {
            openingPanelType = OpeningPanelType.FIX;
        }
        if (GdMutableTypeUtil.matchOR(basicInfo.mAdjustmentFixType, AdjustmentFixType.LEFT_KANKI, AdjustmentFixType.BOTH_KANKI)) {
            openingPanelType2 = OpeningPanelType.LOUVER;
        }
        this.updateSidePanelTypes(zM2Entities.mLeftPanelInfoList, openingPanelType, openingPanelType2);
    }

    public void updateRightSidePanelTypes(ZM2Entities zM2Entities) {
        BasicInfo basicInfo = zM2Entities.mBasicInfo;
        OpeningPanelType openingPanelType = OpeningPanelType.ORIDO;
        OpeningPanelType openingPanelType2 = OpeningPanelType.ADJUSTMENT_FIX;
        if (GdMutableTypeUtil.matchOR(basicInfo.mBodyPanelType, BodyPanelType.RIGHT_FIX, BodyPanelType.BOTH_FIX)) {
            openingPanelType = OpeningPanelType.FIX;
        }
        if (GdMutableTypeUtil.matchOR(basicInfo.mAdjustmentFixType, AdjustmentFixType.RIGHT_KANKI, AdjustmentFixType.BOTH_KANKI)) {
            openingPanelType2 = OpeningPanelType.LOUVER;
        }
        this.updateSidePanelTypes(zM2Entities.mRightPanelInfoList, openingPanelType, openingPanelType2);
    }

    public void updateSidePanelTypes(List<SidePanelInfo> list, OpeningPanelType openingPanelType, OpeningPanelType openingPanelType2) {
        for (SidePanelInfo sidePanelInfo : list) {
            OpeningPanelType openingPanelType3 = sidePanelInfo.mPanelType;
            if (GdMutableTypeUtil.matchOR(openingPanelType3, OpeningPanelType.ORIDO, OpeningPanelType.FIX)) {
                sidePanelInfo.mPanelType = openingPanelType;
            }
            if (!GdMutableTypeUtil.matchOR(openingPanelType3, OpeningPanelType.ADJUSTMENT_FIX, OpeningPanelType.LOUVER)) continue;
            sidePanelInfo.mPanelType = openingPanelType2;
        }
    }

    public LinkedList<SidePanelInfo> findManySidePanelInfo(List<SidePanelInfo> list, OpeningPanelType ... openingPanelTypeArray) {
        LinkedList<SidePanelInfo> linkedList = new LinkedList<SidePanelInfo>();
        for (SidePanelInfo sidePanelInfo : list) {
            if (!GdMutableTypeUtil.matchOR(sidePanelInfo.mPanelType, openingPanelTypeArray)) continue;
            linkedList.add(sidePanelInfo);
        }
        return linkedList;
    }

    public SidePanelInfo findOneSidePanelByIndex(List<SidePanelInfo> list, int n) {
        for (SidePanelInfo sidePanelInfo : list) {
            if (sidePanelInfo.mIndex != n) continue;
            return sidePanelInfo;
        }
        return null;
    }

    public SidePanelInfo findOneSidePanelInfoByIndex(List<SidePanelInfo> list, int n, int n2) {
        for (SidePanelInfo sidePanelInfo : list) {
            if (sidePanelInfo.mIndex != n || sidePanelInfo.mSpan != n2) continue;
            return sidePanelInfo;
        }
        return null;
    }

    public boolean hasSidePanelType(List<SidePanelInfo> list, OpeningPanelType openingPanelType) {
        for (SidePanelInfo sidePanelInfo : list) {
            if (sidePanelInfo.mPanelType != openingPanelType) continue;
            return true;
        }
        return false;
    }

    public boolean hasOnlySidePanelType(List<SidePanelInfo> list, OpeningPanelType openingPanelType) {
        if (list.isEmpty()) {
            return false;
        }
        boolean bl = true;
        for (SidePanelInfo sidePanelInfo : list) {
            if (sidePanelInfo.mPanelType == openingPanelType) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public List<SidePanelInfo> packAllSidePanel(List<SidePanelInfo> list, List<SidePanelInfo> list2) {
        LinkedList<SidePanelInfo> linkedList = new LinkedList<SidePanelInfo>();
        linkedList.addAll(list);
        linkedList.addAll(list2);
        return linkedList;
    }

    public TerraceDepthType calcSideOpeningPartsDepthType(TerracesInfo terracesInfo, boolean bl) {
        float f = this.calcSideOpeningLength(terracesInfo, bl);
        return TerraceDepthTypeDxo.convert(f, true);
    }

    public float calcSideOpeningLength(TerracesInfo terracesInfo, boolean bl) {
        return this.mTerraceCommonService.calcSideLength(terracesInfo, false, false, bl);
    }

    public TerraceDepthType calcSideRoomPartsDepthType(TerracesInfo terracesInfo, boolean bl) {
        float f = this.calcSideRoomLength(terracesInfo, bl);
        return TerraceDepthTypeDxo.convert(f, true);
    }

    public float calcSideRoomLength(TerracesInfo terracesInfo, boolean bl) {
        return this.mTerraceCommonService.calcSideLength(terracesInfo, false, true, bl);
    }

    public boolean hasLeftKutaiSidePanel(ZM2Entities zM2Entities) {
        return this.hasLeftKutaiSidePanel(zM2Entities.mBasicInfo, zM2Entities.mTerraceInfoList, zM2Entities.mLeftPanelInfoList);
    }

    public boolean hasLeftKutaiSidePanel(BasicInfo basicInfo, LinkedList<TerraceInfo> linkedList, LinkedList<SidePanelInfo> linkedList2) {
        float f = linkedList.getFirst().mLeftDepth.floatValue();
        int n = this.mTerraceFigureCommonService.calcSideSpanNum(f, basicInfo, true);
        int n2 = n - 1;
        return this.hasPanelByIndex(linkedList2, n2);
    }

    public boolean hasRightKutaiSidePanel(ZM2Entities zM2Entities) {
        return this.hasRightKutaiSidePanel(zM2Entities.mBasicInfo, zM2Entities.mTerraceInfoList, zM2Entities.mRightPanelInfoList);
    }

    public boolean hasRightKutaiSidePanel(BasicInfo basicInfo, LinkedList<TerraceInfo> linkedList, LinkedList<SidePanelInfo> linkedList2) {
        float f = linkedList.getLast().mRightDepth.floatValue();
        int n = this.mTerraceFigureCommonService.calcSideSpanNum(f, basicInfo, true);
        int n2 = n - 1;
        return this.hasPanelByIndex(linkedList2, n2);
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasPanelByIndex(LinkedList<SidePanelInfo> linkedList, int n) {
        void var4_8;
        HashMap<Integer, Boolean> hashMap = new HashMap<Integer, Boolean>();
        for (SidePanelInfo serializable2 : linkedList) {
            int n2 = serializable2.mIndex;
            while (n2 < serializable2.mIndex + serializable2.mSpan) {
                hashMap.put(n2, true);
                ++n2;
            }
        }
        Boolean bl = (Boolean)hashMap.get(n);
        if (bl == null) {
            Boolean bl2 = false;
        }
        return var4_8.booleanValue();
    }

    public boolean isValidLength(ProductType productType, EnforcementType enforcementType, TerraceDepthType terraceDepthType, float f, OpeningPanelType openingPanelType) {
        Collection<SpecMeasurementDepthInfo> collection = this.mSpecMeasurementDepthCacheDao.findManyByLength(productType, enforcementType, terraceDepthType, Float.valueOf(f), openingPanelType);
        return !collection.isEmpty();
    }

    public String createRengeMessage(ZM2Entities zM2Entities, TerraceDepthType terraceDepthType, CutLenType cutLenType) {
        ProductType productType = zM2Entities.mBasicInfo.mProductType;
        StringBuilder stringBuilder = new StringBuilder();
        if (productType == ProductType.ENCLOSE) {
            stringBuilder.append(this.createRengeMessage(zM2Entities, terraceDepthType, OpeningPanelType.ORIDO, cutLenType));
            stringBuilder.append(this.createRengeMessage(zM2Entities, terraceDepthType, OpeningPanelType.FIX, cutLenType));
        } else {
            stringBuilder.append(this.createRengeMessage(zM2Entities, terraceDepthType, null, cutLenType));
        }
        return stringBuilder.toString();
    }

    private String createRengeMessage(ZM2Entities zM2Entities, TerraceDepthType terraceDepthType, OpeningPanelType openingPanelType, CutLenType cutLenType) {
        ProductType productType = zM2Entities.mBasicInfo.mProductType;
        EnforcementType enforcementType = zM2Entities.mTerracesInfo.mEnforcementType;
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneByType(terraceDepthType);
        float f = typeTerraceDepthInfo.length.floatValue();
        StringBuilder stringBuilder = new StringBuilder();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (openingPanelType != null) {
            hashMap.put("PANEL", openingPanelType.mName);
            stringBuilder.append("\n");
            stringBuilder.append(this.mMessageService.createMessage("ui.step.measurement.remark.panelname", hashMap));
        }
        Collection<SpecMeasurementDepthInfo> collection = this.mSpecMeasurementDepthCacheDao.findManyByLength(productType, enforcementType, terraceDepthType, null, openingPanelType);
        if (cutLenType == CutLenType.CUT_LEN) {
            Collections.reverse((List)collection);
        }
        for (SpecMeasurementDepthInfo specMeasurementDepthInfo : collection) {
            float f2;
            float f3;
            if (f == specMeasurementDepthInfo.lengthMin.floatValue() && f == specMeasurementDepthInfo.lengthMax.floatValue()) continue;
            if (cutLenType == CutLenType.CUT_LEN) {
                f3 = (float)Math.round((f - specMeasurementDepthInfo.lengthMax.floatValue()) * 10.0f) * 0.1f;
                f2 = (float)Math.round((f - specMeasurementDepthInfo.lengthMin.floatValue()) * 10.0f) * 0.1f;
            } else {
                f3 = specMeasurementDepthInfo.lengthMin.floatValue();
                f2 = specMeasurementDepthInfo.lengthMax.floatValue();
            }
            hashMap = new HashMap();
            hashMap.put("MIN", Integer.toString((int)Math.ceil(f3)));
            hashMap.put("MAX", Integer.toString((int)Math.floor(f2)));
            stringBuilder.append("\n");
            stringBuilder.append(this.mMessageService.createMessage("ui.step.measurement.remark.range", hashMap));
        }
        return stringBuilder.toString();
    }
}

