/*
 * Decompiled with CFR 0.152.
 */
package option.zima2.common.service.parts;

import java.util.Collection;
import java.util.LinkedList;
import option.gad.core.inject.GdInject;
import option.gad.core.util.GdMutableTypeUtil;
import option.gad.core.util.ObjectUtil;
import option.zima2.common.dao.cache.spec.SpecBuildingWidthCacheDao;
import option.zima2.common.entity.BasicInfo;
import option.zima2.common.entity.TerraceInfo;
import option.zima2.common.entity.TerracesInfo;
import option.zima2.common.entity.ZM2Entities;
import option.zima2.common.entity.spec.SpecBuildingWidthInfo;
import option.zima2.common.service.parts.TerraceCommonService;
import option.zima2.common.type.KetaType;
import option.zima2.common.type.MiddlePillarPosType;
import option.zima2.common.type.NokiPlusFrontType;
import option.zima2.common.type.NokiPlusSideType;
import option.zima2.common.type.StrengthType;
import option.zima2.common.type.TerraceWidthType;
import option.zima2.common.type.factory.MiddlePillarPosTypeFactory;

public class PillarCommonService {
    @GdInject
    protected TerraceCommonService mTerraceCommonService;
    @GdInject
    private SpecBuildingWidthCacheDao mSpecBuildingWidthCacheDao;

    public boolean judgeMiddlePillarSelectable(TerraceWidthType terraceWidthType, NokiPlusSideType nokiPlusSideType, KetaType ketaType, ZM2Entities zM2Entities) {
        BasicInfo basicInfo = zM2Entities.mBasicInfo;
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        StrengthType strengthType = basicInfo.mStrengthType;
        NokiPlusFrontType nokiPlusFrontType = terracesInfo.mNokiPlusFrontType;
        Collection<SpecBuildingWidthInfo> collection = this.mSpecBuildingWidthCacheDao.findManyByTypes(nokiPlusFrontType, nokiPlusSideType, strengthType, ketaType, terraceWidthType, null, null, null, null);
        for (SpecBuildingWidthInfo specBuildingWidthInfo : collection) {
            for (SpecBuildingWidthInfo specBuildingWidthInfo2 : collection) {
                if (specBuildingWidthInfo.specBuildingWidthId.equals(specBuildingWidthInfo2.specBuildingWidthId) || !ObjectUtil.equals((Object)specBuildingWidthInfo.leftWidth, (Object)specBuildingWidthInfo2.leftWidth) || !ObjectUtil.equals((Object)specBuildingWidthInfo.mainWidth, (Object)specBuildingWidthInfo2.mainWidth) || !ObjectUtil.equals((Object)specBuildingWidthInfo.rightWidth, (Object)specBuildingWidthInfo2.rightWidth) || ObjectUtil.equals((Object)specBuildingWidthInfo.middlePillarPosType, (Object)specBuildingWidthInfo2.middlePillarPosType)) continue;
                return true;
            }
        }
        return false;
    }

    public MiddlePillarPosType convertMiddlePillarPosTypeFromLR(MiddlePillarPosType middlePillarPosType, TerraceInfo terraceInfo, ZM2Entities zM2Entities) {
        BasicInfo basicInfo = zM2Entities.mBasicInfo;
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        Collection<SpecBuildingWidthInfo> collection = this.mSpecBuildingWidthCacheDao.findManyByTypes(basicInfo, terracesInfo, terraceInfo, null);
        if (collection.size() > 1) {
            if (!GdMutableTypeUtil.matchOR(middlePillarPosType, MiddlePillarPosType.L, MiddlePillarPosType.R)) {
                middlePillarPosType = MiddlePillarPosType.R;
            }
            return middlePillarPosType;
        }
        SpecBuildingWidthInfo specBuildingWidthInfo = collection.iterator().next();
        return (MiddlePillarPosType)MiddlePillarPosTypeFactory.getInstance().getTypeById(specBuildingWidthInfo.middlePillarPosType);
    }

    public void updateMiddlePillarPos(ZM2Entities zM2Entities) {
        LinkedList<TerraceInfo> linkedList = zM2Entities.mTerraceInfoList;
        TerraceInfo terraceInfo = this.mTerraceCommonService.findLeftEdgeTerrace(linkedList);
        TerraceInfo terraceInfo2 = this.mTerraceCommonService.findRightEdgeTerrace(linkedList);
        this.changeMiddlePillarPos(zM2Entities, terraceInfo.mMiddlePillarPosType, terraceInfo2.mMiddlePillarPosType);
    }

    public void changeMiddlePillarPos(ZM2Entities zM2Entities, MiddlePillarPosType middlePillarPosType, MiddlePillarPosType middlePillarPosType2) {
        LinkedList<TerraceInfo> linkedList = zM2Entities.mTerraceInfoList;
        int n = 0;
        while (n < linkedList.size()) {
            TerraceInfo terraceInfo = linkedList.get(n);
            MiddlePillarPosType middlePillarPosType3 = n == 0 ? middlePillarPosType : middlePillarPosType2;
            terraceInfo.mMiddlePillarPosType = this.convertMiddlePillarPosTypeFromLR(middlePillarPosType3, terraceInfo, zM2Entities);
            this.updateMiddlePillarPosIndexes(terraceInfo, zM2Entities);
            ++n;
        }
    }

    protected void updateMiddlePillarPosIndexes(TerraceInfo terraceInfo, ZM2Entities zM2Entities) {
        BasicInfo basicInfo = zM2Entities.mBasicInfo;
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        Collection<SpecBuildingWidthInfo> collection = this.mSpecBuildingWidthCacheDao.findManyByTypes(basicInfo, terracesInfo, terraceInfo, terraceInfo.mMiddlePillarPosType);
        SpecBuildingWidthInfo specBuildingWidthInfo = collection.iterator().next();
        int n = Integer.parseInt(specBuildingWidthInfo.middlePillarPosArray, 2);
        int n2 = (int)(terraceInfo.mWidthType.mValue * 2.0f);
        terraceInfo.mMiddlePillarPosIndex1 = null;
        terraceInfo.mMiddlePillarPosIndex2 = null;
        int n3 = 0;
        int n4 = n2 - 1;
        while (n4 > 0) {
            if ((n & 1 << n4 - 1) > 0) {
                if (n3 == 0) {
                    terraceInfo.mMiddlePillarPosIndex1 = n2 - n4;
                } else {
                    terraceInfo.mMiddlePillarPosIndex2 = n2 - n4;
                }
                ++n3;
            }
            --n4;
        }
    }
}

