/*
 * Decompiled with CFR 0.152.
 */
package option.zima2.common.service.parts;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import option.gad.core.inject.GdInject;
import option.zima2.common.entity.BasicInfo;
import option.zima2.common.entity.TerraceInfo;
import option.zima2.common.entity.ZM2Entities;
import option.zima2.common.entity.option.GeneralOptionInfo;
import option.zima2.common.entity.option.OptionInfo;
import option.zima2.common.service.parts.TerraceCommonService;
import option.zima2.common.type.OptionType;
import option.zima2.common.type.ProductType;
import option.zima2.common.type.StrengthType;
import option.zima2.common.type.SubProductType;
import option.zima2.common.type.SupportFrameSizeType;
import option.zima2.common.type.TerraceWidthType;
import option.zima2.common.type.option.PartsSizeType;
import option.zima2.server.type.PickCategoryType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OptionCommonService {
    @GdInject
    protected TerraceCommonService mTerraceService;
    private static final Log log = LogFactory.getLog(OptionCommonService.class);

    protected OptionCommonService() {
    }

    public <T extends OptionInfo> T findOneOptionInfo(OptionType optionType, List<OptionInfo> list) {
        for (OptionInfo optionInfo : list) {
            if (optionInfo.mOptionType != optionType) continue;
            return (T)optionInfo;
        }
        return null;
    }

    public List<GeneralOptionInfo> findManyOptionInfoByCategoryType(PickCategoryType pickCategoryType, List<OptionInfo> list) {
        ArrayList<GeneralOptionInfo> arrayList = new ArrayList<GeneralOptionInfo>();
        for (OptionInfo optionInfo : list) {
            if (!(optionInfo instanceof GeneralOptionInfo)) continue;
            GeneralOptionInfo generalOptionInfo = (GeneralOptionInfo)optionInfo;
            if (generalOptionInfo.mCategoryType != pickCategoryType) continue;
            arrayList.add(generalOptionInfo);
        }
        return arrayList;
    }

    public boolean hasOptionByCategoryType(PickCategoryType pickCategoryType, List<OptionInfo> list) {
        boolean bl = false;
        for (OptionInfo optionInfo : list) {
            if (!(optionInfo instanceof GeneralOptionInfo)) continue;
            GeneralOptionInfo generalOptionInfo = (GeneralOptionInfo)optionInfo;
            if (generalOptionInfo.mCategoryType != pickCategoryType) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public GeneralOptionInfo findInnerShade(List<OptionInfo> list) {
        return this.findOneByCategoryType(PickCategoryType.T461, list);
    }

    public GeneralOptionInfo findSupportFrame(List<OptionInfo> list) {
        return this.findOneByCategoryType(PickCategoryType.T471, list);
    }

    public GeneralOptionInfo findSlidingAmido(List<OptionInfo> list) {
        return this.findOneByCategoryType(PickCategoryType.T501, list);
    }

    public GeneralOptionInfo findShunoAmido(List<OptionInfo> list) {
        return this.findOneByCategoryType(PickCategoryType.T511, list);
    }

    public GeneralOptionInfo findOneByCategoryType(PickCategoryType pickCategoryType, List<OptionInfo> list) {
        List<GeneralOptionInfo> list2 = this.findManyOptionInfoByCategoryType(pickCategoryType, list);
        if (list2 == null || list2.isEmpty()) {
            return null;
        }
        return list2.get(0);
    }

    public boolean hasSupportFrame(List<OptionInfo> list) {
        GeneralOptionInfo generalOptionInfo = this.findOneByCategoryType(PickCategoryType.T471, list);
        return generalOptionInfo != null;
    }

    public boolean hasSupportFrameMiddlePillar(ZM2Entities zM2Entities) {
        TerraceWidthType terraceWidthType;
        BasicInfo basicInfo = zM2Entities.mBasicInfo;
        LinkedList<OptionInfo> linkedList = zM2Entities.mOptionInfoList;
        TerraceInfo terraceInfo = this.mTerraceService.findMasterTerraceInfo(zM2Entities.mTerraceInfoList);
        if (!this.hasSupportFrame(linkedList)) {
            return false;
        }
        TerraceWidthType terraceWidthType2 = terraceWidthType = basicInfo.mProductType == ProductType.TERRACE ? terraceInfo.mWidthType : terraceInfo.mRoomWidthType;
        if (basicInfo.mStrengthType == StrengthType.T3000) {
            return terraceWidthType.mValue >= 2.0f;
        }
        return (double)terraceWidthType.mValue >= 2.5;
    }

    public boolean isDrawableSupportFrame(ZM2Entities zM2Entities) {
        return zM2Entities.mPartsFigureInfo.mIsDrawableSupportFrame;
    }

    public SupportFrameSizeType findSupportFrameSizeType(List<OptionInfo> list) {
        GeneralOptionInfo generalOptionInfo = this.findOneByCategoryType(PickCategoryType.T471, list);
        if (generalOptionInfo == null) {
            return null;
        }
        if (generalOptionInfo.mPartsSize == PartsSizeType.SIZE1) {
            return SupportFrameSizeType.T0;
        }
        if (generalOptionInfo.mPartsSize == PartsSizeType.SIZE2) {
            return SupportFrameSizeType.T100;
        }
        if (generalOptionInfo.mPartsSize == PartsSizeType.SIZE3) {
            return SupportFrameSizeType.T400;
        }
        return null;
    }

    public float findSupportFrameSize(List<OptionInfo> list) {
        SupportFrameSizeType supportFrameSizeType = this.findSupportFrameSizeType(list);
        if (supportFrameSizeType == SupportFrameSizeType.T0) {
            return 0.0f;
        }
        if (supportFrameSizeType == SupportFrameSizeType.T100) {
            return 100.0f;
        }
        if (supportFrameSizeType == SupportFrameSizeType.T400) {
            return 400.0f;
        }
        return -1.0f;
    }

    public float getSupportFramePillarDeph() {
        return 120.0f;
    }

    public float getSupportFrameDeph(List<OptionInfo> list) {
        if (this.hasSupportFrame(list)) {
            return this.findSupportFrameSize(list) + this.getSupportFramePillarDeph();
        }
        return 0.0f;
    }

    public float getDrawingSupportFrameDeph(ZM2Entities zM2Entities) {
        if (!this.isDrawableSupportFrame(zM2Entities)) {
            return 0.0f;
        }
        return this.getSupportFrameDeph(zM2Entities.mOptionInfoList);
    }

    public boolean hasSupportFrameGrating(ZM2Entities zM2Entities) {
        return zM2Entities.mBasicInfo.mProductType == ProductType.ENCLOSE && zM2Entities.mBasicInfo.mSubProductType != SubProductType.DOMA;
    }
}

