/*
 * Decompiled with CFR 0.152.
 */
package option.zima2.common.service.material;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import option.gad.core.inject.GdInject;
import option.gad.core.util.GdMutableTypeUtil;
import option.zima2.common.dao.cache.type.TypeTerraceDepthCacheDao;
import option.zima2.common.dao.cache.type.TypeTerraceWidthCacheDao;
import option.zima2.common.entity.BasicInfo;
import option.zima2.common.entity.DomaTileInfo;
import option.zima2.common.entity.TerraceInfo;
import option.zima2.common.entity.TerracesInfo;
import option.zima2.common.entity.ZM2Entities;
import option.zima2.common.entity.type.TypeTerraceDepthInfo;
import option.zima2.common.entity.type.TypeTerraceWidthInfo;
import option.zima2.common.service.parts.TerraceCommonService;
import option.zima2.common.type.DirectionType;
import option.zima2.common.type.EnforcementDirType;
import option.zima2.common.type.EnforcementType;
import option.zima2.common.type.SodePosType;
import option.zima2.common.type.TerraceDepthType;
import option.zima2.common.type.TerraceWidthType;
import option.zima2.server.dxo.TerraceDepthTypeDxo;

public class TerraceInfoService {
    private static final float DEFAULT_DEPTH_GAP = 10.0f;
    private static final float DEFAULT_PARTIAL_DEPTH = 86.0f;
    @GdInject
    private TerraceCommonService mTerraceCommonService;
    @GdInject
    private TypeTerraceWidthCacheDao mTypeTerraceWidthCacheDao;
    @GdInject
    private TypeTerraceDepthCacheDao mTypeTerraceDepthCacheDao;

    protected TerraceInfoService() {
    }

    public List<TerraceInfo> create(ZM2Entities zM2Entities) {
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        EnforcementType enforcementType = terracesInfo.mEnforcementType;
        EnforcementDirType enforcementDirType = terracesInfo.mEnforcementDirType;
        SodePosType sodePosType = terracesInfo.mSodePosType;
        ArrayList<TerraceInfo> arrayList = new ArrayList<TerraceInfo>();
        if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.STD)) {
            arrayList.addAll(this.createStandard(zM2Entities));
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.KUTAI_DEHABA_CHIGAI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.L)) {
            arrayList.addAll(this.createKutaiDehabaChigaiL(zM2Entities));
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.KUTAI_DEHABA_CHIGAI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.R)) {
            arrayList.addAll(this.createKutaiDehabaChigaiR(zM2Entities));
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.BUBUN_IRISUMI) && sodePosType == SodePosType.L) {
            arrayList.addAll(this.createStandard(zM2Entities));
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.BUBUN_IRISUMI) && sodePosType == SodePosType.R) {
            arrayList.addAll(this.createStandard(zM2Entities));
        }
        return arrayList;
    }

    private List<TerraceInfo> createStandard(ZM2Entities zM2Entities) {
        TerraceWidthType terraceWidthType = TerraceWidthType.T20;
        TerraceDepthType terraceDepthType = TerraceDepthType.T6;
        TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType);
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneByType(terraceDepthType);
        ArrayList<TerraceInfo> arrayList = new ArrayList<TerraceInfo>();
        TerraceInfo terraceInfo = new TerraceInfo();
        terraceInfo.mIsMaster = true;
        terraceInfo.mIsStarting = true;
        terraceInfo.mId = 0;
        terraceInfo.mGroupId = 0;
        terraceInfo.mTurningAngle = Float.valueOf(0.0f);
        terraceInfo.mWidthType = terraceWidthType;
        terraceInfo.mDefaultWidth = typeTerraceWidthInfo.length;
        terraceInfo.mWidth = typeTerraceWidthInfo.length;
        terraceInfo.mDepthType = terraceDepthType;
        terraceInfo.mDefaultDepth = typeTerraceDepthInfo.length;
        terraceInfo.mDepth = typeTerraceDepthInfo.length;
        arrayList.add(terraceInfo);
        return arrayList;
    }

    private List<TerraceInfo> createKutaiDehabaChigaiL(ZM2Entities zM2Entities) {
        TerraceWidthType terraceWidthType = TerraceWidthType.T20;
        TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType);
        TerraceWidthType terraceWidthType2 = TerraceWidthType.T05;
        TypeTerraceWidthInfo typeTerraceWidthInfo2 = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType2);
        TerraceDepthType terraceDepthType = TerraceDepthType.T6;
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneByType(terraceDepthType);
        float f = 10.0f;
        ArrayList<TerraceInfo> arrayList = new ArrayList<TerraceInfo>();
        TerraceInfo terraceInfo = new TerraceInfo();
        terraceInfo.mIsMaster = true;
        terraceInfo.mIsStarting = true;
        terraceInfo.mId = 0;
        terraceInfo.mGroupId = 0;
        terraceInfo.mTurningAngle = Float.valueOf(0.0f);
        terraceInfo.mWidthType = terraceWidthType;
        terraceInfo.mDefaultWidth = typeTerraceWidthInfo.length;
        terraceInfo.mWidth = typeTerraceWidthInfo.length;
        terraceInfo.mLeftWidthType = terraceWidthType2;
        terraceInfo.mLeftWidth = typeTerraceWidthInfo2.length;
        terraceInfo.mLeftDepthType = terraceDepthType;
        terraceInfo.mLeftDepth = Float.valueOf(typeTerraceDepthInfo.length.floatValue() - f);
        arrayList.add(terraceInfo);
        return arrayList;
    }

    private List<TerraceInfo> createKutaiDehabaChigaiR(ZM2Entities zM2Entities) {
        TerraceWidthType terraceWidthType = TerraceWidthType.T20;
        TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType);
        TerraceWidthType terraceWidthType2 = TerraceWidthType.T05;
        TypeTerraceWidthInfo typeTerraceWidthInfo2 = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType2);
        TerraceDepthType terraceDepthType = TerraceDepthType.T6;
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneByType(terraceDepthType);
        float f = 10.0f;
        ArrayList<TerraceInfo> arrayList = new ArrayList<TerraceInfo>();
        TerraceInfo terraceInfo = new TerraceInfo();
        terraceInfo.mIsMaster = true;
        terraceInfo.mIsStarting = true;
        terraceInfo.mId = 0;
        terraceInfo.mGroupId = 0;
        terraceInfo.mTurningAngle = Float.valueOf(0.0f);
        terraceInfo.mWidthType = terraceWidthType;
        terraceInfo.mDefaultWidth = typeTerraceWidthInfo.length;
        terraceInfo.mWidth = typeTerraceWidthInfo.length;
        terraceInfo.mLeftWidthType = terraceWidthType2;
        terraceInfo.mLeftWidth = typeTerraceWidthInfo2.length;
        terraceInfo.mRightDepthType = terraceDepthType;
        terraceInfo.mRightDepth = Float.valueOf(typeTerraceDepthInfo.length.floatValue() - f);
        arrayList.add(terraceInfo);
        return arrayList;
    }

    public TerraceInfo addTerrace(ZM2Entities zM2Entities, DirectionType directionType) {
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        LinkedList<TerraceInfo> linkedList = zM2Entities.mTerraceInfoList;
        return this.addTerrace(zM2Entities, terracesInfo, linkedList, directionType);
    }

    public TerraceInfo addTerrace(ZM2Entities zM2Entities, TerracesInfo terracesInfo, LinkedList<TerraceInfo> linkedList, DirectionType directionType) {
        BasicInfo basicInfo = zM2Entities.mBasicInfo;
        TerraceInfo terraceInfo = linkedList.getFirst();
        TerraceInfo terraceInfo2 = linkedList.getLast();
        TerraceInfo terraceInfo3 = new TerraceInfo();
        TerraceWidthType terraceWidthType = TerraceWidthType.T20;
        TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType);
        TerraceDepthType terraceDepthType = null;
        float f = 0.0f;
        TerraceDepthType terraceDepthType2 = null;
        float f2 = 0.0f;
        int n = 0;
        TerraceInfo terraceInfo4 = null;
        if (directionType == DirectionType.LEFT) {
            n = -1;
            terraceInfo4 = linkedList.getFirst();
            linkedList.addFirst(terraceInfo3);
            terraceDepthType = terraceInfo4.mDepthType;
            f = terraceInfo4.mDepth.floatValue();
            terraceDepthType2 = terraceInfo4.mLeftDepthType;
            f2 = terraceInfo4.mLeftDepth.floatValue();
        } else if (directionType == DirectionType.RIGHT) {
            n = 1;
            terraceInfo4 = linkedList.getLast();
            linkedList.addLast(terraceInfo3);
            terraceDepthType = terraceInfo4.mDepthType;
            f = terraceInfo4.mDepth.floatValue();
            terraceDepthType2 = terraceInfo4.mRightDepthType;
            f2 = terraceInfo4.mRightDepth.floatValue();
        }
        if (terracesInfo.mEnforcementType != EnforcementType.BUBUN_IRISUMI) {
            terraceDepthType = terraceDepthType2;
            f = f2;
        }
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneByType(terraceDepthType);
        terraceInfo3.mIsMaster = false;
        terraceInfo3.mIsStarting = false;
        terraceInfo3.mId = terraceInfo4.mId + n;
        terraceInfo3.mGroupId = terraceInfo4.mGroupId;
        terraceInfo3.mWidthType = terraceWidthType;
        terraceInfo3.mDefaultWidth = typeTerraceWidthInfo.length;
        terraceInfo3.mWidth = typeTerraceWidthInfo.length;
        terraceInfo3.mDepthType = terraceDepthType;
        terraceInfo3.mDefaultDepth = typeTerraceDepthInfo.length;
        terraceInfo3.mDepth = Float.valueOf(f);
        terraceInfo3.mFrontDepthType = terraceInfo4.mFrontDepthType;
        terraceInfo3.mFrontDepth = terraceInfo4.mFrontDepth;
        terraceInfo3.mBackDepthType = terraceInfo4.mBackDepthType;
        terraceInfo3.mBackDepth = terraceInfo4.mBackDepth;
        if (terracesInfo.mEnforcementType == EnforcementType.BUBUN_IRISUMI) {
            if (terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
                terraceInfo3.mLeftDepthType = terraceDepthType2;
                terraceInfo3.mLeftDepth = Float.valueOf(f2);
                terraceInfo3.mRightDepthType = terraceDepthType;
                terraceInfo3.mRightDepth = Float.valueOf(f);
            } else if (terracesInfo.mEnforcementDirType == EnforcementDirType.R) {
                terraceInfo3.mLeftDepthType = terraceDepthType;
                terraceInfo3.mLeftDepth = Float.valueOf(f);
                terraceInfo3.mRightDepthType = terraceDepthType2;
                terraceInfo3.mRightDepth = Float.valueOf(f2);
            }
        } else {
            terraceInfo3.mLeftDepthType = terraceDepthType2;
            terraceInfo3.mLeftDepth = Float.valueOf(f2);
            terraceInfo3.mRightDepthType = terraceDepthType2;
            terraceInfo3.mRightDepth = Float.valueOf(f2);
        }
        terraceInfo3.mTurningAngle = terraceInfo4.mTurningAngle;
        terraceInfo4.mTurningAngle = Float.valueOf(0.0f);
        TerraceInfo terraceInfo5 = linkedList.getFirst();
        TerraceInfo terraceInfo6 = linkedList.getLast();
        if (directionType == DirectionType.LEFT) {
            terraceInfo5.mIsLeftEnd = true;
            if (terraceInfo5 != terraceInfo) {
                terraceInfo.mIsLeftEnd = false;
            }
        } else {
            terraceInfo6.mIsRightEnd = true;
            if (terraceInfo6 != terraceInfo2) {
                terraceInfo2.mIsRightEnd = false;
            }
        }
        if (terraceInfo5 != terraceInfo6) {
            terraceInfo5.mIsRightEnd = false;
            terraceInfo6.mIsLeftEnd = false;
        }
        this.mTerraceCommonService.updateTerracesInfo(basicInfo, terracesInfo, linkedList);
        this.updateDepth(terracesInfo, linkedList);
        return terraceInfo3;
    }

    public void removeTerrace(ZM2Entities zM2Entities, DirectionType directionType) {
        LinkedList<TerraceInfo> linkedList = zM2Entities.mTerraceInfoList;
        if (directionType == DirectionType.RIGHT) {
            TerraceInfo terraceInfo = linkedList.getFirst();
            if (terraceInfo.mIsMaster.booleanValue()) {
                return;
            }
            linkedList.removeFirst();
            TerraceInfo terraceInfo2 = linkedList.getFirst();
            terraceInfo2.mIsLeftEnd = true;
            terraceInfo2.mTurningAngle = terraceInfo.mTurningAngle;
        } else if (directionType == DirectionType.LEFT) {
            TerraceInfo terraceInfo = linkedList.getLast();
            if (terraceInfo.mIsMaster.booleanValue()) {
                return;
            }
            linkedList.removeLast();
            TerraceInfo terraceInfo3 = linkedList.getLast();
            terraceInfo3.mIsRightEnd = true;
            terraceInfo3.mTurningAngle = terraceInfo.mTurningAngle;
        }
        this.mTerraceCommonService.updateTerracesInfo(zM2Entities);
    }

    public void adjustDepth(ZM2Entities zM2Entities) {
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        DomaTileInfo domaTileInfo = zM2Entities.mDomaTileInfo;
        EnforcementType enforcementType = terracesInfo.mEnforcementType;
        EnforcementDirType enforcementDirType = terracesInfo.mEnforcementDirType;
        SodePosType sodePosType = terracesInfo.mSodePosType;
        if (enforcementType == EnforcementType.STD) {
            terracesInfo.mPartialDepth = Float.valueOf(0.0f);
            terracesInfo.mDepthGap = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = Float.valueOf(0.0f);
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.STD)) {
            terracesInfo.mPartialDepth = Float.valueOf(0.0f);
            terracesInfo.mDepthGap = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = Float.valueOf(0.0f);
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.KUTAI_DEHABA_CHIGAI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.L)) {
            terracesInfo.mPartialDepth = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = terracesInfo.mDepthGap = Float.valueOf(10.0f);
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.KUTAI_DEHABA_CHIGAI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.R)) {
            terracesInfo.mPartialDepth = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = terracesInfo.mDepthGap = Float.valueOf(10.0f);
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.BUBUN_IRISUMI) && sodePosType == SodePosType.L) {
            terracesInfo.mPartialDepth = Float.valueOf(86.0f);
            terracesInfo.mDepthGap = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = terracesInfo.mPartialDepth;
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.BUBUN_IRISUMI) && sodePosType == SodePosType.R) {
            terracesInfo.mPartialDepth = Float.valueOf(86.0f);
            terracesInfo.mDepthGap = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = terracesInfo.mPartialDepth;
        }
    }

    public void updateDepth(ZM2Entities zM2Entities) {
        this.updateDepth(zM2Entities.mTerracesInfo, zM2Entities.mTerraceInfoList);
    }

    public void updateDepth(TerracesInfo terracesInfo, LinkedList<TerraceInfo> linkedList) {
        EnforcementType enforcementType = terracesInfo.mEnforcementType;
        EnforcementDirType enforcementDirType = terracesInfo.mEnforcementDirType;
        SodePosType sodePosType = terracesInfo.mSodePosType;
        for (TerraceInfo terraceInfo : linkedList) {
            if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.STD)) {
                terraceInfo.mLeftDepth = terraceInfo.mDepth;
                terraceInfo.mRightDepth = terraceInfo.mDepth;
            } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.KUTAI_DEHABA_CHIGAI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.L)) {
                if (terraceInfo.mId == 0) {
                    terraceInfo.mLeftDepth = Float.valueOf(terracesInfo.mDepth.floatValue() - terracesInfo.mDepthGap.floatValue());
                    terraceInfo.mRightDepth = terracesInfo.mDepth;
                } else if (terraceInfo.mId < 0) {
                    terraceInfo.mLeftDepth = Float.valueOf(terracesInfo.mDepth.floatValue() - terracesInfo.mDepthGap.floatValue());
                    terraceInfo.mRightDepth = Float.valueOf(terracesInfo.mDepth.floatValue() - terracesInfo.mDepthGap.floatValue());
                } else if (terraceInfo.mId > 0) {
                    terraceInfo.mLeftDepth = terracesInfo.mDepth;
                    terraceInfo.mRightDepth = terracesInfo.mDepth;
                }
            } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.KUTAI_DEHABA_CHIGAI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.R)) {
                if (terraceInfo.mId == 0) {
                    terraceInfo.mLeftDepth = terracesInfo.mDepth;
                    terraceInfo.mRightDepth = Float.valueOf(terracesInfo.mDepth.floatValue() - terracesInfo.mDepthGap.floatValue());
                } else if (terraceInfo.mId < 0) {
                    terraceInfo.mLeftDepth = terracesInfo.mDepth;
                    terraceInfo.mRightDepth = terracesInfo.mDepth;
                } else if (terraceInfo.mId > 0) {
                    terraceInfo.mLeftDepth = Float.valueOf(terracesInfo.mDepth.floatValue() - terracesInfo.mDepthGap.floatValue());
                    terraceInfo.mRightDepth = Float.valueOf(terracesInfo.mDepth.floatValue() - terracesInfo.mDepthGap.floatValue());
                }
            } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.BUBUN_IRISUMI) && GdMutableTypeUtil.matchOR(sodePosType, SodePosType.L)) {
                terraceInfo.mLeftDepth = Float.valueOf(terraceInfo.mDepth.floatValue() - terracesInfo.mPartialDepth.floatValue());
                terraceInfo.mRightDepth = terraceInfo.mDepth;
            } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.BUBUN_IRISUMI) && GdMutableTypeUtil.matchOR(sodePosType, SodePosType.R)) {
                terraceInfo.mLeftDepth = terraceInfo.mDepth;
                terraceInfo.mRightDepth = Float.valueOf(terraceInfo.mDepth.floatValue() - terracesInfo.mPartialDepth.floatValue());
            }
            terraceInfo.mLeftDepthType = TerraceDepthTypeDxo.convert(terraceInfo.mLeftDepth.floatValue());
            terraceInfo.mRightDepthType = TerraceDepthTypeDxo.convert(terraceInfo.mRightDepth.floatValue());
        }
    }

    public List<TerraceInfo> findManyByGroupId(List<TerraceInfo> list, Integer n) {
        ArrayList<TerraceInfo> arrayList = new ArrayList<TerraceInfo>();
        for (TerraceInfo terraceInfo : list) {
            if (!terraceInfo.mGroupId.equals(n)) continue;
            arrayList.add(terraceInfo);
        }
        return arrayList;
    }
}

