/*
 * Decompiled with CFR 0.152.
 */
package option.zima2.common.service.material;

import com.kt.annotation.Reflectable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import option.gad.core.inject.GdInject;
import option.zima2.common.dao.cache.AlternativeColorCacheDao;
import option.zima2.common.dao.cache.CategoryColorCacheDao;
import option.zima2.common.entity.CategoryColorInfo;
import option.zima2.common.type.ProductSeriesType;
import option.zima2.common.type.ZM2ColorType;
import option.zima2.common.type.factory.ZM2ColorTypeFactory;

@Reflectable
public class ColorCommonService {
    @GdInject
    protected AlternativeColorCacheDao alternativeColorCacheDao;
    @GdInject
    protected CategoryColorCacheDao categoryColorCacheDao;
    public static final int CATEGORY_BODY = 300000001;
    public static final int CATEGORY_PILLAR = 300000002;
    public static final int CATEGORY_MAKUITA = 300000003;
    public static final int CATEGORY_INNER_DECK_FLOOR = 300000005;
    public static final int CATEGORY_INNER_DECK_TSUKA = 300000006;

    public List<ZM2ColorType> findColorTypes(int n) {
        ArrayList<ZM2ColorType> arrayList = new ArrayList<ZM2ColorType>();
        Collection<CategoryColorInfo> collection = this.categoryColorCacheDao.findManyByCategoryId(ProductSeriesType.ZIMA2, n);
        for (CategoryColorInfo categoryColorInfo : collection) {
            ZM2ColorType zM2ColorType = (ZM2ColorType)ZM2ColorTypeFactory.getInstance().getTypeById(categoryColorInfo.colorId);
            arrayList.add(zM2ColorType);
        }
        return arrayList;
    }

    public CategoryColorInfo findCategoryColorInfo(int n, int n2) {
        return this.categoryColorCacheDao.findOneByColorId(ProductSeriesType.ZIMA2, n, n2);
    }
}

