/*
 * Decompiled with CFR 0.152.
 */
package option.zima2.common.service.floor;

import java.util.LinkedList;
import java.util.List;
import option.gad.core.inject.GdInject;
import option.gad.core.inject.GdInjector;
import option.zima2.common.entity.BasicInfo;
import option.zima2.common.entity.InnerDeckInfo;
import option.zima2.common.entity.TerraceInfo;
import option.zima2.common.entity.TerracesInfo;
import option.zima2.common.service.parts.SidePanelCommonService;
import option.zima2.common.service.parts.TerraceCommonService;
import option.zima2.common.type.EnforcementDirType;
import option.zima2.common.type.EnforcementType;
import option.zima2.common.type.NokiPlusFrontType;
import option.zima2.common.type.ProductType;
import option.zima2.common.type.SodePosType;
import option.zima2.common.type.TerraceDepthType;
import option.zima2.server.dxo.TerraceDepthTypeDxo;

public class FloorShapeCommonService {
    @GdInject
    private TerraceCommonService mTerraceService;
    @GdInject
    private SidePanelCommonService mSidePanelService;
    protected static final float PILLAR_TO_BASE_FRONT = 125.0f;
    protected static final float IDOUHOUTATE_DEPTH = 50.0f;
    protected static final float BASE_WIDTH = 75.0f;

    public FloorShapeCommonService() {
        GdInjector.getInstance().inject((Object)this);
    }

    public TerraceDepthType calcSideBasementPartsDepthType(BasicInfo basicInfo, TerracesInfo terracesInfo, LinkedList<TerraceInfo> linkedList, boolean bl) {
        float f = this.calcSideBasementSize(basicInfo, terracesInfo, linkedList, bl);
        return TerraceDepthTypeDxo.convert(f + 125.0f, true);
    }

    public float calcSideBasementSize(BasicInfo basicInfo, TerracesInfo terracesInfo, LinkedList<TerraceInfo> linkedList, boolean bl) {
        TerraceInfo terraceInfo = bl ? this.mTerraceService.findLeftEdgeTerrace(linkedList) : this.mTerraceService.findRightEdgeTerrace(linkedList);
        EnforcementType enforcementType = terracesInfo.mEnforcementType;
        SodePosType sodePosType = terracesInfo.mSodePosType;
        float f = (bl ? terraceInfo.mLeftDepth : terraceInfo.mRightDepth).floatValue();
        if (terracesInfo.mNokiPlusFrontType == NokiPlusFrontType.EXIST) {
            f = this.mTerraceService.calcRoomDepth(basicInfo, terracesInfo, linkedList);
        }
        float f2 = f - 125.0f;
        if (enforcementType == EnforcementType.BUBUN_IRISUMI && sodePosType == SodePosType.L == bl) {
            float f3 = terraceInfo.mDefaultDepth.floatValue();
            float f4 = f3 - f;
            f2 = f4 < 125.0f ? f3 - 125.0f - 75.0f : (f2 += 50.0f);
        }
        return f2;
    }

    public boolean isBasementCut(BasicInfo basicInfo, TerracesInfo terracesInfo, LinkedList<TerraceInfo> linkedList, boolean bl) {
        float f = this.calcSideBasementSize(basicInfo, terracesInfo, linkedList, bl);
        float f2 = this.mTerraceService.calcRoomDepth(basicInfo, terracesInfo, linkedList);
        TerraceDepthType terraceDepthType = TerraceDepthTypeDxo.convert(f2);
        float f3 = TerraceDepthTypeDxo.convertToLength(terraceDepthType).floatValue();
        return f3 - 125.0f > f;
    }

    public boolean hasSideBasement(TerracesInfo terracesInfo, TerraceInfo terraceInfo, BasicInfo basicInfo, InnerDeckInfo innerDeckInfo, boolean bl) {
        if (basicInfo.mProductType == ProductType.ENCLOSE) {
            if (terracesInfo.mEnforcementType != EnforcementType.BUBUN_IRISUMI) {
                if (bl && terracesInfo.mSodePosType == SodePosType.L) {
                    return false;
                }
                if (!bl && terracesInfo.mSodePosType == SodePosType.R) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public float calcFrontExBasementSize(BasicInfo basicInfo, List<TerraceInfo> list) {
        return 0.0f;
    }

    public float calcRearBaseLength(TerracesInfo terracesInfo, LinkedList<TerraceInfo> linkedList, boolean bl) {
        EnforcementDirType enforcementDirType = terracesInfo.mEnforcementDirType;
        TerraceInfo terraceInfo = this.mTerraceService.findMasterTerraceInfo(linkedList);
        float f = (bl ? terraceInfo.mLeftWidth : terraceInfo.mRightWidth).floatValue();
        f = (float)((double)f - 82.5);
        f = enforcementDirType == EnforcementDirType.L == bl ? (float)((double)f - 32.5) : (float)((double)f + 32.5);
        return f;
    }
}

