/*
 * Decompiled with CFR 0.152.
 */
package option.zima2.common.service.common;

import com.kt.util.StringUtil;
import java.awt.Color;
import option.gad.core.inject.GdInstanceFactory;
import option.zima2.common.dao.cache.ColorCacheDao;
import option.zima2.common.dao.cache.type.TypePanelMaterialCacheDao;
import option.zima2.common.entity.ColorInfo;
import option.zima2.common.entity.type.TypePanelMaterialInfo;
import option.zima2.common.type.PanelMaterialType;
import option.zima2.common.type.ZM2ColorType;
import option.zima2.common.type.factory.ZM2ColorTypeFactory;

public class ZM2Color {
    public static Color getColor(ZM2ColorType zM2ColorType) {
        if (zM2ColorType == null) {
            return null;
        }
        return ZM2Color.getColor(zM2ColorType.id());
    }

    public static Color getColor(int n) {
        ColorCacheDao colorCacheDao = (ColorCacheDao)((Object)GdInstanceFactory.getInstance().getInstance(ColorCacheDao.class, new Object[0]));
        ColorInfo colorInfo = colorCacheDao.findOneById(n);
        return ZM2Color.getColor(colorInfo);
    }

    public static Color getColor(ColorInfo colorInfo) {
        Color color = null;
        if (colorInfo != null && !StringUtil.isEmpty((String)colorInfo.threedArgb) && colorInfo.threedArgb.length() == 8) {
            int n = Integer.parseInt(colorInfo.threedArgb.substring(0, 2), 16);
            int n2 = Integer.parseInt(colorInfo.threedArgb.substring(2, 4), 16);
            int n3 = Integer.parseInt(colorInfo.threedArgb.substring(4, 6), 16);
            int n4 = Integer.parseInt(colorInfo.threedArgb.substring(6, 8), 16);
            color = new Color(n2, n3, n4, n);
        } else {
            color = Color.BLACK;
        }
        return color;
    }

    public static String getName(ZM2ColorType zM2ColorType) {
        if (zM2ColorType == null) {
            return "";
        }
        return ZM2Color.getName(zM2ColorType.id());
    }

    public static String getName(int n) {
        ColorCacheDao colorCacheDao = (ColorCacheDao)((Object)GdInstanceFactory.getInstance().getInstance(ColorCacheDao.class, new Object[0]));
        return ZM2Color.getName(colorCacheDao.findOneById(n));
    }

    public static String getName(ColorInfo colorInfo) {
        return colorInfo.name;
    }

    public static TypePanelMaterialInfo getPanelMaterialInfo(PanelMaterialType panelMaterialType) {
        TypePanelMaterialCacheDao typePanelMaterialCacheDao = (TypePanelMaterialCacheDao)((Object)GdInstanceFactory.getInstance().getInstance(TypePanelMaterialCacheDao.class, new Object[0]));
        return typePanelMaterialCacheDao.findOneByType(panelMaterialType);
    }

    public static ZM2ColorType getColorType(PanelMaterialType panelMaterialType) {
        TypePanelMaterialInfo typePanelMaterialInfo = ZM2Color.getPanelMaterialInfo(panelMaterialType);
        return (ZM2ColorType)ZM2ColorTypeFactory.getInstance().getTypeById(typePanelMaterialInfo.colorId);
    }

    public static Color getColor(PanelMaterialType panelMaterialType) {
        TypePanelMaterialInfo typePanelMaterialInfo = ZM2Color.getPanelMaterialInfo(panelMaterialType);
        ColorCacheDao colorCacheDao = (ColorCacheDao)((Object)GdInstanceFactory.getInstance().getInstance(ColorCacheDao.class, new Object[0]));
        ColorInfo colorInfo = colorCacheDao.findOneById(typePanelMaterialInfo.colorId);
        return ZM2Color.getColor(colorInfo);
    }
}

