/*
 * Decompiled with CFR 0.152.
 */
package option.zima2.common.service.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import option.gad.core.inject.GdInject;
import option.zima2.common.dao.cache.spec.SpecBuildingSizeComboCacheDao;
import option.zima2.common.dao.cache.spec.SpecBuildingWidthCacheDao;
import option.zima2.common.dxo.TerraceWidthTypeDxo;
import option.zima2.common.entity.BasicInfo;
import option.zima2.common.entity.TerracesInfo;
import option.zima2.common.entity.ZM2Entities;
import option.zima2.common.entity.spec.SpecBuildingSizeComboInfo;
import option.zima2.common.entity.spec.SpecBuildingWidthInfo;
import option.zima2.common.service.parts.SidePanelCommonService;
import option.zima2.common.service.parts.TerraceCommonService;
import option.zima2.common.type.EnforcementType;
import option.zima2.common.type.InnerRoofUseType;
import option.zima2.common.type.KetaType;
import option.zima2.common.type.NokiPlusFrontType;
import option.zima2.common.type.NokiPlusSideType;
import option.zima2.common.type.OpeningPanelType;
import option.zima2.common.type.OuterHandleType;
import option.zima2.common.type.StrengthType;
import option.zima2.common.type.TerraceWidthType;
import option.zima2.common.type.factory.KetaTypeFactory;

public class BasicInfoCommonService {
    @GdInject
    protected TerraceCommonService mTerraceService;
    @GdInject
    protected SidePanelCommonService mSidePanelService;
    @GdInject
    protected SpecBuildingWidthCacheDao mSpecBuildingWidthCacheDao;
    @GdInject
    protected SpecBuildingSizeComboCacheDao mSpecBuildingSizeComboCacheDao;

    protected BasicInfoCommonService() {
    }

    public void initKetaType(ZM2Entities zM2Entities) {
        this.changeKetaType(zM2Entities, KetaType.STD);
    }

    public List<KetaType> findAvailableKeta(List<TerraceWidthType> list, ZM2Entities zM2Entities) {
        Collection<SpecBuildingSizeComboInfo> collection;
        BasicInfo basicInfo = zM2Entities.mBasicInfo;
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        StrengthType strengthType = basicInfo.mStrengthType;
        NokiPlusSideType nokiPlusSideType = terracesInfo.mNokiPlusSideType;
        NokiPlusFrontType nokiPlusFrontType = terracesInfo.mNokiPlusFrontType;
        TerraceWidthType terraceWidthType = TerraceWidthTypeDxo.convertTotalWidthType(list);
        ArrayList<KetaType> arrayList = new ArrayList<KetaType>();
        int n = 3;
        int n2 = 0;
        while (n2 < list.size()) {
            TerraceWidthType terraceWidthType2 = list.get(n2);
            collection = this.mTerraceService.convToTerraceNokiPlusSideType(nokiPlusSideType, list.size(), n2);
            Collection<SpecBuildingWidthInfo> collection2 = this.mSpecBuildingWidthCacheDao.findManyByTypes(nokiPlusFrontType, (NokiPlusSideType)((Object)collection), strengthType, null, terraceWidthType2, null, null, null, null);
            int n3 = 0;
            for (SpecBuildingWidthInfo specBuildingWidthInfo : collection2) {
                n3 |= specBuildingWidthInfo.ketaType.intValue();
            }
            n &= n3;
            ++n2;
        }
        for (KetaType ketaType : KetaTypeFactory.getInstance().values()) {
            collection = this.mSpecBuildingSizeComboCacheDao.findManyByTypes(basicInfo, terracesInfo, terracesInfo.mDepthType, terraceWidthType, ketaType);
            if (collection.isEmpty() || (ketaType.id() & n) <= 0) continue;
            arrayList.add(ketaType);
        }
        return arrayList;
    }

    public void updateBasicInfoBySide(ZM2Entities zM2Entities) {
        OpeningPanelType openingPanelType;
        OpeningPanelType openingPanelType2;
        BasicInfo basicInfo = zM2Entities.mBasicInfo;
        OpeningPanelType openingPanelType3 = openingPanelType2 = this.mSidePanelService.hasSidePanelType(zM2Entities.mLeftPanelInfoList, OpeningPanelType.ORIDO) ? OpeningPanelType.ORIDO : OpeningPanelType.FIX;
        if (zM2Entities.mLeftPanelInfoList.isEmpty()) {
            openingPanelType2 = OpeningPanelType.ORIDO;
        }
        OpeningPanelType openingPanelType4 = openingPanelType = this.mSidePanelService.hasSidePanelType(zM2Entities.mRightPanelInfoList, OpeningPanelType.ORIDO) ? OpeningPanelType.ORIDO : OpeningPanelType.FIX;
        if (zM2Entities.mRightPanelInfoList.isEmpty()) {
            openingPanelType = OpeningPanelType.ORIDO;
        }
        basicInfo.mBodyPanelType = this.mSidePanelService.toBodyPanelType(openingPanelType2, openingPanelType);
        OpeningPanelType openingPanelType5 = this.mSidePanelService.hasSidePanelType(zM2Entities.mLeftPanelInfoList, OpeningPanelType.LOUVER) ? OpeningPanelType.LOUVER : OpeningPanelType.ADJUSTMENT_FIX;
        OpeningPanelType openingPanelType6 = this.mSidePanelService.hasSidePanelType(zM2Entities.mRightPanelInfoList, OpeningPanelType.LOUVER) ? OpeningPanelType.LOUVER : OpeningPanelType.ADJUSTMENT_FIX;
        basicInfo.mAdjustmentFixType = this.mSidePanelService.toAdjustmentFixType(openingPanelType5, openingPanelType6);
        basicInfo.mOuterHandleType = OuterHandleType.FRONT_LEFT_ONE;
    }

    public boolean isInnerRoofAvailable(ZM2Entities zM2Entities) {
        boolean bl = true;
        EnforcementType enforcementType = zM2Entities.mTerracesInfo.mEnforcementType;
        if (enforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI) {
            float f = zM2Entities.mTerraceInfoList.getFirst().mRightDepth.floatValue();
            float f2 = zM2Entities.mTerraceInfoList.getLast().mLeftDepth.floatValue();
            if (f < 1630.0f || f2 < 1630.0f) {
                bl = false;
            }
        } else if (enforcementType == EnforcementType.BUBUN_IRISUMI) {
            bl = false;
        } else if (zM2Entities.mTerracesInfo.mDepth.floatValue() < 1630.0f) {
            bl = false;
        }
        return bl;
    }

    public void updateInnerRoof(ZM2Entities zM2Entities) {
        if (!this.isInnerRoofAvailable(zM2Entities)) {
            zM2Entities.mBasicInfo.mInnerRoofUseType = InnerRoofUseType.NONE;
        }
    }

    public void changeKetaType(ZM2Entities zM2Entities, KetaType ketaType) {
        zM2Entities.mBasicInfo.mKetaType = ketaType;
    }
}

