/*
 * Decompiled with CFR 0.152.
 */
package option.zima2.common.dao.cache.spec;

import com.kt.annotation.Reflectable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import option.gad.core.dao.GdDao;
import option.gad.core.inject.GdInject;
import option.gad.core.util.DebugUtil;
import option.zima2.common.dao.cache.AbstractCacheCsvDao;
import option.zima2.common.entity.BasicInfo;
import option.zima2.common.entity.TerracesInfo;
import option.zima2.common.entity.spec.SpecBuildingSizeComboInfo;
import option.zima2.common.service.parts.MultiSpanCommonService;
import option.zima2.common.type.EnforcementDirType;
import option.zima2.common.type.EnforcementType;
import option.zima2.common.type.KetaType;
import option.zima2.common.type.NokiPlusFrontType;
import option.zima2.common.type.ProductSeriesType;
import option.zima2.common.type.ProductType;
import option.zima2.common.type.StrengthType;
import option.zima2.common.type.SubProductType;
import option.zima2.common.type.TerraceDepthType;
import option.zima2.common.type.TerraceWidthType;
import option.zima2.common.type.factory.TerraceDepthTypeFactory;
import option.zima2.common.type.factory.TerraceWidthTypeFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Reflectable(name="SpecBuildingSizeComboCacheDao")
@GdDao(entity=SpecBuildingSizeComboInfo.class)
public class SpecBuildingSizeComboCacheDao
extends AbstractCacheCsvDao<SpecBuildingSizeComboInfo> {
    private static final Log mLog = LogFactory.getLog(SpecBuildingSizeComboCacheDao.class);
    @GdInject
    private MultiSpanCommonService mMultiSpanCommonService;

    public SpecBuildingSizeComboInfo findOneByTypes(BasicInfo basicInfo, TerracesInfo terracesInfo) {
        return this.findOneByTypes(basicInfo, terracesInfo, terracesInfo.mDepthType, terracesInfo.mWidthType, basicInfo.mKetaType);
    }

    public SpecBuildingSizeComboInfo findOneByTypes(BasicInfo basicInfo, TerracesInfo terracesInfo, TerraceDepthType terraceDepthType, TerraceWidthType terraceWidthType, KetaType ketaType) {
        return this.findOneByTypes(basicInfo.mProductSeriesType, basicInfo.mProductType, basicInfo.mSubProductType, terracesInfo.mEnforcementType, terracesInfo.mEnforcementDirType, terracesInfo.mNokiPlusFrontType, basicInfo.mStrengthType, terraceDepthType, terraceWidthType, ketaType);
    }

    public SpecBuildingSizeComboInfo findOneByTypes(ProductSeriesType productSeriesType, ProductType productType, SubProductType subProductType, EnforcementType enforcementType, EnforcementDirType enforcementDirType, NokiPlusFrontType nokiPlusFrontType, StrengthType strengthType, TerraceDepthType terraceDepthType, TerraceWidthType terraceWidthType, KetaType ketaType) {
        SpecBuildingSizeComboInfo specBuildingSizeComboInfo = new SpecBuildingSizeComboInfo();
        specBuildingSizeComboInfo.productSeriesType = this.convTypeToBin(productSeriesType);
        specBuildingSizeComboInfo.productType = this.convTypeToBin(productType);
        specBuildingSizeComboInfo.subProductType = this.convTypeToBin(subProductType);
        specBuildingSizeComboInfo.nokiPlusFType = this.convTypeToBin(nokiPlusFrontType);
        specBuildingSizeComboInfo.strengthType = this.convTypeToBin(strengthType);
        specBuildingSizeComboInfo.enforcementType = this.convTypeToBin(enforcementType);
        specBuildingSizeComboInfo.enforcementDirType = this.convTypeToBin(enforcementDirType);
        specBuildingSizeComboInfo.depthType = this.convTypeToBin(terraceDepthType);
        specBuildingSizeComboInfo.widthType = this.convTypeToBin(terraceWidthType);
        specBuildingSizeComboInfo.ketaType = this.convTypeToBin(ketaType);
        mLog.debug((Object)"SpecBuildingSizeComboCacheDao.findOne");
        mLog.debug((Object)("key[" + specBuildingSizeComboInfo + "]"));
        mLog.debug((Object)("comboInfo[" + this.findOne(specBuildingSizeComboInfo, new boolean[]{true, true}) + "]"));
        return (SpecBuildingSizeComboInfo)this.findOne(specBuildingSizeComboInfo, new boolean[]{true, true});
    }

    public Collection<SpecBuildingSizeComboInfo> findManyByTypes(BasicInfo basicInfo, TerracesInfo terracesInfo) {
        return this.findManyByTypes(basicInfo, terracesInfo, terracesInfo.mDepthType, terracesInfo.mWidthType, basicInfo.mKetaType);
    }

    public Collection<SpecBuildingSizeComboInfo> findManyByTypes(BasicInfo basicInfo, TerracesInfo terracesInfo, TerraceDepthType terraceDepthType, TerraceWidthType terraceWidthType, KetaType ketaType) {
        return this.findManyByTypes(basicInfo.mProductSeriesType, basicInfo.mProductType, basicInfo.mSubProductType, terracesInfo.mNokiPlusFrontType, basicInfo.mStrengthType, terracesInfo.mEnforcementType, terracesInfo.mEnforcementDirType, terraceDepthType, terraceWidthType, ketaType);
    }

    public Collection<SpecBuildingSizeComboInfo> findManyByTypes(ProductSeriesType productSeriesType, ProductType productType, SubProductType subProductType, NokiPlusFrontType nokiPlusFrontType, StrengthType strengthType, EnforcementType enforcementType, EnforcementDirType enforcementDirType, TerraceDepthType terraceDepthType, TerraceWidthType terraceWidthType, KetaType ketaType) {
        SpecBuildingSizeComboInfo specBuildingSizeComboInfo = new SpecBuildingSizeComboInfo();
        specBuildingSizeComboInfo.productSeriesType = this.convTypeToBin(productSeriesType);
        specBuildingSizeComboInfo.productType = this.convTypeToBin(productType);
        specBuildingSizeComboInfo.subProductType = this.convTypeToBin(subProductType);
        specBuildingSizeComboInfo.nokiPlusFType = this.convTypeToBin(nokiPlusFrontType);
        specBuildingSizeComboInfo.strengthType = this.convTypeToBin(strengthType);
        specBuildingSizeComboInfo.enforcementType = this.convTypeToBin(enforcementType);
        specBuildingSizeComboInfo.enforcementDirType = this.convTypeToBin(enforcementDirType);
        specBuildingSizeComboInfo.depthType = this.convTypeToBin(terraceDepthType);
        specBuildingSizeComboInfo.widthType = this.convTypeToBin(terraceWidthType);
        specBuildingSizeComboInfo.ketaType = this.convTypeToBin(ketaType);
        specBuildingSizeComboInfo.permission = this.convNumToBin(1);
        Collection collection = this.findMany(specBuildingSizeComboInfo, new boolean[]{true, true});
        mLog.debug((Object)"SpecBuildingSizeComboCacheDao.findMany");
        mLog.debug((Object)("key[" + specBuildingSizeComboInfo + "]"));
        mLog.debug((Object)("comboInfoList[\n" + DebugUtil.toString((Collection)collection) + "\n]"));
        return collection;
    }

    public List<TerraceWidthType> findManyWidthTypeByTypes(BasicInfo basicInfo, TerracesInfo terracesInfo, TerraceDepthType terraceDepthType, KetaType ketaType) {
        Collection<SpecBuildingSizeComboInfo> collection = this.findManyByTypes(basicInfo.mProductSeriesType, basicInfo.mProductType, basicInfo.mSubProductType, terracesInfo.mNokiPlusFrontType, basicInfo.mStrengthType, terracesInfo.mEnforcementType, terracesInfo.mEnforcementDirType, terraceDepthType, null, ketaType);
        Integer n = 0;
        for (SpecBuildingSizeComboInfo arrayList2 : collection) {
            n = n | Integer.parseInt(arrayList2.widthType, 2);
        }
        ArrayList<TerraceWidthType> arrayList = new ArrayList<TerraceWidthType>();
        int n2 = 0;
        while (n > 0) {
            ++n2;
            int n3 = n & 1;
            if (n3 == 1) {
                TerraceWidthType terraceWidthType = (TerraceWidthType)TerraceWidthTypeFactory.getInstance().getTypeById(n2);
                arrayList.add(terraceWidthType);
            }
            n = n >>> 1;
        }
        return arrayList;
    }

    public List<TerraceDepthType> findManyDepthTypeByTypes(BasicInfo basicInfo, TerracesInfo terracesInfo, TerraceWidthType terraceWidthType) {
        Collection<SpecBuildingSizeComboInfo> collection = this.findManyByTypes(basicInfo.mProductSeriesType, basicInfo.mProductType, basicInfo.mSubProductType, terracesInfo.mNokiPlusFrontType, basicInfo.mStrengthType, terracesInfo.mEnforcementType, terracesInfo.mEnforcementDirType, null, terraceWidthType, basicInfo.mKetaType);
        Integer n = 0;
        for (SpecBuildingSizeComboInfo arrayList2 : collection) {
            n = n | Integer.parseInt(arrayList2.depthType, 2);
        }
        ArrayList<TerraceDepthType> arrayList = new ArrayList<TerraceDepthType>();
        int n2 = 0;
        while (n > 0) {
            ++n2;
            int n3 = n & 1;
            if (n3 == 1) {
                TerraceDepthType terraceDepthType = (TerraceDepthType)TerraceDepthTypeFactory.getInstance().getTypeById(n2);
                arrayList.add(terraceDepthType);
            }
            n = n >>> 1;
        }
        return arrayList;
    }

    public boolean possibleMultiSpan(BasicInfo basicInfo, TerracesInfo terracesInfo) {
        Collection<SpecBuildingSizeComboInfo> collection = this.findManyByTypes(basicInfo.mProductSeriesType, basicInfo.mProductType, basicInfo.mSubProductType, terracesInfo.mNokiPlusFrontType, basicInfo.mStrengthType, terracesInfo.mEnforcementType, terracesInfo.mEnforcementDirType, null, null, null);
        return !collection.isEmpty();
    }
}

