/*
 * Decompiled with CFR 0.152.
 */
package option.speene.shape.speene.model.speene.creator;

import java.awt.Color;
import java.util.Vector;
import model.parts.Parts;
import option.speene.common.entity.SPNEntities;
import option.speene.common.entity.TerraceInfo;
import option.speene.common.entity.TerracesInfo;
import option.speene.common.service.common.SPNColor;
import option.speene.common.type.BuildingType;
import option.speene.common.type.EnforcementDirType;
import option.speene.common.type.EnforcementType;
import option.speene.common.type.RoofFigureType;
import option.speene.common.type.StrengthType;
import option.speene.common.type.TerraceDepthType;
import option.speene.shape.speene.model.speene.creator.SPNTerraceUnitCreator;
import option.speene.shape.speene.model.speene.item.AbstractTerraceUnitItem;
import option.speene.shape.speene.model.speene.item.MsItemTerrace;
import option.speene.shape.speene.model.speene.parts.PNobuchi;

public class MsUnitNobuchiCreator
extends SPNTerraceUnitCreator {
    @Override
    public void create(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SPNEntities sPNEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = sPNEntities.mTerracesInfo;
        if (terraceInfo.mDepthType == TerraceDepthType.T2) {
            return;
        }
        EnforcementType enforcementType = terracesInfo.mEnforcementType;
        if (terraceInfo.mBuildingType != BuildingType.CORNER && (enforcementType == EnforcementType.DESUMI || enforcementType == EnforcementType.IRISUMI)) {
            enforcementType = EnforcementType.STD;
        }
        if (enforcementType == EnforcementType.SOKUMEN_DAIKEI && !terraceInfo.mIsStarting.booleanValue()) {
            enforcementType = EnforcementType.STD;
        }
        if (enforcementType == EnforcementType.STD || enforcementType == EnforcementType.HANEDASHI || enforcementType == EnforcementType.JIZAIKETA_HANEDASHI || enforcementType == EnforcementType.MAEWAKU_DEHABA_CHIGAI) {
            this.createStandard(abstractTerraceUnitItem, parts);
        } else if (enforcementType == EnforcementType.IRISUMI) {
            this.createIrisumi(abstractTerraceUnitItem, parts);
        } else if (enforcementType == EnforcementType.DESUMI) {
            this.createDesumi(abstractTerraceUnitItem, parts);
        } else if (enforcementType == EnforcementType.SHOMEN_DAIKEI) {
            this.createShoumenDaikei(abstractTerraceUnitItem, parts);
        } else if (enforcementType == EnforcementType.SOKUMEN_DAIKEI) {
            this.createSokumenDaikei(abstractTerraceUnitItem, parts);
        } else if (enforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI) {
            this.createKutaiDehabaChigai(abstractTerraceUnitItem, parts);
        } else if (enforcementType == EnforcementType.KEISHA) {
            this.createKeisha(abstractTerraceUnitItem, parts);
        }
    }

    private void createStandard(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SPNEntities sPNEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        double d = msItemTerrace.getFloorlevel();
        double d2 = -terraceInfo.mWidth.floatValue() / 2.0f;
        double d3 = terraceInfo.mWidth.floatValue() / 2.0f;
        double d4 = 0.0;
        double d5 = 10.0;
        double d6 = Math.tan(Math.toRadians(10.0));
        double d7 = -25.0;
        double d8 = -25.0;
        if (abstractTerraceUnitItem.getPrev() == null) {
            d7 = -20.0;
        }
        if (abstractTerraceUnitItem.getNext() == null) {
            d8 = -20.0;
        }
        double[] dArray = this.calcCuttingPositionX(abstractTerraceUnitItem, d2, d3, d7, d8);
        double[] dArray2 = this.getNobuchiPich(sPNEntities.mBasicInfo.mRoofFigureType, terraceInfo.mDepthType, sPNEntities.mBasicInfo.mStrengthType);
        int n = dArray2.length;
        double d9 = sPNEntities.mPartsFigureInfo.mWallHeight.floatValue() + sPNEntities.mPartsFigureInfo.mTooshiHeight.floatValue();
        double d10 = 0.0;
        int n2 = 0;
        while (n2 < n) {
            d4 = (d10 -= dArray2[n2]) * d6 + d + d9 - 8.0;
            int n3 = 0;
            while (n3 < dArray.length - 1) {
                double d11 = dArray[n3];
                double d12 = dArray[n3 + 1];
                vector.add(this.createNobuchi(d11, d12, d10, d4, d5, 0.0));
                n3 += 2;
            }
            ++n2;
        }
    }

    private void createIrisumi(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        double d;
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SPNEntities sPNEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        double d2 = msItemTerrace.getFloorlevel();
        double d3 = terraceInfo.mDepth.floatValue();
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 10.0;
        double d8 = Math.tan(Math.toRadians(10.0));
        double[] dArray = this.getNobuchiPich(sPNEntities.mBasicInfo.mRoofFigureType, terraceInfo.mDepthType, sPNEntities.mBasicInfo.mStrengthType);
        int n = dArray.length;
        double d9 = sPNEntities.mPartsFigureInfo.mWallHeight.floatValue() + sPNEntities.mPartsFigureInfo.mTooshiHeight.floatValue();
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = -25.0;
        double d13 = -25.0;
        d4 = d = d3 + 97.5;
        int n2 = 0;
        while (n2 < n) {
            d5 = d4 + (d3 + 97.5 - (d11 += dArray[n2]));
            d10 = -d11;
            d6 = -d11 * d8 + d2 + d9 - 8.0;
            double[] dArray2 = this.calcCuttingPositionX(abstractTerraceUnitItem, d4, d5, d12, d13);
            int n3 = 0;
            while (n3 < dArray2.length - 1) {
                double d14 = d + (d - dArray2[n3]);
                double d15 = d + (d - dArray2[n3 + 1]);
                if (d14 > d15) {
                    vector.add(this.createNobuchi(d14, d15, d10, d6, d7, 0.0));
                    double d16 = -d + (d - d14);
                    double d17 = -d10;
                    double d18 = d17 + (d14 - d15);
                    vector.add(this.createNobuchi(d17, d18, d16, d6, d7, 90.0));
                }
                n3 += 2;
            }
            ++n2;
        }
    }

    private void createDesumi(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SPNEntities sPNEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        double d = msItemTerrace.getFloorlevel();
        double d2 = 0.0;
        double d3 = 10.0;
        double d4 = Math.tan(Math.toRadians(10.0));
        double[] dArray = this.getNobuchiPich(sPNEntities.mBasicInfo.mRoofFigureType, terraceInfo.mDepthType, sPNEntities.mBasicInfo.mStrengthType);
        int n = dArray.length;
        double d5 = sPNEntities.mPartsFigureInfo.mWallHeight.floatValue() + sPNEntities.mPartsFigureInfo.mTooshiHeight.floatValue();
        double d6 = -97.5;
        double d7 = terraceInfo.mDepth.floatValue();
        double d8 = 0.0;
        double d9 = -25.0;
        double d10 = -25.0;
        int n2 = 0;
        while (n2 < n) {
            d7 = -(d8 -= dArray[n2]);
            d2 = d8 * d4 + d + d5 - 8.0;
            double[] dArray2 = this.calcCuttingPositionX(abstractTerraceUnitItem, d6, d7, d9, d10);
            int n3 = 0;
            while (n3 < dArray2.length - 1) {
                double d11 = dArray2[n3];
                double d12 = dArray2[n3 + 1];
                if (d11 < d12) {
                    vector.add(this.createNobuchi(d11, d12, d8, d2, d3, 0.0));
                    double d13 = d12 * -1.0;
                    double d14 = -d8;
                    double d15 = d14 + (d12 - d11);
                    vector.add(this.createNobuchi(d14, d15, d13, d2, d3, 90.0));
                }
                n3 += 2;
            }
            ++n2;
        }
    }

    private void createShoumenDaikei(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SPNEntities sPNEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        double d = msItemTerrace.getFloorlevel();
        double d2 = -terraceInfo.mWidth.floatValue() / 2.0f;
        double d3 = terraceInfo.mWidth.floatValue() / 2.0f;
        double d4 = 0.0;
        double d5 = 10.0;
        double d6 = Math.tan(Math.toRadians(10.0));
        double[] dArray = this.getNobuchiPich(sPNEntities.mBasicInfo.mRoofFigureType, terraceInfo.mDepthType, sPNEntities.mBasicInfo.mStrengthType);
        int n = dArray.length;
        if (sPNEntities.mBasicInfo.mRoofFigureType == RoofFigureType.F) {
            double d7 = -25.0;
            double d8 = -25.0;
            if (abstractTerraceUnitItem.getPrev() == null) {
                d7 = -20.0;
            }
            if (abstractTerraceUnitItem.getNext() == null) {
                d8 = -20.0;
            }
            double[] dArray2 = this.calcCuttingPositionX(abstractTerraceUnitItem, d2, d3, d7, d8);
            double d9 = (terraceInfo.mLeftDepth.floatValue() <= terraceInfo.mRightDepth.floatValue() ? terraceInfo.mLeftDepth : terraceInfo.mRightDepth).floatValue();
            double d10 = sPNEntities.mPartsFigureInfo.mWallHeight.floatValue() + sPNEntities.mPartsFigureInfo.mTooshiHeight.floatValue();
            double d11 = 0.0;
            int n2 = 0;
            while (n2 < n) {
                d4 = (d11 -= dArray[n2]) * d6 + d + d10 - 8.0;
                if (d11 <= d9) {
                    int n3 = 0;
                    while (n3 < dArray2.length - 1) {
                        double d12 = dArray2[n3];
                        double d13 = dArray2[n3 + 1];
                        vector.add(this.createNobuchi(d12, d13, d11, d4, d5, 0.0));
                        n3 += 2;
                    }
                }
                ++n2;
            }
        }
    }

    private void createSokumenDaikei(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SPNEntities sPNEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = sPNEntities.mTerracesInfo;
        double d = msItemTerrace.getFloorlevel();
        double d2 = terraceInfo.mDepth.floatValue();
        double d3 = terraceInfo.mWidth.floatValue() / 2.0f;
        double d4 = -d3;
        double d5 = d3;
        double d6 = 0.0;
        double d7 = 10.0;
        double d8 = Math.tan(Math.toRadians(10.0));
        double[] dArray = this.getNobuchiPich(sPNEntities.mBasicInfo.mRoofFigureType, terraceInfo.mDepthType, sPNEntities.mBasicInfo.mStrengthType);
        int n = dArray.length;
        if (sPNEntities.mBasicInfo.mRoofFigureType == RoofFigureType.F) {
            double d9 = -25.0;
            double d10 = -25.0;
            if (abstractTerraceUnitItem.getPrev() == null) {
                d9 = -20.0;
            }
            if (abstractTerraceUnitItem.getNext() == null) {
                d10 = -20.0;
            }
            double d11 = terraceInfo.mWidth.floatValue() - terraceInfo.mFrontWidth.floatValue();
            double d12 = d11 / d2;
            double d13 = sPNEntities.mPartsFigureInfo.mWallHeight.floatValue() + sPNEntities.mPartsFigureInfo.mTooshiHeight.floatValue();
            double d14 = 0.0;
            int n2 = 0;
            while (n2 < n) {
                double d15;
                double d16;
                int n3;
                double[] dArray2;
                double d17;
                double d18;
                d6 = (d14 -= dArray[n2]) * d8 + d + d13 - 10.0;
                double d19 = d4;
                double d20 = d5;
                if (terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
                    d10 = -15.0;
                    d18 = d19 += Math.abs(d14) * d12;
                    d17 = d18 + (d20 - d19);
                    dArray2 = this.calcCuttingPositionX(abstractTerraceUnitItem, d18, d17, d9, d10);
                    n3 = 0;
                    while (n3 < dArray2.length - 1) {
                        d16 = d20 - (dArray2[n3] - d18);
                        d15 = d20 - (dArray2[n3 + 1] - d18);
                        vector.add(this.createNobuchi(d15, d16, d14, d6, d7, 0.0));
                        n3 += 2;
                    }
                } else {
                    d10 = -15.0;
                    d18 = d19;
                    d17 = d18 + ((d20 -= Math.abs(d14) * d12) - d19);
                    dArray2 = this.calcCuttingPositionX(abstractTerraceUnitItem, d18, d17, d9, d10);
                    n3 = 0;
                    while (n3 < dArray2.length - 1) {
                        d16 = dArray2[n3];
                        d15 = dArray2[n3 + 1];
                        vector.add(this.createNobuchi(d16, d15, d14, d6, d7, 0.0));
                        n3 += 2;
                    }
                }
                ++n2;
            }
        }
    }

    private void createKutaiDehabaChigai(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SPNEntities sPNEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = sPNEntities.mTerracesInfo;
        double d = msItemTerrace.getFloorlevel();
        double d2 = terraceInfo.mDepth.floatValue();
        double d3 = terraceInfo.mWidth.floatValue() / 2.0f;
        double d4 = -d3;
        double d5 = d3;
        double d6 = 0.0;
        double d7 = 10.0;
        double d8 = Math.tan(Math.toRadians(10.0));
        double[] dArray = this.getNobuchiPich(sPNEntities.mBasicInfo.mRoofFigureType, terracesInfo.mDepthType, sPNEntities.mBasicInfo.mStrengthType);
        int n = dArray.length;
        double d9 = -25.0;
        double d10 = -25.0;
        if (abstractTerraceUnitItem.getPrev() == null) {
            d9 = -20.0;
        }
        if (abstractTerraceUnitItem.getNext() == null) {
            d10 = -20.0;
        }
        double d11 = sPNEntities.mPartsFigureInfo.mSakaimeTakukiW.floatValue();
        double d12 = sPNEntities.mPartsFigureInfo.mKutaiKutaiW.floatValue();
        d2 = terracesInfo.mDepth.floatValue();
        if (terracesInfo.mEnforcementDirType == EnforcementDirType.R) {
            d12 = d2 - (double)terraceInfo.mRightDepth.floatValue();
            d11 = terraceInfo.mRightWidth.floatValue();
        } else {
            d12 = d2 - (double)terraceInfo.mLeftDepth.floatValue();
            d11 = terraceInfo.mLeftWidth.floatValue();
        }
        double d13 = 0.0;
        if (!terraceInfo.mIsMaster.booleanValue()) {
            d13 = terraceInfo.mDepth.floatValue() - terracesInfo.mDepth.floatValue();
        }
        double d14 = sPNEntities.mPartsFigureInfo.mWallHeight.floatValue() + sPNEntities.mPartsFigureInfo.mTooshiHeight.floatValue();
        double d15 = 0.0;
        int n2 = 0;
        while (n2 < n) {
            double d16;
            double d17;
            int n3;
            d6 = (d15 -= dArray[n2]) * d8 + d + d14 - 10.0;
            double[] dArray2 = this.calcCuttingPositionX(abstractTerraceUnitItem, d4, d5, d9, d10);
            double d18 = d4;
            double d19 = d5;
            if (terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
                if (Math.abs(d15) <= d12) {
                    d18 = d4 + d11;
                }
                n3 = 0;
                while (n3 < dArray2.length - 1) {
                    d17 = dArray2[n3];
                    d16 = dArray2[n3 + 1];
                    if (d17 > d18 && d15 < d13) {
                        vector.add(this.createNobuchi(d17, d16, d15, d6, d7, 0.0));
                    }
                    n3 += 2;
                }
            } else {
                if (Math.abs(d15) <= d12) {
                    d19 = d5 - d11;
                }
                n3 = 0;
                while (n3 < dArray2.length - 1) {
                    d17 = dArray2[n3];
                    d16 = dArray2[n3 + 1];
                    if (d16 < d19 && d15 < d13) {
                        vector.add(this.createNobuchi(d17, d16, d15, d6, d7, 0.0));
                    }
                    n3 += 2;
                }
            }
            ++n2;
        }
    }

    private void createKeisha(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SPNEntities sPNEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        double d = msItemTerrace.getFloorlevel();
        double d2 = terraceInfo.mDepth.floatValue();
        double d3 = terraceInfo.mWidth.floatValue() / 2.0f;
        double d4 = -d3;
        double d5 = d3;
        double d6 = 0.0;
        double[] dArray = this.getNobuchiPich(sPNEntities.mBasicInfo.mRoofFigureType, terraceInfo.mDepthType, sPNEntities.mBasicInfo.mStrengthType);
        int n = dArray.length;
        double d7 = -25.0;
        double d8 = -25.0;
        if (abstractTerraceUnitItem.getPrev() == null) {
            d7 = -20.0;
        }
        if (abstractTerraceUnitItem.getNext() == null) {
            d8 = -20.0;
        }
        double[] dArray2 = this.calcCuttingPositionX(abstractTerraceUnitItem, d4, d5, d7, d8);
        double d9 = sPNEntities.mPartsFigureInfo.mSlopeAngle.floatValue();
        double d10 = Math.sin(Math.toRadians(d9));
        double d11 = Math.cos(Math.toRadians(d9));
        double d12 = Math.tan(Math.toRadians(d9));
        double d13 = (d2 - 90.0) * d12 + 71.4 / d11;
        double d14 = sPNEntities.mPartsFigureInfo.mHeight.floatValue() + sPNEntities.mPartsFigureInfo.mTooshiHeight.floatValue();
        double d15 = 0.0;
        int n2 = 0;
        while (n2 < n) {
            d6 = (d15 -= dArray[n2]) * d12 + d + d14 + d13 + 60.0 * d10;
            d6 += 25.0;
            int n3 = 0;
            while (n3 < dArray2.length - 1) {
                double d16 = dArray2[n3];
                double d17 = dArray2[n3 + 1];
                vector.add(this.createNobuchi(d16, d17, d15, d6, d9, 0.0));
                n3 += 2;
            }
            ++n2;
        }
    }

    private PNobuchi createNobuchi(double d, double d2, double d3, double d4, double d5, double d6) {
        Color color = SPNColor.getColor(this.mShapeColorManager.getColor(0));
        PNobuchi pNobuchi = new PNobuchi();
        pNobuchi.set(d, d2, d3, d4, d5, d6, color);
        return pNobuchi;
    }

    double[] getNobuchiPich(RoofFigureType roofFigureType, TerraceDepthType terraceDepthType, StrengthType strengthType) {
        double[] dArray = null;
        if (roofFigureType == RoofFigureType.F) {
            if (terraceDepthType == TerraceDepthType.T3) {
                dArray = new double[]{434.0};
            } else if (terraceDepthType == TerraceDepthType.T4) {
                dArray = new double[]{584.0};
            } else if (terraceDepthType == TerraceDepthType.T5) {
                dArray = new double[]{495.0, 478.0};
            } else if (terraceDepthType == TerraceDepthType.T6) {
                dArray = new double[]{595.0, 578.0};
            } else if (terraceDepthType == TerraceDepthType.T7) {
                dArray = strengthType == StrengthType.T600 ? new double[]{526.0, 508.0, 508.0} : new double[]{695.0, 678.0};
            } else if (terraceDepthType == TerraceDepthType.T8) {
                dArray = strengthType == StrengthType.T600 ? new double[]{601.0, 583.0, 583.0} : new double[]{795.0, 778.0};
            } else if (terraceDepthType == TerraceDepthType.T9) {
                dArray = new double[]{895.0, 879.0};
            } else if (terraceDepthType == TerraceDepthType.T10) {
                dArray = new double[]{995.0, 878.0};
            } else if (terraceDepthType == TerraceDepthType.T12) {
                dArray = new double[]{1196.0, 1177.0};
            } else if (terraceDepthType == TerraceDepthType.T15) {
                dArray = new double[]{1495.0, 1477.0};
            }
        } else if (roofFigureType == RoofFigureType.R) {
            if (terraceDepthType == TerraceDepthType.T3) {
                dArray = new double[]{534.0};
            } else if (terraceDepthType == TerraceDepthType.T4) {
                dArray = new double[]{834.0};
            } else if (terraceDepthType == TerraceDepthType.T5) {
                dArray = new double[]{576.0, 558.0};
            } else if (terraceDepthType == TerraceDepthType.T6) {
                dArray = new double[]{726.0, 708.0};
            } else if (terraceDepthType == TerraceDepthType.T7) {
                dArray = strengthType == StrengthType.T600 ? new double[]{590.0, 572.0, 572.0} : new double[]{876.0, 858.0};
            } else if (terraceDepthType == TerraceDepthType.T8) {
                dArray = strengthType == StrengthType.T600 ? new double[]{690.0, 672.0, 672.0} : new double[]{1026.0, 1008.0};
            } else if (terraceDepthType == TerraceDepthType.T9) {
                dArray = new double[]{1176.0, 1158.0};
            } else if (terraceDepthType == TerraceDepthType.T10) {
                dArray = new double[]{1326.0, 1308.0};
            }
        }
        return dArray;
    }

    private double[] calcCuttingPositionX(AbstractTerraceUnitItem abstractTerraceUnitItem, double d, double d2, double d3, double d4) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SPNEntities sPNEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        boolean bl = false;
        float f = sPNEntities.mBasicInfo.mKenLen.floatValue() / 2.0f;
        float[] fArray = abstractTerraceUnitItem.getPitches();
        double[] dArray = null;
        if (this.isHalfPitch(sPNEntities, terraceInfo)) {
            boolean[] blArray = new boolean[fArray.length * 2];
            float[] fArray2 = new float[fArray.length * 2];
            int n = 0;
            int n2 = 0;
            while (n2 < fArray.length) {
                float f2 = fArray[n2];
                if (f2 > f) {
                    fArray2[n] = n2 == 0 ? f2 - f : f;
                    blArray[n] = true;
                    ++n;
                }
                fArray2[n] = f;
                blArray[n] = false;
                ++n;
                ++n2;
            }
            dArray = new double[n * 2];
            double d5 = d;
            double d6 = d2;
            int n3 = 0;
            while (n3 < n) {
                d6 = d5 + (double)fArray2[n3];
                if (d6 > d2) {
                    d6 = d2 + d4;
                    bl = true;
                }
                double d7 = d5;
                double d8 = d6;
                d7 = n3 == 0 ? d5 - d3 : (blArray[n3 - 1] ? d5 + 22.5 : d5 + 25.0);
                d8 = n3 == n - 1 ? d6 + d4 : (blArray[n3] ? d6 - 22.5 : d6 - 25.0);
                dArray[n3 * 2] = d7;
                dArray[n3 * 2 + 1] = d8;
                d5 = d6;
                if (!bl) {
                    ++n3;
                    continue;
                }
                break;
            }
        } else {
            dArray = new double[fArray.length * 2];
            double d9 = d;
            double d10 = 0.0;
            int n = 0;
            while (n < fArray.length) {
                d10 = d9 + (double)fArray[n];
                if (d10 > d2) {
                    d10 = d2 + d4;
                    bl = true;
                }
                double d11 = d9;
                double d12 = d10;
                d11 = n == 0 ? d9 - d3 : d9 + 25.0;
                d12 = n == fArray.length - 1 ? d10 + d4 : d10 - 25.0;
                dArray[n * 2] = d11;
                dArray[n * 2 + 1] = d12;
                d9 = d10;
                if (!bl) {
                    ++n;
                    continue;
                }
                break;
            }
        }
        return dArray;
    }

    private boolean isHalfPitch(SPNEntities sPNEntities, TerraceInfo terraceInfo) {
        if (sPNEntities.mBasicInfo.mStrengthType == StrengthType.T600 && (terraceInfo.mDepthType == TerraceDepthType.T9 || terraceInfo.mDepthType == TerraceDepthType.T10 || terraceInfo.mDepthType == TerraceDepthType.T12 || terraceInfo.mDepthType == TerraceDepthType.T15)) {
            return true;
        }
        if (sPNEntities.mBasicInfo.mStrengthType == StrengthType.T1500 && (terraceInfo.mDepthType == TerraceDepthType.T7 || terraceInfo.mDepthType == TerraceDepthType.T8 || terraceInfo.mDepthType == TerraceDepthType.T9 || terraceInfo.mDepthType == TerraceDepthType.T10 || terraceInfo.mDepthType == TerraceDepthType.T12 || terraceInfo.mDepthType == TerraceDepthType.T15)) {
            return true;
        }
        return sPNEntities.mBasicInfo.mStrengthType == StrengthType.T3000;
    }
}

