/*
 * Decompiled with CFR 0.152.
 */
package option.speene.shape.speene.model.common.service;

import java.util.LinkedList;
import java.util.List;
import option.gad.core.inject.GdInject;
import option.speene.common.entity.SPNEntities;
import option.speene.common.entity.SidePanelInfo;
import option.speene.common.type.RoomType;
import option.speene.common.type.SidePanelType;
import option.speene.shape.speene.model.common.service.CommonShapeService;
import option.speene.shape.speene.model.speene.item.AbstractTerraceUnitItem;
import option.speene.shape.speene.model.speene.item.MsItemTerrace;
import option.speene.swing.service.material.SidePanelAppletCommonService;

public class SidePanelShapeService
extends SidePanelAppletCommonService {
    @GdInject
    private CommonShapeService mCommonShapeService;

    public boolean isUsed(MsItemTerrace msItemTerrace, SidePanelType sidePanelType) {
        SPNEntities sPNEntities = msItemTerrace.getEntities();
        return this.isUsed(sPNEntities.mLeftPanelInfoList, sPNEntities.mRightPanelInfoList, sidePanelType);
    }

    public boolean isUsed(LinkedList<SidePanelInfo> linkedList, LinkedList<SidePanelInfo> linkedList2, SidePanelType sidePanelType) {
        for (SidePanelInfo sidePanelInfo : linkedList) {
            if (sidePanelInfo.mPanelType != sidePanelType) continue;
            return true;
        }
        for (SidePanelInfo sidePanelInfo : linkedList2) {
            if (sidePanelInfo.mPanelType != sidePanelType) continue;
            return true;
        }
        return false;
    }

    public boolean isUsed(LinkedList<SidePanelInfo> linkedList, SidePanelType sidePanelType) {
        for (SidePanelInfo sidePanelInfo : linkedList) {
            if (sidePanelInfo.mPanelType != sidePanelType) continue;
            return true;
        }
        return false;
    }

    public SidePanelInfo findSidePanelInfo(LinkedList<SidePanelInfo> linkedList, SidePanelType sidePanelType, int n, int n2) {
        for (SidePanelInfo sidePanelInfo : linkedList) {
            if (sidePanelInfo.mPanelType != sidePanelType || sidePanelInfo.mTerraceId != n || sidePanelInfo.mIndex != n2) continue;
            return sidePanelInfo;
        }
        return null;
    }

    public float calcGapPillarToSidePanel(boolean bl) {
        float f = 55.0f;
        if (bl) {
            f += 7.5f;
        }
        return f;
    }

    public SidePanelInfo findSidePanel(LinkedList<SidePanelInfo> linkedList, int n) {
        for (SidePanelInfo sidePanelInfo : linkedList) {
            if (sidePanelInfo.mIndex != n) continue;
            return sidePanelInfo;
        }
        return null;
    }

    public float calcPanelDepth(LinkedList<SidePanelInfo> linkedList) {
        float f = 0.0f;
        for (SidePanelInfo sidePanelInfo : linkedList) {
            if (sidePanelInfo.mPanelType == SidePanelType.ADJUSTMENT_FIX) continue;
            f += sidePanelInfo.mWidth.floatValue();
        }
        return f += this.calcCustomWallOtherWidth(linkedList);
    }

    public boolean hasLeftPanel(AbstractTerraceUnitItem abstractTerraceUnitItem, MsItemTerrace msItemTerrace) {
        SPNEntities sPNEntities = msItemTerrace.getEntities();
        return this.hasLeftPanel(abstractTerraceUnitItem, msItemTerrace, sPNEntities.mLeftPanelInfoList);
    }

    public boolean hasLeftPanel(AbstractTerraceUnitItem abstractTerraceUnitItem, MsItemTerrace msItemTerrace, LinkedList<SidePanelInfo> linkedList) {
        AbstractTerraceUnitItem abstractTerraceUnitItem2 = this.mCommonShapeService.getFirstUnit(msItemTerrace, RoomType.GARDEN_ROOM);
        return this.hasSidePanel(linkedList, abstractTerraceUnitItem, abstractTerraceUnitItem2);
    }

    public boolean hasRightPanel(AbstractTerraceUnitItem abstractTerraceUnitItem, MsItemTerrace msItemTerrace) {
        SPNEntities sPNEntities = msItemTerrace.getEntities();
        return this.hasRightPanel(abstractTerraceUnitItem, msItemTerrace, sPNEntities.mRightPanelInfoList);
    }

    public boolean hasRightPanel(AbstractTerraceUnitItem abstractTerraceUnitItem, MsItemTerrace msItemTerrace, LinkedList<SidePanelInfo> linkedList) {
        AbstractTerraceUnitItem abstractTerraceUnitItem2 = this.mCommonShapeService.getLastUnit(msItemTerrace, RoomType.GARDEN_ROOM);
        return this.hasSidePanel(linkedList, abstractTerraceUnitItem, abstractTerraceUnitItem2);
    }

    private boolean hasSidePanel(LinkedList<SidePanelInfo> linkedList, AbstractTerraceUnitItem abstractTerraceUnitItem, AbstractTerraceUnitItem abstractTerraceUnitItem2) {
        if (linkedList.size() == 0) {
            return false;
        }
        return abstractTerraceUnitItem == abstractTerraceUnitItem2;
    }

    public float getLeftPanelWidth(MsItemTerrace msItemTerrace) {
        List<AbstractTerraceUnitItem> list = msItemTerrace.getUnits();
        for (AbstractTerraceUnitItem abstractTerraceUnitItem : list) {
            if (!this.hasLeftPanel(abstractTerraceUnitItem, msItemTerrace)) continue;
            return abstractTerraceUnitItem.getCx() + abstractTerraceUnitItem.getWidthL() - 70.0f;
        }
        return 0.0f;
    }

    public float getRightPanelWidth(MsItemTerrace msItemTerrace) {
        List<AbstractTerraceUnitItem> list = msItemTerrace.getUnits();
        for (AbstractTerraceUnitItem abstractTerraceUnitItem : list) {
            if (!this.hasRightPanel(abstractTerraceUnitItem, msItemTerrace)) continue;
            return abstractTerraceUnitItem.getCx() + abstractTerraceUnitItem.getWidthR() + 70.0f;
        }
        return 0.0f;
    }

    public float calcLeftKutaiSidePanelY(AbstractTerraceUnitItem abstractTerraceUnitItem, LinkedList<SidePanelInfo> linkedList, float f) {
        return this.calcCommonKutaiSidePanelY(abstractTerraceUnitItem, linkedList, f);
    }

    public float calcRightKutaiSidePanelY(AbstractTerraceUnitItem abstractTerraceUnitItem, LinkedList<SidePanelInfo> linkedList, float f) {
        return this.calcCommonKutaiSidePanelY(abstractTerraceUnitItem, linkedList, f);
    }

    private float calcCommonKutaiSidePanelY(AbstractTerraceUnitItem abstractTerraceUnitItem, LinkedList<SidePanelInfo> linkedList, float f) {
        boolean bl = this.isUsed(linkedList, SidePanelType.ORIDO);
        boolean bl2 = this.isUsed(linkedList, SidePanelType.ORIDO_ADJUSTMENT_FIX);
        float f2 = -f + this.calcGapPillarToSidePanel(bl);
        for (SidePanelInfo sidePanelInfo : linkedList) {
            if (sidePanelInfo == null) continue;
            f2 += sidePanelInfo.mWidth.floatValue();
        }
        f2 += this.calcCustomWallOtherWidth(linkedList);
        return f2 += this.calcChoseiFixOtherWidth(bl2);
    }

    private float calcCustomWallOtherWidth(LinkedList<SidePanelInfo> linkedList) {
        float f = 0.0f;
        for (SidePanelInfo sidePanelInfo : linkedList) {
            if (sidePanelInfo.mPanelType != SidePanelType.CUSTOM_WALL) continue;
            f += 60.0f;
        }
        return f;
    }

    public float calcChoseiFixOtherWidth(boolean bl) {
        float f = 0.0f;
        if (bl) {
            f += 27.0f;
        }
        return f;
    }

    public double calcAngleForOpenOrido(double d, double d2, double d3) {
        double d4 = d3 / 2.0;
        double d5 = Math.sqrt(d * d + d2 * d2);
        double d6 = Math.asin(d4 / d5);
        double d7 = Math.atan2(d2, d);
        return d6 - d7;
    }
}

