/*
 * Decompiled with CFR 0.152.
 */
package option.speene.shape.speene.model.common.service;

import java.util.LinkedList;
import java.util.List;
import option.gad.core.inject.GdInject;
import option.speene.common.entity.FrontPanelOptionInfo;
import option.speene.common.entity.SPNEntities;
import option.speene.common.entity.TerraceInfo;
import option.speene.common.entity.TerracesInfo;
import option.speene.common.service.parts.FrontPanelOptionCommonService;
import option.speene.common.type.EnforcementDirType;
import option.speene.common.type.EnforcementType;
import option.speene.common.type.KetaType;
import option.speene.common.type.TerraceHeightType;
import option.speene.common.type.paneloption.FrontDesignScreenHeightType;
import option.speene.common.type.paneloption.FrontPanelOptionType;
import option.speene.shape.speene.model.common.service.FrontShapeService;
import option.speene.shape.speene.model.common.service.KoshikabeShapeService;
import option.speene.shape.speene.model.common.service.TerraceShapeService;
import option.speene.shape.speene.model.speene.item.MsItemTerrace;
import option.speene.shape.speene.model.speene.service.KetaShapeService;

public class FrontPanelOptionShapeService
extends FrontPanelOptionCommonService {
    @GdInject
    private TerraceShapeService mTerraceShapeService;
    @GdInject
    private KoshikabeShapeService mKoshikabeShapeService;
    @GdInject
    private FrontShapeService mFrontShapeService;
    @GdInject
    private KetaShapeService mKetaShapeService;

    public boolean isUsed(MsItemTerrace msItemTerrace, FrontPanelOptionType frontPanelOptionType) {
        SPNEntities sPNEntities = msItemTerrace.getEntities();
        LinkedList<FrontPanelOptionInfo> linkedList = sPNEntities.mFrontPanelOptionInfoList;
        for (FrontPanelOptionInfo frontPanelOptionInfo : linkedList) {
            if (frontPanelOptionInfo.mPanelOptionType != frontPanelOptionType) continue;
            return true;
        }
        return false;
    }

    public boolean isUsed(LinkedList<FrontPanelOptionInfo> linkedList, FrontPanelOptionType frontPanelOptionType) {
        for (FrontPanelOptionInfo frontPanelOptionInfo : linkedList) {
            if (frontPanelOptionInfo.mPanelOptionType != frontPanelOptionType) continue;
            return true;
        }
        return false;
    }

    public FrontPanelOptionInfo searchFrontPanelOptionInfo(LinkedList<FrontPanelOptionInfo> linkedList, FrontPanelOptionType frontPanelOptionType, int n, int n2) {
        for (FrontPanelOptionInfo frontPanelOptionInfo : linkedList) {
            if (frontPanelOptionInfo.mPanelOptionType != frontPanelOptionType || frontPanelOptionInfo.mTerraceId != n || frontPanelOptionInfo.mIndex != n2) continue;
            return frontPanelOptionInfo;
        }
        return null;
    }

    public float getHeight(List<TerraceInfo> list, TerracesInfo terracesInfo, TerraceInfo terraceInfo, FrontPanelOptionInfo frontPanelOptionInfo) {
        float f = 0.0f;
        FrontPanelOptionType frontPanelOptionType = (FrontPanelOptionType)frontPanelOptionInfo.mPanelOptionType;
        if (frontPanelOptionType == null) {
            return f;
        }
        switch (frontPanelOptionType) {
            case ROLL_SCREEN: {
                f = this.calcRollScreenHeight(list, terracesInfo, terraceInfo, frontPanelOptionInfo);
                break;
            }
            case FRONT_DESIGN_SCREEN: {
                f = this.calcFrontDesignScreenHeight(list, terraceInfo, frontPanelOptionInfo);
                break;
            }
            case FRONT_SCREEN_ONE_STEP: {
                f = this.calcFrontScreenOneStepHeight(list, terracesInfo, terraceInfo, frontPanelOptionInfo);
                break;
            }
            case FRONT_SCREEN_TWO_STEP: {
                f = this.calcFrontScreenTwoStepHeight(list, terracesInfo, terraceInfo, frontPanelOptionInfo);
                break;
            }
            case SUKIMA_FUSAGI_ZAI_ONE_STEP: {
                f = this.calcSukimaFusagiZaiOneStepHeight(list, terracesInfo, terraceInfo, frontPanelOptionInfo);
                break;
            }
            case SUKIMA_FUSAGI_ZAI_TWO_STEP: {
                f = this.calcSukimaFusagiZaiTwoStepHeight(list, terracesInfo, terraceInfo, frontPanelOptionInfo);
            }
        }
        return f;
    }

    private int calcRollScreenHeight(List<TerraceInfo> list, TerracesInfo terracesInfo, TerraceInfo terraceInfo, FrontPanelOptionInfo frontPanelOptionInfo) {
        TerraceHeightType terraceHeightType = terracesInfo.mHeightType;
        int n = (int)this.mFrontShapeService.getHeightFront(terraceHeightType.mTumadarukiHeight);
        if (terraceHeightType == TerraceHeightType.LONG) {
            n -= 600;
        }
        return n;
    }

    private int calcFrontDesignScreenHeight(List<TerraceInfo> list, TerraceInfo terraceInfo, FrontPanelOptionInfo frontPanelOptionInfo) {
        FrontDesignScreenHeightType frontDesignScreenHeightType = (FrontDesignScreenHeightType)frontPanelOptionInfo.getHeightType();
        int n = frontDesignScreenHeightType.mHeightByStandard;
        return n;
    }

    private float calcFrontScreenOneStepHeight(List<TerraceInfo> list, TerracesInfo terracesInfo, TerraceInfo terraceInfo, FrontPanelOptionInfo frontPanelOptionInfo) {
        return 980.5f;
    }

    private float calcFrontScreenTwoStepHeight(List<TerraceInfo> list, TerracesInfo terracesInfo, TerraceInfo terraceInfo, FrontPanelOptionInfo frontPanelOptionInfo) {
        return 1927.0f;
    }

    private float calcSukimaFusagiZaiOneStepHeight(List<TerraceInfo> list, TerracesInfo terracesInfo, TerraceInfo terraceInfo, FrontPanelOptionInfo frontPanelOptionInfo) {
        return 195.0f;
    }

    private float calcSukimaFusagiZaiTwoStepHeight(List<TerraceInfo> list, TerracesInfo terracesInfo, TerraceInfo terraceInfo, FrontPanelOptionInfo frontPanelOptionInfo) {
        return 195.0f;
    }

    public float getSettingHeight(MsItemTerrace msItemTerrace, TerraceInfo terraceInfo) {
        SPNEntities sPNEntities = msItemTerrace.getEntities();
        float f = sPNEntities.mTerracesInfo.mHeight.floatValue();
        if (sPNEntities.mTerracesInfo.mEnforcementType == EnforcementType.MAEWAKU_DEHABA_CHIGAI && terraceInfo.mDepth.floatValue() < sPNEntities.mTerracesInfo.mDepth.floatValue()) {
            float f2 = sPNEntities.mTerracesInfo.mDepth.floatValue() - terraceInfo.mDepth.floatValue();
            float f3 = (float)((double)f2 * Math.tan(Math.toRadians(10.0)));
            f += f3;
        }
        return f -= this.calcSettgingUpperHeightGap(msItemTerrace);
    }

    public float getSettgingDepth(MsItemTerrace msItemTerrace, TerraceInfo terraceInfo) {
        SPNEntities sPNEntities = msItemTerrace.getEntities();
        float f = sPNEntities.mTerracesInfo.mDepth.floatValue();
        if (terraceInfo != null) {
            f = terraceInfo.mDepth.floatValue();
        }
        if (sPNEntities.mBasicInfo.mKetaType == KetaType.FREE) {
            if (sPNEntities.mTerracesInfo.mEnforcementType != EnforcementType.SHOMEN_DAIKEI && sPNEntities.mTerracesInfo.mEnforcementType != EnforcementType.SOKUMEN_DAIKEI) {
                f = sPNEntities.mPartsFigureInfo.mKutaiUniversalPillarDepth1.floatValue();
            }
        } else if (sPNEntities.mTerracesInfo.mEnforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI) {
            f = sPNEntities.mTerracesInfo.mDepth.floatValue();
        }
        float f2 = 35.0f;
        return f + f2;
    }

    private float calcSettgingUpperHeightGap(MsItemTerrace msItemTerrace) {
        float f = this.mKetaShapeService.getFrontPanelSettingOffsetHeight(msItemTerrace);
        return f;
    }

    public float getFusagiZaiSettingHeight(MsItemTerrace msItemTerrace, TerraceInfo terraceInfo) {
        SPNEntities sPNEntities = msItemTerrace.getEntities();
        float f = sPNEntities.mTerracesInfo.mHeight.floatValue() + sPNEntities.mPartsFigureInfo.mTooshiHeight.floatValue() + 60.0f;
        if (sPNEntities.mTerracesInfo.mEnforcementType == EnforcementType.MAEWAKU_DEHABA_CHIGAI && terraceInfo.mDepth.floatValue() < sPNEntities.mTerracesInfo.mDepth.floatValue()) {
            float f2 = sPNEntities.mTerracesInfo.mDepth.floatValue() - terraceInfo.mDepth.floatValue();
            float f3 = (float)((double)f2 * Math.tan(Math.toRadians(10.0)));
            f += f3;
        }
        return f;
    }

    public float getFusagiZaiSettingHeightB(MsItemTerrace msItemTerrace, TerraceInfo terraceInfo) {
        float f = this.getFusagiZaiSettingHeight(msItemTerrace, terraceInfo);
        float f2 = this.mKetaShapeService.getOffsetHeightFusagizaiB(msItemTerrace);
        return f - f2;
    }

    public float getFusagiZaiSettingBottomHeight(MsItemTerrace msItemTerrace, TerraceInfo terraceInfo) {
        float f = this.getFusagiZaiSettingHeightB(msItemTerrace, terraceInfo);
        float f2 = this.getSizeFusagizaiB();
        return f - f2;
    }

    public float getFusagiZaiSettgingDepth(MsItemTerrace msItemTerrace, TerraceInfo terraceInfo) {
        SPNEntities sPNEntities = msItemTerrace.getEntities();
        float f = terraceInfo.mDepth.floatValue();
        if (sPNEntities.mTerracesInfo.mEnforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI) {
            f = sPNEntities.mTerracesInfo.mDepth.floatValue();
        }
        return f;
    }

    public float getSizeFusagizaiA() {
        return 194.0f;
    }

    public float getSizeFusagizaiB() {
        return 154.0f;
    }

    public float getFrontPanelLeftOffset(MsItemTerrace msItemTerrace, TerraceInfo terraceInfo) {
        SPNEntities sPNEntities = msItemTerrace.getEntities();
        if (sPNEntities.mTerracesInfo.mEnforcementType == EnforcementType.SOKUMEN_DAIKEI && sPNEntities.mTerracesInfo.mEnforcementDirType == EnforcementDirType.L && terraceInfo.mIsStarting.booleanValue()) {
            return terraceInfo.mWidth.floatValue() - terraceInfo.mFrontWidth.floatValue();
        }
        return 0.0f;
    }

    public float getFrontPanelRightOffset(MsItemTerrace msItemTerrace, TerraceInfo terraceInfo) {
        SPNEntities sPNEntities = msItemTerrace.getEntities();
        if (sPNEntities.mTerracesInfo.mEnforcementType == EnforcementType.SOKUMEN_DAIKEI && sPNEntities.mTerracesInfo.mEnforcementDirType == EnforcementDirType.R && terraceInfo.mIsStarting.booleanValue()) {
            return -(terraceInfo.mWidth.floatValue() - terraceInfo.mFrontWidth.floatValue());
        }
        return 0.0f;
    }
}

