/*
 * Decompiled with CFR 0.152.
 */
package option.speene.shape.speene.model.common.service;

import java.util.List;
import option.gad.core.inject.GdInject;
import option.gad.core.inject.GdInjector;
import option.gad.core.util.GdMutableTypeUtil;
import option.speene.common.dao.cache.type.TypeTerraceDepthCacheDao;
import option.speene.common.entity.SPNEntities;
import option.speene.common.entity.TerracesInfo;
import option.speene.common.entity.type.TypeTerraceDepthInfo;
import option.speene.common.type.RoomType;
import option.speene.common.type.TerraceDepthType;
import option.speene.common.type.TerraceWidthType;
import option.speene.shape.speene.model.common.service.TerraceShapeService;
import option.speene.shape.speene.model.speene.item.AbstractTerraceUnitItem;
import option.speene.shape.speene.model.speene.item.MsItemTerrace;

public class CommonShapeService {
    @GdInject
    private TerraceShapeService terraceShapeService;
    @GdInject
    private TypeTerraceDepthCacheDao typeTerraceDepthCacheDao;
    public static float DEFAULT_TARUKI_UPPER_T4 = 342.0f;
    public static float DEFAULT_TARUKI_UPPER_T6 = 448.0f;
    public static float DEFAULT_TARUKI_UPPER_T8 = 554.0f;
    public static float DEFAULT_TARUKI_UPPER_T10 = 659.0f;

    public CommonShapeService() {
        GdInjector.getInstance().inject((Object)this);
    }

    public float getConstH2(RoomType roomType, TerraceDepthType terraceDepthType) {
        float f = 0.0f;
        if (roomType == RoomType.GARDEN_ROOM) {
            f = terraceDepthType.mDetailTsumabari;
        } else if (GdMutableTypeUtil.matchOR(terraceDepthType, TerraceDepthType.T4)) {
            f = DEFAULT_TARUKI_UPPER_T4;
        } else if (GdMutableTypeUtil.matchOR(terraceDepthType, TerraceDepthType.T6)) {
            f = DEFAULT_TARUKI_UPPER_T6;
        } else if (GdMutableTypeUtil.matchOR(terraceDepthType, TerraceDepthType.T8)) {
            f = DEFAULT_TARUKI_UPPER_T8;
        } else if (GdMutableTypeUtil.matchOR(terraceDepthType, TerraceDepthType.T10)) {
            f = DEFAULT_TARUKI_UPPER_T10;
        }
        return f;
    }

    public AbstractTerraceUnitItem getFirstUnit(MsItemTerrace msItemTerrace, RoomType roomType) {
        List<AbstractTerraceUnitItem> list = msItemTerrace.getUnits();
        AbstractTerraceUnitItem abstractTerraceUnitItem = null;
        for (AbstractTerraceUnitItem abstractTerraceUnitItem2 : list) {
            if (abstractTerraceUnitItem2.getTerraceInfo().mRoomType != roomType || abstractTerraceUnitItem != null && abstractTerraceUnitItem2.getTerraceInfo().mId >= abstractTerraceUnitItem.getTerraceInfo().mId) continue;
            abstractTerraceUnitItem = abstractTerraceUnitItem2;
        }
        return abstractTerraceUnitItem;
    }

    public AbstractTerraceUnitItem getLastUnit(MsItemTerrace msItemTerrace, RoomType roomType) {
        List<AbstractTerraceUnitItem> list = msItemTerrace.getUnits();
        AbstractTerraceUnitItem abstractTerraceUnitItem = null;
        for (AbstractTerraceUnitItem abstractTerraceUnitItem2 : list) {
            if (abstractTerraceUnitItem2.getTerraceInfo().mRoomType != roomType || abstractTerraceUnitItem != null && abstractTerraceUnitItem2.getTerraceInfo().mId <= abstractTerraceUnitItem.getTerraceInfo().mId) continue;
            abstractTerraceUnitItem = abstractTerraceUnitItem2;
        }
        return abstractTerraceUnitItem;
    }

    public boolean isShortGRplusST(MsItemTerrace msItemTerrace, AbstractTerraceUnitItem abstractTerraceUnitItem) {
        SPNEntities sPNEntities = msItemTerrace.getEntities();
        if (sPNEntities.mTerracesInfo.mWidthType.id() > TerraceWidthType.T30.id()) {
            return false;
        }
        if (this.getFirstUnit(msItemTerrace, RoomType.GARDEN_ROOM) == null) {
            return false;
        }
        return this.getFirstUnit(msItemTerrace, RoomType.SIDE_THROUGH) != null;
    }

    public boolean isShortOTplus(MsItemTerrace msItemTerrace, AbstractTerraceUnitItem abstractTerraceUnitItem) {
        SPNEntities sPNEntities = msItemTerrace.getEntities();
        if (!this.terraceShapeService.isGardenRoomPlus(sPNEntities.mTerraceInfoList)) {
            return false;
        }
        if (sPNEntities.mTerracesInfo.mWidthType.mValue > TerraceWidthType.T30.mValue) {
            return false;
        }
        return this.getFirstUnit(msItemTerrace, RoomType.OPEN_TERRACE) != null;
    }

    public float getHeightByRoomType(MsItemTerrace msItemTerrace) {
        SPNEntities sPNEntities = msItemTerrace.getEntities();
        TerracesInfo terracesInfo = sPNEntities.mTerracesInfo;
        return terracesInfo.mHeight.floatValue();
    }

    public float getH2ByRoomType(MsItemTerrace msItemTerrace, float f) {
        SPNEntities sPNEntities = msItemTerrace.getEntities();
        TerracesInfo terracesInfo = sPNEntities.mTerracesInfo;
        RoomType roomType = msItemTerrace.getFirstUnit().getTerraceInfo().mRoomType;
        if (this.hasGardenRoom(msItemTerrace)) {
            roomType = RoomType.GARDEN_ROOM;
        }
        TerraceDepthType terraceDepthType = terracesInfo.mDepthType;
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.typeTerraceDepthCacheDao.findOneByType(terraceDepthType);
        float f2 = this.getConstH2(roomType, terraceDepthType);
        float f3 = typeTerraceDepthInfo.length.floatValue() - 103.0f - f;
        f2 = (float)((double)f2 - (double)f3 * Math.tan(Math.toRadians(10.0)));
        return f2;
    }

    public boolean hasGardenRoom(MsItemTerrace msItemTerrace) {
        for (AbstractTerraceUnitItem abstractTerraceUnitItem : msItemTerrace.getUnits()) {
            if (abstractTerraceUnitItem.getTerraceInfo().mRoomType != RoomType.GARDEN_ROOM) continue;
            return true;
        }
        return false;
    }
}

