/*
 * Decompiled with CFR 0.152.
 */
package option.speene.shape.common.dao;

import com.kt.annotation.Reflectable;
import com.kt.util.tree.ObjectFolder;
import com.kt.util.tree.ObjectNode;
import java.util.Collection;
import java.util.LinkedList;
import option.gad.core.annotation.GdProperty;
import option.gad.core.dao.GdAbstractSaveFileDao;
import option.gad.core.inject.GdInject;
import option.gad.core.util.ObjectFolderUtil;
import option.speene.common.dxo.SPNSaveDataConverter;
import option.speene.common.entity.BasicInfo;
import option.speene.common.entity.FrontPanelInfo;
import option.speene.common.entity.FrontPanelOptionInfo;
import option.speene.common.entity.IBasicInfo;
import option.speene.common.entity.IFrontPanelInfo;
import option.speene.common.entity.IFrontPanelOptionInfo;
import option.speene.common.entity.ISidePanelInfo;
import option.speene.common.entity.ISidePanelOptionInfo;
import option.speene.common.entity.ITerraceInfo;
import option.speene.common.entity.ITerracesInfo;
import option.speene.common.entity.PartsFigureInfo;
import option.speene.common.entity.PartsFigureUnitInfo;
import option.speene.common.entity.SPNEntities;
import option.speene.common.entity.SPNInfos;
import option.speene.common.entity.SidePanelInfo;
import option.speene.common.entity.SidePanelOptionInfo;
import option.speene.common.entity.TerraceInfo;
import option.speene.common.entity.TerracesInfo;
import option.speene.shape.common.modelset.NodeNameSpeene;
import option.speene.shape.speene.model.speene.item.MsItemTerrace;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Reflectable
public abstract class SPNModelSetDao<PER, DOC, TSI extends ITerracesInfo, TI extends ITerraceInfo, BI extends IBasicInfo, FPI extends IFrontPanelInfo, FPIS extends Collection<FPI>, LSPI extends ISidePanelInfo, LSPIS extends Collection<LSPI>, RSPI extends ISidePanelInfo, RSPIS extends Collection<RSPI>, FPOI extends IFrontPanelOptionInfo, FPOIS extends Collection<FPOI>, LSPOI extends ISidePanelOptionInfo, LSPOIS extends Collection<LSPOI>, RSPOI extends ISidePanelOptionInfo, RSPOIS extends Collection<RSPOI>>
extends GdAbstractSaveFileDao<PER, PER, DOC> {
    @GdInject
    private SPNSaveDataConverter mConverter;
    private static final Log mLog = LogFactory.getLog(SPNModelSetDao.class);

    protected SPNModelSetDao() {
    }

    public void save(ObjectFolder objectFolder, MsItemTerrace msItemTerrace) {
        SPNEntities sPNEntities = msItemTerrace.getEntities();
        this.saveFolder(objectFolder, NodeNameSpeene.BASICINFO.name(), sPNEntities.mBasicInfo);
        this.saveFolders(objectFolder, NodeNameSpeene.FRONTPANELINFOS.name(), NodeNameSpeene.FRONTPANELINFO.name(), sPNEntities.mFrontPanelInfoList);
        this.saveFolders(objectFolder, NodeNameSpeene.LEFTPANELINFOS.name(), NodeNameSpeene.LEFTPANELINFO.name(), sPNEntities.mLeftPanelInfoList);
        this.saveFolders(objectFolder, NodeNameSpeene.RIGHTPANELINFOS.name(), NodeNameSpeene.RIGHTPANELINFO.name(), sPNEntities.mRightPanelInfoList);
        this.saveFolders(objectFolder, NodeNameSpeene.FRONTPANELOPTIONINFOS.name(), NodeNameSpeene.FRONTPANELOPTIONINFO.name(), sPNEntities.mFrontPanelOptionInfoList);
        this.saveFolders(objectFolder, NodeNameSpeene.LEFTPANELOPTIONINFOS.name(), NodeNameSpeene.LEFTPANELOPTIONINFO.name(), sPNEntities.mLeftPanelOptionInfoList);
        this.saveFolders(objectFolder, NodeNameSpeene.RIGHTPANELOPTIONINFOS.name(), NodeNameSpeene.RIGHTPANELOPTIONINFO.name(), sPNEntities.mRightPanelOptionInfoList);
        ObjectFolder objectFolder2 = new ObjectFolder(NodeNameSpeene.TERRACEINFOS.name());
        for (TerraceInfo terraceInfo : sPNEntities.mTerraceInfoList) {
            objectFolder2.addChild((ObjectNode)ObjectFolderUtil.createFolder((Object)terraceInfo, (String)NodeNameSpeene.TERRACEINFO.name(), GdProperty.class), true);
        }
        ObjectFolderUtil.addObject((ObjectFolder)objectFolder2, (Object)sPNEntities.mTerracesInfo, GdProperty.class);
        objectFolder.addChild((ObjectNode)objectFolder2);
    }

    public void load(ObjectFolder objectFolder, MsItemTerrace msItemTerrace) {
        BI BI = this.loadBasicInfo(objectFolder);
        TSI TSI = this.loadTerracesInfo(objectFolder);
        Collection<TI> collection = this.loadTerraceInfos(objectFolder);
        Collection<FPI> collection2 = this.loadFrontPanelInfo(objectFolder);
        Collection<LSPI> collection3 = this.loadLeftPanelInfo(objectFolder);
        Collection<RSPI> collection4 = this.loadRighrPanelInfo(objectFolder);
        Collection<FPOI> collection5 = this.loadFrontPanelOptionInfo(objectFolder);
        Collection<LSPOI> collection6 = this.loadLeftPanelOptionInfo(objectFolder);
        Collection<RSPOI> collection7 = this.loadRighrPanelOptionInfo(objectFolder);
        SPNInfos sPNInfos = SPNInfos.newInstance();
        sPNInfos.value1 = TSI;
        sPNInfos.value2 = collection;
        sPNInfos.value3 = BI;
        sPNInfos.value4 = collection2;
        sPNInfos.value5 = collection3;
        sPNInfos.value6 = collection4;
        sPNInfos.value7 = collection5;
        sPNInfos.value8 = collection6;
        sPNInfos.value9 = collection7;
        this.repair((IBasicInfo)sPNInfos.value3, (ITerracesInfo)sPNInfos.value1, (Collection)sPNInfos.value2, (Collection)sPNInfos.value4, (Collection)sPNInfos.value5, (Collection)sPNInfos.value6, (Collection)sPNInfos.value7, (Collection)sPNInfos.value8, (Collection)sPNInfos.value9);
        SPNInfos sPNInfos2 = (SPNInfos)this.mConverter.convert(msItemTerrace.getVersion(), sPNInfos);
        this.restore(msItemTerrace, (BasicInfo)sPNInfos2.value3, (TerracesInfo)sPNInfos2.value1, (Collection)sPNInfos2.value2, (Collection)sPNInfos2.value4, (Collection)sPNInfos2.value5, (Collection)sPNInfos2.value6, (Collection)sPNInfos2.value7, (Collection)sPNInfos2.value8, (Collection)sPNInfos2.value9);
    }

    protected BI loadBasicInfo(ObjectFolder objectFolder) {
        return (BI)((IBasicInfo)this.loadFolder(objectFolder, NodeNameSpeene.BASICINFO.name()));
    }

    protected Collection<FPI> loadFrontPanelInfo(ObjectFolder objectFolder) {
        return this.loadFolders(objectFolder, NodeNameSpeene.FRONTPANELINFOS.name(), NodeNameSpeene.FRONTPANELINFO.name());
    }

    protected Collection<LSPI> loadLeftPanelInfo(ObjectFolder objectFolder) {
        return this.loadFolders(objectFolder, NodeNameSpeene.LEFTPANELINFOS.name(), NodeNameSpeene.LEFTPANELINFO.name());
    }

    protected Collection<RSPI> loadRighrPanelInfo(ObjectFolder objectFolder) {
        return this.loadFolders(objectFolder, NodeNameSpeene.RIGHTPANELINFOS.name(), NodeNameSpeene.RIGHTPANELINFO.name());
    }

    protected Collection<FPOI> loadFrontPanelOptionInfo(ObjectFolder objectFolder) {
        return this.loadFolders(objectFolder, NodeNameSpeene.FRONTPANELOPTIONINFOS.name(), NodeNameSpeene.FRONTPANELOPTIONINFO.name());
    }

    protected Collection<LSPOI> loadLeftPanelOptionInfo(ObjectFolder objectFolder) {
        return this.loadFolders(objectFolder, NodeNameSpeene.LEFTPANELOPTIONINFOS.name(), NodeNameSpeene.LEFTPANELOPTIONINFO.name());
    }

    protected Collection<RSPOI> loadRighrPanelOptionInfo(ObjectFolder objectFolder) {
        return this.loadFolders(objectFolder, NodeNameSpeene.RIGHTPANELOPTIONINFOS.name(), NodeNameSpeene.RIGHTPANELOPTIONINFO.name());
    }

    protected TSI loadTerracesInfo(ObjectFolder objectFolder) {
        return (TSI)((ITerracesInfo)this.loadFolder(objectFolder, NodeNameSpeene.TERRACEINFOS.name()));
    }

    protected Collection<TI> loadTerraceInfos(ObjectFolder objectFolder) {
        ObjectFolder objectFolder22;
        Collection collection = ObjectFolderUtil.findChildFolders((ObjectFolder)objectFolder, (String)NodeNameSpeene.TERRACEINFO.name());
        ObjectFolder objectFolder3 = new ObjectFolder(NodeNameSpeene.TERRACEINFOS.name());
        objectFolder3.addChild(new ObjectNode("type", (Object)"java.util.ArrayList"));
        for (ObjectFolder objectFolder22 : collection) {
            objectFolder3.addChild((ObjectNode)objectFolder22, true);
        }
        objectFolder22 = new ObjectFolder("root");
        objectFolder22.addChild((ObjectNode)objectFolder3);
        return this.loadFolders(objectFolder22, NodeNameSpeene.TERRACEINFOS.name(), NodeNameSpeene.TERRACEINFO.name(), TerraceInfo.class);
    }

    protected void repair(BI BI, TSI TSI, Collection<TI> collection, Collection<FPI> collection2, Collection<LSPI> collection3, Collection<RSPI> collection4, Collection<FPOI> collection5, Collection<LSPOI> collection6, Collection<RSPOI> collection7) {
    }

    protected void restore(MsItemTerrace msItemTerrace, BasicInfo basicInfo, TerracesInfo terracesInfo, Collection<TerraceInfo> collection, Collection<FrontPanelInfo> collection2, Collection<SidePanelInfo> collection3, Collection<SidePanelInfo> collection4, Collection<FrontPanelOptionInfo> collection5, Collection<SidePanelOptionInfo> collection6, Collection<SidePanelOptionInfo> collection7) {
        SPNEntities sPNEntities = msItemTerrace.getEntities();
        sPNEntities.mBasicInfo = basicInfo;
        sPNEntities.mTerracesInfo = terracesInfo;
        sPNEntities.mTerraceInfoList = new LinkedList<TerraceInfo>(collection);
        sPNEntities.mFrontPanelInfoList = new LinkedList<FrontPanelInfo>(collection2);
        sPNEntities.mLeftPanelInfoList = new LinkedList<SidePanelInfo>(collection3);
        sPNEntities.mRightPanelInfoList = new LinkedList<SidePanelInfo>(collection4);
        sPNEntities.mFrontPanelOptionInfoList = new LinkedList<FrontPanelOptionInfo>(collection5);
        sPNEntities.mLeftPanelOptionInfoList = new LinkedList<SidePanelOptionInfo>(collection6);
        sPNEntities.mRightPanelOptionInfoList = new LinkedList<SidePanelOptionInfo>(collection7);
        sPNEntities.mPartsFigureInfo = new PartsFigureInfo();
        for (TerraceInfo terraceInfo : sPNEntities.mTerraceInfoList) {
            PartsFigureUnitInfo partsFigureUnitInfo = new PartsFigureUnitInfo();
            partsFigureUnitInfo.mId = terraceInfo.mId;
            sPNEntities.mPartsFigureUnitInfoList.add(partsFigureUnitInfo);
        }
    }
}

