/*
 * Decompiled with CFR 0.152.
 */
package option.speene.common.service.parts;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import option.gad.core.inject.GdInject;
import option.gad.core.util.GdMutableTypeUtil;
import option.gad.core.util.NumberUtil;
import option.speene.common.dao.cache.type.TypeTerraceDepthCacheDao;
import option.speene.common.dao.cache.type.TypeTerraceWidthCacheDao;
import option.speene.common.entity.BasicInfo;
import option.speene.common.entity.Constants;
import option.speene.common.entity.FloorInfo;
import option.speene.common.entity.PartsFigureInfo;
import option.speene.common.entity.SPNEntities;
import option.speene.common.entity.TerraceInfo;
import option.speene.common.entity.TerracesInfo;
import option.speene.common.entity.type.TypeTerraceDepthInfo;
import option.speene.common.entity.type.TypeTerraceWidthInfo;
import option.speene.common.entity.v10.BasicInfoV10;
import option.speene.common.entity.v10.TerraceInfoV10;
import option.speene.common.entity.v10.TerracesInfoV10;
import option.speene.common.service.parts.TerraceCommonService;
import option.speene.common.type.BuildingType;
import option.speene.common.type.DirectionType;
import option.speene.common.type.EnforcementDirType;
import option.speene.common.type.EnforcementType;
import option.speene.common.type.KenType;
import option.speene.common.type.KetaType;
import option.speene.common.type.PanelDirectionType;
import option.speene.common.type.RoofFigureType;
import option.speene.common.type.SodePosType;
import option.speene.common.type.SubProductType;
import option.speene.common.type.TerraceHeightType;
import option.speene.common.type.TerraceWidthType;

public class TerraceFigureCommonService {
    @GdInject
    protected Constants mConstants;
    @GdInject
    protected TerraceCommonService mTerraceCommonService;
    @GdInject
    protected TypeTerraceWidthCacheDao mTypeTerraceWidthCacheDao;
    @GdInject
    protected TypeTerraceDepthCacheDao mTypeTerraceDepthCacheDao;
    public static final float CORNER_EXTENTION = 97.5f;
    public static final float FL_OPENING_DIFF = 50.0f;
    public static final float ALMI_BALCONY_FL_OPENING_DIFF = 56.0f;
    public static final float PILLAR_WIDTH = 70.0f;
    public static final float ADJUST_KUTAI_WAKU = 15.0f;

    public <TSI extends TerraceInfoV10> float getFrameDepth(TSI TSI, DirectionType directionType) {
        float f = 0.0f;
        f = directionType == DirectionType.LEFT ? TSI.mLeftDepth.floatValue() : (directionType == DirectionType.RIGHT ? TSI.mRightDepth.floatValue() : TSI.mDepth.floatValue());
        return f;
    }

    public float calcTurningAngle(List<TerraceInfo> list, int n) {
        float f = 0.0f;
        int n2 = 0;
        while (n2 < list.size()) {
            TerraceInfo terraceInfo = list.get(n2);
            if (n2 == 0) {
                f += ((Float)NumberUtil.emptyToDefault((Object)terraceInfo.mTurningAngle, (Object)Float.valueOf(0.0f))).floatValue();
            }
            if (terraceInfo.mId.equals(n)) break;
            if (n2 > 0) {
                f += ((Float)NumberUtil.emptyToDefault((Object)terraceInfo.mTurningAngle, (Object)Float.valueOf(0.0f))).floatValue();
            }
            ++n2;
        }
        return f;
    }

    public float calcWidth(TerracesInfo terracesInfo, TerraceInfo terraceInfo) {
        return this.calcWidth(terracesInfo, terraceInfo, terraceInfo.mDefaultWidth.floatValue(), terraceInfo.mCutWidth.floatValue());
    }

    public float calcWidth(TerracesInfo terracesInfo, TerraceInfo terraceInfo, float f, float f2) {
        float f3 = f - f2;
        return f3;
    }

    public float calcGroupWidth(List<TerraceInfo> list, int n) {
        return this.calcGroupWidth(list, n, true);
    }

    public float calcGroupWidth(List<TerraceInfo> list, int n, boolean bl) {
        return this.calcGroupWidth(list, n, bl, true);
    }

    public float calcGroupWidth(List<TerraceInfo> list, int n, boolean bl, boolean bl2) {
        float f = 0.0f;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        for (TerraceInfo terraceInfo : list) {
            if (!terraceInfo.mGroupId.equals(n)) continue;
            f += terraceInfo.mWidth.floatValue();
            n2 = Math.min(n2, terraceInfo.mId);
            n3 = Math.max(n3, terraceInfo.mId);
        }
        if (bl) {
            for (TerraceInfo terraceInfo : list) {
                if (terraceInfo.mId.equals(n2 - 1) && terraceInfo.mBuildingType == BuildingType.CORNER) {
                    f += terraceInfo.mWidth.floatValue();
                }
                if (!terraceInfo.mId.equals(n3 + 1) || terraceInfo.mBuildingType != BuildingType.CORNER) continue;
                f += terraceInfo.mWidth.floatValue();
            }
        }
        if (bl2) {
            f += 97.5f;
        }
        return f;
    }

    public float calcTotalWidth(List<TerraceInfo> list, boolean bl, boolean bl2) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (TerraceInfo terraceInfo : list) {
            treeSet.add(terraceInfo.mGroupId);
        }
        float f = 0.0f;
        for (Integer n : treeSet) {
            f += this.calcGroupWidth(list, n, bl, bl2);
        }
        return f;
    }

    public float calcDepthInner(SPNEntities sPNEntities) {
        return sPNEntities.mTerracesInfo.mDepth.floatValue() - 35.0f;
    }

    public int calcSpanNum(SPNEntities sPNEntities, TerraceInfo terraceInfo) {
        BasicInfo basicInfo = sPNEntities.mBasicInfo;
        return (int)Math.ceil(terraceInfo.mWidth.floatValue() / basicInfo.mKenLen.floatValue());
    }

    public int calcFrontHalfSpanNum(SPNEntities sPNEntities, boolean bl) {
        return this.calcFrontHalfSpanNum(sPNEntities.mBasicInfo, sPNEntities.mTerracesInfo, sPNEntities.mTerraceInfoList, bl);
    }

    public int calcFrontHalfSpanNum(SPNEntities sPNEntities, TerraceInfo terraceInfo, boolean bl) {
        return this.calcFrontHalfSpanNum(sPNEntities.mBasicInfo, sPNEntities.mTerracesInfo, terraceInfo, bl);
    }

    public int calcFrontHalfSpanNum(BasicInfo basicInfo, TerracesInfo terracesInfo, LinkedList<TerraceInfo> linkedList, boolean bl) {
        int n = 0;
        for (TerraceInfo terraceInfo : linkedList) {
            if (terraceInfo.mBuildingType == BuildingType.CORNER) continue;
            n += this.calcFrontHalfSpanNum(basicInfo, terracesInfo, terraceInfo, bl);
        }
        return n;
    }

    public int calcFrontHalfSpanNum(BasicInfo basicInfo, TerracesInfo terracesInfo, TerraceInfo terraceInfo, boolean bl) {
        TypeTerraceWidthInfo typeTerraceWidthInfo;
        if (GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.OPEN)) {
            return 0;
        }
        int n = 0;
        TerraceWidthType terraceWidthType = terraceInfo.mWidthType;
        if (terraceWidthType != null) {
            typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType, basicInfo.mKenType);
            n += typeTerraceWidthInfo.span.intValue();
        }
        if (terracesInfo.mEnforcementType == EnforcementType.DESUMI) {
            typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByLength(terracesInfo.mDepth, basicInfo.mKenType);
            n += typeTerraceWidthInfo.span.intValue();
        } else if (terracesInfo.mEnforcementType == EnforcementType.IRISUMI) {
            n += 2;
        }
        return n;
    }

    public int calcFrontSpanNum(TerraceWidthType terraceWidthType, KenType kenType) {
        TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType, kenType);
        return typeTerraceWidthInfo.span;
    }

    public int calcLeftSpanNum(SPNEntities sPNEntities, boolean bl) {
        TerracesInfo terracesInfo = sPNEntities.mTerracesInfo;
        if (GdMutableTypeUtil.matchOR(terracesInfo.mSodePosType, SodePosType.L, SodePosType.BOTH)) {
            return 0;
        }
        return this.calcSideSpanNum(sPNEntities.mTerraceInfoList.getFirst().mLeftDepth.floatValue(), sPNEntities.mBasicInfo, bl);
    }

    public int calcRightSpanNum(SPNEntities sPNEntities, boolean bl) {
        TerracesInfo terracesInfo = sPNEntities.mTerracesInfo;
        if (GdMutableTypeUtil.matchOR(terracesInfo.mSodePosType, SodePosType.R, SodePosType.BOTH)) {
            return 0;
        }
        return this.calcSideSpanNum(sPNEntities.mTerraceInfoList.getLast().mRightDepth.floatValue(), sPNEntities.mBasicInfo, bl);
    }

    public int calcSideSpanNum(float f, BasicInfo basicInfo, boolean bl) {
        return this.calcSideSpanNum(f, basicInfo.mSubProductType, bl);
    }

    public int calcSideSpanNum(float f, SubProductType subProductType, boolean bl) {
        if (GdMutableTypeUtil.matchOR(subProductType, SubProductType.OPEN)) {
            return 0;
        }
        return this.calcSideSpanNum(f);
    }

    public int calcSideSpanNum(float f) {
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneByLength(Float.valueOf(f));
        return typeTerraceDepthInfo.span;
    }

    public float calcLeftDepthGap(EnforcementType enforcementType, EnforcementDirType enforcementDirType, TerracesInfo terracesInfo) {
        float f = 0.0f;
        if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.KUTAI_DEHABA_CHIGAI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.L)) {
            f = terracesInfo.mDepthGap == null ? 0.0f : terracesInfo.mDepthGap.floatValue();
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.BUBUN_IRISUMI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.L)) {
            f = terracesInfo.mPartialDepth == null ? 0.0f : terracesInfo.mPartialDepth.floatValue();
            f += 50.0f;
        }
        return f;
    }

    public float calcRightDepthGap(EnforcementType enforcementType, EnforcementDirType enforcementDirType, TerracesInfo terracesInfo) {
        float f = 0.0f;
        if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.KUTAI_DEHABA_CHIGAI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.R)) {
            f = terracesInfo.mDepthGap == null ? 0.0f : terracesInfo.mDepthGap.floatValue();
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.BUBUN_IRISUMI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.R)) {
            f = terracesInfo.mPartialDepth == null ? 0.0f : terracesInfo.mPartialDepth.floatValue();
            f += 50.0f;
        }
        return f;
    }

    public float calcFrontBaseHeight(SPNEntities sPNEntities, TerraceInfo terraceInfo, int n) {
        BasicInfo basicInfo = sPNEntities.mBasicInfo;
        PartsFigureInfo partsFigureInfo = sPNEntities.mPartsFigureInfo;
        float f = 0.0f;
        f = basicInfo.mSubProductType == SubProductType.DOMA ? partsFigureInfo.mDomaLevel.floatValue() : (basicInfo.mSubProductType == SubProductType.TSUKURITSUKE ? 0.0f : partsFigureInfo.mYukaHeight.floatValue());
        return f;
    }

    public float calcSideBaseHeight(SPNEntities sPNEntities, TerraceInfo terraceInfo, int n, boolean bl) {
        BasicInfo basicInfo = sPNEntities.mBasicInfo;
        PartsFigureInfo partsFigureInfo = sPNEntities.mPartsFigureInfo;
        float f = 0.0f;
        f = basicInfo.mSubProductType == SubProductType.DOMA ? partsFigureInfo.mDomaLevel.floatValue() : (basicInfo.mSubProductType == SubProductType.TSUKURITSUKE ? 0.0f : partsFigureInfo.mYukaHeight.floatValue());
        return f;
    }

    public double calcRoofHeight(SPNEntities sPNEntities) {
        return this.calcRoofHeight(sPNEntities.mBasicInfo, sPNEntities.mTerraceInfoList);
    }

    public <BI extends BasicInfoV10, TI extends TerraceInfoV10> double calcRoofHeight(BI BI, Collection<TI> collection) {
        TI TI = this.mTerraceCommonService.findMasterTerraceInfo(collection);
        return this.calcRoofHeight(BI, TI, (DirectionType)null);
    }

    public <BI extends BasicInfoV10, TI extends TerraceInfoV10> double calcRoofHeight(BI BI, TI TI, DirectionType directionType) {
        double d = 10.0;
        double d2 = Math.tan(Math.toRadians(d));
        float f = this.getFrameDepth(TI, directionType);
        double d3 = (double)f * d2;
        double d4 = 0.0;
        if (BI.mRoofFigureType == RoofFigureType.F) {
            d4 = BI.mKetaType == KetaType.STD ? 92.5 : 98.6;
        } else if (BI.mRoofFigureType == RoofFigureType.R) {
            d4 = BI.mKetaType == KetaType.STD ? 233.6 : 144.9;
        }
        double d5 = d3 + d4;
        return d5;
    }

    public <TSI extends TerracesInfoV10> double calcTotalHeight(TSI TSI) {
        return TSI.mRoofHeight.floatValue() + TSI.mHeight.floatValue();
    }

    public float calcH2(BasicInfo basicInfo, FloorInfo floorInfo) {
        float f = 0.0f;
        return f;
    }

    public float getTsumadarukiHeight(TerraceHeightType terraceHeightType) {
        float f = 0.0f;
        if (terraceHeightType == TerraceHeightType.STD) {
            f = 2587.0f;
        } else if (terraceHeightType == TerraceHeightType.LONG) {
            f = 3287.0f;
        }
        return f;
    }

    public boolean isTsukuritsuke(TerracesInfo terracesInfo, SubProductType subProductType, EnforcementType enforcementType, EnforcementDirType enforcementDirType, PanelDirectionType panelDirectionType) {
        return subProductType == SubProductType.TSUKURITSUKE;
    }

    public boolean isTsukuritsuke(SPNEntities sPNEntities, PanelDirectionType panelDirectionType) {
        TerracesInfo terracesInfo = sPNEntities.mTerracesInfo;
        SubProductType subProductType = sPNEntities.mBasicInfo.mSubProductType;
        EnforcementType enforcementType = terracesInfo.mEnforcementType;
        EnforcementDirType enforcementDirType = terracesInfo.mEnforcementDirType;
        return this.isTsukuritsuke(terracesInfo, subProductType, enforcementType, enforcementDirType, panelDirectionType);
    }
}

