/*
 * Decompiled with CFR 0.152.
 */
package option.speene.common.service.parts;

import com.kt.annotation.Reflectable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import option.gad.core.inject.GdInject;
import option.gad.core.util.GdMutableTypeUtil;
import option.speene.common.dao.cache.type.TypeTerraceDepthCacheDao;
import option.speene.common.dao.cache.type.TypeTerraceWidthCacheDao;
import option.speene.common.dxo.TerraceWidthTypeDxo;
import option.speene.common.entity.BasicInfo;
import option.speene.common.entity.SPNEntities;
import option.speene.common.entity.TerraceInfo;
import option.speene.common.entity.TerracesInfo;
import option.speene.common.entity.type.TypeTerraceDepthInfo;
import option.speene.common.entity.type.TypeTerraceWidthInfo;
import option.speene.common.entity.v10.TerraceInfoV10;
import option.speene.common.service.common.EnforcementCommonService;
import option.speene.common.service.floor.DomaTileCommonService;
import option.speene.common.type.BuildingType;
import option.speene.common.type.EnforcementDirType;
import option.speene.common.type.EnforcementType;
import option.speene.common.type.KenType;
import option.speene.common.type.RoomType;
import option.speene.common.type.TerraceDepthType;
import option.speene.common.type.TerraceWidthType;
import option.speene.common.type.factory.TerraceDepthTypeFactory;
import option.speene.common.type.factory.TerraceWidthTypeFactory;
import option.speene.server.dxo.TerraceDepthTypeDxo;

@Reflectable
public class TerraceCommonService {
    @GdInject
    private DomaTileCommonService mDomaTileAppletService;
    @GdInject
    private EnforcementCommonService mEnforcementCommonService;
    @GdInject
    private TypeTerraceDepthCacheDao mTypeTerraceDepthCacheDao;
    @GdInject
    private TypeTerraceWidthCacheDao mTypeTerraceWidthCacheDao;

    public void changeWidth(SPNEntities sPNEntities) {
        this.changeWidth(sPNEntities, null, null);
    }

    public void changeWidth(SPNEntities sPNEntities, TerraceWidthType terraceWidthType, Float f) {
        TerraceWidthType terraceWidthType2;
        TerraceWidthType terraceWidthType3;
        TypeTerraceWidthInfo typeTerraceWidthInfo;
        BasicInfo basicInfo = sPNEntities.mBasicInfo;
        TerracesInfo terracesInfo = sPNEntities.mTerracesInfo;
        LinkedList<TerraceInfo> linkedList = sPNEntities.mTerraceInfoList;
        TerraceInfo terraceInfo = this.findMasterTerraceInfo(linkedList);
        EnforcementType enforcementType = terracesInfo.mEnforcementType;
        if (enforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI && terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
            if (terraceWidthType == null) {
                terraceWidthType = TerraceWidthType.T05;
            }
        } else if (enforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI && terracesInfo.mEnforcementDirType == EnforcementDirType.R && terraceWidthType == null) {
            terraceWidthType = TerraceWidthType.T05;
        }
        if (terraceWidthType == null) {
            terraceWidthType = TerraceWidthType.T00;
        }
        if (f == null) {
            typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType, basicInfo.mKenType);
            f = typeTerraceWidthInfo.length;
        }
        terracesInfo.mWidthGapType = terraceWidthType;
        terracesInfo.mWidthGap = f;
        if (enforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI && terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
            terraceInfo.mLeftWidth = Float.valueOf(terraceInfo.mWidth.floatValue() - f.floatValue());
            terraceInfo.mRightWidth = f;
            terracesInfo.mLeftTotalWidth = Float.valueOf(this.calcLeftTotalWidth(linkedList));
            terracesInfo.mRightTotalWidth = Float.valueOf(this.calcRightTotalWidth(linkedList));
            this.mDomaTileAppletService.setCutWidth(sPNEntities, terracesInfo.mWidth.floatValue() - f.floatValue());
        } else if (enforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI && terracesInfo.mEnforcementDirType == EnforcementDirType.R) {
            terraceInfo.mLeftWidth = f;
            terraceInfo.mRightWidth = Float.valueOf(terraceInfo.mWidth.floatValue() - f.floatValue());
            terracesInfo.mLeftTotalWidth = Float.valueOf(this.calcLeftTotalWidth(linkedList));
            terracesInfo.mRightTotalWidth = Float.valueOf(this.calcRightTotalWidth(linkedList));
            this.mDomaTileAppletService.setCutWidth(sPNEntities, terracesInfo.mWidth.floatValue() - f.floatValue());
        } else if (enforcementType == EnforcementType.SOKUMEN_DAIKEI) {
            terraceInfo.mFrontWidthType = terraceInfo.mWidthType;
            terraceInfo.mFrontWidth = Float.valueOf(terraceInfo.mWidth.floatValue() - basicInfo.mKenLen.floatValue());
            terraceInfo.mBackWidthType = terraceInfo.mWidthType;
            terraceInfo.mBackWidth = terraceInfo.mWidth;
        } else {
            terraceInfo.mLeftWidth = Float.valueOf(0.0f);
            terraceInfo.mRightWidth = Float.valueOf(0.0f);
            terracesInfo.mLeftTotalWidth = Float.valueOf(0.0f);
            terracesInfo.mRightTotalWidth = Float.valueOf(0.0f);
            this.mDomaTileAppletService.setCutWidth(sPNEntities, f.floatValue());
        }
        typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByLength(terraceInfo.mLeftWidth, basicInfo.mKenType);
        terraceInfo.mLeftWidthType = terraceWidthType3 = (TerraceWidthType)TerraceWidthTypeFactory.getInstance().getTypeById(typeTerraceWidthInfo.typeTerraceWidthId);
        TypeTerraceWidthInfo typeTerraceWidthInfo2 = this.mTypeTerraceWidthCacheDao.findOneByLength(terraceInfo.mRightWidth, basicInfo.mKenType);
        terraceInfo.mRightWidthType = terraceWidthType2 = (TerraceWidthType)TerraceWidthTypeFactory.getInstance().getTypeById(typeTerraceWidthInfo2.typeTerraceWidthId);
        this.updateTerracesInfo(basicInfo, terracesInfo, linkedList);
    }

    public void changeAllDepthByDepthType(BasicInfo basicInfo, TerracesInfo terracesInfo, LinkedList<TerraceInfo> linkedList, TerraceDepthType terraceDepthType) {
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneById(terraceDepthType.id());
        this.changeAllDepthByDepth(basicInfo, terracesInfo, linkedList, typeTerraceDepthInfo.length.floatValue());
    }

    public void changeAllDepthByDepth(BasicInfo basicInfo, TerracesInfo terracesInfo, LinkedList<TerraceInfo> linkedList, float f) {
        this.changeAllDepth(basicInfo, terracesInfo, linkedList, Float.valueOf(f), null, null);
    }

    public void changeAllDepthByDepthGap(BasicInfo basicInfo, TerracesInfo terracesInfo, LinkedList<TerraceInfo> linkedList, float f) {
        this.changeAllDepth(basicInfo, terracesInfo, linkedList, null, Float.valueOf(f), null);
    }

    public void changeAllDepth(BasicInfo basicInfo, TerracesInfo terracesInfo, LinkedList<TerraceInfo> linkedList, Float f, Float f2, Integer n) {
        EnforcementType enforcementType = terracesInfo.mEnforcementType;
        EnforcementDirType enforcementDirType = terracesInfo.mEnforcementDirType;
        if (f == null) {
            f = terracesInfo.mDepth;
        }
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneByLength(f);
        float f3 = typeTerraceDepthInfo.length.floatValue();
        TerraceDepthType terraceDepthType = (TerraceDepthType)TerraceDepthTypeFactory.getInstance().getTypeById(typeTerraceDepthInfo.typeTerraceDepthId);
        if (f2 == null) {
            f2 = terracesInfo.mDepthGap;
        }
        float f4 = f.floatValue() - f2.floatValue();
        TypeTerraceDepthInfo typeTerraceDepthInfo2 = this.mTypeTerraceDepthCacheDao.findOneByLength(Float.valueOf(f4));
        float f5 = typeTerraceDepthInfo2.length.floatValue();
        TerraceDepthType terraceDepthType2 = (TerraceDepthType)TerraceDepthTypeFactory.getInstance().getTypeById(typeTerraceDepthInfo2.typeTerraceDepthId);
        for (TerraceInfo terraceInfo : linkedList) {
            if (n != null && !terraceInfo.mGroupId.equals(n)) continue;
            if (enforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI) {
                if (enforcementDirType == EnforcementDirType.L && terraceInfo.mId < 0 || enforcementDirType == EnforcementDirType.R && terraceInfo.mId > 0) {
                    terraceInfo.mDepthType = terraceDepthType2;
                    terraceInfo.mDefaultDepth = Float.valueOf(f5);
                    terraceInfo.mDepth = Float.valueOf(f4);
                    terraceInfo.mLeftDepthType = terraceDepthType2;
                    terraceInfo.mLeftDepth = Float.valueOf(f4);
                    terraceInfo.mRightDepthType = terraceDepthType2;
                    terraceInfo.mRightDepth = Float.valueOf(f4);
                } else if (enforcementDirType == EnforcementDirType.L && terraceInfo.mId == 0) {
                    terraceInfo.mDepthType = terraceDepthType;
                    terraceInfo.mDefaultDepth = Float.valueOf(f3);
                    terraceInfo.mDepth = f;
                    terraceInfo.mLeftDepthType = terraceDepthType2;
                    terraceInfo.mLeftDepth = Float.valueOf(f4);
                    terraceInfo.mRightDepthType = terraceDepthType;
                    terraceInfo.mRightDepth = f;
                } else if (enforcementDirType == EnforcementDirType.R && terraceInfo.mId == 0) {
                    terraceInfo.mDepthType = terraceDepthType;
                    terraceInfo.mDefaultDepth = Float.valueOf(f3);
                    terraceInfo.mDepth = f;
                    terraceInfo.mLeftDepthType = terraceDepthType;
                    terraceInfo.mLeftDepth = f;
                    terraceInfo.mRightDepthType = terraceDepthType2;
                    terraceInfo.mRightDepth = Float.valueOf(f4);
                } else {
                    terraceInfo.mDepthType = terraceDepthType;
                    terraceInfo.mDefaultDepth = Float.valueOf(f3);
                    terraceInfo.mDepth = f;
                    terraceInfo.mLeftDepthType = terraceDepthType;
                    terraceInfo.mLeftDepth = f;
                    terraceInfo.mRightDepthType = terraceDepthType;
                    terraceInfo.mRightDepth = f;
                }
            } else if (enforcementType == EnforcementType.SHOMEN_DAIKEI) {
                if (enforcementDirType == EnforcementDirType.L) {
                    terraceInfo.mDepthType = terraceDepthType;
                    terraceInfo.mDefaultDepth = Float.valueOf(f3);
                    terraceInfo.mDepth = f;
                    terraceInfo.mLeftDepthType = terraceDepthType;
                    terraceInfo.mLeftDepth = Float.valueOf(f.floatValue() - 300.0f);
                    terraceInfo.mRightDepthType = terraceDepthType;
                    terraceInfo.mRightDepth = f;
                } else if (enforcementDirType == EnforcementDirType.R) {
                    terraceInfo.mDepthType = terraceDepthType;
                    terraceInfo.mDefaultDepth = Float.valueOf(f3);
                    terraceInfo.mDepth = f;
                    terraceInfo.mLeftDepthType = terraceDepthType;
                    terraceInfo.mLeftDepth = f;
                    terraceInfo.mRightDepthType = terraceDepthType;
                    terraceInfo.mRightDepth = Float.valueOf(f.floatValue() - 300.0f);
                }
            } else {
                terraceInfo.mDepthType = terraceDepthType;
                terraceInfo.mDefaultDepth = Float.valueOf(f3);
                terraceInfo.mDepth = f;
                terraceInfo.mLeftDepthType = terraceDepthType;
                terraceInfo.mLeftDepth = f;
                terraceInfo.mRightDepthType = terraceDepthType;
                terraceInfo.mRightDepth = f;
            }
            if (terraceInfo.mBuildingType != BuildingType.CORNER) continue;
            terraceInfo.mWidth = f;
            terraceInfo.mDefaultWidth = f;
        }
        this.updateTerracesInfo(basicInfo, terracesInfo, linkedList);
    }

    public void updateTerracesInfo(SPNEntities sPNEntities) {
        this.updateTerracesInfo(sPNEntities.mBasicInfo, sPNEntities.mTerracesInfo, sPNEntities.mTerraceInfoList);
    }

    public void updateTerracesInfo(BasicInfo basicInfo, TerracesInfo terracesInfo, List<TerraceInfo> list) {
        float f = 0.0f;
        for (TerraceInfo terraceInfo : list) {
            f += terraceInfo.mWidth.floatValue();
        }
        float f2 = 0.0f;
        for (TerraceInfo terraceInfo : list) {
            f2 = Math.max(f2, terraceInfo.mDepth.floatValue());
        }
        terracesInfo.mWidth = Float.valueOf(f);
        terracesInfo.mWidthType = TerraceWidthTypeDxo.convert(f, basicInfo.mKenType);
        terracesInfo.mDepth = Float.valueOf(f2);
        terracesInfo.mDepthType = TerraceDepthTypeDxo.convert(f2);
    }

    public <TI extends TerraceInfoV10> TI findMasterTerraceInfo(Collection<TI> collection) {
        for (TerraceInfoV10 terraceInfoV10 : collection) {
            if (!terraceInfoV10.mIsMaster.booleanValue()) continue;
            return (TI)terraceInfoV10;
        }
        return null;
    }

    public TerraceInfo findOneStartingTerraceInfo(LinkedList<TerraceInfo> linkedList, int n) {
        TerraceInfo terraceInfo = null;
        for (TerraceInfo terraceInfo2 : linkedList) {
            if (!terraceInfo2.mIsStarting.booleanValue() || !terraceInfo2.mGroupId.equals(n)) continue;
            terraceInfo = terraceInfo2;
            break;
        }
        return terraceInfo;
    }

    public LinkedList<TerraceInfo> findManyGardenRoomPlusTerrace(LinkedList<TerraceInfo> linkedList) {
        LinkedList<TerraceInfo> linkedList2 = new LinkedList<TerraceInfo>();
        for (TerraceInfo terraceInfo : linkedList) {
            if (terraceInfo.mIsMaster.booleanValue()) continue;
            linkedList2.add(terraceInfo);
        }
        return linkedList2;
    }

    public LinkedList<TerraceInfo> findManyTerraceInfoByRoomType(List<TerraceInfo> list, RoomType roomType) {
        LinkedList<TerraceInfo> linkedList = new LinkedList<TerraceInfo>();
        for (TerraceInfo terraceInfo : list) {
            if (roomType != terraceInfo.mRoomType) continue;
            linkedList.add(terraceInfo);
        }
        return linkedList;
    }

    public LinkedList<TerraceInfo> findManyTerraceInfoByCorner(LinkedList<TerraceInfo> linkedList) {
        LinkedList<TerraceInfo> linkedList2 = new LinkedList<TerraceInfo>();
        for (TerraceInfo terraceInfo : linkedList) {
            if (terraceInfo.mBuildingType != BuildingType.CORNER) continue;
            linkedList2.add(terraceInfo);
        }
        return linkedList2;
    }

    public LinkedList<TerraceInfo> findManyTantaiTerrace(TerracesInfo terracesInfo, LinkedList<TerraceInfo> linkedList) {
        LinkedList<TerraceInfo> linkedList2 = new LinkedList<TerraceInfo>();
        for (TerraceInfo terraceInfo : linkedList) {
            if (this.isRentou(terracesInfo, linkedList, terraceInfo)) continue;
            linkedList2.add(terraceInfo);
        }
        return linkedList2;
    }

    public boolean judgeCornerConnect(TerraceInfo terraceInfo, LinkedList<TerraceInfo> linkedList) {
        boolean bl = false;
        LinkedList<TerraceInfo> linkedList2 = this.findManyTerraceInfoByCorner(linkedList);
        for (TerraceInfo terraceInfo2 : linkedList2) {
            if (!terraceInfo.mId.equals(terraceInfo2.mId - 1) && !terraceInfo.mId.equals(terraceInfo2.mId + 1)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public TerraceWidthType calcTerraceWidthTypeByRoomType(List<TerraceInfo> list, RoomType roomType) {
        LinkedList<TerraceInfo> linkedList = this.findManyTerraceInfoByRoomType(list, roomType);
        float f = 0.0f;
        for (TerraceInfo terraceInfo : linkedList) {
            f += terraceInfo.mWidth.floatValue();
        }
        return TerraceWidthType.getByDetailValue(f);
    }

    public TerraceInfo findTerraceInfoByIndex(List<TerraceInfo> list, int n) {
        for (TerraceInfo terraceInfo : list) {
            if (terraceInfo.mId != n) continue;
            return terraceInfo;
        }
        return null;
    }

    public TerraceInfo findTerraceInfoByMaxWidthType(BasicInfo basicInfo, TerracesInfo terracesInfo, LinkedList<TerraceInfo> linkedList, boolean bl) {
        TerraceInfo terraceInfo = this.findMasterTerraceInfo(linkedList);
        TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(TerraceWidthType.T05, basicInfo.mKenType);
        Float f = Float.valueOf(0.0f);
        if (typeTerraceWidthInfo != null) {
            f = typeTerraceWidthInfo.length;
        }
        for (TerraceInfo terraceInfo2 : linkedList) {
            TypeTerraceWidthInfo typeTerraceWidthInfo2 = this.mTypeTerraceWidthCacheDao.findOneByType(terraceInfo2.mWidthType, basicInfo.mKenType);
            if (typeTerraceWidthInfo2 == null) continue;
            float f2 = typeTerraceWidthInfo2.length.floatValue();
            if (bl) {
                f2 += this.calcJizaiketaHanedashiLength(terracesInfo, terraceInfo2);
            }
            if (!(f.floatValue() < f2)) continue;
            f = Float.valueOf(f2);
            terraceInfo = terraceInfo2;
        }
        return terraceInfo;
    }

    public TerraceInfo findTerraceInfoByMaxWidthType(BasicInfo basicInfo, TerracesInfo terracesInfo, LinkedList<TerraceInfo> linkedList) {
        return this.findTerraceInfoByMaxWidthType(basicInfo, terracesInfo, linkedList, false);
    }

    public TerraceInfo findTerraceInfoByMaxDepthType(LinkedList<TerraceInfo> linkedList) {
        TerraceInfo terraceInfo = this.findMasterTerraceInfo(linkedList);
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneByType(TerraceDepthType.T2);
        Float f = Float.valueOf(0.0f);
        if (typeTerraceDepthInfo != null) {
            f = typeTerraceDepthInfo.length;
        }
        for (TerraceInfo terraceInfo2 : linkedList) {
            TypeTerraceDepthInfo typeTerraceDepthInfo2 = this.mTypeTerraceDepthCacheDao.findOneByType(terraceInfo2.mDepthType);
            if (typeTerraceDepthInfo2 == null || !(f.floatValue() < typeTerraceDepthInfo2.length.floatValue())) continue;
            f = typeTerraceDepthInfo2.length;
            terraceInfo = terraceInfo2;
        }
        return terraceInfo;
    }

    public int findMaxIndex(LinkedList<TerraceInfo> linkedList) {
        int n = Integer.MIN_VALUE;
        for (TerraceInfo terraceInfo : linkedList) {
            if (n >= terraceInfo.mId) continue;
            n = terraceInfo.mId;
        }
        return n;
    }

    public int findMinIndex(LinkedList<TerraceInfo> linkedList) {
        int n = Integer.MAX_VALUE;
        for (TerraceInfo terraceInfo : linkedList) {
            if (n <= terraceInfo.mId) continue;
            n = terraceInfo.mId;
        }
        return n;
    }

    public LinkedList<TerraceInfo> sortAscendingTerraceInfoListByTerraceId(LinkedList<TerraceInfo> linkedList) {
        Collections.sort(linkedList, new Comparator<TerraceInfo>(){

            @Override
            public int compare(TerraceInfo terraceInfo, TerraceInfo terraceInfo2) {
                if (terraceInfo.mId < terraceInfo2.mId) {
                    return 1;
                }
                if (terraceInfo.mId > terraceInfo2.mId) {
                    return -1;
                }
                return terraceInfo2.mId.compareTo(terraceInfo.mId);
            }
        });
        return linkedList;
    }

    public LinkedList<Integer> creatGroupIdList(LinkedList<TerraceInfo> linkedList) {
        LinkedList<Integer> linkedList2 = new LinkedList<Integer>();
        for (TerraceInfo terraceInfo : linkedList) {
            if (linkedList2.contains(terraceInfo.mGroupId)) continue;
            linkedList2.add(terraceInfo.mGroupId);
        }
        return linkedList2;
    }

    public int compare(TerraceWidthType terraceWidthType, TerraceWidthType terraceWidthType2, KenType kenType) {
        TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType, kenType);
        TypeTerraceWidthInfo typeTerraceWidthInfo2 = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType2, kenType);
        if (typeTerraceWidthInfo.length.floatValue() > typeTerraceWidthInfo2.length.floatValue()) {
            return 1;
        }
        if (typeTerraceWidthInfo.length.floatValue() < typeTerraceWidthInfo2.length.floatValue()) {
            return -1;
        }
        return 0;
    }

    public int compare(TerraceDepthType terraceDepthType, TerraceDepthType terraceDepthType2) {
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneByType(terraceDepthType);
        TypeTerraceDepthInfo typeTerraceDepthInfo2 = this.mTypeTerraceDepthCacheDao.findOneByType(terraceDepthType2);
        if (typeTerraceDepthInfo.length.floatValue() > typeTerraceDepthInfo2.length.floatValue()) {
            return 1;
        }
        if (typeTerraceDepthInfo.length.floatValue() < typeTerraceDepthInfo2.length.floatValue()) {
            return -1;
        }
        return 0;
    }

    public boolean isRentou(TerracesInfo terracesInfo, List<TerraceInfo> list, TerraceInfo terraceInfo, boolean bl) {
        boolean bl2 = false;
        if (list.size() <= 1) {
            return false;
        }
        LinkedList<TerraceInfo> linkedList = new LinkedList<TerraceInfo>();
        for (TerraceInfo terraceInfo2 : list) {
            if (!terraceInfo.mGroupId.equals(terraceInfo2.mGroupId)) continue;
            linkedList.add(terraceInfo2);
        }
        int n = this.findMaxIndex(linkedList);
        int n2 = this.findMinIndex(linkedList);
        EnforcementType enforcementType = terracesInfo.mEnforcementType;
        if (enforcementType == EnforcementType.MAEWAKU_DEHABA_CHIGAI || bl) {
            if (linkedList.size() <= 1) {
                return false;
            }
            bl2 = terraceInfo.mGroupId <= 0 ? terraceInfo.mId != n : terraceInfo.mId != n2;
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.DESUMI, EnforcementType.IRISUMI)) {
            if (terracesInfo.mDepthType.mDbId > TerraceDepthType.T6.mDbId) {
                bl2 = terraceInfo.mIsStarting == false;
            } else if (enforcementType == EnforcementType.DESUMI) {
                bl2 = terraceInfo.mGroupId != 0 || terraceInfo.mIsStarting == false;
            } else if (enforcementType == EnforcementType.IRISUMI) {
                bl2 = this.isStartingWidthType(list, TerraceWidthType.T25) ? terraceInfo.mWidthType != TerraceWidthType.T25 || terraceInfo.mIsStarting == false || terraceInfo.mBuildingType == BuildingType.CORNER : terraceInfo.mGroupId != 0 || terraceInfo.mIsStarting == false;
            }
        } else {
            bl2 = terraceInfo.mIsMaster == false;
        }
        return bl2;
    }

    public boolean isRentou(TerracesInfo terracesInfo, List<TerraceInfo> list, TerraceInfo terraceInfo) {
        return this.isRentou(terracesInfo, list, terraceInfo, false);
    }

    public boolean isStartingWidthType(List<TerraceInfo> list, TerraceWidthType terraceWidthType) {
        for (TerraceInfo terraceInfo : list) {
            if (!terraceInfo.mIsStarting.booleanValue() || terraceInfo.mWidthType != terraceWidthType) continue;
            return true;
        }
        return false;
    }

    public boolean isRentou(LinkedList<TerraceInfo> linkedList) {
        return linkedList.size() > 1 && !this.isGardenRoomPlus(linkedList);
    }

    public boolean isGardenRoomPlus(LinkedList<TerraceInfo> linkedList) {
        RoomType roomType = null;
        if (linkedList.size() > 1) {
            for (TerraceInfo terraceInfo : linkedList) {
                if (roomType == null) {
                    roomType = terraceInfo.mRoomType;
                    continue;
                }
                if (roomType == terraceInfo.mRoomType) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isKoshikabeL(TerraceInfo terraceInfo, BasicInfo basicInfo, boolean bl) {
        boolean bl2 = false;
        return bl2;
    }

    public boolean hasRoomTypes(List<TerraceInfo> list, RoomType ... roomTypeArray) {
        boolean[] blArray = new boolean[roomTypeArray.length];
        int n = 0;
        while (n < blArray.length) {
            blArray[n] = false;
            ++n;
        }
        n = 0;
        while (n < roomTypeArray.length) {
            if (this.hasRoomType(list, roomTypeArray[n])) {
                blArray[n] = true;
            }
            ++n;
        }
        n = 1;
        int n2 = 0;
        while (n2 < blArray.length) {
            n &= blArray[n2];
            ++n2;
        }
        return n != 0;
    }

    public boolean hasRoomType(List<TerraceInfo> list, RoomType roomType) {
        for (TerraceInfo terraceInfo : list) {
            if (terraceInfo.mRoomType != roomType) continue;
            return true;
        }
        return false;
    }

    public TerraceInfo findLeftTerrace(LinkedList<TerraceInfo> linkedList, RoomType roomType) {
        TerraceInfo terraceInfo = null;
        for (TerraceInfo terraceInfo2 : linkedList) {
            if (terraceInfo2.mRoomType != roomType || terraceInfo != null && terraceInfo2.mId >= terraceInfo.mId) continue;
            terraceInfo = terraceInfo2;
        }
        return terraceInfo;
    }

    public TerraceInfo findRightTerrace(LinkedList<TerraceInfo> linkedList, RoomType roomType) {
        TerraceInfo terraceInfo = null;
        for (TerraceInfo terraceInfo2 : linkedList) {
            if (terraceInfo2.mRoomType != roomType || terraceInfo != null && terraceInfo2.mId <= terraceInfo.mId) continue;
            terraceInfo = terraceInfo2;
        }
        return terraceInfo;
    }

    public TerraceInfo findLeftEdgeTerrace(LinkedList<TerraceInfo> linkedList) {
        for (TerraceInfo terraceInfo : linkedList) {
            if (!terraceInfo.mIsLeftEnd.booleanValue()) continue;
            return terraceInfo;
        }
        return null;
    }

    public TerraceInfo findRightEdgeTerrace(LinkedList<TerraceInfo> linkedList) {
        for (TerraceInfo terraceInfo : linkedList) {
            if (!terraceInfo.mIsRightEnd.booleanValue()) continue;
            return terraceInfo;
        }
        return null;
    }

    public TerraceDepthType judgeLeftOptionDepthType(TerracesInfo terracesInfo, TerraceInfo terraceInfo) {
        float f = terraceInfo.mLeftDepth.floatValue();
        if (terracesInfo.mEnforcementType == EnforcementType.BUBUN_IRISUMI && terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
            f -= 50.0f;
        }
        for (TerraceDepthType terraceDepthType : TerraceDepthTypeFactory.getInstance().values()) {
            TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneById(terraceDepthType.id());
            if (f != typeTerraceDepthInfo.length.floatValue()) continue;
            return terraceDepthType;
        }
        return null;
    }

    public TerraceDepthType judgeRightOptionDepthType(TerracesInfo terracesInfo, TerraceInfo terraceInfo) {
        float f = terraceInfo.mRightDepth.floatValue();
        if (terracesInfo.mEnforcementType == EnforcementType.BUBUN_IRISUMI && terracesInfo.mEnforcementDirType == EnforcementDirType.R) {
            f -= 50.0f;
        }
        for (TerraceDepthType terraceDepthType : TerraceDepthTypeFactory.getInstance().values()) {
            TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneById(terraceDepthType.id());
            if (f != typeTerraceDepthInfo.length.floatValue()) continue;
            return terraceDepthType;
        }
        return null;
    }

    public boolean existTerraceWidthType(List<TerraceInfo> list, TerraceWidthType terraceWidthType) {
        for (TerraceInfo terraceInfo : list) {
            if (terraceInfo.mWidthType != terraceWidthType) continue;
            return true;
        }
        return false;
    }

    public float calcLeftDepthGap(EnforcementType enforcementType, EnforcementDirType enforcementDirType, TerracesInfo terracesInfo) {
        float f = 0.0f;
        if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.KUTAI_DEHABA_CHIGAI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.L)) {
            f = terracesInfo.mDepthGap == null ? 0.0f : terracesInfo.mDepthGap.floatValue();
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.BUBUN_IRISUMI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.L)) {
            f = terracesInfo.mPartialDepth == null ? 0.0f : terracesInfo.mPartialDepth.floatValue();
            f += 50.0f;
        }
        return f;
    }

    public float calcRightDepthGap(EnforcementType enforcementType, EnforcementDirType enforcementDirType, TerracesInfo terracesInfo) {
        float f = 0.0f;
        if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.KUTAI_DEHABA_CHIGAI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.R)) {
            f = terracesInfo.mDepthGap == null ? 0.0f : terracesInfo.mDepthGap.floatValue();
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.BUBUN_IRISUMI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.R)) {
            f = terracesInfo.mPartialDepth == null ? 0.0f : terracesInfo.mPartialDepth.floatValue();
            f += 50.0f;
        }
        return f;
    }

    public boolean isKoshikabeBorderSpan(List<TerraceInfo> list, TerraceInfo terraceInfo, Integer n) {
        return false;
    }

    public boolean isOnlyLeftEdgeTerraceKoshikabe(LinkedList<TerraceInfo> linkedList) {
        return false;
    }

    public boolean isOnlyRightEdgeTerraceKoshikabe(LinkedList<TerraceInfo> linkedList) {
        return false;
    }

    public float calcLeftTotalWidth(LinkedList<TerraceInfo> linkedList) {
        TerraceInfo terraceInfo = this.findMasterTerraceInfo(linkedList);
        float f = terraceInfo.mLeftWidth.floatValue();
        for (TerraceInfo terraceInfo2 : linkedList) {
            if (terraceInfo2.mId >= 0) continue;
            f += terraceInfo2.mWidth.floatValue();
        }
        return f;
    }

    public float calcRightTotalWidth(LinkedList<TerraceInfo> linkedList) {
        TerraceInfo terraceInfo = this.findMasterTerraceInfo(linkedList);
        float f = terraceInfo.mRightWidth.floatValue();
        for (TerraceInfo terraceInfo2 : linkedList) {
            if (terraceInfo2.mId <= 0) continue;
            f += terraceInfo2.mWidth.floatValue();
        }
        return f;
    }

    public float calcJizaiketaHanedashiLength(TerracesInfo terracesInfo, TerraceInfo terraceInfo) {
        float f = 0.0f;
        if (terracesInfo.mEnforcementType != EnforcementType.JIZAIKETA_HANEDASHI) {
            return f;
        }
        if (terraceInfo.mIsLeftEnd.booleanValue()) {
            f += terracesInfo.mLeftJizaiKetaLen.floatValue();
        }
        if (terraceInfo.mIsRightEnd.booleanValue()) {
            f += terracesInfo.mRightJizaiKetaLen.floatValue();
        }
        return f;
    }

    public TerraceWidthType calcJizaiKetaWidthTypeByJizaiKetaHanedashi(BasicInfo basicInfo, TerracesInfo terracesInfo, TerraceInfo terraceInfo) {
        float f = terraceInfo.mWidth.floatValue();
        return TerraceWidthTypeDxo.convert(f += this.calcJizaiketaHanedashiLength(terracesInfo, terraceInfo), basicInfo.mKenType);
    }

    public TerraceInfo findCornerLeftTerraceInfo(LinkedList<TerraceInfo> linkedList, TerracesInfo terracesInfo) {
        TerraceInfo terraceInfo = null;
        if (!this.mEnforcementCommonService.hasDeirisumi(terracesInfo)) {
            return terraceInfo;
        }
        LinkedList<TerraceInfo> linkedList2 = this.findManyTerraceInfoByCorner(linkedList);
        for (TerraceInfo terraceInfo2 : linkedList2) {
            terraceInfo = this.findTerraceInfoByIndex(linkedList, terraceInfo2.mId - 1);
        }
        return terraceInfo;
    }

    public TerraceInfo findCornerRightTerraceInfo(LinkedList<TerraceInfo> linkedList, TerracesInfo terracesInfo) {
        TerraceInfo terraceInfo = null;
        if (!this.mEnforcementCommonService.hasDeirisumi(terracesInfo)) {
            return terraceInfo;
        }
        LinkedList<TerraceInfo> linkedList2 = this.findManyTerraceInfoByCorner(linkedList);
        for (TerraceInfo terraceInfo2 : linkedList2) {
            terraceInfo = this.findTerraceInfoByIndex(linkedList, terraceInfo2.mId + 1);
        }
        return terraceInfo;
    }

    public LinkedList<TerraceInfo> findCornerConnectTerraceInfoList(LinkedList<TerraceInfo> linkedList) {
        LinkedList<TerraceInfo> linkedList2 = new LinkedList<TerraceInfo>();
        for (TerraceInfo terraceInfo : linkedList) {
            if (!this.judgeCornerConnect(terraceInfo, linkedList)) continue;
            linkedList2.add(terraceInfo);
        }
        return linkedList2;
    }
}

