/*
 * Decompiled with CFR 0.152.
 */
package option.speene.common.service.parts;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import option.gad.core.inject.GdInject;
import option.gad.core.inject.GdInjector;
import option.gad.core.util.EnumUtil;
import option.speene.common.dao.cache.spec.SpecOpeningOptionCacheDao;
import option.speene.common.entity.BasicInfo;
import option.speene.common.entity.SPNEntities;
import option.speene.common.entity.SidePanelOptionInfo;
import option.speene.common.entity.TerraceInfo;
import option.speene.common.entity.TerracesInfo;
import option.speene.common.entity.paneloption.SideScreenInfo;
import option.speene.common.entity.spec.SpecOpeningOptionInfo;
import option.speene.common.type.DirectionType;
import option.speene.common.type.PanelDirectionType;
import option.speene.common.type.paneloption.SidePanelOptionType;

public class SidePanelOptionCommonService {
    @GdInject
    protected SpecOpeningOptionCacheDao mSpecOpeningOptionCacheDao;

    public SidePanelOptionCommonService() {
        GdInjector.getInstance().inject((Object)this);
    }

    public LinkedList<SidePanelOptionInfo> getPanelInfoList(SPNEntities sPNEntities, PanelDirectionType panelDirectionType) {
        LinkedList<SidePanelOptionInfo> linkedList = null;
        if (panelDirectionType == PanelDirectionType.LEFT) {
            linkedList = sPNEntities.mLeftPanelOptionInfoList;
        } else if (panelDirectionType == PanelDirectionType.RIGHT) {
            linkedList = sPNEntities.mRightPanelOptionInfoList;
        }
        return linkedList;
    }

    public boolean hasSidePanelOptionType(SPNEntities sPNEntities, DirectionType directionType, SidePanelOptionType sidePanelOptionType) {
        LinkedList<SidePanelOptionInfo> linkedList = directionType == DirectionType.LEFT ? sPNEntities.mLeftPanelOptionInfoList : sPNEntities.mRightPanelOptionInfoList;
        return this.hasSidePanelOptionType(linkedList, sidePanelOptionType);
    }

    public boolean hasSidePanelOptionType(List<SidePanelOptionInfo> list, SidePanelOptionType sidePanelOptionType) {
        for (SidePanelOptionInfo sidePanelOptionInfo : list) {
            if (sidePanelOptionInfo.mPanelOptionType != sidePanelOptionType) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean hasAmido(List<SidePanelOptionInfo> list) {
        boolean bl = false;
        bl |= this.hasSidePanelOptionType(list, SidePanelOptionType.AMIDO);
        bl |= this.hasSidePanelOptionType(list, SidePanelOptionType.SHUNO_AMIDO_RAIL);
        return bl |= this.hasSidePanelOptionType(list, SidePanelOptionType.SHUNO_AMIDO_UNIT);
    }

    public boolean hasRanmaFusagiZai(LinkedList<SidePanelOptionInfo> linkedList, SidePanelOptionType sidePanelOptionType) {
        LinkedList<SidePanelOptionInfo> linkedList2 = this.findManyOptionInfoByTypes(linkedList, sidePanelOptionType);
        for (SidePanelOptionInfo sidePanelOptionInfo : linkedList2) {
            if (!(sidePanelOptionInfo instanceof SideScreenInfo)) continue;
            SideScreenInfo sideScreenInfo = (SideScreenInfo)sidePanelOptionInfo;
            if (!sideScreenInfo.mHasRanmaFusagiZai.booleanValue()) continue;
            return true;
        }
        return false;
    }

    public List<SidePanelOptionInfo> packAllSidePanelOption(List<SidePanelOptionInfo> list, List<SidePanelOptionInfo> list2) {
        LinkedList<SidePanelOptionInfo> linkedList = new LinkedList<SidePanelOptionInfo>();
        linkedList.addAll(list);
        linkedList.addAll(list2);
        return linkedList;
    }

    public SidePanelOptionInfo findOneSidePanelOptionByIndex(List<SidePanelOptionInfo> list, int n) {
        for (SidePanelOptionInfo sidePanelOptionInfo : list) {
            if (!sidePanelOptionInfo.mIndex.equals(n)) continue;
            return sidePanelOptionInfo;
        }
        return null;
    }

    @Deprecated
    public LinkedList<SidePanelOptionInfo> findManySidePanelOptionByType(List<SidePanelOptionInfo> list, SidePanelOptionType ... sidePanelOptionTypeArray) {
        LinkedList<SidePanelOptionInfo> linkedList = new LinkedList<SidePanelOptionInfo>();
        for (SidePanelOptionInfo sidePanelOptionInfo : list) {
            if (!EnumUtil.matchOR((Enum)((Enum)((Object)sidePanelOptionInfo.mPanelOptionType)), (Enum[])sidePanelOptionTypeArray)) continue;
            linkedList.add(sidePanelOptionInfo);
        }
        return linkedList;
    }

    public LinkedList<SidePanelOptionInfo> findManyOptionInfoByTypes(LinkedList<SidePanelOptionInfo> linkedList, SidePanelOptionType ... sidePanelOptionTypeArray) {
        LinkedList<SidePanelOptionInfo> linkedList2 = new LinkedList<SidePanelOptionInfo>();
        for (SidePanelOptionInfo sidePanelOptionInfo : linkedList) {
            if (!EnumUtil.matchOR((Enum)((Enum)((Object)sidePanelOptionInfo.mPanelOptionType)), (Enum[])sidePanelOptionTypeArray)) continue;
            linkedList2.add(sidePanelOptionInfo);
        }
        return linkedList2;
    }

    public LinkedList<SidePanelOptionInfo> findManySimilarSidePanelOptionByOptionInfo(List<SidePanelOptionInfo> list, List<SidePanelOptionType> list2, SidePanelOptionInfo sidePanelOptionInfo) {
        LinkedList<SidePanelOptionInfo> linkedList = new LinkedList<SidePanelOptionInfo>();
        for (SidePanelOptionInfo sidePanelOptionInfo2 : list) {
            if (!sidePanelOptionInfo2.mIndex.equals(sidePanelOptionInfo.mIndex)) continue;
            if (sidePanelOptionInfo2.mPanelOptionType == sidePanelOptionInfo.mPanelOptionType) {
                linkedList.add(sidePanelOptionInfo2);
            }
            for (SidePanelOptionType sidePanelOptionType : list2) {
                if (sidePanelOptionInfo2.mPanelOptionType != sidePanelOptionType) continue;
                linkedList.add(sidePanelOptionInfo2);
            }
        }
        return linkedList;
    }

    public void removeAll(LinkedList<SidePanelOptionInfo> linkedList, SidePanelOptionType sidePanelOptionType) {
        ArrayList<SidePanelOptionInfo> arrayList = new ArrayList<SidePanelOptionInfo>();
        for (SidePanelOptionInfo sidePanelOptionInfo : linkedList) {
            if (sidePanelOptionInfo.mPanelOptionType != sidePanelOptionType) continue;
            arrayList.add(sidePanelOptionInfo);
        }
        linkedList.removeAll(arrayList);
    }

    public void removeSideRanmaPanel(SPNEntities sPNEntities) {
        this.removeAll(sPNEntities.mLeftPanelOptionInfoList, SidePanelOptionType.SIDE_RANMA_PANEL);
        this.removeAll(sPNEntities.mRightPanelOptionInfoList, SidePanelOptionType.SIDE_RANMA_PANEL);
        this.removeAllRanmaFusagiZai(sPNEntities.mLeftPanelOptionInfoList);
        this.removeAllRanmaFusagiZai(sPNEntities.mRightPanelOptionInfoList);
    }

    private void removeAllRanmaFusagiZai(LinkedList<SidePanelOptionInfo> linkedList) {
        for (SidePanelOptionInfo sidePanelOptionInfo : linkedList) {
            if (sidePanelOptionInfo.mPanelOptionType != SidePanelOptionType.SIDE_SCREEN_ONE_STEP && sidePanelOptionInfo.mPanelOptionType != SidePanelOptionType.SIDE_SCREEN_TWO_STEP) continue;
            SideScreenInfo sideScreenInfo = (SideScreenInfo)sidePanelOptionInfo;
            sideScreenInfo.mHasRanmaFusagiZai = false;
        }
    }

    public boolean isSideOptionPerm(SPNEntities sPNEntities, SidePanelOptionType sidePanelOptionType) {
        LinkedList<TerraceInfo> linkedList = sPNEntities.mTerraceInfoList;
        boolean bl = false;
        bl |= this.isSideOptionPerm(sPNEntities, linkedList.getFirst(), sidePanelOptionType, DirectionType.LEFT);
        return bl |= this.isSideOptionPerm(sPNEntities, linkedList.getLast(), sidePanelOptionType, DirectionType.RIGHT);
    }

    public boolean isSideOptionPerm(SPNEntities sPNEntities, TerraceInfo terraceInfo, SidePanelOptionType sidePanelOptionType, DirectionType directionType) {
        BasicInfo basicInfo = sPNEntities.mBasicInfo;
        TerracesInfo terracesInfo = sPNEntities.mTerracesInfo;
        SpecOpeningOptionInfo specOpeningOptionInfo = this.mSpecOpeningOptionCacheDao.findOneByTypes(sidePanelOptionType, basicInfo, terracesInfo, terraceInfo, directionType);
        return specOpeningOptionInfo != null && specOpeningOptionInfo.permission.equals("1");
    }

    public boolean isRanmaFusagiZaiPerm(SPNEntities sPNEntities, TerraceInfo terraceInfo, SidePanelOptionType sidePanelOptionType, DirectionType directionType) {
        SidePanelOptionType sidePanelOptionType2 = null;
        sidePanelOptionType2 = sidePanelOptionType == SidePanelOptionType.SIDE_SCREEN_ONE_STEP ? SidePanelOptionType.RANMA_FUSAGI_ZAI_ONE_STEP : (sidePanelOptionType == SidePanelOptionType.SIDE_SCREEN_TWO_STEP ? SidePanelOptionType.RANMA_FUSAGI_ZAI_TWO_STEP : sidePanelOptionType);
        return this.isSideOptionPerm(sPNEntities, terraceInfo, sidePanelOptionType2, directionType);
    }

    public LinkedList<SidePanelOptionInfo> packSidePanelOptionInfoList(SPNEntities sPNEntities) {
        LinkedList<SidePanelOptionInfo> linkedList = new LinkedList<SidePanelOptionInfo>();
        linkedList.addAll(sPNEntities.mLeftPanelOptionInfoList);
        linkedList.addAll(sPNEntities.mRightPanelOptionInfoList);
        return linkedList;
    }
}

