/*
 * Decompiled with CFR 0.152.
 */
package option.speene.common.service.parts;

import com.kt.annotation.Reflectable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import option.gad.core.inject.GdInject;
import option.speene.common.entity.FrontPanelOptionInfo;
import option.speene.common.entity.SPNEntities;
import option.speene.common.entity.SidePanelInfo;
import option.speene.common.entity.SidePanelOptionInfo;
import option.speene.common.entity.TerracesInfo;
import option.speene.common.entity.paneloption.ShunoAmidoUnitInfo;
import option.speene.common.service.parts.SidePanelCommonService;
import option.speene.common.type.PanelDirectionType;
import option.speene.common.type.SidePanelType;
import option.speene.common.type.TsurimotoDirectionType;
import option.speene.common.type.paneloption.FrontPanelOptionType;
import option.speene.common.type.paneloption.SidePanelOptionType;

@Reflectable
public class PanelOptionCommonService {
    @GdInject
    private SidePanelCommonService mSidePanelService;

    public void clearAllPanelOptions(SPNEntities sPNEntities) {
        sPNEntities.mFrontPanelOptionInfoList.clear();
        sPNEntities.mLeftPanelOptionInfoList.clear();
        sPNEntities.mRightPanelOptionInfoList.clear();
    }

    public LinkedList<ShunoAmidoUnitInfo> getUnitList(List<SidePanelOptionInfo> list, SidePanelOptionType sidePanelOptionType) {
        LinkedList<ShunoAmidoUnitInfo> linkedList = new LinkedList<ShunoAmidoUnitInfo>();
        for (SidePanelOptionInfo sidePanelOptionInfo : list) {
            if (!(sidePanelOptionInfo instanceof ShunoAmidoUnitInfo) || !sidePanelOptionType.equals(sidePanelOptionInfo.mPanelOptionType)) continue;
            linkedList.add((ShunoAmidoUnitInfo)sidePanelOptionInfo);
        }
        return linkedList;
    }

    public int getUnitCount(LinkedList<ShunoAmidoUnitInfo> linkedList, TsurimotoDirectionType tsurimotoDirectionType) {
        if (tsurimotoDirectionType == null) {
            return 0;
        }
        int n = 0;
        for (ShunoAmidoUnitInfo shunoAmidoUnitInfo : linkedList) {
            if (!tsurimotoDirectionType.equals(shunoAmidoUnitInfo.mTsurimotoDirectionType)) continue;
            ++n;
        }
        return n;
    }

    public boolean hasSidePanelOption(SidePanelOptionType sidePanelOptionType, LinkedList<SidePanelOptionInfo> linkedList) {
        for (SidePanelOptionInfo sidePanelOptionInfo : linkedList) {
            if (sidePanelOptionInfo.mPanelOptionType != sidePanelOptionType) continue;
            return true;
        }
        return false;
    }

    public void removeSidePanelOptions(List<SidePanelOptionInfo> list, SidePanelOptionType ... sidePanelOptionTypeArray) {
        if (list == null) {
            return;
        }
        if (sidePanelOptionTypeArray == null) {
            return;
        }
        ArrayList<SidePanelOptionInfo> arrayList = new ArrayList<SidePanelOptionInfo>();
        for (SidePanelOptionInfo sidePanelOptionInfo : list) {
            SidePanelOptionType[] sidePanelOptionTypeArray2 = sidePanelOptionTypeArray;
            int n = sidePanelOptionTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                SidePanelOptionType sidePanelOptionType = sidePanelOptionTypeArray2[n2];
                if (sidePanelOptionInfo.mPanelOptionType == sidePanelOptionType) {
                    arrayList.add(sidePanelOptionInfo);
                }
                ++n2;
            }
        }
        list.removeAll(arrayList);
    }

    public int countAmidoUnitNum(List<SidePanelOptionInfo> list, PanelDirectionType panelDirectionType, TsurimotoDirectionType tsurimotoDirectionType) {
        LinkedList<ShunoAmidoUnitInfo> linkedList = this.getUnitList(list, SidePanelOptionType.SHUNO_AMIDO_UNIT);
        return this.getUnitCount(linkedList, tsurimotoDirectionType);
    }

    public LinkedList<ShunoAmidoUnitInfo> getUnitList(List<SidePanelOptionInfo> list) {
        return this.getUnitList(list, SidePanelOptionType.SHUNO_AMIDO_UNIT);
    }

    public List<SidePanelOptionInfo> findManyPanelOptionByType(LinkedList<SidePanelOptionInfo> linkedList, List<SidePanelOptionType> list) {
        ArrayList<SidePanelOptionInfo> arrayList = new ArrayList<SidePanelOptionInfo>();
        for (SidePanelOptionInfo sidePanelOptionInfo : linkedList) {
            if (!list.contains(sidePanelOptionInfo.mPanelOptionType)) continue;
            arrayList.add(sidePanelOptionInfo);
        }
        return arrayList;
    }

    public float calcShunoAmidoFront(TerracesInfo terracesInfo) {
        float f = 103.0f;
        float f2 = 62.5f;
        float f3 = 8.1f;
        return terracesInfo.mDepth.floatValue() - f - f2 - f3;
    }

    public float calcShunoAmidoDepth(LinkedList<SidePanelInfo> linkedList) {
        float f = this.mSidePanelService.calcPanelDepth(linkedList, SidePanelType.ORIDO, SidePanelType.ORIDO_ADJUSTMENT_FIX);
        float f2 = 11.0f;
        float f3 = 41.1f;
        float f4 = 8.1f;
        return f + f2 + f3 - f4;
    }

    public List<FrontPanelOptionInfo> findManyFrontPanelOptions(LinkedList<FrontPanelOptionInfo> linkedList, FrontPanelOptionType ... frontPanelOptionTypeArray) {
        ArrayList<FrontPanelOptionInfo> arrayList = new ArrayList<FrontPanelOptionInfo>();
        block0: for (FrontPanelOptionInfo frontPanelOptionInfo : linkedList) {
            FrontPanelOptionType[] frontPanelOptionTypeArray2 = frontPanelOptionTypeArray;
            int n = frontPanelOptionTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                FrontPanelOptionType frontPanelOptionType = frontPanelOptionTypeArray2[n2];
                if (frontPanelOptionInfo.mPanelOptionType == frontPanelOptionType) {
                    arrayList.add(frontPanelOptionInfo);
                    continue block0;
                }
                ++n2;
            }
        }
        return arrayList;
    }

    public FrontPanelOptionInfo findFrontPanelOptionInfoByTerraceIndex(LinkedList<FrontPanelOptionInfo> linkedList, Integer n, FrontPanelOptionType ... frontPanelOptionTypeArray) {
        for (FrontPanelOptionInfo frontPanelOptionInfo : linkedList) {
            FrontPanelOptionType[] frontPanelOptionTypeArray2 = frontPanelOptionTypeArray;
            int n2 = frontPanelOptionTypeArray.length;
            int n3 = 0;
            while (n3 < n2) {
                FrontPanelOptionType frontPanelOptionType = frontPanelOptionTypeArray2[n3];
                if (frontPanelOptionInfo.mTerraceId == n && frontPanelOptionInfo.mPanelOptionType == frontPanelOptionType) {
                    return frontPanelOptionInfo;
                }
                ++n3;
            }
        }
        return null;
    }

    public boolean hasFrontPanelOptionsByTerraceIndex(LinkedList<FrontPanelOptionInfo> linkedList, Integer n, FrontPanelOptionType ... frontPanelOptionTypeArray) {
        for (FrontPanelOptionInfo frontPanelOptionInfo : linkedList) {
            FrontPanelOptionType[] frontPanelOptionTypeArray2 = frontPanelOptionTypeArray;
            int n2 = frontPanelOptionTypeArray.length;
            int n3 = 0;
            while (n3 < n2) {
                FrontPanelOptionType frontPanelOptionType = frontPanelOptionTypeArray2[n3];
                if (frontPanelOptionInfo.mTerraceId == n && frontPanelOptionInfo.mPanelOptionType == frontPanelOptionType) {
                    return true;
                }
                ++n3;
            }
        }
        return false;
    }

    public boolean hasFrontPanelOption(FrontPanelOptionType frontPanelOptionType, LinkedList<FrontPanelOptionInfo> linkedList) {
        for (FrontPanelOptionInfo frontPanelOptionInfo : linkedList) {
            if (frontPanelOptionInfo.mPanelOptionType != frontPanelOptionType) continue;
            return true;
        }
        return false;
    }
}

