/*
 * Decompiled with CFR 0.152.
 */
package option.speene.common.service.parts;

import com.kt.annotation.Reflectable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import option.gad.core.inject.GdInject;
import option.gad.core.util.GdMutableTypeUtil;
import option.speene.common.dao.cache.spec.SpecBuildingSizeComboCacheDao;
import option.speene.common.dao.cache.spec.SpecHanedashiSizeCacheDao;
import option.speene.common.entity.BasicInfo;
import option.speene.common.entity.SPNEntities;
import option.speene.common.entity.TerraceInfo;
import option.speene.common.entity.TerracesInfo;
import option.speene.common.entity.spec.SpecBuildingSizeComboInfo;
import option.speene.common.entity.spec.SpecHanedashiSizeInfo;
import option.speene.common.service.parts.TerraceCommonService;
import option.speene.common.type.BuildingType;
import option.speene.common.type.EnforcementDirType;
import option.speene.common.type.EnforcementType;
import option.speene.common.type.TerraceDepthType;
import option.speene.common.type.TerraceWidthType;

@Reflectable
public class MultiSpanCommonService {
    private static final float MAX_TOTAL_JIZAIKETA_LEN = 2200.0f;
    @GdInject
    protected TerraceCommonService mTerraceCommonService;
    @GdInject
    protected SpecBuildingSizeComboCacheDao mSpecBuildingSizeComboCacheDao;
    @GdInject
    protected SpecHanedashiSizeCacheDao mSpecHanedashiSizeCacheDao;

    public boolean judgeCombo(SPNEntities sPNEntities) {
        BasicInfo basicInfo = sPNEntities.mBasicInfo;
        TerracesInfo terracesInfo = sPNEntities.mTerracesInfo;
        LinkedList<TerraceInfo> linkedList = sPNEntities.mTerraceInfoList;
        for (TerraceInfo terraceInfo : linkedList) {
            if (terraceInfo.mBuildingType == BuildingType.CORNER) continue;
            boolean bl = false;
            Collection<SpecBuildingSizeComboInfo> collection = this.mSpecBuildingSizeComboCacheDao.findManyByTypes(basicInfo, terracesInfo, terraceInfo, linkedList);
            for (SpecBuildingSizeComboInfo specBuildingSizeComboInfo : collection) {
                if (specBuildingSizeComboInfo == null || specBuildingSizeComboInfo.permission.equals("0")) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public boolean hasAdditional(List<TerraceInfo> list) {
        boolean bl = false;
        for (TerraceInfo terraceInfo : list) {
            if (terraceInfo.mIsStarting.booleanValue()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean possibleMultiSpanByBuildingSize(SPNEntities sPNEntities) {
        return this.possibleMultiSpanByBuildingSize(sPNEntities.mBasicInfo, sPNEntities.mTerracesInfo, sPNEntities.mTerraceInfoList);
    }

    public boolean possibleMultiSpanByBuildingSize(BasicInfo basicInfo, TerracesInfo terracesInfo, LinkedList<TerraceInfo> linkedList) {
        boolean bl = false;
        bl = GdMutableTypeUtil.matchOR(terracesInfo.mEnforcementType, EnforcementType.JIZAIKETA_HANEDASHI) ? this.possibleMultiSpanByBuildingSizeByMaster(basicInfo, terracesInfo, linkedList) : this.possibleMultiSpanByBuildingSize(basicInfo, terracesInfo);
        return bl;
    }

    private boolean possibleMultiSpanByBuildingSize(BasicInfo basicInfo, TerracesInfo terracesInfo) {
        Collection<SpecBuildingSizeComboInfo> collection = this.mSpecBuildingSizeComboCacheDao.findManyByTypes(basicInfo.mProductSeriesType, basicInfo.mProductType, basicInfo.mSubProductType, basicInfo.mRoofFigureType, terracesInfo.mEnforcementType, terracesInfo.mEnforcementDirType, basicInfo.mStrengthType, basicInfo.mFloorNum, basicInfo.mKetaType, basicInfo.mRoofToritsukeType, null, null, null, basicInfo.mKenType, false, null);
        return !collection.isEmpty();
    }

    private boolean possibleMultiSpanByBuildingSizeByMaster(BasicInfo basicInfo, TerracesInfo terracesInfo, LinkedList<TerraceInfo> linkedList) {
        TerraceInfo terraceInfo = this.mTerraceCommonService.findMasterTerraceInfo(linkedList);
        Collection<SpecBuildingSizeComboInfo> collection = this.mSpecBuildingSizeComboCacheDao.findManyByTypes(basicInfo, terracesInfo, linkedList, terraceInfo.mDepthType, terraceInfo.mWidthType, null, true, true);
        return !collection.isEmpty();
    }

    public boolean possibleMultiSpanByHanedashiSize(SPNEntities sPNEntities, Boolean bl, Boolean bl2) {
        return this.possibleMultiSpanByHanedashiSize(sPNEntities.mBasicInfo, sPNEntities.mTerracesInfo, sPNEntities.mTerraceInfoList, bl, bl2);
    }

    public boolean possibleMultiSpanByHanedashiSize(BasicInfo basicInfo, TerracesInfo terracesInfo, LinkedList<TerraceInfo> linkedList, Boolean bl, Boolean bl2) {
        TerraceWidthType terraceWidthType = null;
        if (bl.booleanValue() && terracesInfo.mEnforcementDirType == EnforcementDirType.BOTH) {
            TerraceInfo terraceInfo = linkedList.getFirst();
            TerraceInfo terraceInfo2 = linkedList.getLast();
            if (terraceInfo.mIsMaster.booleanValue()) {
                terraceWidthType = terraceInfo.mWidthType;
            } else if (terraceInfo2.mIsMaster.booleanValue()) {
                terraceWidthType = terraceInfo2.mWidthType;
            }
        } else {
            TerraceInfo terraceInfo = this.mTerraceCommonService.findMasterTerraceInfo(linkedList);
            terraceWidthType = terraceInfo.mWidthType;
        }
        return this.possibleMultiSpanByHanedashiSize(basicInfo, terracesInfo, linkedList, terracesInfo.mDepthType, terraceWidthType, null, bl, bl2);
    }

    public boolean possibleMultiSpanByHanedashiSize(BasicInfo basicInfo, TerracesInfo terracesInfo, LinkedList<TerraceInfo> linkedList, TerraceDepthType terraceDepthType, TerraceWidthType terraceWidthType, TerraceWidthType terraceWidthType2, Boolean bl, Boolean bl2) {
        if (terracesInfo.mEnforcementType != EnforcementType.JIZAIKETA_HANEDASHI) {
            return true;
        }
        if (!bl.booleanValue()) {
            return true;
        }
        Collection<SpecHanedashiSizeInfo> collection = this.mSpecHanedashiSizeCacheDao.findManyByTypes(basicInfo, terracesInfo, linkedList, terraceDepthType, terraceWidthType, terraceWidthType2, bl);
        boolean bl3 = false;
        for (SpecHanedashiSizeInfo specHanedashiSizeInfo : collection) {
            float f;
            if (terracesInfo.mEnforcementDirType == EnforcementDirType.L ? terracesInfo.mLeftJizaiKetaLen.floatValue() > (float)specHanedashiSizeInfo.maxHanedashiSize.intValue() : (terracesInfo.mEnforcementDirType == EnforcementDirType.R ? terracesInfo.mRightJizaiKetaLen.floatValue() > (float)specHanedashiSizeInfo.maxHanedashiSize.intValue() : terracesInfo.mEnforcementDirType == EnforcementDirType.BOTH && ((f = terracesInfo.mLeftJizaiKetaLen.floatValue() + terracesInfo.mRightJizaiKetaLen.floatValue()) > 2200.0f || (bl == false ? f > (float)specHanedashiSizeInfo.maxHanedashiSize.intValue() : (bl2 == false ? terracesInfo.mLeftJizaiKetaLen.floatValue() > (float)specHanedashiSizeInfo.maxHanedashiSize.intValue() || terracesInfo.mRightJizaiKetaLen.floatValue() > (float)specHanedashiSizeInfo.maxHanedashiSize2.intValue() : terracesInfo.mLeftJizaiKetaLen.floatValue() > (float)specHanedashiSizeInfo.maxHanedashiSize2.intValue() || terracesInfo.mRightJizaiKetaLen.floatValue() > (float)specHanedashiSizeInfo.maxHanedashiSize.intValue()))))) continue;
            bl3 = true;
            break;
        }
        return bl3;
    }
}

