/*
 * Decompiled with CFR 0.152.
 */
package option.speene.common.service.parts;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import option.gad.core.inject.GdInject;
import option.gad.core.inject.GdInjector;
import option.gad.core.util.EnumUtil;
import option.speene.common.dao.cache.spec.SpecOpeningOptionCacheDao;
import option.speene.common.entity.BasicInfo;
import option.speene.common.entity.FrontPanelOptionInfo;
import option.speene.common.entity.SPNEntities;
import option.speene.common.entity.TerraceInfo;
import option.speene.common.entity.TerracesInfo;
import option.speene.common.entity.paneloption.FrontScreenInfo;
import option.speene.common.entity.spec.SpecOpeningOptionInfo;
import option.speene.common.type.paneloption.FrontPanelOptionType;

public class FrontPanelOptionCommonService {
    @GdInject
    protected SpecOpeningOptionCacheDao mSpecOpeningOptionCacheDao;

    public FrontPanelOptionCommonService() {
        GdInjector.getInstance().inject((Object)this);
    }

    public List<FrontPanelOptionInfo> findManyOptionInfoByTypes(LinkedList<FrontPanelOptionInfo> linkedList, FrontPanelOptionType ... frontPanelOptionTypeArray) {
        ArrayList<FrontPanelOptionInfo> arrayList = new ArrayList<FrontPanelOptionInfo>();
        for (FrontPanelOptionInfo frontPanelOptionInfo : linkedList) {
            if (!EnumUtil.matchOR((Enum)((Enum)((Object)frontPanelOptionInfo.mPanelOptionType)), (Enum[])frontPanelOptionTypeArray)) continue;
            arrayList.add(frontPanelOptionInfo);
        }
        return arrayList;
    }

    public LinkedList<FrontPanelOptionInfo> findManySimilarFrontPanelOptionByOptionInfo(List<FrontPanelOptionInfo> list, List<FrontPanelOptionType> list2, FrontPanelOptionInfo frontPanelOptionInfo) {
        LinkedList<FrontPanelOptionInfo> linkedList = new LinkedList<FrontPanelOptionInfo>();
        for (FrontPanelOptionInfo frontPanelOptionInfo2 : list) {
            if (!frontPanelOptionInfo2.mTerraceId.equals(frontPanelOptionInfo.mTerraceId)) continue;
            if (frontPanelOptionInfo2.mPanelOptionType == frontPanelOptionInfo.mPanelOptionType) {
                linkedList.add(frontPanelOptionInfo2);
            }
            for (FrontPanelOptionType frontPanelOptionType : list2) {
                if (frontPanelOptionInfo2.mPanelOptionType != frontPanelOptionType) continue;
                linkedList.add(frontPanelOptionInfo2);
            }
        }
        return linkedList;
    }

    public boolean isFrontOptionPerm(SPNEntities sPNEntities, FrontPanelOptionType frontPanelOptionType) {
        LinkedList<TerraceInfo> linkedList = sPNEntities.mTerraceInfoList;
        boolean bl = false;
        for (TerraceInfo terraceInfo : linkedList) {
            if (!this.isFrontOptionPerm(sPNEntities, terraceInfo, frontPanelOptionType)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean isFrontOptionPerm(SPNEntities sPNEntities, TerraceInfo terraceInfo, FrontPanelOptionType frontPanelOptionType) {
        BasicInfo basicInfo = sPNEntities.mBasicInfo;
        TerracesInfo terracesInfo = sPNEntities.mTerracesInfo;
        SpecOpeningOptionInfo specOpeningOptionInfo = this.mSpecOpeningOptionCacheDao.findOneByTypes(frontPanelOptionType, basicInfo, terracesInfo, terraceInfo, null);
        return specOpeningOptionInfo != null && specOpeningOptionInfo.permission.equals("1");
    }

    public boolean isSukimaFusagiZaiPerm(SPNEntities sPNEntities, TerraceInfo terraceInfo, FrontPanelOptionType frontPanelOptionType) {
        FrontPanelOptionType frontPanelOptionType2 = null;
        if (frontPanelOptionType == FrontPanelOptionType.FRONT_SCREEN_ONE_STEP) {
            frontPanelOptionType2 = FrontPanelOptionType.SUKIMA_FUSAGI_ZAI_ONE_STEP;
        } else if (frontPanelOptionType == FrontPanelOptionType.FRONT_SCREEN_TWO_STEP) {
            frontPanelOptionType2 = FrontPanelOptionType.SUKIMA_FUSAGI_ZAI_TWO_STEP;
        }
        return this.isFrontOptionPerm(sPNEntities, terraceInfo, frontPanelOptionType2);
    }

    public boolean hasSukimaFusagiZai(LinkedList<FrontPanelOptionInfo> linkedList, FrontPanelOptionType frontPanelOptionType) {
        List<FrontPanelOptionInfo> list = this.findManyOptionInfoByTypes(linkedList, frontPanelOptionType);
        for (FrontPanelOptionInfo frontPanelOptionInfo : list) {
            if (!(frontPanelOptionInfo instanceof FrontScreenInfo)) continue;
            FrontScreenInfo frontScreenInfo = (FrontScreenInfo)frontPanelOptionInfo;
            if (!frontScreenInfo.mHasSukimaFusagiZai.booleanValue()) continue;
            return true;
        }
        return false;
    }
}

