/*
 * Decompiled with CFR 0.152.
 */
package option.speene.common.service.material;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import option.gad.core.inject.GdInject;
import option.gad.core.util.GdMutableTypeUtil;
import option.speene.common.dao.cache.type.TypeTerraceDepthCacheDao;
import option.speene.common.dao.cache.type.TypeTerraceHeightCacheDao;
import option.speene.common.dao.cache.type.TypeTerraceWidthCacheDao;
import option.speene.common.entity.BasicInfo;
import option.speene.common.entity.DomaTileInfo;
import option.speene.common.entity.SPNEntities;
import option.speene.common.entity.TerraceInfo;
import option.speene.common.entity.TerracesInfo;
import option.speene.common.entity.type.TypeTerraceDepthInfo;
import option.speene.common.entity.type.TypeTerraceHeightInfo;
import option.speene.common.entity.type.TypeTerraceWidthInfo;
import option.speene.common.entity.v10.BasicInfoV10;
import option.speene.common.entity.v10.TerraceInfoV10;
import option.speene.common.entity.v10.TerracesInfoV10;
import option.speene.common.service.parts.TerraceCommonService;
import option.speene.common.service.parts.TerraceFigureCommonService;
import option.speene.common.type.BuildingType;
import option.speene.common.type.DirectionType;
import option.speene.common.type.EnforcementDirType;
import option.speene.common.type.EnforcementType;
import option.speene.common.type.KenType;
import option.speene.common.type.PillarLengthType;
import option.speene.common.type.RoomType;
import option.speene.common.type.TerraceDepthType;
import option.speene.common.type.TerraceHeightType;
import option.speene.common.type.TerraceWidthType;
import option.speene.server.dxo.TerraceDepthTypeDxo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TerraceInfoService {
    private static final float DEFAULT_DEPTH_GAP = 10.0f;
    private static final float DEFAULT_PARTIAL_DEPTH = 100.0f;
    @GdInject
    private TerraceCommonService mTerraceCommonService;
    @GdInject
    private TerraceFigureCommonService mTerraceFigureCommonService;
    @GdInject
    private TypeTerraceWidthCacheDao mTypeTerraceWidthCacheDao;
    @GdInject
    private TypeTerraceDepthCacheDao mTypeTerraceDepthCacheDao;
    @GdInject
    private TypeTerraceHeightCacheDao mTypeTerraceHeightCacheDao;
    private Log mLog = LogFactory.getLog(TerraceInfoService.class);

    protected TerraceInfoService() {
    }

    public List<TerraceInfo> create(SPNEntities sPNEntities) {
        TerracesInfo terracesInfo = sPNEntities.mTerracesInfo;
        EnforcementType enforcementType = terracesInfo.mEnforcementType;
        EnforcementDirType enforcementDirType = terracesInfo.mEnforcementDirType;
        ArrayList<TerraceInfo> arrayList = new ArrayList<TerraceInfo>();
        if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.STD)) {
            arrayList.addAll(this.createStandard(sPNEntities));
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.DESUMI)) {
            arrayList.addAll(this.createDesumi(sPNEntities));
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.IRISUMI)) {
            arrayList.addAll(this.createIrisumi(sPNEntities));
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.SHOMEN_DAIKEI)) {
            arrayList.addAll(this.createShomenDaikei(sPNEntities));
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.SOKUMEN_DAIKEI)) {
            arrayList.addAll(this.createSokumenDaikei(sPNEntities));
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.MAEWAKU_DEHABA_CHIGAI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.L)) {
            arrayList.addAll(this.createMaewakuDehabaChigaiL(sPNEntities));
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.MAEWAKU_DEHABA_CHIGAI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.R)) {
            arrayList.addAll(this.createMaewakuDehabaChigaiR(sPNEntities));
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.KUTAI_DEHABA_CHIGAI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.L)) {
            arrayList.addAll(this.createKutaiDehabaChigaiL(sPNEntities));
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.KUTAI_DEHABA_CHIGAI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.R)) {
            arrayList.addAll(this.createKutaiDehabaChigaiR(sPNEntities));
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.HANEDASHI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.L)) {
            arrayList.addAll(this.createHanedashiL(sPNEntities));
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.HANEDASHI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.R)) {
            arrayList.addAll(this.createHanedashiR(sPNEntities));
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.JIZAIKETA_HANEDASHI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.L)) {
            arrayList.addAll(this.createJizaiKetaHanedashiL(sPNEntities));
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.JIZAIKETA_HANEDASHI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.R)) {
            arrayList.addAll(this.createJizaiKetaHanedashiR(sPNEntities));
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.JIZAIKETA_HANEDASHI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.BOTH)) {
            arrayList.addAll(this.createJizaiKetaHanedashiBoth(sPNEntities));
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.KEISHA)) {
            arrayList.addAll(this.createStandard(sPNEntities));
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.BUBUN_IRISUMI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.L)) {
            arrayList.addAll(this.createStandard(sPNEntities));
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.BUBUN_IRISUMI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.R)) {
            arrayList.addAll(this.createStandard(sPNEntities));
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.BUBUN_KAKOI_W)) {
            arrayList.addAll(this.createStandard(sPNEntities));
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.BUBUN_KAKOI_D)) {
            arrayList.addAll(this.createStandard(sPNEntities));
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.TSUKURITSUKE_ZENBU_KAKOI)) {
            arrayList.addAll(this.createStandard(sPNEntities));
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.TSUKURITSUKE_BUBUN_KAKOI)) {
            arrayList.addAll(this.createStandard(sPNEntities));
        }
        return arrayList;
    }

    private List<TerraceInfo> createStandard(SPNEntities sPNEntities) {
        BasicInfo basicInfo = sPNEntities.mBasicInfo;
        TerraceWidthType terraceWidthType = TerraceWidthType.T10;
        TerraceDepthType terraceDepthType = TerraceDepthType.T4;
        TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType, basicInfo.mKenType);
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneByType(terraceDepthType);
        ArrayList<TerraceInfo> arrayList = new ArrayList<TerraceInfo>();
        TerraceInfo terraceInfo = new TerraceInfo();
        terraceInfo.mIsMaster = true;
        terraceInfo.mIsStarting = true;
        terraceInfo.mId = 0;
        terraceInfo.mGroupId = 0;
        terraceInfo.mBuildingType = basicInfo.mBuildingType;
        terraceInfo.mTurningAngle = Float.valueOf(0.0f);
        terraceInfo.mWidthType = terraceWidthType;
        terraceInfo.mDefaultWidth = typeTerraceWidthInfo.length;
        terraceInfo.mWidth = typeTerraceWidthInfo.length;
        terraceInfo.mDepthType = terraceDepthType;
        terraceInfo.mDefaultDepth = typeTerraceDepthInfo.length;
        terraceInfo.mDepth = typeTerraceDepthInfo.length;
        arrayList.add(terraceInfo);
        return arrayList;
    }

    private List<TerraceInfo> createDesumi(SPNEntities sPNEntities) {
        TerracesInfo terracesInfo = sPNEntities.mTerracesInfo;
        EnforcementDirType enforcementDirType = terracesInfo.mEnforcementDirType;
        float f = enforcementDirType == EnforcementDirType.L ? -90 : 0;
        return this.createDesumiIrisumi(sPNEntities, Float.valueOf(f), Float.valueOf(90.0f));
    }

    private List<TerraceInfo> createIrisumi(SPNEntities sPNEntities) {
        TerracesInfo terracesInfo = sPNEntities.mTerracesInfo;
        EnforcementDirType enforcementDirType = terracesInfo.mEnforcementDirType;
        float f = enforcementDirType == EnforcementDirType.L ? 90 : 0;
        return this.createDesumiIrisumi(sPNEntities, Float.valueOf(f), Float.valueOf(-90.0f));
    }

    private List<TerraceInfo> createDesumiIrisumi(SPNEntities sPNEntities, Float f, Float f2) {
        BasicInfo basicInfo = sPNEntities.mBasicInfo;
        TerraceWidthType terraceWidthType = TerraceWidthType.T10;
        TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType, basicInfo.mKenType);
        ArrayList<TerraceInfo> arrayList = new ArrayList<TerraceInfo>();
        TerraceInfo terraceInfo = new TerraceInfo();
        terraceInfo.mIsMaster = true;
        terraceInfo.mIsStarting = true;
        terraceInfo.mId = 0;
        terraceInfo.mGroupId = 0;
        terraceInfo.mIsLeftEnd = true;
        terraceInfo.mIsRightEnd = false;
        terraceInfo.mBuildingType = basicInfo.mBuildingType;
        terraceInfo.mTurningAngle = f;
        terraceInfo.mWidthType = terraceWidthType;
        terraceInfo.mDefaultWidth = typeTerraceWidthInfo.length;
        terraceInfo.mWidth = typeTerraceWidthInfo.length;
        arrayList.add(terraceInfo);
        TerraceInfo terraceInfo2 = new TerraceInfo();
        terraceInfo2.mIsStarting = true;
        terraceInfo2.mId = 1;
        terraceInfo2.mGroupId = Integer.MAX_VALUE;
        terraceInfo2.mIsLeftEnd = false;
        terraceInfo2.mIsRightEnd = false;
        terraceInfo2.mBuildingType = BuildingType.CORNER;
        terraceInfo2.mTurningAngle = f2;
        terraceInfo2.mWidthType = TerraceWidthType.DEPTH;
        terraceInfo2.mDefaultWidth = terraceInfo2.mDepth;
        terraceInfo2.mWidth = terraceInfo2.mDepth;
        arrayList.add(terraceInfo2);
        TerraceInfo terraceInfo3 = new TerraceInfo();
        terraceInfo3.mIsStarting = true;
        terraceInfo3.mId = 2;
        terraceInfo3.mGroupId = 1;
        terraceInfo3.mIsLeftEnd = false;
        terraceInfo3.mIsRightEnd = true;
        terraceInfo3.mBuildingType = basicInfo.mBuildingType;
        terraceInfo3.mTurningAngle = Float.valueOf(0.0f);
        terraceInfo3.mWidthType = terraceWidthType;
        terraceInfo3.mDefaultWidth = typeTerraceWidthInfo.length;
        terraceInfo3.mWidth = typeTerraceWidthInfo.length;
        arrayList.add(terraceInfo3);
        return arrayList;
    }

    private List<TerraceInfo> createShomenDaikei(SPNEntities sPNEntities) {
        BasicInfo basicInfo = sPNEntities.mBasicInfo;
        TerracesInfo terracesInfo = sPNEntities.mTerracesInfo;
        EnforcementDirType enforcementDirType = terracesInfo.mEnforcementDirType;
        TerraceWidthType terraceWidthType = TerraceWidthType.T10;
        TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType, basicInfo.mKenType);
        TerraceDepthType terraceDepthType = TerraceDepthType.T6;
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneByType(terraceDepthType);
        float f = typeTerraceDepthInfo.length.floatValue();
        float f2 = typeTerraceDepthInfo.length.floatValue();
        if (enforcementDirType == EnforcementDirType.L) {
            f -= 300.0f;
        } else if (enforcementDirType == EnforcementDirType.R) {
            f2 -= 300.0f;
        }
        ArrayList<TerraceInfo> arrayList = new ArrayList<TerraceInfo>();
        TerraceInfo terraceInfo = new TerraceInfo();
        terraceInfo.mIsMaster = true;
        terraceInfo.mIsStarting = true;
        terraceInfo.mId = 0;
        terraceInfo.mGroupId = 0;
        terraceInfo.mBuildingType = basicInfo.mBuildingType;
        terraceInfo.mTurningAngle = Float.valueOf(0.0f);
        terraceInfo.mWidthType = terraceWidthType;
        terraceInfo.mDefaultWidth = typeTerraceWidthInfo.length;
        terraceInfo.mWidth = typeTerraceWidthInfo.length;
        terraceInfo.mDepthType = terraceDepthType;
        terraceInfo.mDefaultDepth = typeTerraceDepthInfo.length;
        terraceInfo.mDepth = typeTerraceDepthInfo.length;
        terraceInfo.mLeftDepthType = terraceDepthType;
        terraceInfo.mLeftDepth = Float.valueOf(f);
        terraceInfo.mRightDepthType = terraceDepthType;
        terraceInfo.mRightDepth = Float.valueOf(f2);
        arrayList.add(terraceInfo);
        return arrayList;
    }

    private List<TerraceInfo> createSokumenDaikei(SPNEntities sPNEntities) {
        BasicInfo basicInfo = sPNEntities.mBasicInfo;
        KenType kenType = basicInfo.mKenType;
        TerraceWidthType terraceWidthType = TerraceWidthType.T15;
        TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType, kenType);
        float f = typeTerraceWidthInfo.length.floatValue() - basicInfo.mKenLen.floatValue();
        float f2 = typeTerraceWidthInfo.length.floatValue();
        TerraceDepthType terraceDepthType = TerraceDepthType.T4;
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneByType(terraceDepthType);
        ArrayList<TerraceInfo> arrayList = new ArrayList<TerraceInfo>();
        TerraceInfo terraceInfo = new TerraceInfo();
        terraceInfo.mIsMaster = true;
        terraceInfo.mIsStarting = true;
        terraceInfo.mId = 0;
        terraceInfo.mGroupId = 0;
        terraceInfo.mBuildingType = basicInfo.mBuildingType;
        terraceInfo.mTurningAngle = Float.valueOf(0.0f);
        terraceInfo.mWidthType = terraceWidthType;
        terraceInfo.mDefaultWidth = typeTerraceWidthInfo.length;
        terraceInfo.mWidth = typeTerraceWidthInfo.length;
        terraceInfo.mFrontWidthType = terraceWidthType;
        terraceInfo.mFrontWidth = Float.valueOf(f);
        terraceInfo.mBackWidthType = terraceWidthType;
        terraceInfo.mBackWidth = Float.valueOf(f2);
        terraceInfo.mDepthType = terraceDepthType;
        terraceInfo.mDefaultDepth = typeTerraceDepthInfo.length;
        terraceInfo.mDepth = typeTerraceDepthInfo.length;
        arrayList.add(terraceInfo);
        return arrayList;
    }

    private List<TerraceInfo> createMaewakuDehabaChigaiL(SPNEntities sPNEntities) {
        if (sPNEntities.mBasicInfo.mFloorNum == 3) {
            return this.createMaewakuDehabaChigai(sPNEntities, TerraceDepthType.T3, TerraceDepthType.T4);
        }
        return this.createMaewakuDehabaChigai(sPNEntities, TerraceDepthType.T4, TerraceDepthType.T6);
    }

    private List<TerraceInfo> createMaewakuDehabaChigaiR(SPNEntities sPNEntities) {
        if (sPNEntities.mBasicInfo.mFloorNum == 3) {
            return this.createMaewakuDehabaChigai(sPNEntities, TerraceDepthType.T4, TerraceDepthType.T3);
        }
        return this.createMaewakuDehabaChigai(sPNEntities, TerraceDepthType.T6, TerraceDepthType.T4);
    }

    private List<TerraceInfo> createMaewakuDehabaChigai(SPNEntities sPNEntities, TerraceDepthType terraceDepthType, TerraceDepthType terraceDepthType2) {
        BasicInfo basicInfo = sPNEntities.mBasicInfo;
        TerraceWidthType terraceWidthType = TerraceWidthType.T10;
        TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType, basicInfo.mKenType);
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneByType(terraceDepthType);
        TypeTerraceDepthInfo typeTerraceDepthInfo2 = this.mTypeTerraceDepthCacheDao.findOneByType(terraceDepthType2);
        ArrayList<TerraceInfo> arrayList = new ArrayList<TerraceInfo>();
        TerraceInfo terraceInfo = new TerraceInfo();
        terraceInfo.mIsMaster = true;
        terraceInfo.mIsStarting = true;
        terraceInfo.mId = 0;
        terraceInfo.mGroupId = 0;
        terraceInfo.mBuildingType = basicInfo.mBuildingType;
        terraceInfo.mTurningAngle = Float.valueOf(0.0f);
        terraceInfo.mWidthType = terraceWidthType;
        terraceInfo.mDefaultWidth = typeTerraceWidthInfo.length;
        terraceInfo.mWidth = typeTerraceWidthInfo.length;
        terraceInfo.mDepthType = terraceDepthType;
        terraceInfo.mDefaultDepth = typeTerraceDepthInfo.length;
        terraceInfo.mDepth = typeTerraceDepthInfo.length;
        terraceInfo.mIsLeftEnd = true;
        terraceInfo.mIsRightEnd = false;
        arrayList.add(terraceInfo);
        TerraceInfo terraceInfo2 = new TerraceInfo();
        terraceInfo2.mIsStarting = true;
        terraceInfo2.mId = 1;
        terraceInfo2.mGroupId = 1;
        terraceInfo2.mBuildingType = basicInfo.mBuildingType;
        terraceInfo2.mTurningAngle = Float.valueOf(0.0f);
        terraceInfo2.mWidthType = terraceWidthType;
        terraceInfo2.mDefaultWidth = typeTerraceWidthInfo.length;
        terraceInfo2.mWidth = typeTerraceWidthInfo.length;
        terraceInfo2.mDepthType = terraceDepthType2;
        terraceInfo2.mDefaultDepth = typeTerraceDepthInfo2.length;
        terraceInfo2.mDepth = typeTerraceDepthInfo2.length;
        terraceInfo2.mIsLeftEnd = false;
        terraceInfo2.mIsRightEnd = true;
        arrayList.add(terraceInfo2);
        return arrayList;
    }

    private List<TerraceInfo> createKutaiDehabaChigaiL(SPNEntities sPNEntities) {
        BasicInfo basicInfo = sPNEntities.mBasicInfo;
        TerraceWidthType terraceWidthType = TerraceWidthType.T10;
        TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType, basicInfo.mKenType);
        TerraceWidthType terraceWidthType2 = TerraceWidthType.T05;
        TypeTerraceWidthInfo typeTerraceWidthInfo2 = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType2, basicInfo.mKenType);
        TerraceDepthType terraceDepthType = TerraceDepthType.T4;
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneByType(terraceDepthType);
        float f = 10.0f;
        ArrayList<TerraceInfo> arrayList = new ArrayList<TerraceInfo>();
        TerraceInfo terraceInfo = new TerraceInfo();
        terraceInfo.mIsMaster = true;
        terraceInfo.mIsStarting = true;
        terraceInfo.mId = 0;
        terraceInfo.mGroupId = 0;
        terraceInfo.mBuildingType = basicInfo.mBuildingType;
        terraceInfo.mTurningAngle = Float.valueOf(0.0f);
        terraceInfo.mWidthType = terraceWidthType;
        terraceInfo.mDefaultWidth = typeTerraceWidthInfo.length;
        terraceInfo.mWidth = typeTerraceWidthInfo.length;
        terraceInfo.mLeftWidthType = terraceWidthType2;
        terraceInfo.mLeftWidth = typeTerraceWidthInfo2.length;
        terraceInfo.mLeftDepthType = terraceDepthType;
        terraceInfo.mLeftDepth = Float.valueOf(typeTerraceDepthInfo.length.floatValue() - f);
        arrayList.add(terraceInfo);
        return arrayList;
    }

    private List<TerraceInfo> createKutaiDehabaChigaiR(SPNEntities sPNEntities) {
        BasicInfo basicInfo = sPNEntities.mBasicInfo;
        TerraceWidthType terraceWidthType = TerraceWidthType.T05;
        TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType, basicInfo.mKenType);
        TerraceDepthType terraceDepthType = TerraceDepthType.T4;
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneByType(terraceDepthType);
        float f = 10.0f;
        ArrayList<TerraceInfo> arrayList = new ArrayList<TerraceInfo>();
        TerraceInfo terraceInfo = new TerraceInfo();
        terraceInfo.mIsMaster = true;
        terraceInfo.mIsStarting = true;
        terraceInfo.mId = 0;
        terraceInfo.mGroupId = 0;
        terraceInfo.mBuildingType = basicInfo.mBuildingType;
        terraceInfo.mTurningAngle = Float.valueOf(0.0f);
        terraceInfo.mLeftWidthType = terraceWidthType;
        terraceInfo.mLeftWidth = typeTerraceWidthInfo.length;
        terraceInfo.mRightDepthType = terraceDepthType;
        terraceInfo.mRightDepth = Float.valueOf(typeTerraceDepthInfo.length.floatValue() - f);
        arrayList.add(terraceInfo);
        return arrayList;
    }

    private List<TerraceInfo> createHanedashiL(SPNEntities sPNEntities) {
        return this.createHanedashi(sPNEntities, 300.0f, 0.0f);
    }

    private List<TerraceInfo> createHanedashiR(SPNEntities sPNEntities) {
        return this.createHanedashi(sPNEntities, 0.0f, 300.0f);
    }

    private List<TerraceInfo> createHanedashi(SPNEntities sPNEntities, float f, float f2) {
        BasicInfo basicInfo = sPNEntities.mBasicInfo;
        TerracesInfo terracesInfo = sPNEntities.mTerracesInfo;
        TerraceWidthType terraceWidthType = TerraceWidthType.T10;
        TerraceDepthType terraceDepthType = TerraceDepthType.T4;
        TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType, basicInfo.mKenType);
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneByType(terraceDepthType);
        ArrayList<TerraceInfo> arrayList = new ArrayList<TerraceInfo>();
        terracesInfo.mLeftHanedashiLen = Float.valueOf(f);
        terracesInfo.mRightHanedashiLen = Float.valueOf(f2);
        TerraceInfo terraceInfo = new TerraceInfo();
        terraceInfo.mIsMaster = true;
        terraceInfo.mIsStarting = true;
        terraceInfo.mId = 0;
        terraceInfo.mGroupId = 0;
        terraceInfo.mBuildingType = basicInfo.mBuildingType;
        terraceInfo.mTurningAngle = Float.valueOf(0.0f);
        terraceInfo.mWidthType = terraceWidthType;
        terraceInfo.mDefaultWidth = typeTerraceWidthInfo.length;
        terraceInfo.mWidth = typeTerraceWidthInfo.length;
        terraceInfo.mDepthType = terraceDepthType;
        terraceInfo.mDefaultDepth = typeTerraceDepthInfo.length;
        terraceInfo.mDepth = typeTerraceDepthInfo.length;
        arrayList.add(terraceInfo);
        return arrayList;
    }

    private List<TerraceInfo> createJizaiKetaHanedashiL(SPNEntities sPNEntities) {
        return this.createJizaiKetaHanedashi(sPNEntities, 300.0f, 0.0f);
    }

    private List<TerraceInfo> createJizaiKetaHanedashiR(SPNEntities sPNEntities) {
        return this.createJizaiKetaHanedashi(sPNEntities, 0.0f, 300.0f);
    }

    private List<TerraceInfo> createJizaiKetaHanedashiBoth(SPNEntities sPNEntities) {
        return this.createJizaiKetaHanedashi(sPNEntities, 300.0f, 300.0f);
    }

    private List<TerraceInfo> createJizaiKetaHanedashi(SPNEntities sPNEntities, float f, float f2) {
        BasicInfo basicInfo = sPNEntities.mBasicInfo;
        TerracesInfo terracesInfo = sPNEntities.mTerracesInfo;
        TerraceWidthType terraceWidthType = TerraceWidthType.T10;
        TerraceDepthType terraceDepthType = TerraceDepthType.T4;
        TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType, basicInfo.mKenType);
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneByType(terraceDepthType);
        ArrayList<TerraceInfo> arrayList = new ArrayList<TerraceInfo>();
        terracesInfo.mLeftJizaiKetaLen = Float.valueOf(f);
        terracesInfo.mRightJizaiKetaLen = Float.valueOf(f2);
        TerraceInfo terraceInfo = new TerraceInfo();
        terraceInfo.mIsMaster = true;
        terraceInfo.mIsStarting = true;
        terraceInfo.mId = 0;
        terraceInfo.mGroupId = 0;
        terraceInfo.mBuildingType = basicInfo.mBuildingType;
        terraceInfo.mTurningAngle = Float.valueOf(0.0f);
        terraceInfo.mWidthType = terraceWidthType;
        terraceInfo.mDefaultWidth = typeTerraceWidthInfo.length;
        terraceInfo.mWidth = typeTerraceWidthInfo.length;
        terraceInfo.mDepthType = terraceDepthType;
        terraceInfo.mDefaultDepth = typeTerraceDepthInfo.length;
        terraceInfo.mDepth = typeTerraceDepthInfo.length;
        arrayList.add(terraceInfo);
        return arrayList;
    }

    public TerraceInfo addTerrace(SPNEntities sPNEntities, DirectionType directionType) {
        TerracesInfo terracesInfo = sPNEntities.mTerracesInfo;
        LinkedList<TerraceInfo> linkedList = sPNEntities.mTerraceInfoList;
        return this.addTerrace(sPNEntities, terracesInfo, linkedList, directionType);
    }

    public TerraceInfo addTerrace(SPNEntities sPNEntities, TerracesInfo terracesInfo, LinkedList<TerraceInfo> linkedList, DirectionType directionType) {
        BasicInfo basicInfo = sPNEntities.mBasicInfo;
        TerraceInfo terraceInfo = linkedList.getFirst();
        TerraceInfo terraceInfo2 = linkedList.getLast();
        TerraceInfo terraceInfo3 = new TerraceInfo();
        TerraceWidthType terraceWidthType = TerraceWidthType.T10;
        TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType, basicInfo.mKenType);
        TerraceDepthType terraceDepthType = null;
        float f = 0.0f;
        int n = 0;
        TerraceInfo terraceInfo4 = null;
        if (directionType == DirectionType.LEFT) {
            n = -1;
            terraceInfo4 = linkedList.getFirst();
            linkedList.addFirst(terraceInfo3);
            terraceDepthType = terraceInfo4.mLeftDepthType;
            f = terraceInfo4.mLeftDepth.floatValue();
        } else if (directionType == DirectionType.RIGHT) {
            n = 1;
            terraceInfo4 = linkedList.getLast();
            linkedList.addLast(terraceInfo3);
            terraceDepthType = terraceInfo4.mRightDepthType;
            f = terraceInfo4.mRightDepth.floatValue();
        }
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneByType(terraceDepthType);
        terraceInfo3.mIsMaster = false;
        terraceInfo3.mIsStarting = false;
        terraceInfo3.mId = terraceInfo4.mId + n;
        terraceInfo3.mGroupId = terraceInfo4.mGroupId;
        terraceInfo3.mRoomType = RoomType.GARDEN_ROOM;
        terraceInfo3.mWidthType = terraceWidthType;
        terraceInfo3.mDefaultWidth = typeTerraceWidthInfo.length;
        terraceInfo3.mWidth = typeTerraceWidthInfo.length;
        terraceInfo3.mDepthType = terraceDepthType;
        terraceInfo3.mDefaultDepth = typeTerraceDepthInfo.length;
        terraceInfo3.mDepth = Float.valueOf(f);
        terraceInfo3.mLeftDepthType = terraceDepthType;
        terraceInfo3.mLeftDepth = Float.valueOf(f);
        terraceInfo3.mRightDepthType = terraceDepthType;
        terraceInfo3.mRightDepth = Float.valueOf(f);
        terraceInfo3.mTurningAngle = terraceInfo4.mTurningAngle;
        terraceInfo4.mTurningAngle = Float.valueOf(0.0f);
        TerraceInfo terraceInfo5 = linkedList.getFirst();
        TerraceInfo terraceInfo6 = linkedList.getLast();
        if (directionType == DirectionType.LEFT) {
            terraceInfo5.mIsLeftEnd = true;
            if (terraceInfo5 != terraceInfo) {
                terraceInfo.mIsLeftEnd = false;
            }
        } else {
            terraceInfo6.mIsRightEnd = true;
            if (terraceInfo6 != terraceInfo2) {
                terraceInfo2.mIsRightEnd = false;
            }
        }
        if (terraceInfo5 != terraceInfo6) {
            terraceInfo5.mIsRightEnd = false;
            terraceInfo6.mIsLeftEnd = false;
        }
        this.mTerraceCommonService.updateTerracesInfo(basicInfo, terracesInfo, linkedList);
        this.updateDepth(terracesInfo, linkedList);
        return terraceInfo3;
    }

    public void removeTerrace(SPNEntities sPNEntities, DirectionType directionType) {
        LinkedList<TerraceInfo> linkedList = sPNEntities.mTerraceInfoList;
        if (directionType == DirectionType.RIGHT) {
            TerraceInfo terraceInfo = linkedList.getFirst();
            if (terraceInfo.mIsMaster.booleanValue()) {
                return;
            }
            linkedList.removeFirst();
            TerraceInfo terraceInfo2 = linkedList.getFirst();
            terraceInfo2.mIsLeftEnd = true;
            terraceInfo2.mTurningAngle = terraceInfo.mTurningAngle;
        } else if (directionType == DirectionType.LEFT) {
            TerraceInfo terraceInfo = linkedList.getLast();
            if (terraceInfo.mIsMaster.booleanValue()) {
                return;
            }
            linkedList.removeLast();
            TerraceInfo terraceInfo3 = linkedList.getLast();
            terraceInfo3.mIsRightEnd = true;
            terraceInfo3.mTurningAngle = terraceInfo.mTurningAngle;
        }
        this.mTerraceCommonService.updateTerracesInfo(sPNEntities);
    }

    public void adjustDepth(SPNEntities sPNEntities) {
        TerracesInfo terracesInfo = sPNEntities.mTerracesInfo;
        LinkedList<TerraceInfo> linkedList = sPNEntities.mTerraceInfoList;
        DomaTileInfo domaTileInfo = sPNEntities.mDomaTileInfo;
        EnforcementType enforcementType = terracesInfo.mEnforcementType;
        EnforcementDirType enforcementDirType = terracesInfo.mEnforcementDirType;
        if (enforcementType == EnforcementType.STD) {
            terracesInfo.mPartialDepth = Float.valueOf(0.0f);
            terracesInfo.mDepthGap = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = Float.valueOf(0.0f);
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.STD)) {
            terracesInfo.mPartialDepth = Float.valueOf(0.0f);
            terracesInfo.mDepthGap = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = Float.valueOf(0.0f);
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.DESUMI)) {
            terracesInfo.mPartialDepth = Float.valueOf(0.0f);
            terracesInfo.mDepthGap = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = Float.valueOf(0.0f);
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.IRISUMI)) {
            terracesInfo.mPartialDepth = Float.valueOf(0.0f);
            terracesInfo.mDepthGap = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = Float.valueOf(0.0f);
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.SHOMEN_DAIKEI)) {
            terracesInfo.mPartialDepth = Float.valueOf(0.0f);
            terracesInfo.mDepthGap = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = Float.valueOf(0.0f);
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.SOKUMEN_DAIKEI)) {
            terracesInfo.mPartialDepth = Float.valueOf(0.0f);
            terracesInfo.mDepthGap = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = Float.valueOf(0.0f);
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.MAEWAKU_DEHABA_CHIGAI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.L)) {
            terracesInfo.mPartialDepth = Float.valueOf(0.0f);
            terracesInfo.mDepthGap = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = Float.valueOf(0.0f);
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.MAEWAKU_DEHABA_CHIGAI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.R)) {
            terracesInfo.mPartialDepth = Float.valueOf(0.0f);
            terracesInfo.mDepthGap = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = Float.valueOf(0.0f);
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.KUTAI_DEHABA_CHIGAI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.L)) {
            this.initDepth(terracesInfo, linkedList);
            terracesInfo.mPartialDepth = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = terracesInfo.mDepthGap = Float.valueOf(10.0f);
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.KUTAI_DEHABA_CHIGAI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.R)) {
            this.initDepth(terracesInfo, linkedList);
            terracesInfo.mPartialDepth = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = terracesInfo.mDepthGap = Float.valueOf(10.0f);
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.HANEDASHI)) {
            terracesInfo.mPartialDepth = Float.valueOf(0.0f);
            terracesInfo.mDepthGap = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = Float.valueOf(0.0f);
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.JIZAIKETA_HANEDASHI)) {
            terracesInfo.mPartialDepth = Float.valueOf(0.0f);
            terracesInfo.mDepthGap = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = Float.valueOf(0.0f);
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.KEISHA)) {
            terracesInfo.mPartialDepth = Float.valueOf(0.0f);
            terracesInfo.mDepthGap = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = Float.valueOf(0.0f);
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.BUBUN_IRISUMI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.L)) {
            if (terracesInfo.mDepthType == TerraceDepthType.T4) {
                terracesInfo.mDepthType = TerraceDepthType.T6;
            }
            this.initDepth(terracesInfo, linkedList);
            terracesInfo.mPartialDepth = Float.valueOf(100.0f);
            terracesInfo.mDepthGap = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = terracesInfo.mPartialDepth;
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.BUBUN_IRISUMI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.R)) {
            if (terracesInfo.mDepthType == TerraceDepthType.T4) {
                terracesInfo.mDepthType = TerraceDepthType.T6;
            }
            this.initDepth(terracesInfo, linkedList);
            terracesInfo.mPartialDepth = Float.valueOf(100.0f);
            terracesInfo.mDepthGap = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = terracesInfo.mPartialDepth;
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.BUBUN_KAKOI_W)) {
            terracesInfo.mPartialDepth = Float.valueOf(0.0f);
            terracesInfo.mDepthGap = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = Float.valueOf(0.0f);
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.BUBUN_KAKOI_D)) {
            terracesInfo.mPartialDepth = Float.valueOf(0.0f);
            terracesInfo.mDepthGap = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = Float.valueOf(0.0f);
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.TSUKURITSUKE_ZENBU_KAKOI)) {
            terracesInfo.mPartialDepth = Float.valueOf(0.0f);
            terracesInfo.mDepthGap = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = Float.valueOf(0.0f);
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.TSUKURITSUKE_BUBUN_KAKOI)) {
            terracesInfo.mPartialDepth = Float.valueOf(0.0f);
            terracesInfo.mDepthGap = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = Float.valueOf(0.0f);
        }
        this.updateDepth(terracesInfo, linkedList);
    }

    private void initDepth(TerracesInfo terracesInfo, LinkedList<TerraceInfo> linkedList) {
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneByType(terracesInfo.mDepthType);
        terracesInfo.mDepth = typeTerraceDepthInfo.length;
        for (TerraceInfo terraceInfo : linkedList) {
            terraceInfo.mDepthType = terracesInfo.mDepthType;
            terraceInfo.mDepth = typeTerraceDepthInfo.length;
        }
    }

    public void updateDepth(SPNEntities sPNEntities) {
        this.updateDepth(sPNEntities.mTerracesInfo, sPNEntities.mTerraceInfoList);
    }

    public void updateDepth(TerracesInfo terracesInfo, LinkedList<TerraceInfo> linkedList) {
        EnforcementType enforcementType = terracesInfo.mEnforcementType;
        EnforcementDirType enforcementDirType = terracesInfo.mEnforcementDirType;
        for (TerraceInfo terraceInfo : linkedList) {
            BuildingType buildingType = terraceInfo.mBuildingType;
            if (buildingType == BuildingType.CORNER) {
                terraceInfo.mLeftDepth = terraceInfo.mDepth;
                terraceInfo.mRightDepth = terraceInfo.mDepth;
                terraceInfo.mWidth = terraceInfo.mDepth;
                terraceInfo.mDefaultWidth = terraceInfo.mDepth;
            } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.STD)) {
                terraceInfo.mLeftDepth = terraceInfo.mDepth;
                terraceInfo.mRightDepth = terraceInfo.mDepth;
            } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.DESUMI)) {
                terraceInfo.mLeftDepth = terraceInfo.mDepth;
                terraceInfo.mRightDepth = terraceInfo.mDepth;
            } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.IRISUMI)) {
                terraceInfo.mLeftDepth = terraceInfo.mDepth;
                terraceInfo.mRightDepth = terraceInfo.mDepth;
            } else if (!GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.SHOMEN_DAIKEI)) {
                if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.SOKUMEN_DAIKEI)) {
                    terraceInfo.mLeftDepth = terraceInfo.mDepth;
                    terraceInfo.mRightDepth = terraceInfo.mDepth;
                } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.MAEWAKU_DEHABA_CHIGAI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.L)) {
                    terraceInfo.mLeftDepth = Float.valueOf(terraceInfo.mDepth.floatValue() - terracesInfo.mDepthGap.floatValue());
                    terraceInfo.mRightDepth = terraceInfo.mDepth;
                } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.MAEWAKU_DEHABA_CHIGAI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.R)) {
                    terraceInfo.mLeftDepth = terraceInfo.mDepth;
                    terraceInfo.mRightDepth = Float.valueOf(terraceInfo.mDepth.floatValue() - terracesInfo.mDepthGap.floatValue());
                } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.KUTAI_DEHABA_CHIGAI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.L)) {
                    if (terraceInfo.mId == 0) {
                        terraceInfo.mLeftDepth = Float.valueOf(terracesInfo.mDepth.floatValue() - terracesInfo.mDepthGap.floatValue());
                        terraceInfo.mRightDepth = terracesInfo.mDepth;
                    } else if (terraceInfo.mId < 0) {
                        terraceInfo.mLeftDepth = Float.valueOf(terracesInfo.mDepth.floatValue() - terracesInfo.mDepthGap.floatValue());
                        terraceInfo.mRightDepth = Float.valueOf(terracesInfo.mDepth.floatValue() - terracesInfo.mDepthGap.floatValue());
                    } else if (terraceInfo.mId > 0) {
                        terraceInfo.mLeftDepth = terracesInfo.mDepth;
                        terraceInfo.mRightDepth = terracesInfo.mDepth;
                    }
                } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.KUTAI_DEHABA_CHIGAI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.R)) {
                    if (terraceInfo.mId == 0) {
                        terraceInfo.mLeftDepth = terracesInfo.mDepth;
                        terraceInfo.mRightDepth = Float.valueOf(terracesInfo.mDepth.floatValue() - terracesInfo.mDepthGap.floatValue());
                    } else if (terraceInfo.mId < 0) {
                        terraceInfo.mLeftDepth = terracesInfo.mDepth;
                        terraceInfo.mRightDepth = terracesInfo.mDepth;
                    } else if (terraceInfo.mId > 0) {
                        terraceInfo.mLeftDepth = Float.valueOf(terracesInfo.mDepth.floatValue() - terracesInfo.mDepthGap.floatValue());
                        terraceInfo.mRightDepth = Float.valueOf(terracesInfo.mDepth.floatValue() - terracesInfo.mDepthGap.floatValue());
                    }
                } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.HANEDASHI)) {
                    terraceInfo.mLeftDepth = terraceInfo.mDepth;
                    terraceInfo.mRightDepth = terraceInfo.mDepth;
                } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.JIZAIKETA_HANEDASHI)) {
                    terraceInfo.mLeftDepth = terraceInfo.mDepth;
                    terraceInfo.mRightDepth = terraceInfo.mDepth;
                } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.KEISHA)) {
                    terraceInfo.mLeftDepth = terraceInfo.mDepth;
                    terraceInfo.mRightDepth = terraceInfo.mDepth;
                } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.BUBUN_IRISUMI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.L)) {
                    terraceInfo.mLeftDepth = Float.valueOf(terraceInfo.mDepth.floatValue() - terracesInfo.mPartialDepth.floatValue());
                    terraceInfo.mRightDepth = terraceInfo.mDepth;
                } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.BUBUN_IRISUMI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.R)) {
                    terraceInfo.mLeftDepth = terraceInfo.mDepth;
                    terraceInfo.mRightDepth = Float.valueOf(terraceInfo.mDepth.floatValue() - terracesInfo.mPartialDepth.floatValue());
                } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.BUBUN_KAKOI_W)) {
                    terraceInfo.mLeftDepth = terraceInfo.mDepth;
                    terraceInfo.mRightDepth = terraceInfo.mDepth;
                } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.BUBUN_KAKOI_D)) {
                    terraceInfo.mLeftDepth = terraceInfo.mDepth;
                    terraceInfo.mRightDepth = terraceInfo.mDepth;
                } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.TSUKURITSUKE_ZENBU_KAKOI)) {
                    terraceInfo.mLeftDepth = terraceInfo.mDepth;
                    terraceInfo.mRightDepth = terraceInfo.mDepth;
                } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.TSUKURITSUKE_BUBUN_KAKOI)) {
                    terraceInfo.mLeftDepth = terraceInfo.mDepth;
                    terraceInfo.mRightDepth = terraceInfo.mDepth;
                }
            }
            terraceInfo.mLeftDepthType = TerraceDepthTypeDxo.convert(terraceInfo.mLeftDepth.floatValue());
            terraceInfo.mRightDepthType = TerraceDepthTypeDxo.convert(terraceInfo.mRightDepth.floatValue());
        }
        if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.SHOMEN_DAIKEI)) {
            this.updateDepthForShomenDaikei(linkedList);
        }
    }

    private void updateDepthForShomenDaikei(LinkedList<TerraceInfo> linkedList) {
        TerraceInfo terraceInfo3;
        if (linkedList.size() <= 1) {
            return;
        }
        TerraceInfo terraceInfo2 = linkedList.getFirst();
        for (TerraceInfo terraceInfo3 : linkedList) {
            if (terraceInfo3.mId > 0) continue;
            if (terraceInfo3.mId == 0) {
                terraceInfo3.mLeftDepth = terraceInfo2.mDepth;
                continue;
            }
            terraceInfo3.mLeftDepth = terraceInfo2.mDepth;
            terraceInfo3.mRightDepth = terraceInfo2.mDepth;
        }
        terraceInfo3 = linkedList.getLast();
        for (TerraceInfo terraceInfo4 : linkedList) {
            if (terraceInfo4.mId < 0) continue;
            if (terraceInfo4.mId == 0) {
                terraceInfo4.mRightDepth = terraceInfo3.mDepth;
                continue;
            }
            terraceInfo4.mLeftDepth = terraceInfo3.mDepth;
            terraceInfo4.mRightDepth = terraceInfo3.mDepth;
        }
    }

    public void updateTerraceHeightType(SPNEntities sPNEntities) {
        BasicInfo basicInfo = sPNEntities.mBasicInfo;
        TerracesInfo terracesInfo = sPNEntities.mTerracesInfo;
        PillarLengthType pillarLengthType = basicInfo.mPillarLengthType;
        TerraceHeightType terraceHeightType = null;
        if (GdMutableTypeUtil.matchOR(pillarLengthType, PillarLengthType.NONE, PillarLengthType.STD)) {
            terraceHeightType = TerraceHeightType.STD;
        } else if (GdMutableTypeUtil.matchOR(pillarLengthType, PillarLengthType.LONG)) {
            terraceHeightType = TerraceHeightType.LONG;
        }
        terracesInfo.mHeightType = terraceHeightType;
        TypeTerraceHeightInfo typeTerraceHeightInfo = this.mTypeTerraceHeightCacheDao.findOneByTypes(basicInfo.mProductSeriesType, basicInfo.mKetaType, terraceHeightType, basicInfo.mFloorNum);
        terracesInfo.mHeight = typeTerraceHeightInfo.length;
        terracesInfo.mDefaultHeight = typeTerraceHeightInfo.length;
        this.updateTerraceHeight(sPNEntities);
    }

    public void updateTerraceHeight(SPNEntities sPNEntities) {
        this.updateTerraceHeight(sPNEntities.mBasicInfo, sPNEntities.mTerracesInfo, sPNEntities.mTerraceInfoList);
    }

    public <BI extends BasicInfoV10, TSI extends TerracesInfoV10, TI extends TerraceInfoV10> void updateTerraceHeight(BI BI, TSI TSI, Collection<TI> collection) {
        TSI.mRoofHeight = Float.valueOf((float)this.mTerraceFigureCommonService.calcRoofHeight(BI, collection));
        TSI.mTotalHeight = Float.valueOf((float)this.mTerraceFigureCommonService.calcTotalHeight(TSI));
        this.mLog.debug((Object)("terracesInfo totalHeight[" + TSI.mTotalHeight + "] roofHeight[" + TSI.mRoofHeight + "] height[" + TSI.mHeight + "]"));
    }

    public List<TerraceInfo> findManyByGroupId(List<TerraceInfo> list, Integer n) {
        ArrayList<TerraceInfo> arrayList = new ArrayList<TerraceInfo>();
        for (TerraceInfo terraceInfo : list) {
            if (!terraceInfo.mGroupId.equals(n)) continue;
            arrayList.add(terraceInfo);
        }
        return arrayList;
    }
}

