/*
 * Decompiled with CFR 0.152.
 */
package option.speene.common.service.init.entity;

import option.gad.core.inject.GdInject;
import option.gad.core.service.init.EntityInitLogic;
import option.gad.core.util.NumberUtil;
import option.speene.common.dao.cache.type.TypeKenCacheDao;
import option.speene.common.entity.BasicInfo;
import option.speene.common.entity.SPNBootInfo;
import option.speene.common.entity.type.TypeKenInfo;
import option.speene.common.type.DeckRenkeiType;
import option.speene.common.type.KenType;
import option.speene.common.type.KetaType;
import option.speene.common.type.PanelMaterialType;
import option.speene.common.type.ProductSeriesType;
import option.speene.common.type.RoofFigureType;
import option.speene.common.type.SPNColorType;
import option.speene.common.type.StrengthType;
import option.speene.common.type.SubProductType;
import option.speene.common.type.factory.ProductSeriesTypeFactory;

public class BasicInfoInitLogic
implements EntityInitLogic<BasicInfo> {
    @GdInject
    private SPNBootInfo mBootInfo;
    @GdInject
    private TypeKenCacheDao mTypeKenCacheDao;

    @Override
    public Class<?> configType() {
        return BasicInfo.class;
    }

    @Override
    public void init(BasicInfo basicInfo) {
        KenType kenType = KenType.KANTOUMA;
        TypeKenInfo typeKenInfo = this.mTypeKenCacheDao.findOneByType(kenType);
        Integer n = this.mBootInfo != null ? (Integer)NumberUtil.emptyToDefault((Object)this.mBootInfo.productSeriesType, (Object)1) : 1;
        basicInfo.mProductSeriesType = (ProductSeriesType)ProductSeriesTypeFactory.getInstance().getTypeById(n);
        basicInfo.mFloorNum = 1;
        basicInfo.mStrengthType = StrengthType.T600;
        basicInfo.mKenType = kenType;
        basicInfo.mKenLen = typeKenInfo.length;
        basicInfo.mKetaType = KetaType.STD;
        basicInfo.mSubProductType = SubProductType.DOMA;
        basicInfo.mRoofFigureType = RoofFigureType.F;
        basicInfo.mDeckRenkeiType = DeckRenkeiType.NONE;
        if (basicInfo.mProductSeriesType == ProductSeriesType.SPEENE) {
            basicInfo.mBodyColorType = SPNColorType.AUTUMN_BROWN_G;
        } else if (basicInfo.mProductSeriesType == ProductSeriesType.CHOUETTE) {
            basicInfo.mBodyColorType = SPNColorType.ECRU_IVORY_M9;
        }
        basicInfo.mYaneMaterialType = PanelMaterialType.POLY_CLEAR_BLUE;
    }
}

