/*
 * Decompiled with CFR 0.152.
 */
package option.speene.common.service.common;

import com.kt.util.StringUtil;
import java.awt.Color;
import option.gad.core.inject.GdInstanceFactory;
import option.speene.common.dao.cache.ColorCacheDao;
import option.speene.common.dao.cache.type.TypePanelMaterialCacheDao;
import option.speene.common.entity.ColorInfo;
import option.speene.common.entity.type.TypePanelMaterialInfo;
import option.speene.common.type.PanelMaterialType;
import option.speene.common.type.SPNColorType;
import option.speene.common.type.factory.SPNColorTypeFactory;

public class SPNColor {
    public static Color getColor(SPNColorType sPNColorType) {
        return SPNColor.getColor(sPNColorType.id());
    }

    public static Color getColor(int n) {
        ColorCacheDao colorCacheDao = (ColorCacheDao)((Object)GdInstanceFactory.getInstance().getInstance(ColorCacheDao.class, new Object[0]));
        ColorInfo colorInfo = colorCacheDao.findOneById(n);
        return SPNColor.getColor(colorInfo);
    }

    public static Color getColor(ColorInfo colorInfo) {
        Color color = null;
        if (colorInfo != null && !StringUtil.isEmpty((String)colorInfo.threedArgb) && colorInfo.threedArgb.length() == 8) {
            int n = Integer.parseInt(colorInfo.threedArgb.substring(0, 2), 16);
            int n2 = Integer.parseInt(colorInfo.threedArgb.substring(2, 4), 16);
            int n3 = Integer.parseInt(colorInfo.threedArgb.substring(4, 6), 16);
            int n4 = Integer.parseInt(colorInfo.threedArgb.substring(6, 8), 16);
            color = new Color(n2, n3, n4, n);
        } else {
            color = Color.BLACK;
        }
        return color;
    }

    public static String getName(SPNColorType sPNColorType) {
        if (sPNColorType == null) {
            return "";
        }
        return SPNColor.getName(sPNColorType.id());
    }

    public static String getName(int n) {
        ColorCacheDao colorCacheDao = (ColorCacheDao)((Object)GdInstanceFactory.getInstance().getInstance(ColorCacheDao.class, new Object[0]));
        return SPNColor.getName(colorCacheDao.findOneById(n));
    }

    public static String getName(ColorInfo colorInfo) {
        return colorInfo.name;
    }

    public static TypePanelMaterialInfo getPanelMaterialInfo(PanelMaterialType panelMaterialType) {
        TypePanelMaterialCacheDao typePanelMaterialCacheDao = (TypePanelMaterialCacheDao)((Object)GdInstanceFactory.getInstance().getInstance(TypePanelMaterialCacheDao.class, new Object[0]));
        return typePanelMaterialCacheDao.findOneByType(panelMaterialType);
    }

    public static SPNColorType getColorType(PanelMaterialType panelMaterialType) {
        TypePanelMaterialInfo typePanelMaterialInfo = SPNColor.getPanelMaterialInfo(panelMaterialType);
        return (SPNColorType)SPNColorTypeFactory.getInstance().getTypeById(typePanelMaterialInfo.colorId);
    }

    public static Color getColor(PanelMaterialType panelMaterialType) {
        TypePanelMaterialInfo typePanelMaterialInfo = SPNColor.getPanelMaterialInfo(panelMaterialType);
        ColorCacheDao colorCacheDao = (ColorCacheDao)((Object)GdInstanceFactory.getInstance().getInstance(ColorCacheDao.class, new Object[0]));
        ColorInfo colorInfo = colorCacheDao.findOneById(typePanelMaterialInfo.colorId);
        return SPNColor.getColor(colorInfo);
    }
}

