/*
 * Decompiled with CFR 0.152.
 */
package option.speene.common.service.common;

import option.gad.core.inject.GdInject;
import option.gad.core.util.GdMutableTypeUtil;
import option.speene.common.dao.cache.type.TypeTerraceDepthCacheDao;
import option.speene.common.entity.TerracesInfo;
import option.speene.common.entity.type.TypeTerraceDepthInfo;
import option.speene.common.type.EnforcementDirType;
import option.speene.common.type.EnforcementType;
import option.speene.common.type.SodePosType;

public class EnforcementCommonService {
    @GdInject
    protected TypeTerraceDepthCacheDao typeTerraceDepthCacheDao;

    public boolean isDehabaCut(TerracesInfo terracesInfo) {
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.typeTerraceDepthCacheDao.findOneById(terracesInfo.mDepthType.id());
        return !typeTerraceDepthInfo.length.equals(terracesInfo.mDepth);
    }

    public boolean isLeftDehabaCut(TerracesInfo terracesInfo) {
        if (this.isDehabaCut(terracesInfo)) {
            return true;
        }
        if (GdMutableTypeUtil.matchOR(terracesInfo.mEnforcementType, EnforcementType.KUTAI_DEHABA_CHIGAI) && GdMutableTypeUtil.matchOR(terracesInfo.mEnforcementDirType, EnforcementDirType.L)) {
            return true;
        }
        return GdMutableTypeUtil.matchOR(terracesInfo.mEnforcementType, EnforcementType.BUBUN_IRISUMI) && GdMutableTypeUtil.matchOR(terracesInfo.mEnforcementDirType, EnforcementDirType.L);
    }

    public boolean isRightDehabaCut(TerracesInfo terracesInfo) {
        if (this.isDehabaCut(terracesInfo)) {
            return true;
        }
        if (GdMutableTypeUtil.matchOR(terracesInfo.mEnforcementType, EnforcementType.KUTAI_DEHABA_CHIGAI) && GdMutableTypeUtil.matchOR(terracesInfo.mEnforcementDirType, EnforcementDirType.R)) {
            return true;
        }
        return GdMutableTypeUtil.matchOR(terracesInfo.mEnforcementType, EnforcementType.BUBUN_IRISUMI) && GdMutableTypeUtil.matchOR(terracesInfo.mEnforcementDirType, EnforcementDirType.R);
    }

    public boolean hasSingleIrisumi(SodePosType sodePosType) {
        return sodePosType == SodePosType.L || sodePosType == SodePosType.R;
    }

    public boolean hasNecessaryIdouhoutateEnforcementType(EnforcementType enforcementType, EnforcementDirType enforcementDirType, boolean bl) {
        if (bl && enforcementType == EnforcementType.BUBUN_IRISUMI && enforcementDirType == EnforcementDirType.L) {
            return true;
        }
        return !bl && enforcementType == EnforcementType.BUBUN_IRISUMI && enforcementDirType == EnforcementDirType.R;
    }

    public boolean hasDeirisumi(TerracesInfo terracesInfo) {
        return GdMutableTypeUtil.matchOR(terracesInfo.mEnforcementType, EnforcementType.DESUMI, EnforcementType.IRISUMI);
    }
}

