/*
 * Decompiled with CFR 0.152.
 */
package option.speene.common.dao.cache.type;

import com.kt.annotation.Reflectable;
import java.util.LinkedList;
import option.gad.core.dao.GdDao;
import option.gad.core.inject.GdInject;
import option.speene.common.dao.cache.AbstractCacheCsvDao;
import option.speene.common.entity.BasicInfo;
import option.speene.common.entity.TerraceInfo;
import option.speene.common.entity.TerracesInfo;
import option.speene.common.entity.type.TypeBeamDetailInfo;
import option.speene.common.service.common.EnforcementCommonService;
import option.speene.common.service.parts.TerraceCommonService;
import option.speene.common.type.EnforcementType;
import option.speene.common.type.TerraceWidthType;

@Reflectable(name="TypeBeamDetailCacheDao")
@GdDao(entity=TypeBeamDetailInfo.class)
public class TypeBeamDetailCacheDao
extends AbstractCacheCsvDao<TypeBeamDetailInfo> {
    @GdInject
    private TerraceCommonService mTerraceCommonService;
    @GdInject
    private EnforcementCommonService mEnforcementCommonService;

    public Integer findMaxBeamDetailType(BasicInfo basicInfo, LinkedList<TerraceInfo> linkedList, TerracesInfo terracesInfo) {
        Integer n = 0;
        for (TerraceInfo terraceInfo : linkedList) {
            TypeBeamDetailInfo typeBeamDetailInfo = this.findOneByType(basicInfo, linkedList, terracesInfo, terraceInfo);
            n = Math.max(n, typeBeamDetailInfo.beamDetailType);
        }
        return n;
    }

    public TypeBeamDetailInfo findOneByType(BasicInfo basicInfo, LinkedList<TerraceInfo> linkedList, TerracesInfo terracesInfo, TerraceInfo terraceInfo) {
        TypeBeamDetailInfo typeBeamDetailInfo = new TypeBeamDetailInfo();
        typeBeamDetailInfo.enforcementType = terracesInfo.mEnforcementType.mDbId;
        typeBeamDetailInfo.kenType = basicInfo.mKenType.mDbId;
        typeBeamDetailInfo.strengthType = basicInfo.mStrengthType.mDbId;
        typeBeamDetailInfo.widthType = this.getWidthType(basicInfo, linkedList, terracesInfo, terraceInfo);
        typeBeamDetailInfo.oppositeWidthType = this.getOppositeWidthType(linkedList, terracesInfo);
        typeBeamDetailInfo.overhang = terraceInfo.mDepthType.mDbId;
        return (TypeBeamDetailInfo)this.findOne(typeBeamDetailInfo, new boolean[]{true, true});
    }

    private Integer getWidthType(BasicInfo basicInfo, LinkedList<TerraceInfo> linkedList, TerracesInfo terracesInfo, TerraceInfo terraceInfo) {
        Integer n = terraceInfo.mWidthType.mDbId;
        if (terracesInfo.mEnforcementType == EnforcementType.JIZAIKETA_HANEDASHI) {
            TerraceWidthType terraceWidthType = this.mTerraceCommonService.calcJizaiKetaWidthTypeByJizaiKetaHanedashi(basicInfo, terracesInfo, terraceInfo);
            n = terraceWidthType != null ? terraceWidthType.mDbId : null;
        } else if (this.mEnforcementCommonService.hasDeirisumi(terracesInfo)) {
            TerraceInfo terraceInfo2 = this.mTerraceCommonService.findCornerLeftTerraceInfo(linkedList, terracesInfo);
            n = terraceInfo2.mWidthType.mDbId;
        }
        return n;
    }

    private Integer getOppositeWidthType(LinkedList<TerraceInfo> linkedList, TerracesInfo terracesInfo) {
        Integer n = null;
        if (this.mEnforcementCommonService.hasDeirisumi(terracesInfo)) {
            TerraceInfo terraceInfo = this.mTerraceCommonService.findCornerRightTerraceInfo(linkedList, terracesInfo);
            n = terraceInfo.mWidthType.mDbId;
        }
        return n;
    }
}

