/*
 * Decompiled with CFR 0.152.
 */
package option.pdf;

import com.kt.geom.KLocalAxis;
import com.kt.util.KCollection;
import com.kt.util.RefList;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.text.DecimalFormat;
import java.util.Vector;
import jp.kitec.kwt.IRichGraphics;
import jp.kitec.kwt.KFont;
import jp.kitec.kwt.KLineType;
import nethome.geom.primitive.GPoint2Df;
import nethome.ui.MainComponent;
import option.pdf.PdfCommand;
import option.pdf.PdfCommandGraphics;

public class PdfRichGraphics
implements IRichGraphics {
    public PdfCommand pdf;
    protected PdfCommandGraphics mGraphics;
    private static int BUF_SIZE = 128;
    private static float[] XBUF = new float[BUF_SIZE];
    private static float[] YBUF = new float[BUF_SIZE];
    private static KLineType NULL_LINE = new KLineType("", new float[]{0.0f, 0.0f}, 0.1f);

    public PdfRichGraphics(String string) {
        this.pdf = new PdfCommand(string);
    }

    public void setFontEmbed(boolean bl) {
        ((PdfCommandGraphics)this.pdf.getGraphics()).setFontEmbed(bl);
    }

    public void startPage(int n, int n2) {
        this.pdf.setPageInfo(n, n2);
        this.pdf.setUserCoordinateDirectionY(1);
        this.mGraphics = (PdfCommandGraphics)this.pdf.getGraphics();
    }

    public void endPage() {
        this.mGraphics.dispose();
    }

    public void setClipArea(float f, float f2, float f3, float f4) {
        this.mGraphics.setClip(Math.min(f, f3), Math.max(f2, f4), Math.abs(f3 - f), Math.abs(f4 - f2));
    }

    public void releaseClipArea() {
        this.mGraphics.releaseClip();
    }

    public void setColor(Color color) {
        this.mGraphics.setColor(color);
    }

    public void drawLine(float f, float f2, float f3, float f4, KLineType kLineType) {
        this.setLineType(kLineType);
        this.mGraphics.drawLine(f, f2, f3, f4);
    }

    public void drawCircle(float f, float f2, float f3, float f4, float f5, KLineType kLineType) {
        this.setLineType(kLineType);
        this.mGraphics.drawArc(f - f3, f2 + f3, f3 * 2.0f, f3 * 2.0f, f4, f5, false);
    }

    public void drawFillCircle(float f, float f2, float f3, float f4, float f5, KLineType kLineType) {
        this.setLineType(kLineType);
        this.mGraphics.drawArc(f - f3, f2 + f3, f3 * 2.0f, f3 * 2.0f, f4, f5, true);
    }

    public void drawEllipse(float f, float f2, float f3, float f4, float f5, float f6, KLineType kLineType) {
        this.drawEllipse(f, f2, f3, f4, f5, f6, kLineType, false);
    }

    public void drawFillEllipse(float f, float f2, float f3, float f4, float f5, float f6, KLineType kLineType) {
        this.drawEllipse(f, f2, f3, f4, f5, f6, kLineType, true);
    }

    private void drawEllipse(float f, float f2, float f3, float f4, float f5, float f6, KLineType kLineType, boolean bl) {
        this.setLineType(kLineType);
        if (Math.abs(f5 - f6) < 0.001f) {
            f5 = 0.0f;
            f6 = 360.0f;
        }
        this.mGraphics.drawArc(f - f4, f2 + f3, f4 * 2.0f, f3 * 2.0f, f5, f6, bl);
    }

    public void drawRect(float f, float f2, float f3, float f4, KLineType kLineType) {
        this.setLineType(kLineType);
        this.mGraphics.drawRect(Math.min(f, f3), Math.max(f2, f4), Math.abs(f3 - f), Math.abs(f4 - f2), false);
    }

    public void drawFillRect(float f, float f2, float f3, float f4, KLineType kLineType) {
        this.setLineType(kLineType);
        this.mGraphics.drawRect(Math.min(f, f3), Math.max(f2, f4), Math.abs(f3 - f), Math.abs(f4 - f2), true);
    }

    public void drawRoundRect(float f, float f2, float f3, float f4, float f5, KLineType kLineType) {
        this.setLineType(kLineType);
        this.mGraphics.drawRoundRect(Math.min(f, f3), Math.max(f2, f4), Math.abs(f3 - f), Math.abs(f4 - f2), f5, f5, false);
    }

    public void drawFillRoundRect(float f, float f2, float f3, float f4, float f5, KLineType kLineType) {
        this.setLineType(kLineType);
        this.mGraphics.drawRoundRect(Math.min(f, f3), Math.max(f2, f4), Math.abs(f3 - f), Math.abs(f4 - f2), f5, f5, true);
    }

    public void drawPolygon(KCollection kCollection, KLineType kLineType) {
        this.setLineType(kLineType);
        this.createFloatPointArrayBuffer(kCollection);
        this.mGraphics.drawPolygon(XBUF, YBUF, kCollection.size(), false);
    }

    public void drawFillPolygon(KCollection kCollection, KLineType kLineType) {
        this.setLineType(kLineType);
        this.createFloatPointArrayBuffer(kCollection);
        this.mGraphics.drawPolygon(XBUF, YBUF, kCollection.size(), true);
    }

    public void drawPolyLine(KCollection kCollection, KLineType kLineType) {
        this.setLineType(kLineType);
        this.createFloatPointArrayBuffer(kCollection);
    }

    public void drawImage(Image image, String string, float f, float f2, float f3, float f4) {
        this.drawImage(image, f, f2, f3, f4);
    }

    public void drawImage(Image image, String string, String string2, float f, float f2, float f3, float f4) {
        this.drawImage(image, f, f2, f3, f4);
    }

    public void drawImage(Image image, float f, float f2, float f3, float f4) {
        this.mGraphics.drawImage(image, Math.min(f, f3), Math.max(f2, f4), Math.abs(f3 - f), Math.abs(f4 - f2), (ImageObserver)MainComponent.getInstance().getApplication().getImageObserver());
    }

    public void drawText(String string, float f, float f2, String string2, int n, float f3, float f4) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.mGraphics.setFont(string2, n, f3);
        KFont kFont = KFont.getFont((String)string2, (int)n, (float)f3);
        this.mGraphics.drawString(string, f, f2, false, 0.0f, kFont.stringWidthf(string), "spaceX");
    }

    public void drawShadePolygon(Vector vector, float f, float f2, float f3, float f4, Color color, Color color2) {
        Object object;
        Object object2;
        int n = 0;
        int[] nArray = new int[vector.size()];
        int n2 = 0;
        while (n2 < vector.size()) {
            object2 = (RefList)vector.elementAt(n2);
            n += object2.size();
            ++n2;
        }
        float[] fArray = new float[n];
        object2 = new float[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < vector.size()) {
            object = (RefList)vector.elementAt(n4);
            nArray[n4] = object.size();
            int n5 = 0;
            while (n5 < object.size()) {
                float[] fArray2 = (float[])object.elementAt(n5);
                fArray[n3] = fArray2[0];
                object2[n3] = (RefList)fArray2[1];
                ++n3;
                ++n5;
            }
            ++n4;
        }
        DecimalFormat decimalFormat = new DecimalFormat("000");
        object = new StringBuffer("TYPE2_");
        ((StringBuffer)object).append(decimalFormat.format(color.getRed()));
        ((StringBuffer)object).append(decimalFormat.format(color.getGreen()));
        ((StringBuffer)object).append(decimalFormat.format(color.getBlue()));
        ((StringBuffer)object).append(decimalFormat.format(color2.getRed()));
        ((StringBuffer)object).append(decimalFormat.format(color2.getGreen()));
        ((StringBuffer)object).append(decimalFormat.format(color2.getBlue()));
        this.mGraphics.drawShadingGroupPolygon(((StringBuffer)object).toString(), fArray, (float[])object2, nArray);
    }

    public void setLineType(KLineType kLineType) {
        if (kLineType != null) {
            this.mGraphics.setLineWidth(kLineType.mWidth);
            if (kLineType.mStroke != null) {
                this.mGraphics.setLinePattern(kLineType.mStroke);
            } else {
                this.mGraphics.setLinePattern(PdfRichGraphics.NULL_LINE.mStroke);
            }
        } else {
            this.mGraphics.setLineWidth(PdfRichGraphics.NULL_LINE.mWidth);
            this.mGraphics.setLinePattern(PdfRichGraphics.NULL_LINE.mStroke);
        }
    }

    private void createFloatPointArrayBuffer(KCollection kCollection) {
        if (kCollection.size() > XBUF.length) {
            XBUF = new float[kCollection.size()];
            YBUF = new float[kCollection.size()];
        }
        int n = 0;
        while (n < kCollection.size()) {
            PdfRichGraphics.XBUF[n] = ((GPoint2Df)kCollection.elementAt((int)n)).x;
            PdfRichGraphics.YBUF[n] = ((GPoint2Df)kCollection.elementAt((int)n)).y;
            ++n;
        }
    }

    public void pathInit(int n) {
    }

    public void pathClear() {
    }

    public void pathMoveTo(double d, double d2, KLocalAxis kLocalAxis) {
    }

    public void pathLineTo(double d, double d2, KLocalAxis kLocalAxis) {
    }

    public void pathQuadTo(float f, float f2, float f3, float f4, KLocalAxis kLocalAxis) {
    }

    public void pathCurveTo(float f, float f2, float f3, float f4, float f5, float f6, KLocalAxis kLocalAxis) {
    }

    public void pathClose() {
    }

    public void pathAdd(KCollection kCollection, KLocalAxis kLocalAxis) {
    }

    public void fillPath(KLineType kLineType) {
    }

    public void drawPath(KLineType kLineType) {
    }

    public void pathArc(float f, float f2, float f3, float f4, float f5, KLocalAxis kLocalAxis) {
    }

    public void shadePath(KLineType kLineType, float f, float f2, float f3, float f4, Color color, Color color2, boolean bl) {
    }
}

