/*
 * Decompiled with CFR 0.152.
 */
package option.pdf;

import com.kt.io.AbstFile;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import option.pdf.PdfCommandGraphics;

public class PdfCommand {
    public static final int A1 = 0;
    public static final int A2 = 1;
    public static final int A3 = 2;
    public static final int A4 = 3;
    public static final int A5 = 4;
    public static final int A6 = 5;
    public static final int A7 = 6;
    public static final int A8 = 7;
    public static final int A9 = 8;
    public static final int A10 = 9;
    public static final int B1 = 10;
    public static final int B2 = 11;
    public static final int B3 = 12;
    public static final int B4 = 13;
    public static final int B5 = 14;
    public static final int B6 = 15;
    public static final int B7 = 16;
    public static final int B8 = 17;
    public static final int B9 = 18;
    public static final int B10 = 19;
    private static final String[] MEDIA_SIZE_INDEXES = new String[]{"A1", "A2", "A3", "A4", "A5", "A6", "B1", "B2", "B3", "B4", "B5", "B6"};
    private static final float[][] MEDIA_SIZE = new float[][]{{594.0f, 841.0f}, {420.0f, 594.0f}, {297.0f, 420.0f}, {210.0f, 297.0f}, {148.0f, 210.0f}, {105.0f, 148.0f}, {74.0f, 105.0f}, {52.0f, 74.0f}, {37.0f, 52.0f}, {26.0f, 37.0f}, {728.0f, 1030.0f}, {515.0f, 728.0f}, {364.0f, 515.0f}, {257.0f, 364.0f}, {182.0f, 257.0f}, {128.0f, 182.0f}, {91.0f, 128.0f}, {64.0f, 91.0f}, {45.0f, 64.0f}, {32.0f, 45.0f}};
    public static final int PORTRAIT = 0;
    public static final int LANDSCAPE = 1;
    private static final int DEFAULT_DPI = 72;
    private static final int DEFAULT_VIEWPORT_MAX = 8;
    public static final int TOP_TO_BOTTOM = 0;
    public static final int BOTTOM_TO_TOP = 1;
    private static final String DEFAULT_ENCODING = "MS932";
    private String mEncoding;
    private PdfCommandGraphics mPdfGraphics;
    private Hashtable mTable;
    private AbstFile mOutFile;
    private String mFileName;
    private int mPageCount;
    private boolean mIsPDFOpened;
    private boolean mIsFileOpened;
    private boolean mIsPageStarted;
    private int mPageSize;
    private int mDirection;
    private float mDpi;
    private int mImageCount;
    private float mUserMinX;
    private float mUserMinY;
    private float mUserMaxX;
    private float mUserMaxY;
    private float[] mViewMinX;
    private float[] mViewMinY;
    private float[] mViewMaxX;
    private float[] mViewMaxY;
    private int mViewportMax;
    private int mViewportCount;
    private int mCurrentViewport;
    private float mPageWidth;
    private float mPageHeight;
    private Vector mFormats;
    private int mUserCoordDirY = 0;
    int count = 0;

    public PdfCommand(String string) {
        this(string, DEFAULT_ENCODING);
    }

    public PdfCommand(String string, String string2) {
        this.mEncoding = string2;
        this.mPdfGraphics = new PdfCommandGraphics(this);
        this.openPdf();
        this.openFile(string);
        this.setPageInfomation(3, 0, 72.0f);
        this.createViewport(8);
        this.count = 0;
    }

    private void openPdf() {
        if (this.mIsPDFOpened) {
            throw new InternalError("PDF is alread opened");
        }
        this.mOutFile = new AbstFile();
        this.mOutFile.openNewFileToBuffer("", this.mEncoding);
        this.mOutFile.writeStringToBufferln("pdfstart");
        this.mTable = new Hashtable();
        this.mPageCount = 0;
        this.mImageCount = 0;
        this.mFileName = null;
        this.mIsFileOpened = false;
        this.mIsPageStarted = false;
        this.mIsPDFOpened = true;
        this.mFormats = new Vector();
    }

    private void closePdf() {
        if (!this.mIsPDFOpened) {
            return;
        }
        this.mOutFile.writeStringToBufferln("pdfend");
        this.mOutFile.closeNewFileToBuffer();
        this.mIsPDFOpened = false;
    }

    public void setPageInfo(int n, int n2) {
        this.setPageInfo(n, n2, 72.0f);
    }

    public void setPageInfo(int n, int n2, float f) {
        this.setPageInfomation(n, n2, f);
        this.setUserCoordinate(0.0f, 0.0f, this.mPageWidth, this.mPageHeight);
    }

    protected void setPageInfomation(int n, int n2, float f) {
        if (n < 0 || n >= MEDIA_SIZE_INDEXES.length) {
            throw new IllegalArgumentException("illegal page size");
        }
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("illegal page direciton");
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException("illegal dpi");
        }
        this.mPageSize = n;
        this.mDirection = n2;
        this.mDpi = f;
        float[] fArray = MEDIA_SIZE[this.mPageSize];
        if (this.mDirection == 0) {
            this.setPageDimension(fArray[0], fArray[1]);
        } else {
            this.setPageDimension(fArray[1], fArray[0]);
        }
    }

    public void end() {
        this.endPage();
        this.closeFile();
        this.closePdf();
    }

    private void openFile(String string) {
        if (string == null) {
            throw new IllegalArgumentException("file name is null");
        }
        if (!this.mIsPDFOpened) {
            throw new InternalError("PDF is not opend");
        }
        if (this.mIsFileOpened) {
            throw new InternalError("file is already opend");
        }
        this.mFileName = string;
        this.mOutFile.writeStringToBufferln(new String("filestart," + this.mFileName));
        this.mPageCount = 0;
        this.mIsFileOpened = true;
    }

    private void closeFile() {
        if (!this.mIsFileOpened) {
            return;
        }
        this.mOutFile.writeStringToBufferln(new String("fileend," + this.mFileName));
        this.mIsFileOpened = false;
    }

    private void startPage(String string, int n) {
        if (!this.mIsFileOpened) {
            throw new InternalError("file is not opend");
        }
        if (this.mIsPageStarted) {
            throw new InternalError("page is already opend");
        }
        StringBuffer stringBuffer = new StringBuffer("pagestart,");
        stringBuffer.append(this.mPageCount);
        this.mOutFile.writeStringToBufferln(stringBuffer.toString());
        stringBuffer = new StringBuffer("pagesize,");
        stringBuffer.append(string);
        stringBuffer.append(",");
        stringBuffer.append(n);
        if (this.mDpi != 72.0f) {
            stringBuffer.append(",");
            stringBuffer.append(this.mDpi);
        }
        this.mOutFile.writeStringToBufferln(stringBuffer.toString());
        this.setFormat();
        this.mIsPageStarted = true;
    }

    protected void endPage() {
        if (!this.mIsPageStarted) {
            return;
        }
        this.mOutFile.writeStringToBufferln(new String("pageend," + this.mPageCount++));
        this.mIsPageStarted = false;
        this.resetViewport();
        this.setUserCoordinate(0.0f, 0.0f, this.mPageWidth, this.mPageHeight);
    }

    public void setFormat(String string) {
        if (this.mFormats.size() > 0) {
            this.mFormats.removeAllElements();
        }
        this.addFormat(string);
    }

    public void addFormat(String string) {
        if (string != null && string.length() > 0) {
            this.mFormats.addElement(string);
        }
    }

    private void setFormat() {
        int n = 0;
        while (n < this.mFormats.size()) {
            String string = (String)this.mFormats.elementAt(n);
            this.mOutFile.writeStringToBufferln("format," + string);
            ++n;
        }
    }

    public Graphics getGraphics() {
        if (!this.mIsPageStarted) {
            this.startPage(MEDIA_SIZE_INDEXES[this.mPageSize], this.mDirection);
        }
        return this.mPdfGraphics;
    }

    public Map<String, Object> getData() {
        this.mTable.put("DATA", this.mOutFile.getData());
        this.mTable.put("ENCODING", this.mEncoding);
        return this.mTable;
    }

    public String getImageName() {
        return String.valueOf(this.mImageCount);
    }

    public Dimension getPageDimension() {
        return new Dimension((int)this.mPageWidth, (int)this.mPageHeight);
    }

    public void createViewport(int n) {
        this.mViewportMax = n;
        this.mViewMinX = new float[this.mViewportMax];
        this.mViewMinY = new float[this.mViewportMax];
        this.mViewMaxX = new float[this.mViewportMax];
        this.mViewMaxY = new float[this.mViewportMax];
        this.resetViewport();
    }

    public void resetViewport() {
        this.mCurrentViewport = 0;
        this.mViewMinX[0] = 0.0f;
        this.mViewMinY[0] = 0.0f;
        this.mViewMaxX[0] = 1.0f;
        this.mViewMaxY[0] = 1.0f;
        this.mViewportCount = 1;
    }

    public void setViewport(float f, float f2, float f3, float f4) {
        this.mViewMinX[this.mViewportCount] = f;
        this.mViewMinY[this.mViewportCount] = f2;
        this.mViewMaxX[this.mViewportCount] = f3;
        this.mViewMaxY[this.mViewportCount] = f4;
        this.mCurrentViewport = this.mViewportCount++;
    }

    public void setUserCoordinate(float f, float f2, float f3, float f4) {
        this.mUserMinX = f;
        this.mUserMinY = f2;
        this.mUserMaxX = f3;
        this.mUserMaxY = f4;
    }

    public void setUserCoordinateDirectionY(int n) {
        this.mUserCoordDirY = n;
    }

    public int getUserCoordinateDirectionY() {
        return this.mUserCoordDirY;
    }

    protected void setPageDimension(float f, float f2) {
        this.mPageWidth = f;
        this.mPageHeight = f2;
    }

    protected float userWidthToPageWidth(float f) {
        float f2 = this.mViewMaxX[this.mCurrentViewport] - this.mViewMinX[this.mCurrentViewport];
        return Math.abs(f2 * this.mPageWidth * f / (this.mUserMaxX - this.mUserMinX));
    }

    protected float userHeightToPageHeight(float f) {
        float f2 = this.mViewMaxY[this.mCurrentViewport] - this.mViewMinY[this.mCurrentViewport];
        return Math.abs(f2 * this.mPageHeight * f / (this.mUserMaxY - this.mUserMinY));
    }

    protected float userXToPageX(float f) {
        return this.viewXToPageX(this.userXToViewX(f));
    }

    protected float userYToPageY(float f) {
        return this.viewYToPageY(this.userYToViewY(f));
    }

    protected float userXToViewX(float f) {
        float f2 = (f - this.mUserMinX) / (this.mUserMaxX - this.mUserMinX);
        return this.mViewMinX[this.mCurrentViewport] + f2 * (this.mViewMaxX[this.mCurrentViewport] - this.mViewMinX[this.mCurrentViewport]);
    }

    protected float userYToViewY(float f) {
        if (this.getUserCoordinateDirectionY() == 0) {
            f = this.mUserMaxY - f;
        }
        float f2 = (f - this.mUserMinY) / (this.mUserMaxY - this.mUserMinY);
        return this.mViewMinY[this.mCurrentViewport] + f2 * (this.mViewMaxY[this.mCurrentViewport] - this.mViewMinY[this.mCurrentViewport]);
    }

    protected float viewXToPageX(float f) {
        return this.mPageWidth * f;
    }

    protected float viewYToPageY(float f) {
        return this.mPageHeight * f;
    }

    protected void draw(String string) {
        if (!this.canWrite()) {
            throw new InternalError("graphics is not ready");
        }
        this.mOutFile.writeStringToBufferln(string);
        ++this.count;
    }

    protected void draw(int[] nArray) {
        if (!this.canWrite()) {
            throw new InternalError("graphics is not ready");
        }
        this.mTable.put(new String("im" + this.mImageCount++), nArray);
    }

    protected void draw(byte[] byArray) {
        if (!this.canWrite()) {
            throw new InternalError("graphics is not ready");
        }
        this.mTable.put(new String("im" + this.mImageCount++), byArray);
    }

    protected boolean canWrite() {
        if (!this.mIsPDFOpened || !this.mIsFileOpened) {
            return false;
        }
        return this.mIsPageStarted;
    }
}

