/*
 * Decompiled with CFR 0.152.
 */
package option.misc.gui;

import com.kt.util.UtilString;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jp.kitec.kwt.KFont;
import option.misc.gui.DkTipMessage;

public class DkMultiLineStatusBar
extends JPanel
implements DkTipMessage {
    protected String mStr = null;
    protected String mSubStr = null;
    protected String mConstantStr = "";
    protected int mTextSize = 12;
    protected KFont mFont;
    protected JLabel[] mMain;

    public DkMultiLineStatusBar(Color color, Color color2) {
        this(color, color2, 1, 12);
    }

    public DkMultiLineStatusBar(Color color, Color color2, int n) {
        this(color, color2, n, 12);
    }

    public DkMultiLineStatusBar(Color color, Color color2, int n, int n2) {
        this.setForeground(color);
        this.mTextSize = n2;
        this.setBorder(BorderFactory.createEtchedBorder(1));
        this.mFont = KFont.getFont((String)"MS UI Gothic", (int)KFont.PLAIN, (float)this.mTextSize);
        this.setFont(this.mFont.getFontObject());
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.mMain = new JLabel[n];
        int n3 = 0;
        while (n3 < n) {
            this.mMain[n3] = new JLabel(" ");
            this.mMain[n3].setFont(this.mFont.getFontObject());
            this.add((Component)this.mMain[n3], gridBagConstraints);
            ++gridBagConstraints.gridy;
            ++n3;
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                DkMultiLineStatusBar.this.update();
            }
        });
    }

    @Override
    public void setConstantMessage(String string) {
        this.mConstantStr = string;
        this.update();
    }

    public String getConstantMessage() {
        return this.mConstantStr;
    }

    @Override
    public void setMessage(String string) {
        if (UtilString.isDiff((String)this.mStr, (String)string)) {
            this.mStr = string;
            this.update();
        }
    }

    @Override
    public void setMessage(String string, String string2) {
        this.mStr = String.valueOf(string) + "\n" + string2;
    }

    @Override
    public void setMessage2(String string) {
    }

    @Override
    public void update() {
        String string = null;
        string = this.mStr != null ? this.mStr : (this.mConstantStr != null ? this.mConstantStr : "");
        int n = this.mMain[0].getWidth();
        if (string.length() == 0) {
            int n2 = 0;
            while (n2 < this.mMain.length) {
                this.mMain[n2].setText("  ");
                ++n2;
            }
        } else {
            AttributedString attributedString = new AttributedString(string);
            attributedString.addAttribute(TextAttribute.FONT, this.mFont.getFontObject());
            Graphics2D graphics2D = (Graphics2D)this.mMain[0].getGraphics();
            if (graphics2D == null) {
                return;
            }
            LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedString.getIterator(), graphics2D.getFontRenderContext());
            int n3 = 0;
            while (n3 < this.mMain.length) {
                String string2 = string.substring(lineBreakMeasurer.getPosition(), lineBreakMeasurer.nextOffset(n));
                if (string2.length() > 0) {
                    this.mMain[n3].setText(string2);
                } else {
                    this.mMain[n3].setText(" ");
                }
                this.mMain[n3].setToolTipText(string);
                lineBreakMeasurer.nextLayout(n);
                ++n3;
            }
            graphics2D.dispose();
        }
    }

    public Component getComponenet() {
        return this;
    }

    public void close() {
    }
}

