/*
 * Decompiled with CFR 0.152.
 */
package option.misc.gui;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import option.gui.CornerBorder;
import option.gui.RibbonBorder;
import option.gui.RoundBorder;
import option.gui.TitledLineBorder;

public class BorderUtil {
    private static boolean mRichUI = true;

    public static Border createTitledBorder(String string) {
        if (mRichUI) {
            return new RibbonBorder(string);
        }
        return BorderFactory.createTitledBorder(string);
    }

    public static Border createTitledLineBorder(String string) {
        if (mRichUI) {
            return new TitledLineBorder(string);
        }
        return BorderFactory.createTitledBorder(string);
    }

    public static Border createSpacedTitledBorder(String string) {
        return BorderUtil.createSpacedTitledBorder(string, 20, 5, 5, 5);
    }

    public static Border createSpacedTitledBorder(String string, int n, int n2, int n3, int n4) {
        return BorderUtil.createSpacedBorder(new RibbonBorder(string), n, n2, n3, n4);
    }

    public static Border createSpacedBorder(Border border, int n, int n2, int n3, int n4) {
        if (mRichUI) {
            return BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(n, n2, n3, n4));
        }
        return border;
    }

    public static Border createCornerBorder() {
        if (mRichUI) {
            return new CornerBorder();
        }
        return BorderFactory.createEtchedBorder();
    }

    public static boolean isRichUI() {
        return mRichUI;
    }

    public static void setRichUI(boolean bl) {
        mRichUI = bl;
    }

    public static Dimension getTitledBorderMinimumSize(Component component, Border border) {
        if (border instanceof RoundBorder) {
            RoundBorder roundBorder = (RoundBorder)border;
            return roundBorder.getMinimumSize(component);
        }
        if (border instanceof TitledBorder) {
            TitledBorder titledBorder = (TitledBorder)border;
            return titledBorder.getMinimumSize(component);
        }
        return new Dimension();
    }
}

