/*
 * Decompiled with CFR 0.152.
 */
package option.loneterrace.shape.sunnyge.model.sunnyge.service;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import option.gad.core.inject.GdInject;
import option.gad.core.inject.GdInjector;
import option.gad.core.util.ObjectUtil;
import option.loneterrace.common.entity.SNYEntities;
import option.loneterrace.common.entity.TerraceInfo;
import option.loneterrace.common.service.parts.TerraceFigureCommonService;
import option.loneterrace.shape.sunnyge.model.sunnyge.item.AbstractTerraceUnitItem;
import option.loneterrace.shape.sunnyge.model.sunnyge.item.ItemTerraceUnitGeneric;
import option.loneterrace.shape.sunnyge.model.sunnyge.item.MsItemTerrace;
import option.loneterrace.shape.sunnyge.model.sunnyge.parts.MsPartsTerrace;
import option.loneterrace.shape.sunnyge.model.sunnyge.service.PartsFigureService;

public class SNYTerraceUpdater {
    @GdInject
    protected TerraceFigureCommonService mTerraceFigureCommonService;
    @GdInject
    protected PartsFigureService mPartsFigureService;

    public SNYTerraceUpdater() {
        GdInjector.getInstance().inject((Object)this);
    }

    public void update(MsItemTerrace msItemTerrace) {
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        this.updateUnitItems(msItemTerrace);
        this.updateSpanPitches(sNYEntities, msItemTerrace.getUnits());
        this.updatePartsFigureInfo(msItemTerrace);
    }

    protected void updateUnitItems(MsItemTerrace msItemTerrace) {
        Object object;
        int n;
        List<AbstractTerraceUnitItem> list = msItemTerrace.getUnits();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        LinkedList<TerraceInfo> linkedList = sNYEntities.mTerraceInfoList;
        if (list.size() != 0) {
            for (AbstractTerraceUnitItem abstractTerraceUnitItem : list) {
                abstractTerraceUnitItem.clear();
            }
            list.clear();
        }
        int n2 = 0;
        while (n2 < linkedList.size()) {
            ItemTerraceUnitGeneric itemTerraceUnitGeneric = new ItemTerraceUnitGeneric();
            itemTerraceUnitGeneric.setTerraceItem(msItemTerrace);
            list.add(itemTerraceUnitGeneric);
            ++n2;
        }
        float f = msItemTerrace.getTotalWidthInLength();
        float f2 = -f / 2.0f;
        if (linkedList != null) {
            Iterator iterator = linkedList.iterator();
            n = 0;
            while (n < list.size()) {
                object = (TerraceInfo)iterator.next();
                TerraceInfo terraceInfo = new TerraceInfo();
                ObjectUtil.shallowCopy((Object)object, (Object)terraceInfo);
                list.get(n).setTerraceInfo(terraceInfo);
                ++n;
            }
        }
        float f3 = f2;
        n = 0;
        while (n < linkedList.size()) {
            boolean bl;
            float f4;
            object = list.get(n);
            float f5 = f4 = ((AbstractTerraceUnitItem)((Object)object)).getTerraceInfo().mWidth.floatValue();
            float f6 = f4 / 2.0f;
            boolean bl2 = n > 0;
            boolean bl3 = bl = n < linkedList.size() - 1;
            if (bl2) {
                ((AbstractTerraceUnitItem)((Object)object)).setPrev(list.get(n - 1));
            }
            if (bl) {
                ((AbstractTerraceUnitItem)((Object)object)).setNext(list.get(n + 1));
            }
            ((AbstractTerraceUnitItem)((Object)object)).setCx(f3 + f6);
            f3 += f5;
            ++n;
        }
    }

    private void updateSpanPitches(SNYEntities sNYEntities, List<AbstractTerraceUnitItem> list) {
        int n = 0;
        while (n < list.size()) {
            AbstractTerraceUnitItem abstractTerraceUnitItem = list.get(n);
            TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
            abstractTerraceUnitItem.setPitches(this.mPartsFigureService.calcSpanPitches(sNYEntities, terraceInfo));
            ++n;
        }
    }

    protected void updatePartsFigureInfo(MsItemTerrace msItemTerrace) {
        this.mPartsFigureService.initPartsFigureInfo(msItemTerrace);
    }

    public void updateAfter(MsItemTerrace msItemTerrace, MsPartsTerrace msPartsTerrace) {
        this.mPartsFigureService.initPartsFigureInfoAfter(msItemTerrace, msPartsTerrace);
    }
}

