/*
 * Decompiled with CFR 0.152.
 */
package option.loneterrace.shape.sunnyge.model.sunnyge.service;

import java.util.LinkedList;
import option.gad.core.inject.GdInject;
import option.gad.core.util.GdMutableTypeUtil;
import option.loneterrace.common.dao.cache.type.TypeTerraceDepthCacheDao;
import option.loneterrace.common.dxo.DirectionTypeDxo;
import option.loneterrace.common.dxo.PanelDirectionTypeDxo;
import option.loneterrace.common.entity.BasicInfo;
import option.loneterrace.common.entity.Constants;
import option.loneterrace.common.entity.DomaTileInfo;
import option.loneterrace.common.entity.FloorInfo;
import option.loneterrace.common.entity.PanelCutInfo;
import option.loneterrace.common.entity.PanelInfo;
import option.loneterrace.common.entity.PartsFigureInfo;
import option.loneterrace.common.entity.PartsFigureUnitInfo;
import option.loneterrace.common.entity.SNYEntities;
import option.loneterrace.common.entity.TerraceInfo;
import option.loneterrace.common.entity.TerracesInfo;
import option.loneterrace.common.entity.type.TypeTerraceDepthInfo;
import option.loneterrace.common.service.cut.PanelCutCommonService;
import option.loneterrace.common.service.parts.PartsFigureCommonService;
import option.loneterrace.common.service.parts.TerraceCommonService;
import option.loneterrace.common.service.parts.TerraceFigureCommonService;
import option.loneterrace.common.type.BuildingType;
import option.loneterrace.common.type.DirectionType;
import option.loneterrace.common.type.EnforcementDirType;
import option.loneterrace.common.type.EnforcementType;
import option.loneterrace.common.type.FloorType;
import option.loneterrace.common.type.KetaType;
import option.loneterrace.common.type.OpeningPanelType;
import option.loneterrace.common.type.PanelDirectionType;
import option.loneterrace.common.type.PillarLengthType;
import option.loneterrace.common.type.RanmaType;
import option.loneterrace.common.type.RanmaUseType;
import option.loneterrace.common.type.RoofFigureType;
import option.loneterrace.common.type.SodePosType;
import option.loneterrace.common.type.StrengthType;
import option.loneterrace.common.type.SubProductType;
import option.loneterrace.common.type.TerraceDepthType;
import option.loneterrace.common.type.TerraceHeightType;
import option.loneterrace.common.type.TileUsedType;
import option.loneterrace.common.type.WidthCutType;
import option.loneterrace.shape.sunnyge.model.option.parts.TobukuroNige;
import option.loneterrace.shape.sunnyge.model.sunnyge.creator.PanelDoorCreator;
import option.loneterrace.shape.sunnyge.model.sunnyge.creator.PanelFixCreator;
import option.loneterrace.shape.sunnyge.model.sunnyge.creator.PanelFixFixCreator;
import option.loneterrace.shape.sunnyge.model.sunnyge.creator.PanelHikidoCreator;
import option.loneterrace.shape.sunnyge.model.sunnyge.creator.PanelLouverCreator;
import option.loneterrace.shape.sunnyge.model.sunnyge.creator.PanelLouverFixCreator;
import option.loneterrace.shape.sunnyge.model.sunnyge.creator.PanelRanmaFixCreator;
import option.loneterrace.shape.sunnyge.model.sunnyge.creator.PanelRanmaHikichigaiCreator;
import option.loneterrace.shape.sunnyge.model.sunnyge.creator.PanelSaifuDoorCreator;
import option.loneterrace.shape.sunnyge.model.sunnyge.creator.PanelTakamadoCreator;
import option.loneterrace.shape.sunnyge.model.sunnyge.creator.PanelTakamadoFixCreator;
import option.loneterrace.shape.sunnyge.model.sunnyge.creator.PanelTatesuberidashiCreator;
import option.loneterrace.shape.sunnyge.model.sunnyge.creator.PanelTatesuberidashiFixCreator;
import option.loneterrace.shape.sunnyge.model.sunnyge.creator.PanelTerraceCreator;
import option.loneterrace.shape.sunnyge.model.sunnyge.creator.SNYTerracePanelCreator;
import option.loneterrace.shape.sunnyge.model.sunnyge.item.AbstractTerraceUnitItem;
import option.loneterrace.shape.sunnyge.model.sunnyge.item.MsItemTerrace;
import option.loneterrace.shape.sunnyge.model.sunnyge.parts.AbstractPartsTerraceUnit;
import option.loneterrace.shape.sunnyge.model.sunnyge.parts.MsPartsTerrace;
import option.loneterrace.shape.sunnyge.model.sunnyge.parts.MsPartsTerraceUnitAlumiBalcony;
import option.loneterrace.shape.sunnyge.model.sunnyge.parts.MsPartsTerraceUnitDomaYuka;
import option.loneterrace.shape.sunnyge.model.sunnyge.parts.MsPartsTerraceUnitHalfKakoiYuka;
import option.loneterrace.shape.sunnyge.model.sunnyge.parts.MsPartsTerraceUnitKakoiDoma;
import option.loneterrace.shape.sunnyge.model.sunnyge.parts.MsPartsTerraceUnitKakoiYuka;
import option.loneterrace.shape.sunnyge.model.sunnyge.parts.MsPartsTerraceUnitOpen;
import option.loneterrace.shape.sunnyge.model.sunnyge.parts.MsPartsTerraceUnitTsukuritsuke;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PartsFigureService
extends PartsFigureCommonService {
    @GdInject
    protected Constants mConstants;
    @GdInject
    protected TerraceCommonService mTerraceCommonService;
    @GdInject
    protected TerraceFigureCommonService mTerraceFigureCommonService;
    @GdInject
    protected PanelCutCommonService mPanelCutCommonService;
    @GdInject
    protected TypeTerraceDepthCacheDao mTypeTerraceDepthCacheDao;
    private static final Log mLog = LogFactory.getLog(PartsFigureService.class);
    public static final float ALMI_BALCONY_YANESHITA_TO_FL = 1950.0f;
    public static final float ALMI_BALCONY_STD_UNDER_HEIGHT = 450.0f;
    public static final float ALMI_BALCONY_YUKASHITA_LONG_UNDER_HEIGHT = 1570.0f;
    public static final float ALMI_BALCONY_FL_OPENING_DIFF = 56.0f;
    public static final float RANMA_HEIGHT = 430.0f;
    public static final float LOWER_PANEL_PARTS_HEIGHT = 894.0f;
    public static final float FL_OPENING_DIFF = 50.0f;
    public static final float UPPER_PANEL_PARTS_ADJUSTMENT_HEIGHT = 60.0f;
    public static final float TSUKURITSUKE_BALCONY_OPENING_DIFF = 28.0f;
    public static final float TSUKURITSUKE_BUBUNKAKOI_DOMA_OPENING_DIFF = 68.0f;
    public static final float KUTAIDEHABA_CHIGAI_ADJUSTMENT_WIDTH = 97.5f;

    public void initPartsFigureInfo(MsItemTerrace msItemTerrace) {
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        PartsFigureInfo partsFigureInfo = sNYEntities.mPartsFigureInfo;
        LinkedList<PartsFigureUnitInfo> linkedList = sNYEntities.mPartsFigureUnitInfoList;
        partsFigureInfo.mLeftTarukiOut = Float.valueOf(110.0f);
        partsFigureInfo.mRightTarukiOut = Float.valueOf(110.0f);
        partsFigureInfo.mKutaiKutaiW = Float.valueOf(910.0f);
        partsFigureInfo.mSakaimeTakukiW = Float.valueOf(1820.0f);
        partsFigureInfo.mDirection = terracesInfo.mEnforcementDirType == EnforcementDirType.R;
        partsFigureInfo.mLeftTarukiPillarsin = Float.valueOf(this.calcTarukiPillarsin(basicInfo));
        partsFigureInfo.mRightTarukiPillarsin = Float.valueOf(this.calcTarukiPillarsin(basicInfo));
        partsFigureInfo.mTarukiOutOut = Float.valueOf(1840.0f);
        partsFigureInfo.mLeftTanbuTarukiKutai = Float.valueOf(300.0f);
        partsFigureInfo.mRightTanbuTarukiKutai = Float.valueOf(300.0f);
        partsFigureInfo.mTarukiMaewakuDwH = Float.valueOf(0.0f);
        partsFigureInfo.mTarukiTatewakuDwH = Float.valueOf(0.0f);
        partsFigureInfo.mPillarType = 0;
        partsFigureInfo.mSlopeAngle = Float.valueOf(35.0f);
        partsFigureInfo.mLeftTerasuOutPillarsin = Float.valueOf(0.0f);
        partsFigureInfo.mRightTerasuOutPillarsin = Float.valueOf(0.0f);
        partsFigureInfo.mTooshiHeight = Float.valueOf(0.0f);
        partsFigureInfo.mWallHeightOffsetHeight = Float.valueOf(0.0f);
        partsFigureInfo.mBottomHeight = Float.valueOf(this.getFrontPoleBottmHeight(msItemTerrace));
        partsFigureInfo.mYukaHeight = Float.valueOf(this.getYukaHeight(msItemTerrace));
        partsFigureInfo.mYukaLevelHeight = Float.valueOf(this.getYukaLevel(msItemTerrace));
        partsFigureInfo.mKutaiUniversalPillarHeight1 = Float.valueOf(2080.0f);
        if (basicInfo.mSubProductType == SubProductType.TSUKURITSUKE) {
            partsFigureInfo.mKutaiUniversalPillarDepth1 = Float.valueOf(terracesInfo.mDepth.floatValue() - 300.0f);
        } else {
            partsFigureInfo.mKutaiUniversalPillarDepth1 = Float.valueOf(1185.0f);
            partsFigureInfo.mKutaiUniversalPillarHeight1 = terracesInfo.mHeight;
        }
        partsFigureInfo.mNokiHeight = Float.valueOf(this.getNokiHeight(msItemTerrace));
        partsFigureInfo.mTooshiHeight = Float.valueOf(this.getMaewakuMatoohiHeight(sNYEntities));
        partsFigureInfo.mHokyouKetaHeight = Float.valueOf(0.0f);
        partsFigureInfo.mKutaiPillarCoreDepth = terracesInfo.mDepth;
        partsFigureInfo.mKutaiUniversalPillarDepth2 = Float.valueOf(300.0f);
        partsFigureInfo.mKutaiUniversalPillarHeight2 = Float.valueOf(0.0f);
        partsFigureInfo.mHeight = Float.valueOf(this.getFrontPoleHeight(msItemTerrace));
        partsFigureInfo.mWallHeight = Float.valueOf(this.getWallHeight(msItemTerrace));
        partsFigureInfo.mTarukiMaewakuDwH = Float.valueOf(0.0f);
        partsFigureInfo.mTarukiTatewakuDwH = Float.valueOf(0.0f);
        partsFigureInfo.mGroundLevel = Float.valueOf(this.calcGroundLevel(sNYEntities));
        partsFigureInfo.mDomaLevel = Float.valueOf(this.calcDomaLevel(sNYEntities));
        partsFigureInfo.mFloorLevel = Float.valueOf(this.calcFloorLevel(sNYEntities));
        partsFigureInfo.mOpeningLevel = Float.valueOf(this.calcFrontOpeningLevel(sNYEntities, 0, null));
        partsFigureInfo.mRanmaLevel = Float.valueOf(this.calcRanmaLevel(sNYEntities));
        partsFigureInfo.mBalconyHeight = Float.valueOf(this.calcBalconyHeight(sNYEntities));
        partsFigureInfo.mUnderHeight = Float.valueOf(this.calcUnderHeight(sNYEntities));
        partsFigureInfo.mRanmaHeight = Float.valueOf(this.calcRanmaHeight());
        partsFigureInfo.mMaeketaShitaToTop = Float.valueOf(this.calcMaeketaShitaToTop(sNYEntities, null, null));
        partsFigureInfo.mMaeketaShitaToGL = Float.valueOf(this.calcMaeketaShitaToGL(sNYEntities));
        partsFigureInfo.mMaeketaShitaToDL = Float.valueOf(this.calcMaeketaShitaToDoma(sNYEntities));
        partsFigureInfo.mMaeketaShitaToFL = Float.valueOf(this.calcMaeketaShitaToFL(sNYEntities, 0, null));
        partsFigureInfo.mLeftMaeketaShitaToFL = Float.valueOf(this.calcMaeketaShitaToFL(sNYEntities, 0, DirectionType.LEFT));
        partsFigureInfo.mRightMaeketaShitaToFL = Float.valueOf(this.calcMaeketaShitaToFL(sNYEntities, 0, DirectionType.RIGHT));
        partsFigureInfo.mFrontOpeningHeight = Float.valueOf(this.calcFrontOpeningHeight(sNYEntities, 0, null));
        partsFigureInfo.mLeftFrontOpeningHeight = Float.valueOf(this.calcFrontOpeningHeight(sNYEntities, 0, DirectionType.LEFT));
        partsFigureInfo.mRightFrontOpeningHeight = Float.valueOf(this.calcFrontOpeningHeight(sNYEntities, 0, DirectionType.RIGHT));
        partsFigureInfo.mLeftSideOpeningHeight = Float.valueOf(this.calcSideOpeningHeight(sNYEntities, 0, PanelDirectionType.LEFT));
        partsFigureInfo.mRightSideOpeningHeight = Float.valueOf(this.calcSideOpeningHeight(sNYEntities, 0, PanelDirectionType.RIGHT));
        mLog.debug((Object)("partsFigureInfo.mGroundLevel[" + partsFigureInfo.mGroundLevel + "]"));
        mLog.debug((Object)("partsFigureInfo.mDomaLevel[" + partsFigureInfo.mDomaLevel + "]"));
        mLog.debug((Object)("partsFigureInfo.mFloorLevel[" + partsFigureInfo.mFloorLevel + "]"));
        mLog.debug((Object)("partsFigureInfo.mOpeningLevel[" + partsFigureInfo.mOpeningLevel + "]"));
        mLog.debug((Object)("partsFigureInfo.mRanmaLevel[" + partsFigureInfo.mRanmaLevel + "]"));
        mLog.debug((Object)("partsFigureInfo.mBalconyHeight[" + partsFigureInfo.mBalconyHeight + "]"));
        mLog.debug((Object)("partsFigureInfo.mUnderHeight[" + partsFigureInfo.mUnderHeight + "]"));
        mLog.debug((Object)("partsFigureInfo.mRanmaHeight[" + partsFigureInfo.mRanmaHeight + "]"));
        mLog.debug((Object)("partsFigureInfo.mMaeketaShitaToTop[" + partsFigureInfo.mMaeketaShitaToTop + "]"));
        mLog.debug((Object)("partsFigureInfo.mMaeketaShitaToGL[" + partsFigureInfo.mMaeketaShitaToGL + "]"));
        mLog.debug((Object)("partsFigureInfo.mMaeketaShitaToDL[" + partsFigureInfo.mMaeketaShitaToDL + "]"));
        mLog.debug((Object)("partsFigureInfo.mMaeketaShitaToFL[" + partsFigureInfo.mMaeketaShitaToFL + "]"));
        mLog.debug((Object)("partsFigureInfo.mLeftMaeketaShitaToFL[" + partsFigureInfo.mLeftMaeketaShitaToFL + "]"));
        mLog.debug((Object)("partsFigureInfo.mRightMaeketaShitaToFL[" + partsFigureInfo.mRightMaeketaShitaToFL + "]"));
        mLog.debug((Object)("partsFigureInfo.mFrontOpeningHeight[" + partsFigureInfo.mFrontOpeningHeight + "]"));
        mLog.debug((Object)("partsFigureInfo.mLeftFrontOpeningHeight[" + partsFigureInfo.mLeftFrontOpeningHeight + "]"));
        mLog.debug((Object)("partsFigureInfo.mRightFrontOpeningHeight[" + partsFigureInfo.mRightFrontOpeningHeight + "]"));
        mLog.debug((Object)("partsFigureInfo.mLeftSideOpeningHeight[" + partsFigureInfo.mLeftSideOpeningHeight + "]"));
        mLog.debug((Object)("partsFigureInfo.mRightSideOpeningHeight[" + partsFigureInfo.mRightSideOpeningHeight + "]"));
        mLog.debug((Object)("partsFigureUnitInfoList[" + linkedList.size() + "]"));
        for (AbstractTerraceUnitItem abstractTerraceUnitItem : msItemTerrace.getUnits()) {
            TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
            if (terraceInfo.mBuildingType == BuildingType.BALCONY) continue;
            PartsFigureUnitInfo partsFigureUnitInfo = this.findOnePartsFigureUnitInfo(linkedList, terraceInfo);
            mLog.debug((Object)("terraceInfo.mId[" + terraceInfo.mId + "] partsFigureUnitInfo[" + partsFigureUnitInfo + "]"));
            partsFigureInfo.mTarukiOutOut = Float.valueOf(terraceInfo.mWidth.floatValue() + 20.0f);
            partsFigureInfo.mLeftTarukiOut = Float.valueOf(terraceInfo.mWidth.floatValue() / 2.0f);
            partsFigureInfo.mRightTarukiOut = Float.valueOf(terraceInfo.mWidth.floatValue() / 2.0f);
            double d = 0.0;
            d = basicInfo.mRoofFigureType == RoofFigureType.R ? Math.tan(Math.toRadians(10.0)) : Math.tan(Math.toRadians(10.0));
            if (terracesInfo.mEnforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI) {
                if (terraceInfo.mIsMaster.booleanValue()) {
                    Float f = partsFigureInfo.mKutaiKutaiW;
                    boolean bl = terracesInfo.mEnforcementDirType == EnforcementDirType.R;
                    f = bl ? Float.valueOf(terraceInfo.mDepth.floatValue() - terraceInfo.mRightDepth.floatValue()) : Float.valueOf(terraceInfo.mDepth.floatValue() - terraceInfo.mLeftDepth.floatValue());
                    partsFigureInfo.mLeftPillarHeight = partsFigureInfo.mRightPillarHeight = Float.valueOf(partsFigureInfo.mHeight.floatValue() - sNYEntities.mFloorInfo.mFloorLevel.floatValue() - this.calcDomaLevel(sNYEntities));
                    if (bl) {
                        partsFigureInfo.mLeftWallHeight = Float.valueOf(partsFigureInfo.mWallHeight.floatValue() + partsFigureInfo.mTooshiHeight.floatValue());
                        partsFigureInfo.mLeftPillarDepth = terraceInfo.mDepth;
                        partsFigureInfo.mLeftFrontDepth = Float.valueOf(terraceInfo.mDepth.floatValue() + 90.0f);
                        partsFigureInfo.mRightWallHeight = Float.valueOf(partsFigureInfo.mWallHeight.floatValue() - (float)Math.ceil((double)f.floatValue() * d) + partsFigureInfo.mTooshiHeight.floatValue());
                        partsFigureInfo.mRightPillarDepth = terraceInfo.mRightDepth;
                        partsFigureInfo.mRightFrontDepth = Float.valueOf(terraceInfo.mRightDepth.floatValue() + 90.0f);
                    } else {
                        partsFigureInfo.mLeftWallHeight = Float.valueOf(partsFigureInfo.mWallHeight.floatValue() - (float)Math.ceil((double)f.floatValue() * d) + partsFigureInfo.mTooshiHeight.floatValue());
                        partsFigureInfo.mLeftPillarDepth = terraceInfo.mLeftDepth;
                        partsFigureInfo.mLeftFrontDepth = Float.valueOf(terraceInfo.mLeftDepth.floatValue() + 90.0f);
                        partsFigureInfo.mRightWallHeight = Float.valueOf(partsFigureInfo.mWallHeight.floatValue() + partsFigureInfo.mTooshiHeight.floatValue());
                        partsFigureInfo.mRightPillarDepth = terraceInfo.mDepth;
                        partsFigureInfo.mRightFrontDepth = Float.valueOf(terraceInfo.mDepth.floatValue() + 90.0f);
                    }
                }
            } else {
                if (sNYEntities.mTerraceInfoList.getFirst().mId == terraceInfo.mId) {
                    partsFigureInfo.mLeftWallHeight = Float.valueOf(partsFigureInfo.mWallHeight.floatValue() + partsFigureInfo.mTooshiHeight.floatValue() - sNYEntities.mFloorInfo.mFloorLevel.floatValue() - this.calcDomaLevel(sNYEntities));
                    partsFigureInfo.mLeftPillarHeight = Float.valueOf(0.0f);
                    partsFigureInfo.mLeftPillarDepth = Float.valueOf(0.0f);
                    partsFigureInfo.mLeftFrontDepth = Float.valueOf(0.0f);
                    if (terracesInfo.mSodePosType != SodePosType.L && terracesInfo.mSodePosType != SodePosType.BOTH) {
                        partsFigureInfo.mLeftPillarDepth = terraceInfo.mDepth;
                        partsFigureInfo.mLeftPillarHeight = Float.valueOf(partsFigureInfo.mHeight.floatValue() - sNYEntities.mFloorInfo.mFloorLevel.floatValue() - this.calcDomaLevel(sNYEntities));
                        partsFigureInfo.mLeftFrontDepth = Float.valueOf(terraceInfo.mDepth.floatValue() + 90.0f);
                    }
                }
                if (sNYEntities.mTerraceInfoList.getLast().mId == terraceInfo.mId) {
                    partsFigureInfo.mRightWallHeight = Float.valueOf(partsFigureInfo.mWallHeight.floatValue() + partsFigureInfo.mTooshiHeight.floatValue() - sNYEntities.mFloorInfo.mFloorLevel.floatValue() - this.calcDomaLevel(sNYEntities));
                    partsFigureInfo.mRightPillarHeight = Float.valueOf(0.0f);
                    partsFigureInfo.mRightPillarDepth = Float.valueOf(0.0f);
                    partsFigureInfo.mRightFrontDepth = Float.valueOf(0.0f);
                    if (terracesInfo.mSodePosType != SodePosType.R && terracesInfo.mSodePosType != SodePosType.BOTH) {
                        partsFigureInfo.mRightPillarDepth = terraceInfo.mDepth;
                        partsFigureInfo.mRightPillarHeight = Float.valueOf(partsFigureInfo.mHeight.floatValue() - sNYEntities.mFloorInfo.mFloorLevel.floatValue() - this.calcDomaLevel(sNYEntities));
                        partsFigureInfo.mRightFrontDepth = Float.valueOf(terraceInfo.mDepth.floatValue() + 90.0f);
                    }
                }
            }
            abstractTerraceUnitItem.setTerraceInfo(terraceInfo);
            if (partsFigureUnitInfo == null) continue;
            partsFigureUnitInfo.mFrontOpeningLevel = Float.valueOf(this.calcFrontOpeningLevel(sNYEntities, terraceInfo.mId, null));
            partsFigureUnitInfo.mLeftFrontOpeningLevel = Float.valueOf(this.calcFrontOpeningLevel(sNYEntities, terraceInfo.mId, DirectionType.LEFT));
            partsFigureUnitInfo.mRightFrontOpeningLevel = Float.valueOf(this.calcFrontOpeningLevel(sNYEntities, terraceInfo.mId, DirectionType.RIGHT));
            partsFigureUnitInfo.mLeftSideOpeningLevel = Float.valueOf(this.calcSideOpeningLevel(sNYEntities, (int)terraceInfo.mId, DirectionType.LEFT));
            partsFigureUnitInfo.mRightSideOpeningLevel = Float.valueOf(this.calcSideOpeningLevel(sNYEntities, (int)terraceInfo.mId, DirectionType.RIGHT));
            partsFigureUnitInfo.mSideFrontOpeningLevel = Float.valueOf(this.calcSideOpeningLevel(sNYEntities, (int)terraceInfo.mId, PanelDirectionType.FRONT));
            partsFigureUnitInfo.mSideBackOpeningLevel = Float.valueOf(this.calcSideOpeningLevel(sNYEntities, (int)terraceInfo.mId, PanelDirectionType.REAR));
            partsFigureUnitInfo.mMaeketaShitaToTop = Float.valueOf(this.calcMaeketaShitaToTop(sNYEntities, terraceInfo, null));
            partsFigureUnitInfo.mLeftMaeketaShitaToTop = Float.valueOf(this.calcMaeketaShitaToTop(sNYEntities, terraceInfo, DirectionType.LEFT));
            partsFigureUnitInfo.mRightMaeketaShitaToTop = Float.valueOf(this.calcMaeketaShitaToTop(sNYEntities, terraceInfo, DirectionType.RIGHT));
            partsFigureUnitInfo.mMaeketaShitaToFL = Float.valueOf(this.calcMaeketaShitaToFL(sNYEntities, terraceInfo.mId, null));
            partsFigureUnitInfo.mLeftMaeketaShitaToFL = Float.valueOf(this.calcMaeketaShitaToFL(sNYEntities, terraceInfo.mId, DirectionType.LEFT));
            partsFigureUnitInfo.mRightMaeketaShitaToFL = Float.valueOf(this.calcMaeketaShitaToFL(sNYEntities, terraceInfo.mId, DirectionType.RIGHT));
            partsFigureUnitInfo.mFrontOpeningHeight = Float.valueOf(this.calcFrontOpeningHeight(sNYEntities, terraceInfo.mId, null));
            partsFigureUnitInfo.mLeftFrontOpeningHeight = Float.valueOf(this.calcFrontOpeningHeight(sNYEntities, terraceInfo.mId, DirectionType.LEFT));
            partsFigureUnitInfo.mRightFrontOpeningHeight = Float.valueOf(this.calcFrontOpeningHeight(sNYEntities, terraceInfo.mId, DirectionType.RIGHT));
            partsFigureUnitInfo.mLeftSideOpeningHeight = Float.valueOf(this.calcSideOpeningHeight(sNYEntities, terraceInfo.mId, PanelDirectionType.LEFT));
            partsFigureUnitInfo.mRightSideOpeningHeight = Float.valueOf(this.calcSideOpeningHeight(sNYEntities, terraceInfo.mId, PanelDirectionType.RIGHT));
            partsFigureUnitInfo.mSideFrontOpeningHeight = Float.valueOf(this.calcSideOpeningHeight(sNYEntities, terraceInfo.mId, PanelDirectionType.FRONT));
            partsFigureUnitInfo.mSideBackOpeningHeight = Float.valueOf(this.calcSideOpeningHeight(sNYEntities, terraceInfo.mId, PanelDirectionType.REAR));
            partsFigureUnitInfo.mFrontOpeningWidth = Float.valueOf(this.calcFrontOpeningWidth(sNYEntities, terraceInfo, null));
            partsFigureUnitInfo.mLeftFrontOpeningWidth = Float.valueOf(this.calcFrontOpeningWidth(sNYEntities, terraceInfo, DirectionType.LEFT));
            partsFigureUnitInfo.mRightFrontOpeningWidth = Float.valueOf(this.calcFrontOpeningWidth(sNYEntities, terraceInfo, DirectionType.RIGHT));
            partsFigureUnitInfo.mLeftSideOpeningWidth = Float.valueOf(this.calcSideOpeningWidth(sNYEntities, terraceInfo, PanelDirectionType.LEFT));
            partsFigureUnitInfo.mRightSideOpeningWidth = Float.valueOf(this.calcSideOpeningWidth(sNYEntities, terraceInfo, PanelDirectionType.RIGHT));
            partsFigureUnitInfo.mSideFrontOpeningWidth = Float.valueOf(this.calcSideOpeningWidth(sNYEntities, terraceInfo, PanelDirectionType.FRONT));
            partsFigureUnitInfo.mSideBackOpeningWidth = Float.valueOf(this.calcSideOpeningWidth(sNYEntities, terraceInfo, PanelDirectionType.REAR));
            partsFigureUnitInfo.mLeftKutaiDehabaWidth = Float.valueOf(this.calcKutaiDehabaWidth(sNYEntities, terraceInfo, PanelDirectionType.LEFT));
            partsFigureUnitInfo.mRightKutaiDehabaWidth = Float.valueOf(this.calcKutaiDehabaWidth(sNYEntities, terraceInfo, PanelDirectionType.RIGHT));
            mLog.debug((Object)("terraceInfo.mId[" + terraceInfo.mId + "] partsFigureUnitInfo.mFrontOpeningLevel[" + partsFigureUnitInfo.mFrontOpeningLevel + "]"));
            mLog.debug((Object)("terraceInfo.mId[" + terraceInfo.mId + "] partsFigureUnitInfo.mLeftFrontOpeningLevel[" + partsFigureUnitInfo.mLeftFrontOpeningLevel + "]"));
            mLog.debug((Object)("terraceInfo.mId[" + terraceInfo.mId + "] partsFigureUnitInfo.mRightFrontOpeningLevel[" + partsFigureUnitInfo.mRightFrontOpeningLevel + "]"));
            mLog.debug((Object)("terraceInfo.mId[" + terraceInfo.mId + "] partsFigureUnitInfo.mLeftSideOpeningLevel[" + partsFigureUnitInfo.mLeftSideOpeningLevel + "]"));
            mLog.debug((Object)("terraceInfo.mId[" + terraceInfo.mId + "] partsFigureUnitInfo.mRightSideOpeningLevel[" + partsFigureUnitInfo.mRightSideOpeningLevel + "]"));
            mLog.debug((Object)("terraceInfo.mId[" + terraceInfo.mId + "] partsFigureUnitInfo.mSideFrontOpeningLevel[" + partsFigureUnitInfo.mSideFrontOpeningLevel + "]"));
            mLog.debug((Object)("terraceInfo.mId[" + terraceInfo.mId + "] partsFigureUnitInfo.mSideBackOpeningLevel[" + partsFigureUnitInfo.mSideBackOpeningLevel + "]"));
            mLog.debug((Object)("terraceInfo.mId[" + terraceInfo.mId + "] partsFigureUnitInfo.mMaeketaShitaToTop[" + partsFigureUnitInfo.mMaeketaShitaToTop + "]"));
            mLog.debug((Object)("terraceInfo.mId[" + terraceInfo.mId + "] partsFigureUnitInfo.mLeftMaeketaShitaToTop[" + partsFigureUnitInfo.mLeftMaeketaShitaToTop + "]"));
            mLog.debug((Object)("terraceInfo.mId[" + terraceInfo.mId + "] partsFigureUnitInfo.mRightMaeketaShitaToTop[" + partsFigureUnitInfo.mRightMaeketaShitaToTop + "]"));
            mLog.debug((Object)("terraceInfo.mId[" + terraceInfo.mId + "] partsFigureUnitInfo.mMaeketaShitaToFL[" + partsFigureUnitInfo.mMaeketaShitaToFL + "]"));
            mLog.debug((Object)("terraceInfo.mId[" + terraceInfo.mId + "] partsFigureUnitInfo.mLeftMaeketaShitaToFL[" + partsFigureUnitInfo.mLeftMaeketaShitaToFL + "]"));
            mLog.debug((Object)("terraceInfo.mId[" + terraceInfo.mId + "] partsFigureUnitInfo.mRightMaeketaShitaToFL[" + partsFigureUnitInfo.mRightMaeketaShitaToFL + "]"));
            mLog.debug((Object)("terraceInfo.mId[" + terraceInfo.mId + "] partsFigureUnitInfo.mFrontOpeningHeight[" + partsFigureUnitInfo.mFrontOpeningHeight + "]"));
            mLog.debug((Object)("terraceInfo.mId[" + terraceInfo.mId + "] partsFigureUnitInfo.mLeftFrontOpeningHeight[" + partsFigureUnitInfo.mLeftFrontOpeningHeight + "]"));
            mLog.debug((Object)("terraceInfo.mId[" + terraceInfo.mId + "] partsFigureUnitInfo.mRightFrontOpeningHeight[" + partsFigureUnitInfo.mRightFrontOpeningHeight + "]"));
            mLog.debug((Object)("terraceInfo.mId[" + terraceInfo.mId + "] partsFigureUnitInfo.mLeftSideOpeningHeight[" + partsFigureUnitInfo.mLeftSideOpeningHeight + "]"));
            mLog.debug((Object)("terraceInfo.mId[" + terraceInfo.mId + "] partsFigureUnitInfo.mRightSideOpeningHeight[" + partsFigureUnitInfo.mRightSideOpeningHeight + "]"));
            mLog.debug((Object)("terraceInfo.mId[" + terraceInfo.mId + "] partsFigureUnitInfo.mSideFrontOpeningHeight[" + partsFigureUnitInfo.mSideFrontOpeningHeight + "]"));
            mLog.debug((Object)("terraceInfo.mId[" + terraceInfo.mId + "] partsFigureUnitInfo.mSideBackOpeningHeight[" + partsFigureUnitInfo.mSideBackOpeningHeight + "]"));
            mLog.debug((Object)("terraceInfo.mId[" + terraceInfo.mId + "] partsFigureUnitInfo.mFrontOpeningWidth[" + partsFigureUnitInfo.mFrontOpeningWidth + "]"));
            mLog.debug((Object)("terraceInfo.mId[" + terraceInfo.mId + "] partsFigureUnitInfo.mLeftFrontOpeningWidth[" + partsFigureUnitInfo.mLeftFrontOpeningWidth + "]"));
            mLog.debug((Object)("terraceInfo.mId[" + terraceInfo.mId + "] partsFigureUnitInfo.mRightFrontOpeningWidth[" + partsFigureUnitInfo.mRightFrontOpeningWidth + "]"));
            mLog.debug((Object)("terraceInfo.mId[" + terraceInfo.mId + "] partsFigureUnitInfo.mLeftSideOpeningWidth[" + partsFigureUnitInfo.mLeftSideOpeningWidth + "]"));
            mLog.debug((Object)("terraceInfo.mId[" + terraceInfo.mId + "] partsFigureUnitInfo.mRightSideOpeningWidth[" + partsFigureUnitInfo.mRightSideOpeningWidth + "]"));
            mLog.debug((Object)("terraceInfo.mId[" + terraceInfo.mId + "] partsFigureUnitInfo.mSideFrontOpeningWidth[" + partsFigureUnitInfo.mSideFrontOpeningWidth + "]"));
            mLog.debug((Object)("terraceInfo.mId[" + terraceInfo.mId + "] partsFigureUnitInfo.mSideBackOpeningWidth[" + partsFigureUnitInfo.mSideBackOpeningWidth + "]"));
            mLog.debug((Object)("terraceInfo.mId[" + terraceInfo.mId + "] partsFigureUnitInfo.mLeftKutaiDehabaWidth[" + partsFigureUnitInfo.mLeftKutaiDehabaWidth + "]"));
            mLog.debug((Object)("terraceInfo.mId[" + terraceInfo.mId + "] partsFigureUnitInfo.mRightKutaiDehabaWidth[" + partsFigureUnitInfo.mRightKutaiDehabaWidth + "]"));
        }
    }

    public void initPartsFigureInfoAfter(MsItemTerrace msItemTerrace, MsPartsTerrace msPartsTerrace) {
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        PartsFigureInfo cfr_ignored_0 = sNYEntities.mPartsFigureInfo;
        LinkedList<PartsFigureUnitInfo> cfr_ignored_1 = sNYEntities.mPartsFigureUnitInfoList;
    }

    public PartsUnitType getUnitType(SNYEntities sNYEntities) {
        RoofFigureType roofFigureType = sNYEntities.mBasicInfo.mRoofFigureType;
        if (roofFigureType == RoofFigureType.F) {
            return PartsUnitType.F;
        }
        if (roofFigureType == RoofFigureType.R) {
            return PartsUnitType.R;
        }
        return PartsUnitType.F;
    }

    public boolean isJizaiketa(SNYEntities sNYEntities) {
        if (sNYEntities.mBasicInfo.mKetaType == KetaType.FREE) {
            return true;
        }
        return sNYEntities.mBasicInfo.mSubProductType == SubProductType.HALF_KAKOI;
    }

    public AbstractPartsTerraceUnit createPartsUnit(SNYEntities sNYEntities) {
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.DOMA) {
            return new MsPartsTerraceUnitKakoiDoma();
        }
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.YUKA) {
            return new MsPartsTerraceUnitKakoiYuka();
        }
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.HALF_KAKOI) {
            return new MsPartsTerraceUnitHalfKakoiYuka();
        }
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.OPEN) {
            return new MsPartsTerraceUnitOpen();
        }
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.TSUKURITSUKE) {
            return new MsPartsTerraceUnitTsukuritsuke();
        }
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.ALMI_BALCONY_PILLAR) {
            return new MsPartsTerraceUnitAlumiBalcony();
        }
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.ALMI_BALCONY_ROOF) {
            return new MsPartsTerraceUnitAlumiBalcony();
        }
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.DOMA_YUKA) {
            return new MsPartsTerraceUnitDomaYuka();
        }
        SubProductType cfr_ignored_0 = sNYEntities.mBasicInfo.mSubProductType;
        return null;
    }

    public int getFloorNum(SNYEntities sNYEntities) {
        if (sNYEntities.mBasicInfo.mFloorNum != null) {
            return sNYEntities.mBasicInfo.mFloorNum;
        }
        return 1;
    }

    public float getMaewakuMatoohiHeight(SNYEntities sNYEntities) {
        float f = 0.0f;
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.HALF_KAKOI || sNYEntities.mBasicInfo.mSubProductType == SubProductType.OPEN) {
            f = sNYEntities.mBasicInfo.mStrengthType == StrengthType.T600 ? 0.0f : 45.0f;
        } else {
            f = 60.0f;
            if (sNYEntities.mBasicInfo.mStrengthType != StrengthType.T600) {
                f = sNYEntities.mBasicInfo.mRoofFigureType == RoofFigureType.F ? (f += 20.0f) : (f += 35.0f);
            }
        }
        return f;
    }

    public float calcDehabaCutOffsetHeight(TerracesInfo terracesInfo) {
        float f = 0.0f;
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneStdByType(terracesInfo.mDepthType);
        if (typeTerraceDepthInfo.length != terracesInfo.mDepth) {
            f = (terracesInfo.mDepth.floatValue() - typeTerraceDepthInfo.length.floatValue()) * (float)Math.tan(Math.toRadians(10.0));
        }
        return f;
    }

    public TerraceDepthType getDepthType(TerraceDepthType terraceDepthType, Float f) {
        TerraceDepthType[] terraceDepthTypeArray;
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneStdByType(terraceDepthType);
        if (typeTerraceDepthInfo.length == f) {
            return terraceDepthType;
        }
        TerraceDepthType[] terraceDepthTypeArray2 = terraceDepthTypeArray = new TerraceDepthType[]{TerraceDepthType.T3, TerraceDepthType.T4, TerraceDepthType.T5, TerraceDepthType.T6, TerraceDepthType.T7, TerraceDepthType.T8, TerraceDepthType.T9, TerraceDepthType.T10};
        int n = terraceDepthTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TerraceDepthType terraceDepthType2 = terraceDepthTypeArray2[n2];
            typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneStdByType(terraceDepthType2);
            if (typeTerraceDepthInfo != null && (typeTerraceDepthInfo.length.floatValue() > 0.0f ? f.floatValue() <= typeTerraceDepthInfo.length.floatValue() && f.floatValue() > typeTerraceDepthInfo.minLength.floatValue() : typeTerraceDepthInfo.length.floatValue() > 0.0f && f.floatValue() <= typeTerraceDepthInfo.length.floatValue() && f.floatValue() > typeTerraceDepthInfo.minLength.floatValue())) {
                return terraceDepthType2;
            }
            ++n2;
        }
        return terraceDepthType;
    }

    public float getFrontPoleHeight(MsItemTerrace msItemTerrace) {
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        PartsUnitType partsUnitType = this.getUnitType(sNYEntities);
        float f = this.calcDomaLevel(sNYEntities) + terracesInfo.mHeight.floatValue();
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.HALF_KAKOI) {
            if (partsUnitType == PartsUnitType.F) {
                if (terracesInfo.mDepthType == TerraceDepthType.T6) {
                    f = terracesInfo.mHeight.floatValue() - 16.5f;
                } else if (terracesInfo.mDepthType == TerraceDepthType.T7) {
                    f = terracesInfo.mHeight.floatValue() - 69.5f;
                }
            }
            TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneStdByType(sNYEntities.mTerracesInfo.mDepthType);
            if (typeTerraceDepthInfo.length != sNYEntities.mTerracesInfo.mDepth) {
                f += (typeTerraceDepthInfo.length.floatValue() - sNYEntities.mTerracesInfo.mDepth.floatValue()) * (float)Math.tan(Math.toRadians(10.0));
            }
        } else if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.OPEN) {
            if (sNYEntities.mBasicInfo.mStrengthType == StrengthType.T600) {
                if (terracesInfo.mDepthType == TerraceDepthType.T6) {
                    f += -16.0f;
                } else if (terracesInfo.mDepthType == TerraceDepthType.T7) {
                    f += -69.0f;
                }
            } else if (terracesInfo.mDepthType == TerraceDepthType.T6) {
                f += 4.0f;
            } else if (terracesInfo.mDepthType == TerraceDepthType.T7) {
                f += -49.0f;
            }
            TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneStdByType(sNYEntities.mTerracesInfo.mDepthType);
            if (typeTerraceDepthInfo.length != sNYEntities.mTerracesInfo.mDepth) {
                f += (typeTerraceDepthInfo.length.floatValue() - sNYEntities.mTerracesInfo.mDepth.floatValue()) * (float)Math.tan(Math.toRadians(10.0));
            }
        } else if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.TSUKURITSUKE) {
            f = this.getNokiHeight(msItemTerrace);
        } else if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.ALMI_BALCONY_PILLAR || sNYEntities.mBasicInfo.mSubProductType == SubProductType.ALMI_BALCONY_ROOF) {
            f = this.getNokiHeight(msItemTerrace);
        }
        return f;
    }

    @Deprecated
    public static float getGL(SNYEntities sNYEntities) {
        float f = 0.0f;
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.DOMA && sNYEntities.mDomaTileInfo != null && sNYEntities.mDomaTileInfo.mTileUsedType == TileUsedType.ON) {
            f = sNYEntities.mDomaTileInfo.mFloorLevel.floatValue();
        }
        return f;
    }

    public float getFrontPoleBottmHeight(MsItemTerrace msItemTerrace) {
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        float f = this.calcDomaLevel(sNYEntities);
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.TSUKURITSUKE && terracesInfo.mEnforcementType == EnforcementType.BUBUN_KAKOI) {
            f = terracesInfo.mHeight.floatValue() - terracesInfo.mOpeningHeight.floatValue();
        }
        return f;
    }

    public float getWallHeight(MsItemTerrace msItemTerrace) {
        return this.getWallHeight(msItemTerrace.getEntities());
    }

    public float getWallHeight(SNYEntities sNYEntities) {
        float f;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        KetaType ketaType = sNYEntities.mBasicInfo.mKetaType == null ? KetaType.STD : sNYEntities.mBasicInfo.mKetaType;
        PartsUnitType partsUnitType = this.getUnitType(sNYEntities);
        float f2 = this.calcDomaLevel(sNYEntities) + sNYEntities.mTerracesInfo.mHeight.floatValue();
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.HALF_KAKOI) {
            f2 += 391.18f;
        } else if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.OPEN) {
            f2 = sNYEntities.mBasicInfo.mStrengthType == StrengthType.T600 ? (f2 += 391.0f) : (f2 += 411.0f);
        } else if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.TSUKURITSUKE || sNYEntities.mBasicInfo.mSubProductType == SubProductType.ALMI_BALCONY_PILLAR || sNYEntities.mBasicInfo.mSubProductType == SubProductType.ALMI_BALCONY_ROOF) {
            f = this.getNokiHeight(sNYEntities);
            if (sNYEntities.mBasicInfo.mKetaType == KetaType.STD) {
                if (partsUnitType == PartsUnitType.F) {
                    f2 = f + this.getBalconyWallOffsetHeightTypeF(terracesInfo.mDepthType);
                } else if (partsUnitType == PartsUnitType.R) {
                    f2 = f + this.getBalconyWallOffsetHeightTypeR(terracesInfo.mDepthType);
                }
            } else if (sNYEntities.mBasicInfo.mKetaType == KetaType.FREE) {
                if (partsUnitType == PartsUnitType.F) {
                    f2 = f + this.getBalconyWallOffsetHeightFreeTypeF(terracesInfo.mDepthType, sNYEntities.mBasicInfo.mStrengthType);
                } else if (partsUnitType == PartsUnitType.R) {
                    f2 = f + this.getBalconyWallOffsetHeightFreeTypeR(terracesInfo.mDepthType, sNYEntities.mBasicInfo.mStrengthType);
                }
            }
        } else if (partsUnitType == PartsUnitType.F) {
            if (ketaType == KetaType.STD) {
                f2 += this.getWallOffsetHeightTypeF(sNYEntities.mTerracesInfo.mDepthType);
            } else if (ketaType == KetaType.FREE) {
                f2 += this.getWallOffsetHeightFreeTypeF(sNYEntities.mTerracesInfo.mDepthType);
            }
        } else if (partsUnitType == PartsUnitType.R) {
            if (ketaType == KetaType.STD) {
                f2 += this.getWallOffsetHeightTypeR(sNYEntities.mTerracesInfo.mDepthType);
            } else if (ketaType == KetaType.FREE) {
                f2 += this.getWallOffsetHeightFreeTypeR(sNYEntities.mTerracesInfo.mDepthType);
            }
        }
        f = this.calcDehabaCutOffsetHeight(sNYEntities.mTerracesInfo);
        return f2 += f;
    }

    protected float getBalconyWallOffsetHeight(RoofFigureType roofFigureType, TerraceDepthType terraceDepthType) {
        float f = 0.0f;
        if (roofFigureType == RoofFigureType.F) {
            f = this.getBalconyWallOffsetHeightTypeF(terraceDepthType);
        } else if (roofFigureType == RoofFigureType.R) {
            f = this.getBalconyWallOffsetHeightTypeR(terraceDepthType);
        }
        return f;
    }

    protected float getBalconyWallOffsetHeightTypeF(TerraceDepthType terraceDepthType) {
        if (terraceDepthType == TerraceDepthType.T3) {
            return 248.5f;
        }
        if (terraceDepthType == TerraceDepthType.T4) {
            return 301.5f;
        }
        if (terraceDepthType == TerraceDepthType.T5) {
            return 354.5f;
        }
        if (terraceDepthType == TerraceDepthType.T6) {
            return 407.0f;
        }
        return 0.0f;
    }

    protected float getBalconyWallOffsetHeightTypeR(TerraceDepthType terraceDepthType) {
        if (terraceDepthType == TerraceDepthType.T3) {
            return 369.5f;
        }
        if (terraceDepthType == TerraceDepthType.T4) {
            return 422.5f;
        }
        if (terraceDepthType == TerraceDepthType.T5) {
            return 475.5f;
        }
        if (terraceDepthType == TerraceDepthType.T6) {
            return 528.5f;
        }
        return 0.0f;
    }

    protected float getBalconyWallOffsetHeightFree(RoofFigureType roofFigureType, TerraceDepthType terraceDepthType, StrengthType strengthType) {
        float f = 0.0f;
        if (roofFigureType == RoofFigureType.F) {
            f = this.getBalconyWallOffsetHeightFreeTypeF(terraceDepthType, strengthType);
        } else if (roofFigureType == RoofFigureType.R) {
            f = this.getBalconyWallOffsetHeightFreeTypeR(terraceDepthType, strengthType);
        }
        return f;
    }

    protected float getBalconyWallOffsetHeightFreeTypeF(TerraceDepthType terraceDepthType, StrengthType strengthType) {
        if (strengthType == StrengthType.T600) {
            if (terraceDepthType == TerraceDepthType.T3) {
                return 248.0f;
            }
            if (terraceDepthType == TerraceDepthType.T4) {
                return 301.0f;
            }
            if (terraceDepthType == TerraceDepthType.T5) {
                return 354.0f;
            }
            if (terraceDepthType == TerraceDepthType.T6) {
                return 407.0f;
            }
        } else {
            if (terraceDepthType == TerraceDepthType.T3) {
                return 338.0f;
            }
            if (terraceDepthType == TerraceDepthType.T4) {
                return 391.0f;
            }
            if (terraceDepthType == TerraceDepthType.T5) {
                return 444.0f;
            }
            if (terraceDepthType == TerraceDepthType.T6) {
                return 497.0f;
            }
        }
        return 0.0f;
    }

    protected float getBalconyWallOffsetHeightFreeTypeR(TerraceDepthType terraceDepthType, StrengthType strengthType) {
        if (strengthType == StrengthType.T600) {
            if (terraceDepthType == TerraceDepthType.T3) {
                return 499.0f;
            }
            if (terraceDepthType == TerraceDepthType.T4) {
                return 552.0f;
            }
            if (terraceDepthType == TerraceDepthType.T5) {
                return 605.0f;
            }
            if (terraceDepthType == TerraceDepthType.T6) {
                return 657.0f;
            }
        } else {
            if (terraceDepthType == TerraceDepthType.T3) {
                return 531.0f;
            }
            if (terraceDepthType == TerraceDepthType.T4) {
                return 584.0f;
            }
            if (terraceDepthType == TerraceDepthType.T5) {
                return 637.0f;
            }
            if (terraceDepthType == TerraceDepthType.T6) {
                return 689.0f;
            }
        }
        return 0.0f;
    }

    protected float getWallOffsetHeightTypeF(TerraceDepthType terraceDepthType) {
        if (terraceDepthType == TerraceDepthType.T3) {
            return 248.5f;
        }
        if (terraceDepthType == TerraceDepthType.T4) {
            return 301.5f;
        }
        if (terraceDepthType == TerraceDepthType.T5) {
            return 354.5f;
        }
        if (terraceDepthType == TerraceDepthType.T6) {
            return 407.0f;
        }
        if (terraceDepthType == TerraceDepthType.T7) {
            return 460.0f;
        }
        if (terraceDepthType == TerraceDepthType.T8) {
            return 513.0f;
        }
        if (terraceDepthType == TerraceDepthType.T9) {
            return 566.0f;
        }
        return 0.0f;
    }

    protected float getWallOffsetHeightFreeTypeF(TerraceDepthType terraceDepthType) {
        if (terraceDepthType == TerraceDepthType.T3) {
            return 209.5f;
        }
        if (terraceDepthType == TerraceDepthType.T4) {
            return 262.5f;
        }
        if (terraceDepthType == TerraceDepthType.T5) {
            return 315.0f;
        }
        if (terraceDepthType == TerraceDepthType.T6) {
            return 368.0f;
        }
        if (terraceDepthType == TerraceDepthType.T7) {
            return 421.0f;
        }
        if (terraceDepthType == TerraceDepthType.T8) {
            return 474.0f;
        }
        if (terraceDepthType == TerraceDepthType.T9) {
            return 527.0f;
        }
        if (terraceDepthType == TerraceDepthType.T10) {
            return 579.5f;
        }
        if (terraceDepthType == TerraceDepthType.T12) {
            return 685.5f;
        }
        if (terraceDepthType == TerraceDepthType.T15) {
            return 844.0f;
        }
        return 0.0f;
    }

    protected float getWallOffsetHeightTypeR(TerraceDepthType terraceDepthType) {
        if (terraceDepthType == TerraceDepthType.T3) {
            return 369.5f;
        }
        if (terraceDepthType == TerraceDepthType.T4) {
            return 422.5f;
        }
        if (terraceDepthType == TerraceDepthType.T5) {
            return 475.5f;
        }
        if (terraceDepthType == TerraceDepthType.T6) {
            return 528.5f;
        }
        if (terraceDepthType == TerraceDepthType.T7) {
            return 581.0f;
        }
        if (terraceDepthType == TerraceDepthType.T8) {
            return 634.0f;
        }
        if (terraceDepthType == TerraceDepthType.T9) {
            return 687.0f;
        }
        return 0.0f;
    }

    protected float getWallOffsetHeightFreeTypeR(TerraceDepthType terraceDepthType) {
        if (terraceDepthType == TerraceDepthType.T3) {
            return 357.0f;
        }
        if (terraceDepthType == TerraceDepthType.T4) {
            return 410.0f;
        }
        if (terraceDepthType == TerraceDepthType.T5) {
            return 463.0f;
        }
        if (terraceDepthType == TerraceDepthType.T6) {
            return 516.0f;
        }
        if (terraceDepthType == TerraceDepthType.T7) {
            return 569.0f;
        }
        if (terraceDepthType == TerraceDepthType.T8) {
            return 621.5f;
        }
        if (terraceDepthType == TerraceDepthType.T9) {
            return 674.5f;
        }
        if (terraceDepthType == TerraceDepthType.T10) {
            return 727.5f;
        }
        return 0.0f;
    }

    public float getFreelyPillarHeight(SNYEntities sNYEntities) {
        float f = sNYEntities.mTerracesInfo.mHeight.floatValue();
        float f2 = 0.0f;
        float f3 = sNYEntities.mTerracesInfo.mDepth.floatValue() - sNYEntities.mPartsFigureInfo.mKutaiUniversalPillarDepth1.floatValue();
        float[][] fArrayArray = new float[][]{{150.0f, 255.0f, 408.0f}, {200.0f, 264.0f, 443.0f}, {250.0f, 272.0f, 469.0f}, {300.0f, 281.0f, 489.0f}, {350.0f, 290.0f, 502.0f}, {400.0f, 299.0f, 511.0f}, {450.0f, 308.0f, 520.0f}};
        int n = sNYEntities.mBasicInfo.mRoofFigureType == RoofFigureType.F ? 1 : 2;
        int n2 = 0;
        while (n2 < 7) {
            if (fArrayArray[n2][0] == f3) {
                f2 = fArrayArray[n2][n] - 300.0f;
                if (sNYEntities.mBasicInfo.mRoofFigureType != RoofFigureType.R) break;
                f2 = (float)((double)f2 - 51.79);
                break;
            }
            ++n2;
        }
        return f + f2;
    }

    public float calcTsukuritsukeYukaSlopeAngle(TerracesInfo terracesInfo) {
        double d = terracesInfo.mDepth.floatValue();
        double d2 = terracesInfo.mDepth.floatValue() / 50.0f;
        float f = (float)Math.atan2(d2, d);
        return f;
    }

    public boolean isLeftCreateOK(AbstractTerraceUnitItem abstractTerraceUnitItem) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        boolean bl = true;
        if (sNYEntities.mTerracesInfo.mEnforcementType == EnforcementType.BUBUN_KAKOI) {
            bl = abstractTerraceUnitItem.getPrev() != null ? !this.isUseRoof(sNYEntities, abstractTerraceUnitItem.getPrev().getTerraceInfo()) : this.isUseRoof(sNYEntities, terraceInfo);
        } else if (abstractTerraceUnitItem.getPrev() != null) {
            bl = false;
        } else if (sNYEntities.mTerraceInfoList.getFirst().mId == terraceInfo.mId && sNYEntities.mTerracesInfo.mEnforcementType != EnforcementType.BUBUN_IRISUMI && (terracesInfo.mSodePosType == SodePosType.L || terracesInfo.mSodePosType == SodePosType.BOTH)) {
            bl = false;
        }
        return bl;
    }

    public boolean isRightCreateOK(AbstractTerraceUnitItem abstractTerraceUnitItem) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        boolean bl = true;
        if (sNYEntities.mTerracesInfo.mEnforcementType == EnforcementType.BUBUN_KAKOI) {
            bl = abstractTerraceUnitItem.getNext() != null ? !this.isUseRoof(sNYEntities, abstractTerraceUnitItem.getNext().getTerraceInfo()) : this.isUseRoof(sNYEntities, terraceInfo);
        } else if (abstractTerraceUnitItem.getNext() != null) {
            bl = false;
        } else if (sNYEntities.mTerraceInfoList.getLast().mId == terraceInfo.mId && sNYEntities.mTerracesInfo.mEnforcementType != EnforcementType.BUBUN_IRISUMI && (terracesInfo.mSodePosType == SodePosType.R || terracesInfo.mSodePosType == SodePosType.BOTH)) {
            bl = false;
        }
        return bl;
    }

    public boolean isUseRoof(SNYEntities sNYEntities, TerraceInfo terraceInfo) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        return basicInfo.mSubProductType != SubProductType.TSUKURITSUKE || terracesInfo.mEnforcementType != EnforcementType.BUBUN_KAKOI || terraceInfo.mBuildingType != BuildingType.BALCONY;
    }

    public boolean isPrevRoof(AbstractTerraceUnitItem abstractTerraceUnitItem) {
        SNYEntities sNYEntities = abstractTerraceUnitItem.getTerraceItem().getEntities();
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        boolean bl = false;
        if (basicInfo.mSubProductType == SubProductType.TSUKURITSUKE && terracesInfo.mEnforcementType == EnforcementType.BUBUN_KAKOI) {
            AbstractTerraceUnitItem abstractTerraceUnitItem2 = abstractTerraceUnitItem.getPrev();
            if (abstractTerraceUnitItem2 == null) {
                return false;
            }
            TerraceInfo terraceInfo = abstractTerraceUnitItem2.getTerraceInfo();
            bl = this.isUseRoof(sNYEntities, terraceInfo);
        } else {
            bl = abstractTerraceUnitItem.getPrev() != null;
        }
        return bl;
    }

    public boolean isNextRoof(AbstractTerraceUnitItem abstractTerraceUnitItem) {
        SNYEntities sNYEntities = abstractTerraceUnitItem.getTerraceItem().getEntities();
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        boolean bl = false;
        if (basicInfo.mSubProductType == SubProductType.TSUKURITSUKE && terracesInfo.mEnforcementType == EnforcementType.BUBUN_KAKOI) {
            AbstractTerraceUnitItem abstractTerraceUnitItem2 = abstractTerraceUnitItem.getNext();
            if (abstractTerraceUnitItem2 == null) {
                return false;
            }
            TerraceInfo terraceInfo = abstractTerraceUnitItem2.getTerraceInfo();
            bl = this.isUseRoof(sNYEntities, terraceInfo);
        } else {
            bl = abstractTerraceUnitItem.getNext() != null;
        }
        return bl;
    }

    public float getLeftDepth(TerracesInfo terracesInfo, TerraceInfo terraceInfo) {
        float f = terraceInfo.mDepth.floatValue();
        if ((terracesInfo.mEnforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI || terracesInfo.mEnforcementType == EnforcementType.BUBUN_IRISUMI) && terraceInfo.mIsStarting.booleanValue()) {
            f = terraceInfo.mLeftDepth.floatValue();
        }
        return f;
    }

    public float getRightDepth(TerracesInfo terracesInfo, TerraceInfo terraceInfo) {
        float f = terraceInfo.mDepth.floatValue();
        if ((terracesInfo.mEnforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI || terracesInfo.mEnforcementType == EnforcementType.BUBUN_IRISUMI) && terraceInfo.mIsStarting.booleanValue()) {
            f = terraceInfo.mRightDepth.floatValue();
        }
        return f;
    }

    public boolean isPrevConner(AbstractTerraceUnitItem abstractTerraceUnitItem) {
        AbstractTerraceUnitItem abstractTerraceUnitItem2 = abstractTerraceUnitItem.getPrev();
        if (abstractTerraceUnitItem2 == null) {
            return false;
        }
        TerraceInfo terraceInfo = abstractTerraceUnitItem2.getTerraceInfo();
        return terraceInfo.mBuildingType == BuildingType.CORNER;
    }

    public boolean isNextConner(AbstractTerraceUnitItem abstractTerraceUnitItem) {
        AbstractTerraceUnitItem abstractTerraceUnitItem2 = abstractTerraceUnitItem.getNext();
        if (abstractTerraceUnitItem2 == null) {
            return false;
        }
        TerraceInfo terraceInfo = abstractTerraceUnitItem2.getTerraceInfo();
        return terraceInfo.mBuildingType == BuildingType.CORNER;
    }

    public boolean isUchiKousi(SNYEntities sNYEntities) {
        return this.getFloorNum(sNYEntities) > 1 && (sNYEntities.mBasicInfo.mSubProductType == SubProductType.ALMI_BALCONY_PILLAR || sNYEntities.mBasicInfo.mSubProductType == SubProductType.ALMI_BALCONY_ROOF);
    }

    public float getKaikouHeight(SNYEntities sNYEntities) {
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        float f = 1970.0f;
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.TSUKURITSUKE) {
            f = 918.0f;
        } else if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.ALMI_BALCONY_PILLAR || sNYEntities.mBasicInfo.mSubProductType == SubProductType.ALMI_BALCONY_ROOF) {
            f = 1950.0f;
        }
        if (terracesInfo.mHeightType == TerraceHeightType.LONG) {
            f += 600.0f;
        }
        return f;
    }

    public float getYukaHeight(MsItemTerrace msItemTerrace) {
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        FloorInfo floorInfo = sNYEntities.mFloorInfo;
        float f = 0.0f;
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.OPEN) {
            f = floorInfo.mFloorLevel.floatValue();
        } else if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.YUKA || sNYEntities.mBasicInfo.mSubProductType == SubProductType.HALF_KAKOI || sNYEntities.mBasicInfo.mSubProductType == SubProductType.DOMA_YUKA) {
            f = floorInfo.mFloorLevel.floatValue() - 50.0f;
        } else if (sNYEntities.mBasicInfo.mSubProductType != SubProductType.TSUKURITSUKE) {
            if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.ALMI_BALCONY_PILLAR || sNYEntities.mBasicInfo.mSubProductType == SubProductType.ALMI_BALCONY_ROOF) {
                f = floorInfo.mFloorLevel.floatValue() + 56.0f;
            } else if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.DOMA) {
                f = this.calcDomaLevel(sNYEntities);
            }
        }
        return f;
    }

    public float getYukaLevel(MsItemTerrace msItemTerrace) {
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        FloorInfo floorInfo = sNYEntities.mFloorInfo;
        float f = this.calcDomaLevel(sNYEntities);
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.YUKA || sNYEntities.mBasicInfo.mSubProductType == SubProductType.DOMA_YUKA || sNYEntities.mBasicInfo.mSubProductType == SubProductType.HALF_KAKOI) {
            f += floorInfo.mFloorLevel.floatValue();
        } else if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.OPEN) {
            f += floorInfo.mFloorLevel.floatValue() - 50.0f;
        } else if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.DOMA) {
            f = (float)((double)f + this.getYukaAtumi(true));
        } else if (sNYEntities.mBasicInfo.mSubProductType != SubProductType.TSUKURITSUKE && (sNYEntities.mBasicInfo.mSubProductType == SubProductType.ALMI_BALCONY_PILLAR || sNYEntities.mBasicInfo.mSubProductType == SubProductType.ALMI_BALCONY_ROOF)) {
            f = floorInfo.mFloorLevel.floatValue();
        }
        return f;
    }

    public double getYukaAtumi(boolean bl) {
        if (bl) {
            return 10.0;
        }
        return 32.5;
    }

    public float getNokiHeight(MsItemTerrace msItemTerrace) {
        return this.getNokiHeight(msItemTerrace.getEntities());
    }

    public float getNokiHeight(SNYEntities sNYEntities) {
        FloorInfo floorInfo = sNYEntities.mFloorInfo;
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        float f = this.calcDomaLevel(sNYEntities) + sNYEntities.mTerracesInfo.mHeight.floatValue();
        if (basicInfo.mSubProductType == SubProductType.TSUKURITSUKE) {
            f = terracesInfo.mEnforcementType == EnforcementType.BUBUN_KAKOI ? terracesInfo.mHeight.floatValue() : floorInfo.mFloorLevel.floatValue() + sNYEntities.mTerracesInfo.mHeight.floatValue();
        }
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.ALMI_BALCONY_PILLAR || sNYEntities.mBasicInfo.mSubProductType == SubProductType.ALMI_BALCONY_ROOF) {
            f = floorInfo.mFloorLevel.floatValue() + sNYEntities.mTerracesInfo.mHeight.floatValue();
        }
        return f;
    }

    public float getPanelBottomHeight(SNYEntities sNYEntities, TerraceInfo terraceInfo, DirectionType directionType) {
        float f = sNYEntities.mPartsFigureInfo.mYukaHeight.floatValue();
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.TSUKURITSUKE) {
            f = sNYEntities.mPartsFigureInfo.mBottomHeight.floatValue();
            if (sNYEntities.mTerracesInfo.mEnforcementType == EnforcementType.BUBUN_KAKOI) {
                if (terraceInfo.mIsMaster.booleanValue()) {
                    if (sNYEntities.mTerracesInfo.mEnforcementDirType == EnforcementDirType.L) {
                        if (directionType == DirectionType.RIGHT) {
                            f = sNYEntities.mFloorInfo.mFloorLevel.floatValue() + 68.0f;
                        }
                    } else if (directionType == DirectionType.LEFT) {
                        f = sNYEntities.mFloorInfo.mFloorLevel.floatValue() + 68.0f;
                    }
                } else if (terraceInfo.mBuildingType == BuildingType.TERRACE) {
                    f = sNYEntities.mFloorInfo.mFloorLevel.floatValue() + 68.0f;
                }
            }
        } else if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.ALMI_BALCONY_PILLAR || sNYEntities.mBasicInfo.mSubProductType == SubProductType.ALMI_BALCONY_ROOF) {
            f = sNYEntities.mPartsFigureInfo.mYukaLevelHeight.floatValue() + 56.0f;
        } else if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.DOMA_YUKA) {
            if (sNYEntities.mTerracesInfo.mEnforcementType == EnforcementType.DOMA_YUKA_W) {
                if (!terraceInfo.mIsMaster.booleanValue() && terraceInfo.mFloorType == FloorType.DOMA) {
                    f = 0.0f;
                }
            } else {
                EnforcementType cfr_ignored_0 = sNYEntities.mTerracesInfo.mEnforcementType;
            }
        }
        return f;
    }

    public float getPanelTopHeight(SNYEntities sNYEntities, RanmaType ranmaType) {
        float f = sNYEntities.mPartsFigureInfo.mNokiHeight.floatValue();
        if (ranmaType != null) {
            f -= 430.0f;
        }
        return f;
    }

    public boolean isTsukuritsukePanel(SNYEntities sNYEntities, TerraceInfo terraceInfo, DirectionType directionType) {
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.TSUKURITSUKE) {
            if (sNYEntities.mTerracesInfo.mEnforcementType == EnforcementType.BUBUN_KAKOI && terraceInfo.mIsStarting.booleanValue()) {
                if (directionType == DirectionType.LEFT && sNYEntities.mTerracesInfo.mEnforcementDirType == EnforcementDirType.R) {
                    return false;
                }
                if (directionType == DirectionType.RIGHT && sNYEntities.mTerracesInfo.mEnforcementDirType == EnforcementDirType.L) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public SNYTerracePanelCreator getPanelCreator(SubProductType subProductType, OpeningPanelType openingPanelType) {
        if (openingPanelType == OpeningPanelType.FIX) {
            if (subProductType == SubProductType.TSUKURITSUKE) {
                return new PanelFixCreator();
            }
            return new PanelFixFixCreator();
        }
        if (openingPanelType == OpeningPanelType.HIKIDO) {
            return new PanelHikidoCreator();
        }
        if (openingPanelType == OpeningPanelType.TAKAMADO) {
            if (subProductType == SubProductType.TSUKURITSUKE) {
                return new PanelTakamadoCreator();
            }
            return new PanelTakamadoFixCreator();
        }
        if (openingPanelType == OpeningPanelType.TERRACE) {
            return new PanelTerraceCreator();
        }
        if (openingPanelType == OpeningPanelType.TATESUBERI) {
            if (subProductType == SubProductType.TSUKURITSUKE) {
                return new PanelTatesuberidashiCreator();
            }
            return new PanelTatesuberidashiFixCreator();
        }
        return null;
    }

    public SNYTerracePanelCreator getPanelCreator(OpeningPanelType openingPanelType, boolean bl) {
        if (openingPanelType == OpeningPanelType.FIX) {
            if (bl) {
                return new PanelFixCreator();
            }
            return new PanelFixFixCreator();
        }
        if (openingPanelType == OpeningPanelType.HIKIDO) {
            return new PanelHikidoCreator();
        }
        if (openingPanelType == OpeningPanelType.TAKAMADO) {
            if (bl) {
                return new PanelTakamadoCreator();
            }
            return new PanelTakamadoFixCreator();
        }
        if (openingPanelType == OpeningPanelType.TERRACE) {
            return new PanelTerraceCreator();
        }
        if (openingPanelType == OpeningPanelType.LOUVER) {
            if (bl) {
                return new PanelLouverCreator();
            }
            return new PanelLouverFixCreator();
        }
        if (openingPanelType == OpeningPanelType.DOOR) {
            return new PanelDoorCreator();
        }
        if (openingPanelType == OpeningPanelType.SAIFU_DOOR) {
            return new PanelSaifuDoorCreator();
        }
        if (openingPanelType == OpeningPanelType.TATESUBERI) {
            if (bl) {
                return new PanelTatesuberidashiCreator();
            }
            return new PanelTatesuberidashiFixCreator();
        }
        return null;
    }

    public SNYTerracePanelCreator getRanmaCreator(RanmaType ranmaType) {
        if (ranmaType == RanmaType.FIX) {
            return new PanelRanmaFixCreator();
        }
        if (ranmaType == RanmaType.SLIDING) {
            return new PanelRanmaHikichigaiCreator();
        }
        return null;
    }

    public float getYaneuraHeight(SNYEntities sNYEntities, float f, float f2) {
        float f3 = sNYEntities.mPartsFigureInfo.mNokiHeight.floatValue();
        double d = f - Math.abs(f2);
        double d2 = d * Math.tan(Math.toRadians(10.0));
        if (sNYEntities.mBasicInfo.mSubProductType != SubProductType.HALF_KAKOI) {
            if (sNYEntities.mBasicInfo.mRoofFigureType == RoofFigureType.F) {
                double d3 = d2 + 6.5 + (double)sNYEntities.mPartsFigureInfo.mTooshiHeight.floatValue();
                f3 += (float)(d3 + 58.0);
            } else if (sNYEntities.mBasicInfo.mRoofFigureType == RoofFigureType.R) {
                double d4 = d2 + 154.0 + (double)sNYEntities.mPartsFigureInfo.mTooshiHeight.floatValue();
                f3 += (float)(d4 + 58.0);
            }
        }
        return f3;
    }

    public boolean isFrontPanelBuildOnDoma(SNYEntities sNYEntities, TerraceInfo terraceInfo, float f, float f2) {
        boolean bl = false;
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.DOMA) {
            bl = true;
        } else if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.DOMA_YUKA) {
            if (sNYEntities.mTerracesInfo.mEnforcementType == EnforcementType.DOMA_YUKA_D) {
                bl = true;
            } else if (sNYEntities.mTerracesInfo.mEnforcementType == EnforcementType.DOMA_YUKA_W) {
                if (terraceInfo.mIsStarting.booleanValue()) {
                    float f3 = 0.0f;
                    bl = sNYEntities.mTerracesInfo.mEnforcementDirType == EnforcementDirType.L ? f < (f3 = terraceInfo.mWidth.floatValue() / 2.0f - terraceInfo.mRightWidth.floatValue()) : f > (f3 = -terraceInfo.mWidth.floatValue() / 2.0f + terraceInfo.mLeftWidth.floatValue());
                } else if (terraceInfo.mFloorType == FloorType.DOMA) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    public boolean isSidePanelBuildOnDoma(SNYEntities sNYEntities, TerraceInfo terraceInfo, DirectionType directionType, float f, float f2) {
        boolean bl = false;
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.DOMA) {
            bl = true;
        } else if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.DOMA_YUKA) {
            if (sNYEntities.mTerracesInfo.mEnforcementType == EnforcementType.DOMA_YUKA_D) {
                bl = !(f > -terraceInfo.mBackDepth.floatValue());
            } else if (sNYEntities.mTerracesInfo.mEnforcementType == EnforcementType.DOMA_YUKA_W) {
                bl = terraceInfo.mIsStarting.booleanValue() ? (directionType == DirectionType.LEFT ? sNYEntities.mTerracesInfo.mEnforcementDirType == EnforcementDirType.L : sNYEntities.mTerracesInfo.mEnforcementDirType != EnforcementDirType.L) : terraceInfo.mFloorType != FloorType.YUKA;
            }
        }
        return bl;
    }

    public boolean isMabashiraBuildNG(SNYEntities sNYEntities, TerraceInfo terraceInfo, float f) {
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.DOMA_YUKA && sNYEntities.mTerracesInfo.mEnforcementType == EnforcementType.DOMA_YUKA_W && terraceInfo.mIsStarting.booleanValue()) {
            float f2 = 0.0f;
            f2 = sNYEntities.mTerracesInfo.mEnforcementDirType == EnforcementDirType.L ? terraceInfo.mWidth.floatValue() / 2.0f - terraceInfo.mRightWidth.floatValue() : -terraceInfo.mWidth.floatValue() / 2.0f + terraceInfo.mLeftWidth.floatValue();
            float f3 = Math.abs(f2 - f);
            if (f3 < 70.0f) {
                return true;
            }
        }
        return false;
    }

    public boolean isKiritsume(SNYEntities sNYEntities, TerraceInfo terraceInfo, DirectionType directionType) {
        float f = 0.0f;
        if (sNYEntities.mTerracesInfo.mEnforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI) {
            float f2 = (terraceInfo.mIsStarting != false ? terraceInfo.mDefaultDepth : sNYEntities.mTerracesInfo.mDepth).floatValue();
            f = directionType == DirectionType.LEFT ? terraceInfo.mLeftDepth.floatValue() - f2 : terraceInfo.mRightDepth.floatValue() - f2;
        } else {
            f = terraceInfo.mDepth.floatValue() - terraceInfo.mDefaultDepth.floatValue();
        }
        return Math.abs(f) > 1.0f;
    }

    public float calcKutaiY(SNYEntities sNYEntities, TerraceInfo terraceInfo, DirectionType directionType) {
        float f = 0.0f;
        if (sNYEntities.mTerracesInfo.mEnforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI) {
            f = terraceInfo.mIsStarting.booleanValue() ? (directionType == DirectionType.LEFT ? terraceInfo.mLeftDepth.floatValue() - sNYEntities.mTerracesInfo.mDepth.floatValue() : terraceInfo.mRightDepth.floatValue() - sNYEntities.mTerracesInfo.mDepth.floatValue()) : terraceInfo.mDepth.floatValue() - sNYEntities.mTerracesInfo.mDepth.floatValue();
        }
        return f;
    }

    public float calcWariHoudateKutaiY() {
        return -TobukuroNige.NIGE - 27.5f;
    }

    public float calcWariHoudateKiritumeNashiY() {
        return -TobukuroNige.NIGE_1R + 27.5f;
    }

    public float calcWariHoudateY(boolean bl) {
        float f = 0.0f;
        f = bl ? this.calcWariHoudateKutaiY() : this.calcWariHoudateKiritumeNashiY();
        return f += 7.5f;
    }

    public float calcGroundLevel(SNYEntities sNYEntities) {
        return 0.0f;
    }

    public float calcFloorLevel(SNYEntities sNYEntities) {
        FloorInfo floorInfo = sNYEntities.mFloorInfo;
        return floorInfo.mFloorLevel.floatValue() + this.calcGroundLevel(sNYEntities);
    }

    public float calcDomaLevel(SNYEntities sNYEntities) {
        float f = 0.0f;
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.DOMA && sNYEntities.mDomaTileInfo != null && sNYEntities.mDomaTileInfo.mTileUsedType == TileUsedType.ON) {
            f = sNYEntities.mDomaTileInfo.mFloorLevel.floatValue();
        }
        return f + this.calcGroundLevel(sNYEntities);
    }

    public float calcFrontOpeningLevel(SNYEntities sNYEntities, int n, DirectionType directionType) {
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        float f = 0.0f;
        if (GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.DOMA)) {
            f = this.calcDomaLevel(sNYEntities);
        } else if (GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.YUKA)) {
            f = this.calcFloorLevel(sNYEntities) - 50.0f;
        } else if (GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.DOMA_YUKA)) {
            if (terracesInfo.mEnforcementType == EnforcementType.DOMA_YUKA_W) {
                if (terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
                    if (n < 0) {
                        f = this.calcDomaLevel(sNYEntities);
                    } else if (n == 0) {
                        f = directionType == DirectionType.LEFT ? this.calcDomaLevel(sNYEntities) : (directionType == DirectionType.RIGHT ? this.calcFloorLevel(sNYEntities) - 50.0f : this.calcFloorLevel(sNYEntities) - 50.0f);
                    } else if (n > 0) {
                        f = this.calcFloorLevel(sNYEntities) - 50.0f;
                    }
                } else if (terracesInfo.mEnforcementDirType == EnforcementDirType.R) {
                    if (n < 0) {
                        f = this.calcFloorLevel(sNYEntities) - 50.0f;
                    } else if (n == 0) {
                        f = directionType == DirectionType.LEFT ? this.calcFloorLevel(sNYEntities) - 50.0f : (directionType == DirectionType.RIGHT ? this.calcDomaLevel(sNYEntities) : this.calcFloorLevel(sNYEntities) - 50.0f);
                    } else if (n > 0) {
                        f = this.calcDomaLevel(sNYEntities);
                    }
                }
            } else if (terracesInfo.mEnforcementType == EnforcementType.DOMA_YUKA_D) {
                f = this.calcDomaLevel(sNYEntities);
            }
        } else {
            f = GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.ALMI_BALCONY_PILLAR, SubProductType.ALMI_BALCONY_ROOF) ? this.calcUnderHeight(sNYEntities) + this.calcGroundLevel(sNYEntities) + 56.0f : (GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.TSUKURITSUKE) ? (terracesInfo.mEnforcementType == EnforcementType.BUBUN_KAKOI ? this.calcDomaLevel(sNYEntities) + this.calcBalconyHeight(sNYEntities) + 28.0f : this.calcGroundLevel(sNYEntities) + 28.0f) : (GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.HALF_KAKOI) ? this.calcFloorLevel(sNYEntities) - 50.0f : (GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.OPEN) ? this.calcFloorLevel(sNYEntities) : this.calcGroundLevel(sNYEntities))));
        }
        return f;
    }

    public float calcSideOpeningLevel(SNYEntities sNYEntities, int n, DirectionType directionType) {
        PanelDirectionType panelDirectionType = PanelDirectionTypeDxo.convert(directionType);
        return this.calcSideOpeningLevel(sNYEntities, n, panelDirectionType);
    }

    public float calcSideOpeningLevel(SNYEntities sNYEntities, int n, PanelDirectionType panelDirectionType) {
        DirectionType directionType = DirectionTypeDxo.convert(panelDirectionType);
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        float f = 0.0f;
        if (GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.DOMA)) {
            f = this.calcDomaLevel(sNYEntities);
        } else if (GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.YUKA)) {
            f = this.calcFloorLevel(sNYEntities) - 50.0f;
        } else if (GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.DOMA_YUKA)) {
            if (terracesInfo.mEnforcementType == EnforcementType.DOMA_YUKA_W) {
                if (terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
                    if (n < 0) {
                        f = this.calcDomaLevel(sNYEntities);
                    } else if (n == 0) {
                        f = directionType == DirectionType.LEFT ? this.calcDomaLevel(sNYEntities) : (directionType == DirectionType.RIGHT ? this.calcFloorLevel(sNYEntities) - 50.0f : this.calcFloorLevel(sNYEntities) - 50.0f);
                    } else if (n > 0) {
                        f = this.calcFloorLevel(sNYEntities) - 50.0f;
                    }
                } else if (terracesInfo.mEnforcementDirType == EnforcementDirType.R) {
                    if (n < 0) {
                        f = this.calcFloorLevel(sNYEntities) - 50.0f;
                    } else if (n == 0) {
                        f = directionType == DirectionType.LEFT ? this.calcFloorLevel(sNYEntities) - 50.0f : (directionType == DirectionType.RIGHT ? this.calcDomaLevel(sNYEntities) : this.calcFloorLevel(sNYEntities) - 50.0f);
                    } else if (n > 0) {
                        f = this.calcDomaLevel(sNYEntities);
                    }
                }
            } else if (terracesInfo.mEnforcementType == EnforcementType.DOMA_YUKA_D) {
                if (panelDirectionType == PanelDirectionType.FRONT) {
                    f = this.calcDomaLevel(sNYEntities);
                } else if (panelDirectionType == PanelDirectionType.REAR) {
                    f = this.calcFloorLevel(sNYEntities) - 50.0f;
                }
            }
        } else if (GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.ALMI_BALCONY_PILLAR, SubProductType.ALMI_BALCONY_ROOF)) {
            f = this.calcUnderHeight(sNYEntities) + this.calcGroundLevel(sNYEntities) + 56.0f;
        } else if (GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.TSUKURITSUKE)) {
            if (GdMutableTypeUtil.matchOR(terracesInfo.mEnforcementType, EnforcementType.BUBUN_KAKOI)) {
                if (terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
                    if (n < 0) {
                        f = this.calcDomaLevel(sNYEntities) + this.calcBalconyHeight(sNYEntities) + 28.0f;
                    } else if (n == 0) {
                        f = directionType == DirectionType.LEFT ? this.calcDomaLevel(sNYEntities) + this.calcBalconyHeight(sNYEntities) + 28.0f : (directionType == DirectionType.RIGHT ? this.calcDomaLevel(sNYEntities) + 68.0f : this.calcDomaLevel(sNYEntities) + 68.0f);
                    } else if (n > 0) {
                        f = this.calcDomaLevel(sNYEntities) + 68.0f;
                    }
                } else if (terracesInfo.mEnforcementDirType == EnforcementDirType.R) {
                    if (n < 0) {
                        f = this.calcDomaLevel(sNYEntities) + 68.0f;
                    } else if (n == 0) {
                        f = directionType == DirectionType.LEFT ? this.calcDomaLevel(sNYEntities) + 68.0f : (directionType == DirectionType.RIGHT ? this.calcDomaLevel(sNYEntities) + this.calcBalconyHeight(sNYEntities) + 28.0f : this.calcDomaLevel(sNYEntities) + 68.0f);
                    } else if (n > 0) {
                        f = this.calcDomaLevel(sNYEntities) + this.calcBalconyHeight(sNYEntities) + 28.0f;
                    }
                }
            } else {
                f = this.calcGroundLevel(sNYEntities) + 28.0f;
            }
        } else {
            f = GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.HALF_KAKOI) ? this.calcFloorLevel(sNYEntities) - 50.0f : (GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.OPEN) ? this.calcFloorLevel(sNYEntities) : this.calcGroundLevel(sNYEntities));
        }
        return f;
    }

    public float calcUpperPanelPartsLevel(SNYEntities sNYEntities, TerraceInfo terraceInfo, PanelInfo panelInfo) {
        PartsFigureUnitInfo partsFigureUnitInfo = this.findOnePartsFigureUnitInfo(sNYEntities.mPartsFigureUnitInfoList, terraceInfo);
        return this.calcUpperPanelPartsLevel(sNYEntities, partsFigureUnitInfo, panelInfo);
    }

    public float calcUpperPanelPartsLevel(SNYEntities sNYEntities, PartsFigureUnitInfo partsFigureUnitInfo, PanelInfo panelInfo) {
        float f = this.getOpeningLevel(partsFigureUnitInfo, panelInfo.mPanelDirectionType, panelInfo.mFrontPanelDirectionType);
        float f2 = this.calcLowerPanelPartsHeight(sNYEntities, (int)panelInfo.mTerraceId, (int)panelInfo.mIndex, panelInfo.mPanelDirectionType);
        float f3 = f + f2 + 60.0f + 60.0f;
        return f3;
    }

    public float calcRanmaLevel(SNYEntities sNYEntities) {
        return this.calcMaeketaShitaToGL(sNYEntities) - this.calcRanmaHeight();
    }

    public float calcBalconyHeight(SNYEntities sNYEntities) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        float f = 0.0f;
        if (GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.ALMI_BALCONY_PILLAR, SubProductType.ALMI_BALCONY_ROOF)) {
            f = 1130.0f;
        } else if (GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.TSUKURITSUKE)) {
            f = terracesInfo.mEnforcementType == EnforcementType.BUBUN_KAKOI ? terracesInfo.mHeight.floatValue() - terracesInfo.mOpeningHeight.floatValue() : 1100.0f;
        }
        return f;
    }

    public float calcUnderHeight(SNYEntities sNYEntities) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        float f = 0.0f;
        if (GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.ALMI_BALCONY_PILLAR, SubProductType.ALMI_BALCONY_ROOF)) {
            if (basicInfo.mPillarLengthType == PillarLengthType.STD) {
                f = 450.0f;
            } else if (basicInfo.mPillarLengthType == PillarLengthType.YUKASHITA_LONG) {
                f = 1570.0f;
            }
        }
        return f;
    }

    public float calcRanmaHeight() {
        return 430.0f;
    }

    public float calcPanelHeight(SNYEntities sNYEntities, TerraceInfo terraceInfo, PanelInfo panelInfo) {
        PartsFigureUnitInfo partsFigureUnitInfo = this.findOnePartsFigureUnitInfo(sNYEntities.mPartsFigureUnitInfoList, terraceInfo);
        return this.calcPanelHeight(sNYEntities, partsFigureUnitInfo, panelInfo);
    }

    public float calcPanelHeight(SNYEntities sNYEntities, PartsFigureUnitInfo partsFigureUnitInfo, PanelInfo panelInfo) {
        float f;
        float f2 = f = this.getOpeningHeight(partsFigureUnitInfo, panelInfo.mPanelDirectionType, panelInfo.mFrontPanelDirectionType);
        if (panelInfo.mRanmaUseType == RanmaUseType.EXIST) {
            f2 -= this.calcRanmaHeight();
        }
        return f2;
    }

    public float calcLowerPanelPartsHeight(SNYEntities sNYEntities, int n, int n2, DirectionType directionType) {
        return this.calcLowerPanelPartsHeight(sNYEntities, n, n2, PanelDirectionTypeDxo.convert(directionType));
    }

    public float calcLowerPanelPartsHeight(SNYEntities sNYEntities, int n, int n2, PanelDirectionType panelDirectionType) {
        LinkedList<PanelCutInfo> linkedList = this.mPanelCutCommonService.getPanelCutInfoList(sNYEntities, panelDirectionType);
        PanelCutCommonService.ClassifiedCutInfo classifiedCutInfo = this.mPanelCutCommonService.getClassifiedCutInfo(n, n2, linkedList);
        float f = 894.0f;
        if (classifiedCutInfo.lowerCutInfo != null) {
            f = (float)((double)(classifiedCutInfo.lowerCutInfo.mStandardHeight.floatValue() - classifiedCutInfo.lowerCutInfo.mCutHeight.floatValue()) - 50.0);
        }
        return f;
    }

    public float calcUpperPanelPartsHeight(SNYEntities sNYEntities, TerraceInfo terraceInfo, PanelInfo panelInfo) {
        PartsFigureUnitInfo partsFigureUnitInfo = this.findOnePartsFigureUnitInfo(sNYEntities.mPartsFigureUnitInfoList, terraceInfo);
        return this.calcUpperPanelPartsHeight(sNYEntities, partsFigureUnitInfo, panelInfo);
    }

    public float calcUpperPanelPartsHeight(SNYEntities sNYEntities, PartsFigureUnitInfo partsFigureUnitInfo, PanelInfo panelInfo) {
        float f = this.getOpeningHeight(partsFigureUnitInfo, panelInfo.mPanelDirectionType, panelInfo.mFrontPanelDirectionType);
        float f2 = this.calcLowerPanelPartsHeight(sNYEntities, (int)panelInfo.mTerraceId, (int)panelInfo.mIndex, panelInfo.mPanelDirectionType);
        float f3 = f - f2 - 60.0f - 60.0f;
        if (panelInfo.mRanmaUseType == RanmaUseType.EXIST) {
            f3 -= this.calcRanmaHeight();
        }
        return f3;
    }

    public float calcMaeketaShitaToTop(SNYEntities sNYEntities, TerraceInfo terraceInfo, DirectionType directionType) {
        double d;
        float f = this.getWallHeight(sNYEntities);
        float f2 = this.calcMaeketaShitaToGL(sNYEntities);
        float f3 = this.getMaewakuMatoohiHeight(sNYEntities);
        double d2 = 0.0;
        if (directionType == DirectionType.LEFT) {
            d = Math.tan(Math.toRadians(10.0));
            d2 = d * (double)(terraceInfo.mDefaultDepth.floatValue() - terraceInfo.mLeftDepth.floatValue());
        } else if (directionType == DirectionType.RIGHT) {
            d = Math.tan(Math.toRadians(10.0));
            d2 = d * (double)(terraceInfo.mDefaultDepth.floatValue() - terraceInfo.mRightDepth.floatValue());
        }
        float f4 = (float)((double)(f - f2 + f3) - d2);
        return f4;
    }

    public float calcMaeketaShitaToGL(SNYEntities sNYEntities) {
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        FloorInfo floorInfo = sNYEntities.mFloorInfo;
        float f = 0.0f;
        f = GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.ALMI_BALCONY_PILLAR, SubProductType.ALMI_BALCONY_ROOF) ? terracesInfo.mHeight.floatValue() + floorInfo.mFloorLevel.floatValue() : (GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.TSUKURITSUKE) ? terracesInfo.mHeight.floatValue() + this.calcGroundLevel(sNYEntities) : terracesInfo.mHeight.floatValue() + this.calcDomaLevel(sNYEntities) + this.calcGroundLevel(sNYEntities));
        return f;
    }

    public float calcMaeketaShitaToDoma(SNYEntities sNYEntities) {
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        FloorInfo floorInfo = sNYEntities.mFloorInfo;
        float f = 0.0f;
        f = GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.ALMI_BALCONY_PILLAR, SubProductType.ALMI_BALCONY_ROOF) ? terracesInfo.mHeight.floatValue() + floorInfo.mFloorLevel.floatValue() : (GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.TSUKURITSUKE) ? (terracesInfo.mEnforcementType == EnforcementType.BUBUN_KAKOI ? terracesInfo.mHeight.floatValue() : terracesInfo.mHeight.floatValue() + this.calcBalconyHeight(sNYEntities)) : terracesInfo.mHeight.floatValue());
        return f;
    }

    public float calcMaeketaShitaToFL(SNYEntities sNYEntities, int n, DirectionType directionType) {
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        FloorInfo floorInfo = sNYEntities.mFloorInfo;
        DomaTileInfo domaTileInfo = sNYEntities.mDomaTileInfo;
        mLog.debug((Object)("terracesInfo.mHeight[" + terracesInfo.mHeight + "]"));
        mLog.debug((Object)("floorInfo.mFloorLevel[" + floorInfo.mFloorLevel + "]"));
        if (domaTileInfo != null) {
            mLog.debug((Object)("domaTileInfo.mFloorLevel[" + domaTileInfo.mFloorLevel + "]"));
        }
        float f = 0.0f;
        if (GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.DOMA)) {
            f = terracesInfo.mHeight.floatValue();
        } else if (GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.YUKA)) {
            f = terracesInfo.mHeight.floatValue() - floorInfo.mFloorLevel.floatValue();
        } else if (GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.DOMA_YUKA)) {
            if (terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
                if (n < 0) {
                    f = terracesInfo.mHeight.floatValue();
                } else if (n == 0) {
                    f = directionType == DirectionType.LEFT ? terracesInfo.mHeight.floatValue() : (directionType == DirectionType.RIGHT ? terracesInfo.mHeight.floatValue() - floorInfo.mFloorLevel.floatValue() : terracesInfo.mHeight.floatValue() - floorInfo.mFloorLevel.floatValue());
                } else if (n > 0) {
                    f = terracesInfo.mHeight.floatValue() - floorInfo.mFloorLevel.floatValue();
                }
            } else if (terracesInfo.mEnforcementDirType == EnforcementDirType.R) {
                if (n < 0) {
                    f = terracesInfo.mHeight.floatValue() - floorInfo.mFloorLevel.floatValue();
                } else if (n == 0) {
                    f = directionType == DirectionType.LEFT ? terracesInfo.mHeight.floatValue() - floorInfo.mFloorLevel.floatValue() : (directionType == DirectionType.RIGHT ? terracesInfo.mHeight.floatValue() : terracesInfo.mHeight.floatValue() - floorInfo.mFloorLevel.floatValue());
                } else if (n > 0) {
                    f = terracesInfo.mHeight.floatValue();
                }
            }
        } else {
            f = GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.ALMI_BALCONY_PILLAR, SubProductType.ALMI_BALCONY_ROOF) ? 1950.0f : (GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.TSUKURITSUKE) ? (terracesInfo.mEnforcementType == EnforcementType.BUBUN_KAKOI ? terracesInfo.mHeight.floatValue() : terracesInfo.mHeight.floatValue() + this.calcBalconyHeight(sNYEntities)) : terracesInfo.mHeight.floatValue() - floorInfo.mFloorLevel.floatValue());
        }
        return f;
    }

    public float calcFrontOpeningHeight(SNYEntities sNYEntities, int n, DirectionType directionType) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        float f = 0.0f;
        if (GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.DOMA)) {
            f = this.calcMaeketaShitaToFL(sNYEntities, n, directionType);
        } else if (GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.DOMA_YUKA)) {
            if (terracesInfo.mEnforcementType == EnforcementType.DOMA_YUKA_W) {
                f = this.calcMaeketaShitaToFL(sNYEntities, n, directionType) + 50.0f;
            } else if (terracesInfo.mEnforcementType == EnforcementType.DOMA_YUKA_D) {
                f = this.calcMaeketaShitaToDoma(sNYEntities);
            }
        } else {
            f = GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.ALMI_BALCONY_PILLAR, SubProductType.ALMI_BALCONY_ROOF) ? this.calcMaeketaShitaToFL(sNYEntities, n, directionType) - 56.0f : (GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.TSUKURITSUKE) ? (terracesInfo.mEnforcementType == EnforcementType.BUBUN_KAKOI ? terracesInfo.mOpeningHeight.floatValue() - 28.0f : terracesInfo.mHeight.floatValue() - 28.0f) : this.calcMaeketaShitaToFL(sNYEntities, n, directionType) + 50.0f);
        }
        return f;
    }

    public float calcSideOpeningHeight(SNYEntities sNYEntities, int n, PanelDirectionType panelDirectionType) {
        DirectionType directionType = DirectionTypeDxo.convert(panelDirectionType);
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        float f = 0.0f;
        if (GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.DOMA)) {
            f = this.calcMaeketaShitaToFL(sNYEntities, n, directionType);
        } else if (GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.YUKA)) {
            f = this.calcMaeketaShitaToFL(sNYEntities, n, directionType) + 50.0f;
        } else if (GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.DOMA_YUKA)) {
            if (terracesInfo.mEnforcementType == EnforcementType.DOMA_YUKA_W) {
                if (terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
                    if (n < 0) {
                        f = this.calcMaeketaShitaToDoma(sNYEntities);
                    } else if (n == 0) {
                        f = directionType == DirectionType.LEFT ? this.calcMaeketaShitaToDoma(sNYEntities) : (directionType == DirectionType.RIGHT ? this.calcMaeketaShitaToFL(sNYEntities, n, directionType) + 50.0f : this.calcMaeketaShitaToFL(sNYEntities, n, directionType) + 50.0f);
                    } else if (n > 0) {
                        f = this.calcMaeketaShitaToFL(sNYEntities, n, directionType) + 50.0f;
                    }
                } else if (terracesInfo.mEnforcementDirType == EnforcementDirType.R) {
                    if (n < 0) {
                        f = this.calcMaeketaShitaToFL(sNYEntities, n, directionType) + 50.0f;
                    } else if (n == 0) {
                        f = directionType == DirectionType.LEFT ? this.calcMaeketaShitaToFL(sNYEntities, n, directionType) + 50.0f : (directionType == DirectionType.RIGHT ? this.calcMaeketaShitaToDoma(sNYEntities) : this.calcMaeketaShitaToFL(sNYEntities, n, directionType) + 50.0f);
                    } else if (n > 0) {
                        f = this.calcMaeketaShitaToDoma(sNYEntities);
                    }
                }
            } else if (terracesInfo.mEnforcementType == EnforcementType.DOMA_YUKA_D) {
                if (panelDirectionType == PanelDirectionType.FRONT) {
                    f = this.calcMaeketaShitaToDoma(sNYEntities);
                } else if (panelDirectionType == PanelDirectionType.REAR) {
                    f = this.calcMaeketaShitaToFL(sNYEntities, n, directionType) + 50.0f;
                }
            }
        } else if (GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.ALMI_BALCONY_PILLAR, SubProductType.ALMI_BALCONY_ROOF)) {
            f = this.calcMaeketaShitaToFL(sNYEntities, n, directionType) - 56.0f;
        } else if (GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.TSUKURITSUKE)) {
            if (GdMutableTypeUtil.matchOR(terracesInfo.mEnforcementType, EnforcementType.BUBUN_KAKOI)) {
                if (terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
                    if (n < 0) {
                        f = terracesInfo.mOpeningHeight.floatValue() - 28.0f;
                    } else if (n == 0) {
                        f = directionType == DirectionType.LEFT ? terracesInfo.mOpeningHeight.floatValue() - 28.0f : (directionType == DirectionType.RIGHT ? this.calcMaeketaShitaToFL(sNYEntities, n, directionType) - 68.0f : this.calcMaeketaShitaToFL(sNYEntities, n, directionType) - 68.0f);
                    } else if (n > 0) {
                        f = this.calcMaeketaShitaToFL(sNYEntities, n, directionType) - 68.0f;
                    }
                } else if (terracesInfo.mEnforcementDirType == EnforcementDirType.R) {
                    if (n < 0) {
                        f = this.calcMaeketaShitaToFL(sNYEntities, n, directionType) - 68.0f;
                    } else if (n == 0) {
                        f = directionType == DirectionType.LEFT ? this.calcMaeketaShitaToFL(sNYEntities, n, directionType) - 68.0f : (directionType == DirectionType.RIGHT ? terracesInfo.mOpeningHeight.floatValue() - 28.0f : this.calcMaeketaShitaToFL(sNYEntities, n, directionType) - 68.0f);
                    } else if (n > 0) {
                        f = terracesInfo.mOpeningHeight.floatValue() - 28.0f;
                    }
                }
            } else {
                f = terracesInfo.mHeight.floatValue() - 28.0f;
            }
        } else {
            f = this.calcMaeketaShitaToFL(sNYEntities, n, directionType) + 50.0f;
        }
        return f;
    }

    public float calcFrontOpeningWidth(SNYEntities sNYEntities, TerraceInfo terraceInfo, DirectionType directionType) {
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        float f = 0.0f;
        if (terracesInfo.mEnforcementType == EnforcementType.DESUMI) {
            f = terraceInfo.mOpeningWidth.floatValue();
        } else if (terracesInfo.mEnforcementType == EnforcementType.IRISUMI) {
            f = terraceInfo.mOpeningWidth.floatValue();
        } else if (terracesInfo.mEnforcementType == EnforcementType.BUBUN_KAKOI) {
            if (terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
                if (directionType == DirectionType.LEFT) {
                    f = terraceInfo.mLeftWidth.floatValue() - 70.0f;
                } else if (directionType == DirectionType.RIGHT) {
                    f = 0.0f;
                }
            } else if (terracesInfo.mEnforcementDirType == EnforcementDirType.R) {
                if (directionType == DirectionType.LEFT) {
                    f = 0.0f;
                } else if (directionType == DirectionType.RIGHT) {
                    f = terraceInfo.mRightWidth.floatValue() - 70.0f;
                }
            }
        } else if (terracesInfo.mEnforcementType == EnforcementType.DOMA_YUKA_W) {
            if (directionType == DirectionType.LEFT) {
                f = terraceInfo.mLeftWidth.floatValue() - 70.0f;
            } else if (directionType == DirectionType.RIGHT) {
                f = terraceInfo.mRightWidth.floatValue() - 70.0f;
            }
        } else {
            f = terraceInfo.mOpeningWidth.floatValue();
        }
        return f;
    }

    public float calcSideOpeningWidth(SNYEntities sNYEntities, TerraceInfo terraceInfo, PanelDirectionType panelDirectionType) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        float f = 0.0f;
        if (terracesInfo.mEnforcementType == EnforcementType.BUBUN_IRISUMI) {
            if (panelDirectionType == PanelDirectionType.LEFT) {
                f = terraceInfo.mLeftDepth.floatValue() - 70.0f;
            } else if (panelDirectionType == PanelDirectionType.RIGHT) {
                f = terraceInfo.mRightDepth.floatValue() - 70.0f;
            }
        } else if (terracesInfo.mEnforcementType == EnforcementType.BUBUN_KAKOI) {
            if (basicInfo.mSubProductType == SubProductType.TSUKURITSUKE) {
                if (terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
                    if (panelDirectionType == PanelDirectionType.LEFT) {
                        f = terraceInfo.mDepth.floatValue() - 70.0f;
                    } else if (panelDirectionType == PanelDirectionType.RIGHT) {
                        f = terraceInfo.mRightOpeningDepth.floatValue();
                    }
                } else if (terracesInfo.mEnforcementDirType == EnforcementDirType.R) {
                    if (panelDirectionType == PanelDirectionType.LEFT) {
                        f = terraceInfo.mLeftOpeningDepth.floatValue();
                    } else if (panelDirectionType == PanelDirectionType.RIGHT) {
                        f = terraceInfo.mDepth.floatValue() - 70.0f;
                    }
                }
            } else {
                f = terraceInfo.mDepth.floatValue() - 70.0f;
            }
        } else if (terracesInfo.mEnforcementType == EnforcementType.DOMA_YUKA_D) {
            if (panelDirectionType == PanelDirectionType.FRONT) {
                f = terraceInfo.mFrontDepth.floatValue() - 15.0f - 70.0f;
            } else if (panelDirectionType == PanelDirectionType.REAR) {
                f = terraceInfo.mBackDepth.floatValue() - 70.0f;
            }
        } else if (terracesInfo.mEnforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI) {
            if (panelDirectionType == PanelDirectionType.LEFT) {
                f = terraceInfo.mLeftDepth.floatValue() - 70.0f;
            } else if (panelDirectionType == PanelDirectionType.RIGHT) {
                f = terraceInfo.mRightDepth.floatValue() - 105.0f;
            }
        } else if (terracesInfo.mSodePosType == SodePosType.L) {
            if (panelDirectionType == PanelDirectionType.LEFT) {
                f = 0.0f;
            } else if (panelDirectionType == PanelDirectionType.RIGHT) {
                f = terraceInfo.mDepth.floatValue() - 70.0f;
            }
        } else if (terracesInfo.mSodePosType == SodePosType.R) {
            if (panelDirectionType == PanelDirectionType.LEFT) {
                f = terraceInfo.mDepth.floatValue() - 70.0f;
            } else if (panelDirectionType == PanelDirectionType.RIGHT) {
                f = 0.0f;
            }
        } else {
            f = terracesInfo.mSodePosType == SodePosType.BOTH ? 0.0f : terraceInfo.mDepth.floatValue() - 70.0f;
        }
        return f;
    }

    public float calcKutaiDehabaWidth(SNYEntities sNYEntities, TerraceInfo terraceInfo, PanelDirectionType panelDirectionType) {
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        float f = 0.0f;
        if (terracesInfo.mEnforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI && terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
            if (panelDirectionType == PanelDirectionType.LEFT) {
                f = terraceInfo.mLeftWidth.floatValue() + 97.5f;
            } else if (panelDirectionType == PanelDirectionType.RIGHT) {
                f = terraceInfo.mRightWidth.floatValue() - 97.5f;
            }
        } else if (terracesInfo.mEnforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI && terracesInfo.mEnforcementDirType == EnforcementDirType.R) {
            if (panelDirectionType == PanelDirectionType.LEFT) {
                f = terraceInfo.mLeftWidth.floatValue() - 97.5f;
            } else if (panelDirectionType == PanelDirectionType.RIGHT) {
                f = terraceInfo.mRightWidth.floatValue() + 97.5f;
            }
        }
        return f;
    }

    public boolean isHalfSpanPitch(BasicInfo basicInfo, TerracesInfo terracesInfo) {
        return GdMutableTypeUtil.matchOR(basicInfo.mStrengthType, StrengthType.T600, StrengthType.T1500) && terracesInfo.mDepthType == TerraceDepthType.T9;
    }

    public float[] calcSpanPitches(SNYEntities sNYEntities, TerraceInfo terraceInfo) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        int n = this.mTerraceFigureCommonService.calcFrontSpanNum(terraceInfo.mWidthType, basicInfo.mKenType) / 2;
        float f = basicInfo.mKenLen.floatValue();
        if (this.isHalfSpanPitch(basicInfo, terracesInfo)) {
            n *= 2;
            if (terraceInfo.mDefaultWidth.floatValue() - terraceInfo.mWidth.floatValue() > basicInfo.mKenLen.floatValue() / 2.0f) {
                --n;
            }
            f /= 2.0f;
        }
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = f;
            ++n2;
        }
        if (n > 0 && terraceInfo.mWidthCutType != null) {
            if (GdMutableTypeUtil.matchOR(terraceInfo.mWidthCutType, WidthCutType.L)) {
                float f2;
                fArray[0] = f2 = terraceInfo.mWidth.floatValue() - f * (float)(n - 1);
            } else if (GdMutableTypeUtil.matchOR(terraceInfo.mWidthCutType, WidthCutType.R)) {
                float f3;
                fArray[n - 1] = f3 = terraceInfo.mWidth.floatValue() - f * (float)(n - 1);
            } else if (GdMutableTypeUtil.matchOR(terraceInfo.mWidthCutType, WidthCutType.BOTH)) {
                float f4;
                fArray[0] = f4 = (terraceInfo.mWidth.floatValue() - f * (float)(n - 2)) / 2.0f;
                fArray[n - 1] = f4;
            }
        }
        return fArray;
    }

    public float calcTarukiPillarsin(BasicInfo basicInfo) {
        if (basicInfo.mSubProductType == SubProductType.HALF_KAKOI) {
            return 52.0f;
        }
        if (basicInfo.mSubProductType == SubProductType.OPEN) {
            return 42.0f;
        }
        return 50.0f;
    }

    private static enum PartsUnitType {
        F,
        R;

    }
}

