/*
 * Decompiled with CFR 0.152.
 */
package option.loneterrace.shape.sunnyge.model.sunnyge.creator;

import java.awt.Color;
import java.util.Vector;
import model.parts.Parts;
import option.gad.core.util.GdMutableTypeUtil;
import option.loneterrace.common.entity.PartsFigureInfo;
import option.loneterrace.common.entity.SNYEntities;
import option.loneterrace.common.entity.TerraceInfo;
import option.loneterrace.common.entity.TerracesInfo;
import option.loneterrace.common.service.common.SNYColor;
import option.loneterrace.common.type.EnforcementDirType;
import option.loneterrace.common.type.EnforcementType;
import option.loneterrace.common.type.SubProductType;
import option.loneterrace.shape.sunnyge.model.sunnyge.creator.SNYTerraceUnitCreator;
import option.loneterrace.shape.sunnyge.model.sunnyge.item.AbstractTerraceUnitItem;
import option.loneterrace.shape.sunnyge.model.sunnyge.parts.POobiki;
import option.loneterrace.shape.sunnyge.model.sunnyge.parts.PYukaTuka;

public class OobikiCreator
extends SNYTerraceUnitCreator {
    public static final float PILLAR_TO_OOBIKI = 28.5f;
    public static final float MINIMUM_DEPTH = 1785.0f;
    public static final float MIN_KUTAI_TO_OUTER_OOBIKI = 200.0f;
    public static final float MIN_KUTAI_TO_INNER_OOBIKI = 50.0f;

    @Override
    public void create(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        SNYEntities sNYEntities = abstractTerraceUnitItem.getTerraceItem().getEntities();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        SubProductType subProductType = sNYEntities.mBasicInfo.mSubProductType;
        EnforcementType enforcementType = terracesInfo.mEnforcementType;
        if (GdMutableTypeUtil.matchOR(subProductType, SubProductType.DOMA, SubProductType.HALF_KAKOI, SubProductType.OPEN)) {
            return;
        }
        if (enforcementType != EnforcementType.DESUMI && enforcementType != EnforcementType.IRISUMI) {
            if (enforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI) {
                this.createKutaiDehabaChigai(abstractTerraceUnitItem, parts);
            } else if (enforcementType == EnforcementType.BUBUN_KAKOI) {
                this.createWidthPartial(abstractTerraceUnitItem, parts, EnforcementDirType.L);
            } else if (enforcementType == EnforcementType.DOMA_YUKA_W) {
                this.createWidthPartial(abstractTerraceUnitItem, parts, EnforcementDirType.R);
            } else if (enforcementType == EnforcementType.DOMA_YUKA_D) {
                this.createDomaYukaD(abstractTerraceUnitItem, parts);
            } else {
                this.createStandard(abstractTerraceUnitItem, parts);
            }
        }
    }

    protected void createStandard(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        float f = -terraceInfo.mWidth.floatValue() / 2.0f;
        float f2 = terraceInfo.mWidth.floatValue() / 2.0f;
        this.create(abstractTerraceUnitItem, parts, f, f2, terraceInfo.mDepth.floatValue());
    }

    protected void createKutaiDehabaChigai(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        SNYEntities sNYEntities = abstractTerraceUnitItem.getTerraceItem().getEntities();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        EnforcementDirType enforcementDirType = terracesInfo.mEnforcementDirType;
        if (!terraceInfo.mIsMaster.booleanValue()) {
            this.createStandard(abstractTerraceUnitItem, parts);
            return;
        }
        if (terracesInfo.mDepth.floatValue() <= 1785.0f) {
            return;
        }
        float f = -terracesInfo.mDepthGap.floatValue();
        float f2 = (-terracesInfo.mDepth.floatValue() + 35.0f) / 2.0f;
        float f3 = -terraceInfo.mWidth.floatValue() / 2.0f;
        float f4 = terraceInfo.mWidth.floatValue() / 2.0f;
        if (f - 200.0f < f2 && f2 < f + 50.0f) {
            f2 = f + 50.0f;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (f < f2) {
            if (enforcementDirType == EnforcementDirType.L) {
                f3 += terraceInfo.mLeftWidth.floatValue();
                bl = true;
            } else {
                f4 += -terraceInfo.mRightWidth.floatValue();
                bl2 = true;
            }
        }
        this.createTsuka(f3, f4, f2, abstractTerraceUnitItem, parts);
        if (!bl) {
            f3 += 28.5f;
        }
        if (!bl2) {
            f4 -= 28.5f;
        }
        this.createOobiki(f3, f4, f2, abstractTerraceUnitItem, parts);
    }

    protected void createWidthPartial(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts, EnforcementDirType enforcementDirType) {
        SNYEntities sNYEntities = abstractTerraceUnitItem.getTerraceItem().getEntities();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        if (terraceInfo.mDepth.floatValue() <= 1785.0f) {
            return;
        }
        EnforcementDirType enforcementDirType2 = terracesInfo.mEnforcementDirType;
        int n = this.mTerraceShapeService.findMasterTerraceInfo(sNYEntities.mTerraceInfoList).mId;
        if (enforcementDirType2 == enforcementDirType ? terraceInfo.mId > n : terraceInfo.mId < n) {
            return;
        }
        float f = -terraceInfo.mWidth.floatValue() / 2.0f;
        float f2 = terraceInfo.mWidth.floatValue() / 2.0f;
        if (terraceInfo.mIsMaster.booleanValue()) {
            if (enforcementDirType2 == enforcementDirType) {
                f2 = f + terraceInfo.mLeftWidth.floatValue();
            } else {
                f += terraceInfo.mLeftWidth.floatValue();
            }
        }
        this.create(abstractTerraceUnitItem, parts, f, f2, terracesInfo.mDepth.floatValue());
    }

    protected void createDomaYukaD(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        float f = -terraceInfo.mWidth.floatValue() / 2.0f;
        float f2 = terraceInfo.mWidth.floatValue() / 2.0f;
        this.create(abstractTerraceUnitItem, parts, f, f2, terraceInfo.mBackDepth.floatValue());
    }

    protected void create(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts, float f, float f2, float f3) {
        float f4 = f2 - 28.5f;
        float f5 = f + 28.5f;
        if (f4 - f5 <= 0.0f) {
            return;
        }
        if (f3 <= 1785.0f) {
            return;
        }
        float f6 = (-f3 + 35.0f) / 2.0f;
        this.createTsuka(f, f2, f6, abstractTerraceUnitItem, parts);
        this.createOobiki(f5, f4, f6, abstractTerraceUnitItem, parts);
    }

    private void createOobiki(float f, float f2, float f3, AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        SNYEntities sNYEntities = abstractTerraceUnitItem.getTerraceItem().getEntities();
        Vector vector = parts.getChildren(true);
        float f4 = this.judgeYukaZ(sNYEntities);
        float f5 = f4 - 60.0f;
        Color color = SNYColor.getColor(this.mShapeColorManager.getColor(0));
        POobiki pOobiki = new POobiki();
        pOobiki.set(f, f2, f3, f5, color);
        vector.add(pOobiki);
    }

    private void createTsuka(float f, float f2, float f3, AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        PYukaTuka pYukaTuka;
        SNYEntities sNYEntities = abstractTerraceUnitItem.getTerraceItem().getEntities();
        if (this.mPartsFigureService.getFloorNum(sNYEntities) > 1) {
            return;
        }
        Vector vector = parts.getChildren(true);
        float f4 = this.judgeYukaZ(sNYEntities);
        float f5 = f4 - 60.0f - 67.5f;
        Color color = SNYColor.getColor(this.mShapeColorManager.getColor(0));
        if (910.0f <= f2 - f) {
            pYukaTuka = new PYukaTuka();
            pYukaTuka.set(f + 280.0f, f3, 0.0f, f5, color);
            vector.add(pYukaTuka);
            pYukaTuka = new PYukaTuka();
            pYukaTuka.set(f2 - 280.0f, f3, 0.0f, f5, color);
            vector.add(pYukaTuka);
        }
        if (f2 - f < 910.0f || 2000.0f < f2 - f) {
            pYukaTuka = new PYukaTuka();
            pYukaTuka.set((f2 + f) / 2.0f, f3, 0.0f, f5, color);
            vector.add(pYukaTuka);
        }
    }

    protected float judgeYukaZ(SNYEntities sNYEntities) {
        PartsFigureInfo partsFigureInfo = sNYEntities.mPartsFigureInfo;
        float f = partsFigureInfo.mYukaLevelHeight.floatValue();
        f = (float)((double)f - this.mPartsFigureService.getYukaAtumi(false));
        return f;
    }
}

