/*
 * Decompiled with CFR 0.152.
 */
package option.loneterrace.shape.sunnyge.model.sunnyge.creator;

import java.awt.Color;
import java.util.Vector;
import model.parts.Parts;
import option.gad.core.inject.GdInject;
import option.loneterrace.common.entity.PartsFigureInfo;
import option.loneterrace.common.entity.SNYEntities;
import option.loneterrace.common.entity.TerraceInfo;
import option.loneterrace.common.entity.TerracesInfo;
import option.loneterrace.common.service.common.SNYColor;
import option.loneterrace.common.service.parts.TerraceFigureCommonService;
import option.loneterrace.common.type.BuildingType;
import option.loneterrace.common.type.EnforcementDirType;
import option.loneterrace.common.type.EnforcementType;
import option.loneterrace.common.type.FloorType;
import option.loneterrace.common.type.KenType;
import option.loneterrace.common.type.SubProductType;
import option.loneterrace.common.type.TerraceWidthType;
import option.loneterrace.shape.sunnyge.model.sunnyge.creator.SNYTerraceUnitCreator;
import option.loneterrace.shape.sunnyge.model.sunnyge.item.AbstractTerraceUnitItem;
import option.loneterrace.shape.sunnyge.model.sunnyge.parts.PDeirisumiKoneda;
import option.loneterrace.shape.sunnyge.model.sunnyge.parts.PDeirisumiNedaKake;
import option.loneterrace.shape.sunnyge.model.sunnyge.parts.PNeda;
import option.loneterrace.shape.sunnyge.model.sunnyge.parts.PRenketsuNeda;

public class NedaCreator
extends SNYTerraceUnitCreator {
    @GdInject
    protected TerraceFigureCommonService mTerraceFigureCommonService;
    public static final float KUTAI_TO_NEDA = 10.0f;
    public static final float PILLAR_TO_NEDA = 40.0f;
    public static final float PILLAR_TO_NEDA_HALF_KAKOI = 43.0f;
    public static final float MIKIRIZAI_WIDTH = 45.0f;
    public static final float NEJI_TO_FIN_EDGE = 7.5f;
    public static final float NEJI_TO_SHIN = 20.0f;

    @Override
    public void create(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        SNYEntities sNYEntities = abstractTerraceUnitItem.getTerraceItem().getEntities();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        SubProductType subProductType = sNYEntities.mBasicInfo.mSubProductType;
        EnforcementType enforcementType = terracesInfo.mEnforcementType;
        if (subProductType != SubProductType.DOMA) {
            if (subProductType == SubProductType.HALF_KAKOI) {
                this.createHalfKakoi(abstractTerraceUnitItem, parts);
            } else if (subProductType == SubProductType.OPEN) {
                this.createOpen(abstractTerraceUnitItem, parts);
            } else if (enforcementType == EnforcementType.DESUMI) {
                this.createDeirisumi(abstractTerraceUnitItem, parts, false);
            } else if (enforcementType == EnforcementType.IRISUMI) {
                this.createDeirisumi(abstractTerraceUnitItem, parts, true);
            } else if (enforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI) {
                this.createKutaiDehabaChigai(abstractTerraceUnitItem, parts);
            } else if (enforcementType == EnforcementType.BUBUN_KAKOI) {
                this.createBubunKakoi(abstractTerraceUnitItem, parts);
            } else if (enforcementType == EnforcementType.DOMA_YUKA_W) {
                this.createDomaYukaW(abstractTerraceUnitItem, parts);
            } else if (enforcementType == EnforcementType.DOMA_YUKA_D) {
                this.createDomaYukaD(abstractTerraceUnitItem, parts);
            } else {
                this.createStandard(abstractTerraceUnitItem, parts);
            }
        }
    }

    protected void createStandard(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        float f = -terraceInfo.mWidth.floatValue() / 2.0f + 35.0f;
        float f2 = terraceInfo.mWidth.floatValue() / 2.0f - 35.0f;
        float f3 = -terraceInfo.mDepth.floatValue() + 40.0f;
        this.create(abstractTerraceUnitItem, parts, f, f2, f3, -10.0f);
    }

    protected void createHalfKakoi(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        SNYEntities sNYEntities = abstractTerraceUnitItem.getTerraceItem().getEntities();
        PartsFigureInfo partsFigureInfo = sNYEntities.mPartsFigureInfo;
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        float f = partsFigureInfo.mKutaiUniversalPillarDepth1.floatValue();
        if (terraceInfo.mDepth.floatValue() <= f + 43.0f) {
            return;
        }
        float f2 = -terraceInfo.mWidth.floatValue() / 2.0f + 35.0f;
        float f3 = terraceInfo.mWidth.floatValue() / 2.0f - 35.0f;
        float f4 = -f + 40.0f;
        this.create(abstractTerraceUnitItem, parts, f2, f3, f4, -10.0f);
        float f5 = -terraceInfo.mDepth.floatValue() + 40.0f;
        float f6 = -f - 43.0f;
        float f7 = this.configOpenNedaTop(sNYEntities);
        this.create(abstractTerraceUnitItem, parts, f2, f3, f5, f6, f7);
    }

    protected void createOpen(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        SNYEntities sNYEntities = abstractTerraceUnitItem.getTerraceItem().getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        float f = -terraceInfo.mWidth.floatValue() / 2.0f + 35.0f;
        float f2 = terraceInfo.mWidth.floatValue() / 2.0f - 35.0f;
        float f3 = -terraceInfo.mDepth.floatValue() + 40.0f;
        float f4 = this.configOpenNedaTop(sNYEntities);
        this.create(abstractTerraceUnitItem, parts, f, f2, f3, -10.0f, f4);
    }

    protected void createKutaiDehabaChigai(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        float[] fArray;
        SNYEntities sNYEntities = abstractTerraceUnitItem.getTerraceItem().getEntities();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        EnforcementDirType enforcementDirType = terracesInfo.mEnforcementDirType;
        float f = -terraceInfo.mWidth.floatValue() / 2.0f + 35.0f;
        float f2 = terraceInfo.mWidth.floatValue() / 2.0f - 35.0f;
        float f3 = -terracesInfo.mDepth.floatValue() + 40.0f;
        float f4 = -10.0f;
        int n = this.mTerraceShapeService.findMasterTerraceInfo(sNYEntities.mTerraceInfoList).mId;
        if (enforcementDirType == EnforcementDirType.L) {
            if (terraceInfo.mId > n) {
                this.createStandard(abstractTerraceUnitItem, parts);
                return;
            }
            if (terraceInfo.mId < n) {
                this.create(abstractTerraceUnitItem, parts, f, f2, f3, f4 - terracesInfo.mDepthGap.floatValue());
                return;
            }
        } else {
            if (terraceInfo.mId > n) {
                this.create(abstractTerraceUnitItem, parts, f, f2, f3, f4 - terracesInfo.mDepthGap.floatValue());
                return;
            }
            if (terraceInfo.mId < n) {
                this.createStandard(abstractTerraceUnitItem, parts);
                return;
            }
        }
        Vector vector = parts.getChildren(true);
        float f5 = -terraceInfo.mWidth.floatValue() / 2.0f + terraceInfo.mLeftWidth.floatValue();
        float f6 = -10.0f;
        float f7 = -10.0f;
        if (enforcementDirType == EnforcementDirType.L) {
            f6 = -terracesInfo.mDepthGap.floatValue();
        } else {
            f7 = -terracesInfo.mDepthGap.floatValue();
        }
        float f8 = -terraceInfo.mWidth.floatValue() / 2.0f + 35.0f;
        float[] fArray2 = fArray = this.createPitches(terraceInfo.mWidth.floatValue() - 70.0f);
        int n2 = fArray.length;
        int n3 = 0;
        while (n3 < n2) {
            float f9 = fArray2[n3];
            float f10 = (f8 += f9) - 20.0f;
            if (enforcementDirType == EnforcementDirType.L) {
                if (f5 - 7.5f - 55.0f < f10 && f10 < f5 + 45.0f + 7.5f) {
                    f8 = f5 - 7.5f - 55.0f + 20.0f;
                }
            } else if (f5 - 7.5f - 55.0f - 45.0f < f10 && f10 < f5 + 7.5f) {
                f8 = f5 + 7.5f + 20.0f;
            }
            float f11 = f8 < f5 ? f6 : f7;
            vector.add(this.createNeda(f8, f3, f11, sNYEntities));
            ++n3;
        }
    }

    protected void createDeirisumi(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts, boolean bl) {
        TerraceInfo terraceInfo;
        TerraceInfo terraceInfo2 = abstractTerraceUnitItem.getTerraceInfo();
        if (terraceInfo2.mBuildingType == BuildingType.CORNER) {
            this.createDeirisumiCorner(abstractTerraceUnitItem, parts, bl);
            return;
        }
        if (abstractTerraceUnitItem.getNext() != null) {
            terraceInfo = abstractTerraceUnitItem.getNext().getTerraceInfo();
            if (terraceInfo.mBuildingType == BuildingType.CORNER) {
                this.createDeirisumiNeda(abstractTerraceUnitItem, parts, true, bl);
                return;
            }
        }
        if (abstractTerraceUnitItem.getPrev() != null) {
            terraceInfo = abstractTerraceUnitItem.getPrev().getTerraceInfo();
            if (terraceInfo.mBuildingType == BuildingType.CORNER) {
                this.createDeirisumiNeda(abstractTerraceUnitItem, parts, false, bl);
                return;
            }
        }
        this.createStandard(abstractTerraceUnitItem, parts);
    }

    protected void createDeirisumiCorner(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts, boolean bl) {
        SNYEntities sNYEntities = abstractTerraceUnitItem.getTerraceItem().getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        float f = terraceInfo.mDepth.floatValue() - 35.0f;
        float f2 = bl ? f : 0.0f;
        float f3 = bl ? 0.0f : f;
        float f4 = bl ? -f : 0.0f;
        float f5 = bl ? 0.0f : -f;
        Vector vector = parts.getChildren(true);
        float f6 = this.configNedaTop(sNYEntities);
        PDeirisumiNedaKake pDeirisumiNedaKake = new PDeirisumiNedaKake();
        pDeirisumiNedaKake.set(f2, f3, f4, f5, f6, this.configColor());
        vector.add(pDeirisumiNedaKake);
    }

    protected void createDeirisumiNeda(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts, boolean bl, boolean bl2) {
        float f;
        float f2;
        float f3;
        SNYEntities sNYEntities = abstractTerraceUnitItem.getTerraceItem().getEntities();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        Vector vector = parts.getChildren(true);
        int n = bl ? 1 : -1;
        int n2 = bl ? 0 : 1;
        float f4 = -terraceInfo.mWidth.floatValue() / 2.0f * (float)n;
        float f5 = this.mTerraceFigureCommonService.calcGroupWidth(sNYEntities.mTerracesInfo, sNYEntities.mTerraceInfoList, n2);
        for (TerraceInfo terraceInfo2 : sNYEntities.mTerraceInfoList) {
            if (bl) {
                if (terraceInfo2.mId >= terraceInfo.mId) continue;
                f5 -= terraceInfo2.mWidth.floatValue();
                continue;
            }
            if (terraceInfo2.mId <= terraceInfo.mId) continue;
            f5 -= terraceInfo2.mWidth.floatValue();
        }
        float f6 = f4 + (f5 - terraceInfo.mDepth.floatValue() - 287.5f) * (float)n;
        if (bl2) {
            f6 += 35.0f * (float)n;
        }
        float f7 = (f6 - 32.5f - f4) * (float)n - 35.0f;
        float[] fArray = this.createDeirisumiPitches(f7, sNYEntities);
        float f8 = f4 + 35.0f * (float)n;
        float f9 = -10.0f;
        float[] fArray2 = fArray;
        int n3 = fArray.length;
        int n4 = 0;
        while (n4 < n3) {
            f3 = fArray2[n4];
            f2 = -terracesInfo.mDepth.floatValue() + 40.0f;
            vector.add(this.createNeda(f8 += f3 * (float)n, f2, f9, sNYEntities));
            ++n4;
        }
        f3 = f4 + f5 * (float)n;
        float f10 = f3 - (float)(325 * n);
        float f11 = f6 + 45.9f * (float)n;
        fArray2 = this.createKonedaPitches((f10 - f8) * (float)n);
        f2 = f8 + fArray2[0] * (float)n;
        if (bl ? (double)f2 - 9.6 < (double)f11 : (double)f2 + 9.6 > (double)f11) {
            f8 = f6 - 32.5f * (float)n;
            f = -terracesInfo.mDepth.floatValue() + 40.0f;
            vector.add(this.createNeda(f8, f, f9, sNYEntities));
            fArray2 = this.createKonedaPitches((f10 - f8) * (float)n);
        }
        f = -terraceInfo.mDepth.floatValue() + 40.0f;
        int n5 = 0;
        while (n5 < fArray2.length - 1) {
            float f12 = f;
            f9 = -((f8 += fArray2[n5] * (float)n) - f11) * (float)n - 10.4f;
            if (bl2) {
                f12 = f - f9;
                f9 = -10.0f;
            }
            vector.add(this.createDeirisumiNeda(f8, f12, f9, bl, bl2, sNYEntities));
            ++n5;
        }
    }

    protected void createBubunKakoi(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        SNYEntities sNYEntities = abstractTerraceUnitItem.getTerraceItem().getEntities();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        EnforcementDirType enforcementDirType = terracesInfo.mEnforcementDirType;
        if (terraceInfo.mIsMaster.booleanValue()) {
            if (enforcementDirType == EnforcementDirType.L) {
                if (terraceInfo.mLeftWidthType == TerraceWidthType.DEPTH) {
                    this.createStandard(abstractTerraceUnitItem, parts);
                } else {
                    float f = -terraceInfo.mDepth.floatValue() + 40.0f;
                    float f2 = -terraceInfo.mWidth.floatValue() / 2.0f + 35.0f;
                    float f3 = -terraceInfo.mWidth.floatValue() / 2.0f + terraceInfo.mLeftWidth.floatValue() - 35.0f;
                    this.create(abstractTerraceUnitItem, parts, f2, f3, f, -10.0f);
                }
            } else if (enforcementDirType == EnforcementDirType.R) {
                if (terraceInfo.mRightWidthType == TerraceWidthType.DEPTH) {
                    this.createStandard(abstractTerraceUnitItem, parts);
                } else {
                    float f = -terraceInfo.mDepth.floatValue() + 40.0f;
                    float f4 = terraceInfo.mWidth.floatValue() / 2.0f - terraceInfo.mRightWidth.floatValue() + 35.0f;
                    float f5 = terraceInfo.mWidth.floatValue() / 2.0f - 35.0f;
                    this.create(abstractTerraceUnitItem, parts, f4, f5, f, -10.0f);
                }
            }
        } else if (terraceInfo.mFloorType == FloorType.YUKA) {
            this.createStandard(abstractTerraceUnitItem, parts);
        }
    }

    protected void createDomaYukaW(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        SNYEntities sNYEntities = abstractTerraceUnitItem.getTerraceItem().getEntities();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        EnforcementDirType enforcementDirType = terracesInfo.mEnforcementDirType;
        if (terraceInfo.mIsMaster.booleanValue()) {
            if (enforcementDirType == EnforcementDirType.R) {
                if (terraceInfo.mLeftWidthType == TerraceWidthType.DEPTH) {
                    this.createStandard(abstractTerraceUnitItem, parts);
                } else {
                    float f = -terraceInfo.mDepth.floatValue() + 40.0f;
                    float f2 = -terraceInfo.mWidth.floatValue() / 2.0f + 35.0f;
                    float f3 = f2 + terraceInfo.mLeftWidth.floatValue() - 35.0f;
                    this.create(abstractTerraceUnitItem, parts, f2, f3, f, -10.0f);
                }
            } else if (enforcementDirType == EnforcementDirType.L) {
                if (terraceInfo.mRightWidthType == TerraceWidthType.DEPTH) {
                    this.createStandard(abstractTerraceUnitItem, parts);
                } else {
                    float f = -terraceInfo.mDepth.floatValue() + 40.0f;
                    float f4 = terraceInfo.mWidth.floatValue() / 2.0f - terraceInfo.mRightWidth.floatValue() + 35.0f;
                    float f5 = terraceInfo.mWidth.floatValue() / 2.0f - 35.0f;
                    this.create(abstractTerraceUnitItem, parts, f4, f5, f, -10.0f);
                }
            }
        } else if (terraceInfo.mFloorType == FloorType.YUKA) {
            this.createStandard(abstractTerraceUnitItem, parts);
        }
    }

    protected void createDomaYukaD(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        float f = -terraceInfo.mBackDepth.floatValue() + 40.0f;
        float f2 = -terraceInfo.mWidth.floatValue() / 2.0f + 35.0f;
        float f3 = terraceInfo.mWidth.floatValue() / 2.0f - 35.0f;
        this.create(abstractTerraceUnitItem, parts, f2, f3, f, -10.0f);
    }

    protected void create(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts, float f, float f2, float f3, float f4) {
        SNYEntities sNYEntities = abstractTerraceUnitItem.getTerraceItem().getEntities();
        float f5 = this.configNedaTop(sNYEntities);
        this.create(abstractTerraceUnitItem, parts, f, f2, f3, f4, f5);
    }

    protected void create(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts, float f, float f2, float f3, float f4, float f5) {
        float[] fArray;
        SNYEntities sNYEntities = abstractTerraceUnitItem.getTerraceItem().getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        Vector vector = parts.getChildren(true);
        float f6 = f;
        float[] fArray2 = fArray = this.createPitches(f2 - f);
        int n = fArray.length;
        int n2 = 0;
        while (n2 < n) {
            float f7 = fArray2[n2];
            vector.add(this.createNeda(f6 += f7, f3, f4, f5));
            ++n2;
        }
        int n3 = this.mTerraceShapeService.findMasterTerraceInfo(sNYEntities.mTerraceInfoList).mId;
        if (terraceInfo.mId > n3) {
            vector.add(this.createRenketsuNeda(-terraceInfo.mWidth.floatValue() / 2.0f, f3, f4, f5));
        } else if (terraceInfo.mId < n3) {
            vector.add(this.createRenketsuNeda(terraceInfo.mWidth.floatValue() / 2.0f, f3, f4, f5));
        }
    }

    protected Parts createNeda(float f, float f2, float f3, SNYEntities sNYEntities) {
        float f4 = this.configNedaTop(sNYEntities);
        return this.createNeda(f, f2, f3, f4);
    }

    protected Parts createNeda(float f, float f2, float f3, float f4) {
        boolean bl = f3 - f2 > 1135.0f;
        PNeda pNeda = new PNeda();
        pNeda.set(f, f2, f3, f4, this.configColor(), bl);
        return pNeda;
    }

    protected Parts createRenketsuNeda(float f, float f2, float f3, float f4) {
        PRenketsuNeda pRenketsuNeda = new PRenketsuNeda();
        pRenketsuNeda.set(f, f2, f3, f4, this.configColor());
        return pRenketsuNeda;
    }

    protected Parts createDeirisumiNeda(float f, float f2, float f3, boolean bl, boolean bl2, SNYEntities sNYEntities) {
        float f4 = this.configNedaTop(sNYEntities);
        PDeirisumiKoneda pDeirisumiKoneda = new PDeirisumiKoneda();
        pDeirisumiKoneda.set(f, f2, f3, f4, this.configColor(), bl, bl2);
        return pDeirisumiKoneda;
    }

    protected float[] createPitches(float f) {
        if (f <= 0.0f) {
            return new float[0];
        }
        float f2 = 450.0f;
        int n = (int)Math.ceil(Math.max(f - 890.0f, 0.0f) / f2);
        float f3 = (f - f2 * (float)n) / 2.0f;
        float f4 = f3 -= 3.0f;
        float[] fArray = new float[n + 1];
        fArray[0] = f4;
        int n2 = 1;
        while (n2 < fArray.length) {
            fArray[n2] = f2;
            ++n2;
        }
        return fArray;
    }

    protected float[] createDeirisumiPitches(float f, SNYEntities sNYEntities) {
        KenType kenType = sNYEntities.mBasicInfo.mKenType;
        float f2 = kenType == KenType.KANTOUMA ? 447 : 312;
        float f3 = 450.0f;
        int n = (int)Math.floor((f - f2) / f3);
        float[] fArray = new float[n + 1];
        fArray[0] = f2;
        int n2 = 1;
        while (n2 < fArray.length) {
            fArray[n2] = f3;
            ++n2;
        }
        return fArray;
    }

    protected float[] createKonedaPitches(float f) {
        int n = (int)Math.ceil(f / 400.0f);
        float f2 = f / (float)n;
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < fArray.length) {
            fArray[n2] = f2;
            ++n2;
        }
        return fArray;
    }

    protected float configNedaTop(SNYEntities sNYEntities) {
        float f = sNYEntities.mPartsFigureInfo.mYukaLevelHeight.floatValue();
        f = (float)((double)f - this.mPartsFigureService.getYukaAtumi(false));
        return f;
    }

    protected float configOpenNedaTop(SNYEntities sNYEntities) {
        float f = sNYEntities.mPartsFigureInfo.mYukaHeight.floatValue();
        f = (float)((double)f - this.mPartsFigureService.getYukaAtumi(false));
        return f;
    }

    protected Color configColor() {
        return SNYColor.getColor(this.mShapeColorManager.getColor(0));
    }
}

