/*
 * Decompiled with CFR 0.152.
 */
package option.loneterrace.shape.sunnyge.model.sunnyge.creator;

import java.awt.Color;
import java.util.List;
import java.util.Vector;
import model.parts.Parts;
import option.gad.core.util.GdMutableTypeUtil;
import option.loneterrace.common.entity.SNYEntities;
import option.loneterrace.common.entity.TerraceInfo;
import option.loneterrace.common.entity.TerracesInfo;
import option.loneterrace.common.service.common.SNYColor;
import option.loneterrace.common.type.BuildingType;
import option.loneterrace.common.type.EnforcementDirType;
import option.loneterrace.common.type.EnforcementType;
import option.loneterrace.common.type.FloorType;
import option.loneterrace.common.type.SubProductType;
import option.loneterrace.common.type.TerraceWidthType;
import option.loneterrace.shape.sunnyge.model.sunnyge.creator.SNYTerraceUnitCreator;
import option.loneterrace.shape.sunnyge.model.sunnyge.item.AbstractTerraceUnitItem;
import option.loneterrace.shape.sunnyge.model.sunnyge.item.MsItemTerrace;
import option.loneterrace.shape.sunnyge.model.sunnyge.parts.PYukaTuka;

public class MsUnitYukaTukaCreator
extends SNYTerraceUnitCreator {
    @Override
    public void create(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.YUKA || sNYEntities.mBasicInfo.mSubProductType == SubProductType.OPEN) {
            if (terracesInfo.mEnforcementType == EnforcementType.STD) {
                this.createStandard(abstractTerraceUnitItem, parts);
            } else if (terracesInfo.mEnforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI) {
                this.createStandard(abstractTerraceUnitItem, parts);
            } else if (terracesInfo.mEnforcementType == EnforcementType.IRISUMI) {
                this.createIrisumi(abstractTerraceUnitItem, parts);
            } else if (terracesInfo.mEnforcementType == EnforcementType.DESUMI) {
                this.createDesumi(abstractTerraceUnitItem, parts);
            } else if (terracesInfo.mEnforcementType == EnforcementType.HANEDASHI) {
                this.createStandard(abstractTerraceUnitItem, parts);
            } else if (terracesInfo.mEnforcementType == EnforcementType.BUBUN_IRISUMI) {
                this.createStandard(abstractTerraceUnitItem, parts);
            } else if (terracesInfo.mEnforcementType == EnforcementType.BUBUN_KAKOI) {
                this.createBubunKakoi(abstractTerraceUnitItem, parts);
            }
        } else if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.DOMA_YUKA) {
            if (terracesInfo.mEnforcementType == EnforcementType.DOMA_YUKA_D) {
                this.createDomaYukaDehaba(abstractTerraceUnitItem, parts);
            } else if (terracesInfo.mEnforcementType == EnforcementType.DOMA_YUKA_W) {
                this.createDomaYukaKaikou(abstractTerraceUnitItem, parts);
            }
        } else if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.HALF_KAKOI) {
            this.createHalfKakoi(abstractTerraceUnitItem, parts);
        }
    }

    private void createStandard(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        float f = 0.0f;
        float f2 = -terracesInfo.mDepth.floatValue();
        float f3 = 0.0f;
        float f4 = sNYEntities.mPartsFigureInfo.mYukaHeight.floatValue() - 110.0f;
        if (terraceInfo.mWidthType == TerraceWidthType.T15 || terraceInfo.mWidthType == TerraceWidthType.T20) {
            this.createYukaTuka(f, f2, f3, f4, 0.0f, vector);
        }
    }

    private void createIrisumi(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        if (terraceInfo.mBuildingType != BuildingType.CORNER) {
            float f = 0.0f;
            float f2 = -terracesInfo.mDepth.floatValue();
            float f3 = 0.0f;
            float f4 = sNYEntities.mPartsFigureInfo.mYukaHeight.floatValue() - 110.0f;
            if (terraceInfo.mWidthType == TerraceWidthType.T15 || terraceInfo.mWidthType == TerraceWidthType.T20) {
                this.createYukaTuka(f, f2, f3, f4, 0.0f, vector);
            }
        }
    }

    private void createDesumi(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        if (terraceInfo.mBuildingType != BuildingType.CORNER) {
            float f = 0.0f;
            float f2 = -terracesInfo.mDepth.floatValue();
            float f3 = 0.0f;
            float f4 = sNYEntities.mPartsFigureInfo.mYukaHeight.floatValue() - 110.0f;
            if (this.mPartsFigureService.isPrevConner(abstractTerraceUnitItem)) {
                f = (terraceInfo.mDepth.floatValue() + 97.5f) / 2.0f * -1.0f;
                this.createYukaTuka(f, f2, f3, f4, 0.0f, vector);
            }
            if (this.mPartsFigureService.isNextConner(abstractTerraceUnitItem)) {
                f = (terraceInfo.mDepth.floatValue() + 97.5f) / 2.0f;
                this.createYukaTuka(f, f2, f3, f4, 0.0f, vector);
            }
        }
    }

    private void createBubunKakoi(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        float f = 0.0f;
        float f2 = -terracesInfo.mDepth.floatValue();
        float f3 = 0.0f;
        float f4 = sNYEntities.mPartsFigureInfo.mYukaHeight.floatValue() - 110.0f;
        if (terraceInfo.mIsStarting.booleanValue()) {
            if (terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
                if (terraceInfo.mLeftWidthType == TerraceWidthType.DEPTH && GdMutableTypeUtil.matchOR(terraceInfo.mWidthType, TerraceWidthType.T15, TerraceWidthType.T20)) {
                    f = 0.0f;
                    this.createYukaTuka(f, f2, f3, f4, 0.0f, vector);
                } else if (GdMutableTypeUtil.matchOR(terraceInfo.mLeftWidthType, TerraceWidthType.T15, TerraceWidthType.T20)) {
                    f = -terraceInfo.mWidth.floatValue() / 2.0f + terraceInfo.mLeftWidth.floatValue() / 2.0f;
                    this.createYukaTuka(f, f2, f3, f4, 0.0f, vector);
                }
            } else if (terraceInfo.mRightWidthType == TerraceWidthType.DEPTH && GdMutableTypeUtil.matchOR(terraceInfo.mWidthType, TerraceWidthType.T15, TerraceWidthType.T20)) {
                f = 0.0f;
                this.createYukaTuka(f, f2, f3, f4, 0.0f, vector);
            } else if (GdMutableTypeUtil.matchOR(terraceInfo.mRightWidthType, TerraceWidthType.T15, TerraceWidthType.T20)) {
                f = terraceInfo.mWidth.floatValue() / 2.0f - terraceInfo.mRightWidth.floatValue() / 2.0f;
                this.createYukaTuka(f, f2, f3, f4, 0.0f, vector);
            }
        } else if (terraceInfo.mBuildingType == BuildingType.ROOM && (terraceInfo.mWidthType == TerraceWidthType.T15 || terraceInfo.mWidthType == TerraceWidthType.T20)) {
            this.createYukaTuka(f, f2, f3, f4, 0.0f, vector);
        }
    }

    private void createDomaYukaDehaba(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo cfr_ignored_0 = sNYEntities.mTerracesInfo;
        float f = 0.0f;
        float f2 = -terraceInfo.mBackDepth.floatValue();
        float f3 = 0.0f;
        float f4 = sNYEntities.mPartsFigureInfo.mYukaHeight.floatValue() - 110.0f;
        if (terraceInfo.mWidthType == TerraceWidthType.T15 || terraceInfo.mWidthType == TerraceWidthType.T20) {
            this.createYukaTuka(f, f2, f3, f4, 0.0f, vector);
        }
        if (abstractTerraceUnitItem.getPrev() != null) {
            f = -terraceInfo.mWidth.floatValue() / 2.0f;
            this.createYukaTuka(f, f2, f3, f4, 0.0f, vector);
        }
    }

    private void createDomaYukaKaikou(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        float f = 0.0f;
        float f2 = -terracesInfo.mDepth.floatValue();
        float f3 = 0.0f;
        float f4 = sNYEntities.mPartsFigureInfo.mYukaHeight.floatValue() - 110.0f;
        if (terraceInfo.mIsStarting.booleanValue()) {
            TerraceWidthType terraceWidthType = null;
            if (terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
                terraceWidthType = terraceInfo.mRightWidthType;
                f = terraceInfo.mWidth.floatValue() / 2.0f - terraceInfo.mRightWidth.floatValue() / 2.0f;
            } else {
                terraceWidthType = terraceInfo.mLeftWidthType;
                f = -terraceInfo.mWidth.floatValue() / 2.0f + terraceInfo.mLeftWidth.floatValue() / 2.0f;
            }
            if (terraceWidthType == TerraceWidthType.T15 || terraceWidthType == TerraceWidthType.T20) {
                this.createYukaTuka(f, f2, f3, f4, 0.0f, vector);
            }
        } else if (terraceInfo.mFloorType == FloorType.YUKA && (terraceInfo.mWidthType == TerraceWidthType.T15 || terraceInfo.mWidthType == TerraceWidthType.T20)) {
            this.createYukaTuka(f, f2, f3, f4, 0.0f, vector);
        }
    }

    private void createHalfKakoi(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        if (terraceInfo.mWidthType == TerraceWidthType.T15 || terraceInfo.mWidthType == TerraceWidthType.T20) {
            float f = 0.0f;
            float f2 = -terracesInfo.mDepth.floatValue();
            float f3 = 0.0f;
            float f4 = sNYEntities.mPartsFigureInfo.mYukaHeight.floatValue() - 110.0f;
            this.createYukaTuka(f, f2, f3, f4, 0.0f, vector);
            if (terraceInfo.mDepth.floatValue() > sNYEntities.mPartsFigureInfo.mKutaiUniversalPillarDepth1.floatValue()) {
                f2 = -sNYEntities.mPartsFigureInfo.mKutaiUniversalPillarDepth1.floatValue();
                this.createYukaTuka(f, f2, f3, f4, 0.0f, vector);
            }
        }
    }

    private void createYukaTuka(float f, float f2, float f3, float f4, float f5, List<Parts> list) {
        Color color = SNYColor.getColor(this.mShapeColorManager.getColor(0));
        PYukaTuka pYukaTuka = new PYukaTuka();
        pYukaTuka.set(f, f2, f3, f3 + f4, color);
        list.add(pYukaTuka);
    }
}

