/*
 * Decompiled with CFR 0.152.
 */
package option.loneterrace.shape.sunnyge.model.sunnyge.creator;

import java.awt.Color;
import java.util.List;
import java.util.Vector;
import model.parts.Parts;
import option.loneterrace.common.entity.PartsFigureUnitInfo;
import option.loneterrace.common.entity.SNYEntities;
import option.loneterrace.common.entity.TerraceInfo;
import option.loneterrace.common.entity.TerracesInfo;
import option.loneterrace.common.service.common.SNYColor;
import option.loneterrace.common.type.BuildingType;
import option.loneterrace.common.type.EnforcementDirType;
import option.loneterrace.common.type.EnforcementType;
import option.loneterrace.common.type.FloorType;
import option.loneterrace.common.type.SNYColorType;
import option.loneterrace.common.type.SodePosType;
import option.loneterrace.common.type.SubProductType;
import option.loneterrace.common.type.TerraceWidthType;
import option.loneterrace.shape.sunnyge.model.sunnyge.creator.SNYTerraceUnitCreator;
import option.loneterrace.shape.sunnyge.model.sunnyge.item.AbstractTerraceUnitItem;
import option.loneterrace.shape.sunnyge.model.sunnyge.item.MsItemTerrace;
import option.loneterrace.shape.sunnyge.model.sunnyge.parts.PMaeketaTumabari;
import option.loneterrace.shape.sunnyge.model.sunnyge.parts.PTerraceYuka;
import option.loneterrace.shape.sunnyge.model.sunnyge.parts.PTerraceYukaDesumi;
import option.loneterrace.shape.sunnyge.model.sunnyge.parts.PTerraceYukaIrisumi;
import option.loneterrace.shape.sunnyge.model.sunnyge.parts.PYukashitaFusagiPanel;

public class MsUnitTerraceYukaCreator
extends SNYTerraceUnitCreator {
    private static final float KETATUMA_ATTACH_SIZE_H = 50.0f;

    @Override
    public void create(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        this.createYuka(abstractTerraceUnitItem, parts);
        this.createMaeketaTsumabari(abstractTerraceUnitItem, parts);
        this.createYukashitaFusagiPanel(abstractTerraceUnitItem, parts);
    }

    private void createYuka(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        EnforcementType enforcementType = terracesInfo.mEnforcementType;
        if (terraceInfo.mBuildingType != BuildingType.CORNER && (enforcementType == EnforcementType.DESUMI || enforcementType == EnforcementType.IRISUMI)) {
            enforcementType = EnforcementType.STD;
        }
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.YUKA || sNYEntities.mBasicInfo.mSubProductType == SubProductType.OPEN || sNYEntities.mBasicInfo.mSubProductType == SubProductType.DOMA || sNYEntities.mBasicInfo.mSubProductType == SubProductType.DOMA_YUKA || sNYEntities.mBasicInfo.mSubProductType == SubProductType.ALMI_BALCONY_PILLAR || sNYEntities.mBasicInfo.mSubProductType == SubProductType.ALMI_BALCONY_ROOF) {
            if (enforcementType == EnforcementType.STD) {
                this.createYukaStandard(abstractTerraceUnitItem, parts);
            } else if (enforcementType == EnforcementType.DESUMI) {
                this.createYukaDesumi(abstractTerraceUnitItem, parts);
            } else if (enforcementType == EnforcementType.IRISUMI) {
                this.createYukaIrisumi(abstractTerraceUnitItem, parts);
            } else if (enforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI) {
                this.createYukaKutaiDehabaChigai(abstractTerraceUnitItem, parts);
            } else if (enforcementType == EnforcementType.HANEDASHI) {
                this.createYukaHanedasi(abstractTerraceUnitItem, parts);
            } else if (enforcementType == EnforcementType.BUBUN_IRISUMI) {
                this.createYukaBubunIrisumi(abstractTerraceUnitItem, parts);
            } else if (enforcementType == EnforcementType.BUBUN_KAKOI) {
                this.createYukaBubunKakoi(abstractTerraceUnitItem, parts);
            } else if (enforcementType == EnforcementType.DOMA_YUKA_D) {
                this.createDomaYukaDehaba(abstractTerraceUnitItem, parts);
            } else if (enforcementType == EnforcementType.DOMA_YUKA_W) {
                this.createDomaYukaKaikou(abstractTerraceUnitItem, parts);
            }
        } else if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.HALF_KAKOI) {
            if (enforcementType == EnforcementType.STD) {
                this.createYukaStandardHalf(abstractTerraceUnitItem, parts);
            } else if (enforcementType != EnforcementType.DESUMI && enforcementType != EnforcementType.IRISUMI && enforcementType != EnforcementType.KUTAI_DEHABA_CHIGAI) {
            }
        }
    }

    private void createMaeketaTsumabari(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        EnforcementType enforcementType = terracesInfo.mEnforcementType;
        if (terraceInfo.mBuildingType != BuildingType.CORNER && (enforcementType == EnforcementType.DESUMI || enforcementType == EnforcementType.IRISUMI)) {
            enforcementType = EnforcementType.STD;
        }
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.YUKA || sNYEntities.mBasicInfo.mSubProductType == SubProductType.DOMA_YUKA || sNYEntities.mBasicInfo.mSubProductType == SubProductType.OPEN || sNYEntities.mBasicInfo.mSubProductType == SubProductType.ALMI_BALCONY_PILLAR || sNYEntities.mBasicInfo.mSubProductType == SubProductType.ALMI_BALCONY_ROOF) {
            if (enforcementType == EnforcementType.STD) {
                this.createMaeketaTumabariStandard(abstractTerraceUnitItem, parts);
            } else if (enforcementType != EnforcementType.DESUMI && enforcementType != EnforcementType.IRISUMI) {
                if (enforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI) {
                    this.createMaeketaTumabariKutaiDehabaChigai(abstractTerraceUnitItem, parts);
                } else if (enforcementType == EnforcementType.HANEDASHI) {
                    this.createMaeketaTumabariHanedasi(abstractTerraceUnitItem, parts);
                } else if (enforcementType == EnforcementType.BUBUN_IRISUMI) {
                    this.createMaeketaTumabariStandard(abstractTerraceUnitItem, parts);
                } else if (enforcementType == EnforcementType.BUBUN_KAKOI) {
                    this.createMaeketaTumabariBubunKakoi(abstractTerraceUnitItem, parts);
                } else if (enforcementType == EnforcementType.DOMA_YUKA_D) {
                    this.createMaeketaTumabariDomaYukaDehaba(abstractTerraceUnitItem, parts);
                } else if (enforcementType == EnforcementType.DOMA_YUKA_W) {
                    this.createMaeketaTumabariDomaYukaKaikou(abstractTerraceUnitItem, parts);
                }
            }
        } else if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.HALF_KAKOI) {
            if (enforcementType == EnforcementType.STD) {
                this.createMaeketaTumabariStandardHalf(abstractTerraceUnitItem, parts);
            } else if (enforcementType != EnforcementType.DESUMI && enforcementType != EnforcementType.IRISUMI && enforcementType != EnforcementType.KUTAI_DEHABA_CHIGAI) {
            }
        }
    }

    private void createYukashitaFusagiPanel(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        EnforcementType enforcementType = terracesInfo.mEnforcementType;
        if (terraceInfo.mBuildingType != BuildingType.CORNER && (enforcementType == EnforcementType.DESUMI || enforcementType == EnforcementType.IRISUMI)) {
            enforcementType = EnforcementType.STD;
        }
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.DOMA_YUKA) {
            if (enforcementType == EnforcementType.DOMA_YUKA_D) {
                this.createYukasitaFusagiPanelDomaYukaDehaba(abstractTerraceUnitItem, parts);
            } else if (enforcementType == EnforcementType.DOMA_YUKA_W && abstractTerraceUnitItem.getTerraceInfo().mIsStarting.booleanValue()) {
                this.createYukasitaFusagiPanelDomaYukaKaikou(abstractTerraceUnitItem, parts);
            }
        }
    }

    private void createYukaStandard(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        double d = terraceInfo.mWidth.floatValue();
        double d2 = terraceInfo.mDepth.floatValue() - 35.0f;
        double d3 = sNYEntities.mPartsFigureInfo.mYukaLevelHeight.floatValue();
        double d4 = sNYEntities.mPartsFigureInfo.mYukaHeight.floatValue();
        boolean bl = sNYEntities.mBasicInfo.mSubProductType == SubProductType.DOMA;
        double d5 = -d / 2.0;
        double d6 = 0.0;
        double d7 = d3;
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.OPEN) {
            d7 = d4;
        }
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.TSUKURITSUKE) {
            d2 = sNYEntities.mPartsFigureInfo.mKutaiUniversalPillarDepth1.floatValue() - 35.0f;
        }
        if (abstractTerraceUnitItem.getPrev() == null) {
            if (this.isLeftSode(msItemTerrace, terracesInfo, terraceInfo)) {
                d += 35.0;
                d5 -= 35.0;
            } else {
                d -= 35.0;
                d5 += 35.0;
            }
        }
        if (abstractTerraceUnitItem.getNext() == null) {
            d = this.isRightSode(msItemTerrace, terracesInfo, terraceInfo) ? (d += 35.0) : (d -= 35.0);
        }
        this.createYuka(d5, d6, d7, d, d2, sNYEntities.mFloorInfo.mFloorColorType, bl, vector);
    }

    private void createMaeketaTumabariStandard(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        double d = terraceInfo.mDepth.floatValue();
        double d2 = sNYEntities.mPartsFigureInfo.mYukaHeight.floatValue();
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.TSUKURITSUKE) {
            d = sNYEntities.mPartsFigureInfo.mKutaiUniversalPillarDepth1.floatValue() - 35.0f;
        }
        double d3 = -terraceInfo.mWidth.floatValue() / 2.0f;
        double d4 = -d;
        double d5 = terraceInfo.mWidth.floatValue() / 2.0f;
        double d6 = -d;
        double d7 = this.getKetaSizeHeight(sNYEntities);
        double d8 = this.getKetaSizeDepth(sNYEntities);
        if (terracesInfo.mEnforcementType == EnforcementType.DESUMI) {
            if (this.mPartsFigureService.isPrevConner(abstractTerraceUnitItem)) {
                d3 -= (double)(terraceInfo.mDepth.floatValue() + 97.5f - 35.0f);
            }
            if (this.mPartsFigureService.isNextConner(abstractTerraceUnitItem)) {
                d5 += (double)(terraceInfo.mDepth.floatValue() + 97.5f - 35.0f);
            }
        } else if (terracesInfo.mEnforcementType == EnforcementType.IRISUMI) {
            if (this.mPartsFigureService.isPrevConner(abstractTerraceUnitItem)) {
                d3 -= 104.0;
            }
            if (this.mPartsFigureService.isNextConner(abstractTerraceUnitItem)) {
                d5 += 104.0;
            }
        }
        if (abstractTerraceUnitItem.getPrev() == null) {
            d3 += 35.0;
        }
        if (abstractTerraceUnitItem.getNext() == null) {
            d5 -= 35.0;
        }
        this.createKeta(d3, d4, d5, d6, d2, d8, d7, vector);
        if (this.mPartsFigureService.isLeftCreateOK(abstractTerraceUnitItem)) {
            d3 = -terraceInfo.mWidth.floatValue() / 2.0f;
            d4 = -d + 35.0;
            d5 = -terraceInfo.mWidth.floatValue() / 2.0f;
            d6 = 0.0;
            this.createKeta(d3, d4, d5, d6, d2, d8, d7, vector);
        }
        if (this.mPartsFigureService.isRightCreateOK(abstractTerraceUnitItem)) {
            d3 = terraceInfo.mWidth.floatValue() / 2.0f;
            d4 = -d + 35.0;
            d5 = terraceInfo.mWidth.floatValue() / 2.0f;
            d6 = 0.0;
            this.createKeta(d3, d4, d5, d6, d2, d8, d7, vector);
        }
    }

    private void createYukaStandardHalf(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        double d = terraceInfo.mWidth.floatValue();
        double d2 = terraceInfo.mDepth.floatValue() - 35.0f;
        double d3 = sNYEntities.mPartsFigureInfo.mYukaLevelHeight.floatValue();
        double d4 = sNYEntities.mPartsFigureInfo.mYukaHeight.floatValue();
        boolean bl = sNYEntities.mBasicInfo.mSubProductType == SubProductType.DOMA;
        double d5 = -d / 2.0;
        double d6 = 0.0;
        if (abstractTerraceUnitItem.getPrev() == null) {
            if (this.isLeftSode(msItemTerrace, terracesInfo, terraceInfo)) {
                d += 35.0;
                d5 -= 35.0;
            } else {
                d -= 35.0;
                d5 += 35.0;
            }
        }
        if (abstractTerraceUnitItem.getNext() == null) {
            d = this.isRightSode(msItemTerrace, terracesInfo, terraceInfo) ? (d -= 35.0) : (d -= 35.0);
        }
        if (terraceInfo.mDepth.floatValue() < sNYEntities.mPartsFigureInfo.mKutaiUniversalPillarDepth1.floatValue()) {
            this.createYuka(d5, d6, d4, d, d2, sNYEntities.mFloorInfo.mFloorColorType, bl, vector);
        } else {
            double d7 = sNYEntities.mPartsFigureInfo.mKutaiUniversalPillarDepth1.floatValue() - 35.0f;
            this.createYuka(d5, 0.0, d3, d, d7, sNYEntities.mFloorInfo.mFloorColorType, bl, vector);
            d7 = d2 - (double)sNYEntities.mPartsFigureInfo.mKutaiUniversalPillarDepth1.floatValue() - 35.0;
            this.createYuka(d5, -sNYEntities.mPartsFigureInfo.mKutaiUniversalPillarDepth1.floatValue() - 35.0f, d4, d, d7, sNYEntities.mFloorInfo.mFloorColorType, bl, vector);
        }
    }

    private void createMaeketaTumabariStandardHalf(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        double d = sNYEntities.mPartsFigureInfo.mYukaHeight.floatValue();
        double d2 = -terraceInfo.mWidth.floatValue() / 2.0f + 35.0f;
        double d3 = -terraceInfo.mDepth.floatValue();
        double d4 = terraceInfo.mWidth.floatValue() / 2.0f - 35.0f;
        double d5 = -terraceInfo.mDepth.floatValue();
        double d6 = this.getKetaSizeHeight(sNYEntities);
        double d7 = this.getKetaSizeDepth(sNYEntities);
        this.createKeta(d2, d3, d4, d5, d, d7, d6, vector);
        if (terraceInfo.mDepth.floatValue() > sNYEntities.mPartsFigureInfo.mKutaiUniversalPillarDepth1.floatValue()) {
            d3 = d5 = (double)(-sNYEntities.mPartsFigureInfo.mKutaiUniversalPillarDepth1.floatValue());
            this.createKeta(d2, d3, d4, d5, d, d7, d6, vector);
        }
        if (this.mPartsFigureService.isLeftCreateOK(abstractTerraceUnitItem)) {
            d2 = -terraceInfo.mWidth.floatValue() / 2.0f;
            d3 = -terraceInfo.mDepth.floatValue() + 35.0f;
            d4 = -terraceInfo.mWidth.floatValue() / 2.0f;
            d5 = 0.0;
            this.createKeta(d2, d3, d4, d5, d, d7, d6, vector);
        }
        if (this.mPartsFigureService.isRightCreateOK(abstractTerraceUnitItem)) {
            d2 = terraceInfo.mWidth.floatValue() / 2.0f;
            d3 = -terraceInfo.mDepth.floatValue() - 35.0f;
            d4 = terraceInfo.mWidth.floatValue() / 2.0f;
            d5 = 0.0;
            this.createKeta(d2, d3, d4, d5, d, d7, d6, vector);
        }
    }

    private void createYukaDesumi(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        double d = terraceInfo.mWidth.floatValue() + 97.5f - 35.0f;
        double d2 = terraceInfo.mDepth.floatValue() - 35.0f + 97.5f;
        double d3 = sNYEntities.mPartsFigureInfo.mYukaLevelHeight.floatValue();
        double d4 = sNYEntities.mPartsFigureInfo.mYukaHeight.floatValue();
        boolean bl = sNYEntities.mBasicInfo.mSubProductType == SubProductType.DOMA;
        double d5 = -97.5;
        double d6 = 97.5;
        double d7 = d3;
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.OPEN) {
            d7 = d4;
        }
        this.createYukaDesumi(d5, d6, d7, d, d2, sNYEntities.mFloorInfo.mFloorColorType, bl, vector);
    }

    private void createYukaIrisumi(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        double d = terraceInfo.mWidth.floatValue() + 139.0f;
        double d2 = terraceInfo.mDepth.floatValue() + 139.0f;
        double d3 = sNYEntities.mPartsFigureInfo.mYukaLevelHeight.floatValue();
        double d4 = sNYEntities.mPartsFigureInfo.mYukaHeight.floatValue();
        boolean bl = sNYEntities.mBasicInfo.mSubProductType == SubProductType.DOMA;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = d3;
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.OPEN) {
            d7 = d4;
        }
        this.createYukaIrisumi(d5, d6, d7, d, d2, sNYEntities.mFloorInfo.mFloorColorType, bl, vector);
    }

    private void createYukaKutaiDehabaChigai(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        boolean bl;
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        double d = sNYEntities.mPartsFigureInfo.mYukaLevelHeight.floatValue();
        double d2 = sNYEntities.mPartsFigureInfo.mYukaHeight.floatValue();
        boolean bl2 = bl = sNYEntities.mBasicInfo.mSubProductType == SubProductType.DOMA;
        if (terraceInfo.mIsMaster.booleanValue()) {
            PartsFigureUnitInfo partsFigureUnitInfo = this.mPartsFigureService.findOnePartsFigureUnitInfo(sNYEntities.mPartsFigureUnitInfoList, terraceInfo);
            float f = terraceInfo.mLeftWidth.floatValue();
            float f2 = terraceInfo.mRightWidth.floatValue();
            if (partsFigureUnitInfo != null) {
                f = partsFigureUnitInfo.mLeftKutaiDehabaWidth.floatValue();
                f2 = partsFigureUnitInfo.mRightKutaiDehabaWidth.floatValue();
            }
            double d3 = f;
            double d4 = f2;
            double d5 = terraceInfo.mLeftDepth.floatValue() - 35.0f;
            double d6 = terraceInfo.mRightDepth.floatValue() - 35.0f;
            double d7 = -terraceInfo.mWidth.floatValue() / 2.0f;
            double d8 = 0.0;
            double d9 = d;
            if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.OPEN) {
                d9 = d2;
            }
            if (abstractTerraceUnitItem.getPrev() == null) {
                if (this.isLeftSode(msItemTerrace, terracesInfo, terraceInfo)) {
                    d3 += 35.0;
                    d7 -= 35.0;
                } else {
                    d3 -= 35.0;
                    d7 += 35.0;
                }
            }
            if (abstractTerraceUnitItem.getNext() == null) {
                d4 = this.isRightSode(msItemTerrace, terracesInfo, terraceInfo) ? (d4 += 35.0) : (d4 -= 35.0);
            }
            this.createYukaKutaiDehabaChigai(d7, d8, d9, d3, d4, d5, d6, sNYEntities.mFloorInfo.mFloorColorType, bl, vector);
        } else {
            double d10 = terraceInfo.mWidth.floatValue();
            double d11 = terraceInfo.mDepth.floatValue() - 35.0f;
            double d12 = -d10 / 2.0;
            double d13 = terraceInfo.mDepth.floatValue() - sNYEntities.mTerracesInfo.mDepth.floatValue();
            double d14 = d;
            if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.OPEN) {
                d14 = d2;
            }
            if (abstractTerraceUnitItem.getPrev() == null) {
                if (this.isLeftSode(msItemTerrace, terracesInfo, terraceInfo)) {
                    d10 += 35.0;
                    d12 -= 35.0;
                } else {
                    d10 -= 35.0;
                    d12 += 35.0;
                }
            }
            if (abstractTerraceUnitItem.getNext() == null) {
                d10 = this.isRightSode(msItemTerrace, terracesInfo, terraceInfo) ? (d10 += 35.0) : (d10 -= 35.0);
            }
            this.createYuka(d12, d13, d14, d10, d11, sNYEntities.mFloorInfo.mFloorColorType, bl, vector);
        }
    }

    private void createMaeketaTumabariKutaiDehabaChigai(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        double d = sNYEntities.mPartsFigureInfo.mYukaHeight.floatValue();
        double d2 = -terraceInfo.mWidth.floatValue() / 2.0f + 35.0f;
        double d3 = -sNYEntities.mTerracesInfo.mDepth.floatValue();
        double d4 = terraceInfo.mWidth.floatValue() / 2.0f - 35.0f;
        double d5 = -sNYEntities.mTerracesInfo.mDepth.floatValue();
        double d6 = this.getKetaSizeHeight(sNYEntities);
        double d7 = this.getKetaSizeDepth(sNYEntities);
        this.createKeta(d2, d3, d4, d5, d, d7, d6, vector);
        if (this.mPartsFigureService.isLeftCreateOK(abstractTerraceUnitItem)) {
            d2 = -terraceInfo.mWidth.floatValue() / 2.0f;
            d3 = -sNYEntities.mTerracesInfo.mDepth.floatValue() + 35.0f;
            d4 = -terraceInfo.mWidth.floatValue() / 2.0f;
            d5 = terraceInfo.mDepth.floatValue() - sNYEntities.mTerracesInfo.mDepth.floatValue();
            if (terraceInfo.mIsMaster.booleanValue()) {
                d5 = terraceInfo.mLeftDepth.floatValue() - sNYEntities.mTerracesInfo.mDepth.floatValue();
            }
            this.createKeta(d2, d3, d4, d5, d, d7, d6, vector);
        }
        if (this.mPartsFigureService.isRightCreateOK(abstractTerraceUnitItem)) {
            d2 = terraceInfo.mWidth.floatValue() / 2.0f;
            d3 = -sNYEntities.mTerracesInfo.mDepth.floatValue() - 35.0f;
            d4 = terraceInfo.mWidth.floatValue() / 2.0f;
            d5 = terraceInfo.mDepth.floatValue() - sNYEntities.mTerracesInfo.mDepth.floatValue();
            if (terraceInfo.mIsMaster.booleanValue()) {
                d5 = terraceInfo.mRightDepth.floatValue() - sNYEntities.mTerracesInfo.mDepth.floatValue();
            }
            this.createKeta(d2, d3, d4, d5, d, d7, d6, vector);
        }
    }

    private void createYukaHanedasi(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        double d = terraceInfo.mWidth.floatValue();
        double d2 = terraceInfo.mDepth.floatValue() - 35.0f;
        double d3 = sNYEntities.mPartsFigureInfo.mYukaLevelHeight.floatValue();
        double d4 = sNYEntities.mPartsFigureInfo.mYukaHeight.floatValue();
        boolean bl = sNYEntities.mBasicInfo.mSubProductType == SubProductType.DOMA;
        double d5 = -d / 2.0;
        double d6 = 0.0;
        double d7 = d3;
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.OPEN) {
            d7 = d4;
        }
        if (abstractTerraceUnitItem.getPrev() == null) {
            if (this.isLeftSode(msItemTerrace, terracesInfo, terraceInfo)) {
                d += 35.0;
                d5 -= 35.0;
            } else {
                d -= 35.0;
                d5 += 35.0;
            }
        }
        if (abstractTerraceUnitItem.getNext() == null) {
            d = this.isRightSode(msItemTerrace, terracesInfo, terraceInfo) ? (d += 35.0) : (d -= 35.0);
        }
        this.createYuka(d5, d6, d7, d, d2, sNYEntities.mFloorInfo.mFloorColorType, bl, vector);
    }

    private void createMaeketaTumabariHanedasi(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        double d = sNYEntities.mPartsFigureInfo.mYukaHeight.floatValue();
        double d2 = -terraceInfo.mWidth.floatValue() / 2.0f + 35.0f;
        double d3 = -terraceInfo.mDepth.floatValue();
        double d4 = terraceInfo.mWidth.floatValue() / 2.0f - 35.0f;
        double d5 = -terraceInfo.mDepth.floatValue();
        double d6 = this.getKetaSizeHeight(sNYEntities);
        double d7 = this.getKetaSizeDepth(sNYEntities);
        this.createKeta(d2, d3, d4, d5, d, d7, d6, vector);
        if (this.mPartsFigureService.isLeftCreateOK(abstractTerraceUnitItem)) {
            d2 = -terraceInfo.mWidth.floatValue() / 2.0f;
            d3 = -terraceInfo.mDepth.floatValue() + 35.0f;
            d4 = -terraceInfo.mWidth.floatValue() / 2.0f;
            d5 = 0.0;
            this.createKeta(d2, d3, d4, d5, d, d7, d6, vector);
        }
        if (this.mPartsFigureService.isRightCreateOK(abstractTerraceUnitItem)) {
            d2 = terraceInfo.mWidth.floatValue() / 2.0f;
            d3 = -terraceInfo.mDepth.floatValue() - 35.0f;
            d4 = terraceInfo.mWidth.floatValue() / 2.0f;
            d5 = 0.0;
            this.createKeta(d2, d3, d4, d5, d, d7, d6, vector);
        }
        if (sNYEntities.mTerracesInfo.mLeftHanedashiLen != null && terraceInfo.mIsStarting.booleanValue() && sNYEntities.mTerracesInfo.mLeftHanedashiLen.floatValue() > 0.0f) {
            d2 = -terraceInfo.mWidth.floatValue() / 2.0f + 35.0f;
            d3 = 35.0;
            d4 = d2 + (double)sNYEntities.mTerracesInfo.mLeftHanedashiLen.floatValue() - 70.0;
            d5 = d3;
            this.createKeta(d2, d3, d4, d5, d, d7, d6, vector);
        }
        if (sNYEntities.mTerracesInfo.mRightHanedashiLen != null && terraceInfo.mIsStarting.booleanValue() && sNYEntities.mTerracesInfo.mRightHanedashiLen.floatValue() > 0.0f) {
            d2 = terraceInfo.mWidth.floatValue() / 2.0f - 35.0f;
            d3 = 35.0;
            d4 = d2 - (double)sNYEntities.mTerracesInfo.mRightHanedashiLen.floatValue() + 70.0;
            d5 = d3;
            this.createKeta(d2, d3, d4, d5, d, d7, d6, vector);
        }
    }

    private void createYukaBubunKakoi(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        boolean bl;
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        double d = terraceInfo.mDepth.floatValue() - 35.0f;
        double d2 = sNYEntities.mPartsFigureInfo.mYukaLevelHeight.floatValue();
        boolean bl2 = bl = sNYEntities.mBasicInfo.mSubProductType == SubProductType.DOMA;
        if (terraceInfo.mIsStarting.booleanValue()) {
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = d2;
            if (terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
                d3 = terraceInfo.mLeftWidth.floatValue() - 35.0f;
                d4 = -terraceInfo.mWidth.floatValue() / 2.0f;
                if (abstractTerraceUnitItem.getPrev() == null) {
                    if (this.isLeftSode(msItemTerrace, terracesInfo, terraceInfo)) {
                        d4 -= 35.0;
                        d3 += 35.0;
                    } else {
                        d4 += 35.0;
                        d3 -= 35.0;
                    }
                }
            } else {
                d3 = terraceInfo.mRightWidth.floatValue() - 35.0f;
                d4 = terraceInfo.mWidth.floatValue() / 2.0f - terraceInfo.mRightWidth.floatValue() + 35.0f;
                if (abstractTerraceUnitItem.getNext() == null) {
                    d3 = this.isRightSode(msItemTerrace, terracesInfo, terraceInfo) ? (d3 += 35.0) : (d3 -= 35.0);
                }
            }
            this.createYuka(d4, d5, d6, d3, d, sNYEntities.mFloorInfo.mFloorColorType, bl, vector);
        } else if (terraceInfo.mBuildingType == BuildingType.ROOM) {
            double d7 = -terraceInfo.mWidth.floatValue() / 2.0f;
            double d8 = 0.0;
            double d9 = d2;
            double d10 = terraceInfo.mWidth.floatValue();
            if (abstractTerraceUnitItem.getPrev() == null) {
                if (this.isLeftSode(msItemTerrace, terracesInfo, terraceInfo)) {
                    d7 -= 35.0;
                    d10 += 35.0;
                } else {
                    d7 += 35.0;
                    d10 -= 35.0;
                }
            }
            if (abstractTerraceUnitItem.getNext() == null) {
                d10 = this.isRightSode(msItemTerrace, terracesInfo, terraceInfo) ? (d10 += 35.0) : (d10 -= 35.0);
            }
            this.createYuka(d7, d8, d9, d10, d, sNYEntities.mFloorInfo.mFloorColorType, bl, vector);
        }
    }

    private void createMaeketaTumabariBubunKakoi(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        double d = terraceInfo.mDepth.floatValue();
        double d2 = sNYEntities.mPartsFigureInfo.mYukaHeight.floatValue();
        double d3 = this.getKetaSizeHeight(sNYEntities);
        double d4 = this.getKetaSizeDepth(sNYEntities);
        if (terraceInfo.mIsStarting.booleanValue()) {
            double d5 = 0.0;
            double d6 = 0.0;
            if (terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
                d5 = -terraceInfo.mWidth.floatValue() / 2.0f;
                d6 = -terraceInfo.mWidth.floatValue() / 2.0f + terraceInfo.mLeftWidth.floatValue();
            } else {
                d5 = terraceInfo.mWidth.floatValue() / 2.0f - terraceInfo.mRightWidth.floatValue();
                d6 = terraceInfo.mWidth.floatValue() / 2.0f;
            }
            double d7 = d5 + 35.0;
            double d8 = -d;
            double d9 = d6 - 35.0;
            double d10 = -d;
            this.createKeta(d7, d8, d9, d10, d2, d4, d3, vector);
            if (terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
                if (this.mPartsFigureService.isLeftCreateOK(abstractTerraceUnitItem)) {
                    d7 = d5;
                    d8 = -d + 35.0;
                    d9 = d5;
                    d10 = -35.0;
                    this.createKeta(d7, d8, d9, d10, d2, d4, d3, vector);
                }
                d7 = d6;
                d8 = -d + 35.0;
                d9 = d6;
                d10 = -35.0;
                this.createKeta(d7, d8, d9, d10, d2, d4, d3, vector);
            } else {
                d7 = d5;
                d8 = -d + 35.0;
                d9 = d5;
                d10 = -35.0;
                this.createKeta(d7, d8, d9, d10, d2, d4, d3, vector);
                if (this.mPartsFigureService.isRightCreateOK(abstractTerraceUnitItem)) {
                    d7 = d6;
                    d8 = -d + 35.0;
                    d9 = d6;
                    d10 = -35.0;
                    this.createKeta(d7, d8, d9, d10, d2, d4, d3, vector);
                }
            }
        } else if (terraceInfo.mBuildingType == BuildingType.ROOM) {
            double d11 = -terraceInfo.mWidth.floatValue() / 2.0f + 35.0f;
            double d12 = -d;
            double d13 = terraceInfo.mWidth.floatValue() / 2.0f - 35.0f;
            double d14 = -d;
            this.createKeta(d11, d12, d13, d14, d2, d4, d3, vector);
            if (this.mPartsFigureService.isLeftCreateOK(abstractTerraceUnitItem)) {
                d11 = -terraceInfo.mWidth.floatValue() / 2.0f;
                d12 = -d + 35.0;
                d13 = -terraceInfo.mWidth.floatValue() / 2.0f;
                d14 = 0.0;
                this.createKeta(d11, d12, d13, d14, d2, d4, d3, vector);
            }
            if (this.mPartsFigureService.isRightCreateOK(abstractTerraceUnitItem)) {
                d11 = terraceInfo.mWidth.floatValue() / 2.0f;
                d12 = -d + 35.0;
                d13 = terraceInfo.mWidth.floatValue() / 2.0f;
                d14 = 0.0;
                this.createKeta(d11, d12, d13, d14, d2, d4, d3, vector);
            }
        }
    }

    private void createDomaYukaDehaba(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        double d = terraceInfo.mWidth.floatValue();
        double d2 = terraceInfo.mBackDepth.floatValue() - 35.0f;
        double d3 = sNYEntities.mPartsFigureInfo.mYukaLevelHeight.floatValue();
        double cfr_ignored_0 = sNYEntities.mPartsFigureInfo.mYukaHeight.floatValue();
        double d4 = -d / 2.0;
        double d5 = 0.0;
        double d6 = d3;
        if (abstractTerraceUnitItem.getPrev() == null) {
            if (this.isLeftSode(msItemTerrace, terracesInfo, terraceInfo)) {
                d += 35.0;
                d4 -= 35.0;
            } else {
                d -= 35.0;
                d4 += 35.0;
            }
        }
        if (abstractTerraceUnitItem.getNext() == null) {
            d = this.isRightSode(msItemTerrace, terracesInfo, terraceInfo) ? (d += 35.0) : (d -= 35.0);
        }
        this.createYuka(d4, d5, d6, d, d2, sNYEntities.mFloorInfo.mFloorColorType, false, vector);
        d2 = terraceInfo.mDepth.floatValue() - terraceInfo.mBackDepth.floatValue();
        d5 = -terraceInfo.mBackDepth.floatValue();
        d6 = this.mPartsFigureService.getYukaAtumi(true);
        this.createYuka(d4, d5, d6, d, d2, sNYEntities.mFloorInfo.mFloorColorType, true, vector);
    }

    private void createMaeketaTumabariDomaYukaDehaba(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        double d = terraceInfo.mBackDepth.floatValue();
        double d2 = sNYEntities.mPartsFigureInfo.mYukaHeight.floatValue();
        double d3 = this.getKetaSizeHeight(sNYEntities);
        double d4 = this.getKetaSizeDepth(sNYEntities);
        double d5 = -terraceInfo.mWidth.floatValue() / 2.0f;
        double d6 = -d;
        double d7 = terraceInfo.mWidth.floatValue() / 2.0f;
        double d8 = -d;
        this.createKeta(d5, d6, d7, d8, d2 + 50.0, d4, d3 + 50.0, vector);
        if (this.mPartsFigureService.isLeftCreateOK(abstractTerraceUnitItem)) {
            d5 = -terraceInfo.mWidth.floatValue() / 2.0f;
            d6 = -d + 35.0;
            d7 = -terraceInfo.mWidth.floatValue() / 2.0f;
            d8 = 0.0;
            this.createKeta(d5, d6, d7, d8, d2, d4, d3, vector);
        }
        if (this.mPartsFigureService.isRightCreateOK(abstractTerraceUnitItem)) {
            d5 = terraceInfo.mWidth.floatValue() / 2.0f;
            d6 = -d + 35.0;
            d7 = terraceInfo.mWidth.floatValue() / 2.0f;
            d8 = 0.0;
            this.createKeta(d5, d6, d7, d8, d2, d4, d3, vector);
        }
    }

    private void createDomaYukaKaikou(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = terraceInfo.mDepth.floatValue() - 35.0f;
        double d4 = sNYEntities.mPartsFigureInfo.mYukaLevelHeight.floatValue();
        if (terraceInfo.mIsStarting.booleanValue()) {
            boolean bl = false;
            boolean bl2 = false;
            if (terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
                d = terraceInfo.mWidth.floatValue() - terraceInfo.mRightWidth.floatValue();
                d2 = terraceInfo.mRightWidth.floatValue();
                bl = true;
            } else {
                d = terraceInfo.mLeftWidth.floatValue();
                d2 = terraceInfo.mWidth.floatValue() - terraceInfo.mLeftWidth.floatValue();
                bl2 = true;
            }
            double d5 = -terraceInfo.mWidth.floatValue() / 2.0f;
            double d6 = 0.0;
            double d7 = 0.0;
            if (abstractTerraceUnitItem.getPrev() == null) {
                if (this.isLeftSode(msItemTerrace, terracesInfo, terraceInfo)) {
                    d += 35.0;
                    d5 -= 35.0;
                } else {
                    d -= 35.0;
                    d5 += 35.0;
                }
            }
            if (abstractTerraceUnitItem.getNext() == null) {
                d2 = this.isRightSode(msItemTerrace, terracesInfo, terraceInfo) ? (d2 += 35.0) : (d2 -= 35.0);
            }
            d7 = bl ? this.mPartsFigureService.getYukaAtumi(true) : d4;
            this.createYuka(d5, d6, d7, d - 35.0, d3, sNYEntities.mFloorInfo.mFloorColorType, bl, vector);
            d7 = bl2 ? this.mPartsFigureService.getYukaAtumi(true) : d4;
            this.createYuka(d5 += d + 35.0, d6, d7, d2 - 35.0, d3, sNYEntities.mFloorInfo.mFloorColorType, bl2, vector);
        } else {
            double d8 = -terraceInfo.mWidth.floatValue() / 2.0f;
            double d9 = 0.0;
            double d10 = this.mPartsFigureService.getYukaAtumi(true);
            double d11 = terraceInfo.mWidth.floatValue();
            boolean bl = true;
            if (abstractTerraceUnitItem.getPrev() == null) {
                if (this.isLeftSode(msItemTerrace, terracesInfo, terraceInfo)) {
                    d8 -= 35.0;
                    d11 += 35.0;
                } else {
                    d8 += 35.0;
                    d11 -= 35.0;
                }
            }
            if (abstractTerraceUnitItem.getNext() == null) {
                d11 = this.isRightSode(msItemTerrace, terracesInfo, terraceInfo) ? (d11 += 35.0) : (d11 -= 35.0);
            }
            if (terraceInfo.mFloorType == FloorType.YUKA) {
                d10 = d4;
                bl = false;
            }
            this.createYuka(d8, d9, d10, d11, d3, sNYEntities.mFloorInfo.mFloorColorType, bl, vector);
        }
    }

    private void createMaeketaTumabariDomaYukaKaikou(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        double d = terraceInfo.mDepth.floatValue();
        double d2 = sNYEntities.mPartsFigureInfo.mYukaHeight.floatValue();
        double d3 = this.getKetaSizeHeight(sNYEntities);
        double d4 = this.getKetaSizeDepth(sNYEntities);
        if (terraceInfo.mIsStarting.booleanValue()) {
            double d5 = 0.0;
            double d6 = 0.0;
            if (terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
                d5 = terraceInfo.mWidth.floatValue() / 2.0f - terraceInfo.mRightWidth.floatValue();
                d6 = terraceInfo.mWidth.floatValue() / 2.0f;
            } else {
                d5 = -terraceInfo.mWidth.floatValue() / 2.0f;
                d6 = -terraceInfo.mWidth.floatValue() / 2.0f + terraceInfo.mLeftWidth.floatValue();
            }
            double d7 = d5 + 35.0;
            double d8 = -d;
            double d9 = d6 - 35.0;
            double d10 = -d;
            this.createKeta(d7, d8, d9, d10, d2, d4, d3, vector);
            if (terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
                d7 = d5;
                d8 = -d + 35.0;
                d9 = d5;
                d10 = -35.0;
                this.createKeta(d7, d8, d9, d10, d2 + 50.0, d4, d3 + 50.0, vector);
                if (this.mPartsFigureService.isLeftCreateOK(abstractTerraceUnitItem)) {
                    d7 = d6;
                    d8 = -d + 35.0;
                    d9 = d6;
                    d10 = -35.0;
                    this.createKeta(d7, d8, d9, d10, d2, d4, d3, vector);
                }
            } else {
                if (this.mPartsFigureService.isRightCreateOK(abstractTerraceUnitItem)) {
                    d7 = d5;
                    d8 = -d + 35.0;
                    d9 = d5;
                    d10 = -35.0;
                    this.createKeta(d7, d8, d9, d10, d2, d4, d3, vector);
                }
                d7 = d6;
                d8 = -d + 35.0;
                d9 = d6;
                d10 = -35.0;
                this.createKeta(d7, d8, d9, d10, d2 + 50.0, d4, d3 + 50.0, vector);
            }
        } else if (terraceInfo.mFloorType == FloorType.YUKA) {
            double d11 = -terraceInfo.mWidth.floatValue() / 2.0f + 35.0f;
            double d12 = -d;
            double d13 = terraceInfo.mWidth.floatValue() / 2.0f - 35.0f;
            double d14 = -d;
            this.createKeta(d11, d12, d13, d14, d2, d4, d3, vector);
            if (this.mPartsFigureService.isLeftCreateOK(abstractTerraceUnitItem)) {
                d11 = -terraceInfo.mWidth.floatValue() / 2.0f;
                d12 = -d + 35.0;
                d13 = -terraceInfo.mWidth.floatValue() / 2.0f;
                d14 = 0.0;
                this.createKeta(d11, d12, d13, d14, d2, d4, d3, vector);
            }
            if (this.mPartsFigureService.isRightCreateOK(abstractTerraceUnitItem)) {
                d11 = terraceInfo.mWidth.floatValue() / 2.0f;
                d12 = -d + 35.0;
                d13 = terraceInfo.mWidth.floatValue() / 2.0f;
                d14 = 0.0;
                this.createKeta(d11, d12, d13, d14, d2, d4, d3, vector);
            }
        }
    }

    private void createYukasitaFusagiPanelDomaYukaKaikou(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        float f = sNYEntities.mPartsFigureInfo.mYukaHeight.floatValue() - this.getKetaSizeHeight(sNYEntities);
        float f2 = -35.0f;
        float f3 = -terraceInfo.mDepth.floatValue() + 35.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        f4 = terracesInfo.mEnforcementDirType == EnforcementDirType.L ? terraceInfo.mWidth.floatValue() / 2.0f - terraceInfo.mRightWidth.floatValue() : -terraceInfo.mWidth.floatValue() / 2.0f + terraceInfo.mLeftWidth.floatValue();
        f6 = f2 - f3;
        f5 = (f2 + f3) / 2.0f;
        this.createYukasitaFusagiPanel(f4, f5, f6, f, 90.0, vector);
    }

    private void createYukasitaFusagiPanelDomaYukaDehaba(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo cfr_ignored_0 = sNYEntities.mTerracesInfo;
        float f = sNYEntities.mPartsFigureInfo.mYukaHeight.floatValue() - this.getKetaSizeHeight(sNYEntities);
        float f2 = 0.0f;
        float f3 = -terraceInfo.mBackDepth.floatValue();
        float f4 = terraceInfo.mWidth.floatValue() - 70.0f;
        if (terraceInfo.mWidthType == TerraceWidthType.T15 || terraceInfo.mWidthType == TerraceWidthType.T20) {
            f2 = -terraceInfo.mWidth.floatValue() / 4.0f + 11.25f;
            f4 = terraceInfo.mWidth.floatValue() / 2.0f - 35.0f - 22.5f;
            this.createYukasitaFusagiPanel(f2, f3, f4, f, 0.0, vector);
            f2 = terraceInfo.mWidth.floatValue() / 4.0f - 11.25f;
            this.createYukasitaFusagiPanel(f2, f3, f4, f, 0.0, vector);
        } else {
            this.createYukasitaFusagiPanel(f2, f3, f4, f, 0.0, vector);
        }
    }

    private void createYukaBubunIrisumi(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        double d = terraceInfo.mWidth.floatValue();
        double d2 = terraceInfo.mDepth.floatValue() - 35.0f;
        double d3 = sNYEntities.mPartsFigureInfo.mYukaLevelHeight.floatValue();
        boolean bl = sNYEntities.mBasicInfo.mSubProductType == SubProductType.DOMA;
        double d4 = -d / 2.0;
        double d5 = 0.0;
        double d6 = d3;
        if (abstractTerraceUnitItem.getPrev() == null) {
            d -= 35.0;
            d4 += 35.0;
        }
        if (abstractTerraceUnitItem.getNext() == null) {
            d -= 35.0;
        }
        this.createYuka(d4, d5, d6, d, d2, sNYEntities.mFloorInfo.mFloorColorType, bl, vector);
    }

    private void createYuka(double d, double d2, double d3, double d4, double d5, SNYColorType sNYColorType, boolean bl, List<Parts> list) {
        Color color = this.getColor(sNYColorType, bl);
        double d6 = this.mPartsFigureService.getYukaAtumi(bl);
        PTerraceYuka pTerraceYuka = new PTerraceYuka();
        pTerraceYuka.set(d, d2, d3, d4, d5, d6, 0.0, color);
        list.add(pTerraceYuka);
    }

    private void createYukaDesumi(double d, double d2, double d3, double d4, double d5, SNYColorType sNYColorType, boolean bl, List<Parts> list) {
        Color color = this.getColor(sNYColorType, bl);
        double d6 = this.mPartsFigureService.getYukaAtumi(bl);
        PTerraceYukaDesumi pTerraceYukaDesumi = new PTerraceYukaDesumi();
        pTerraceYukaDesumi.set(d, d2, d3, d4, d5, d6, 0.0, color);
        list.add(pTerraceYukaDesumi);
    }

    private void createYukaIrisumi(double d, double d2, double d3, double d4, double d5, SNYColorType sNYColorType, boolean bl, List<Parts> list) {
        Color color = this.getColor(sNYColorType, bl);
        double d6 = this.mPartsFigureService.getYukaAtumi(bl);
        PTerraceYukaIrisumi pTerraceYukaIrisumi = new PTerraceYukaIrisumi();
        pTerraceYukaIrisumi.set(d, d2, d3, d4, d5, d6, 0.0, color);
        list.add(pTerraceYukaIrisumi);
    }

    private void createYukaKutaiDehabaChigai(double d, double d2, double d3, double d4, double d5, double d6, double d7, SNYColorType sNYColorType, boolean bl, List<Parts> list) {
        Color color = this.getColor(sNYColorType, bl);
        double d8 = this.mPartsFigureService.getYukaAtumi(bl);
        double d9 = d6 - d7;
        double d10 = d6 < d7 ? d9 : 0.0;
        PTerraceYuka pTerraceYuka = new PTerraceYuka();
        pTerraceYuka.set(d, d2 + d10, d3, d4, d6, d8, 0.0, color);
        list.add(pTerraceYuka);
        PTerraceYuka pTerraceYuka2 = new PTerraceYuka();
        pTerraceYuka2.set(d + d4, d2 + (d10 -= d9), d3, d5, d7, d8, 0.0, color);
        list.add(pTerraceYuka2);
    }

    private void createKeta(double d, double d2, double d3, double d4, double d5, double d6, double d7, List<Parts> list) {
        Color color = SNYColor.getColor(this.mShapeColorManager.getColor(0));
        PMaeketaTumabari pMaeketaTumabari = new PMaeketaTumabari();
        pMaeketaTumabari.set(d, d2, d3, d4, d5, d6, d7, color);
        list.add(pMaeketaTumabari);
    }

    private void createYukasitaFusagiPanel(double d, double d2, double d3, double d4, double d5, List<Parts> list) {
        Color color = SNYColor.getColor(this.mShapeColorManager.getColor(0));
        Color color2 = SNYColor.getColor(SNYColorType.IVORY_WHITE);
        PYukashitaFusagiPanel pYukashitaFusagiPanel = new PYukashitaFusagiPanel();
        pYukashitaFusagiPanel.set(d, d2, d3, d4, d5, color, color2);
        list.add(pYukashitaFusagiPanel);
    }

    private float getKetaSizeHeight(SNYEntities sNYEntities) {
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.ALMI_BALCONY_PILLAR || sNYEntities.mBasicInfo.mSubProductType == SubProductType.ALMI_BALCONY_ROOF) {
            return 155.0f;
        }
        return 110.0f;
    }

    private float getKetaSizeDepth(SNYEntities sNYEntities) {
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.ALMI_BALCONY_PILLAR || sNYEntities.mBasicInfo.mSubProductType == SubProductType.ALMI_BALCONY_ROOF) {
            return 70.0f;
        }
        return 70.0f;
    }

    private Color getColor(SNYColorType sNYColorType, boolean bl) {
        if (bl) {
            return new Color(233, 233, 234, 255);
        }
        return SNYColor.getColor(sNYColorType);
    }

    private boolean isLeftSode(MsItemTerrace msItemTerrace, TerracesInfo terracesInfo, TerraceInfo terraceInfo) {
        return (terracesInfo.mSodePosType == SodePosType.L || terracesInfo.mSodePosType == SodePosType.BOTH) && msItemTerrace.getFirstUnit().getTerraceInfo().mId == terraceInfo.mId;
    }

    private boolean isRightSode(MsItemTerrace msItemTerrace, TerracesInfo terracesInfo, TerraceInfo terraceInfo) {
        return (terracesInfo.mSodePosType == SodePosType.R || terracesInfo.mSodePosType == SodePosType.BOTH) && msItemTerrace.getFirstUnit().getTerraceInfo().mId == terraceInfo.mId;
    }
}

