/*
 * Decompiled with CFR 0.152.
 */
package option.loneterrace.shape.sunnyge.model.sunnyge.creator;

import java.awt.Color;
import java.util.List;
import java.util.Vector;
import model.parts.Parts;
import option.gad.core.util.GdMutableTypeUtil;
import option.loneterrace.common.entity.BasicInfo;
import option.loneterrace.common.entity.SNYEntities;
import option.loneterrace.common.entity.TerraceInfo;
import option.loneterrace.common.entity.TerracesInfo;
import option.loneterrace.common.service.common.SNYColor;
import option.loneterrace.common.type.BuildingType;
import option.loneterrace.common.type.EnforcementDirType;
import option.loneterrace.common.type.EnforcementType;
import option.loneterrace.common.type.KetaType;
import option.loneterrace.common.type.SubProductType;
import option.loneterrace.common.type.TerraceWidthType;
import option.loneterrace.shape.sunnyge.model.sunnyge.creator.SNYTerraceUnitCreator;
import option.loneterrace.shape.sunnyge.model.sunnyge.item.AbstractTerraceUnitItem;
import option.loneterrace.shape.sunnyge.model.sunnyge.item.MsItemTerrace;
import option.loneterrace.shape.sunnyge.model.sunnyge.parts.PHanedashizai;
import option.loneterrace.shape.sunnyge.model.sunnyge.parts.PPillar;
import option.loneterrace.shape.sunnyge.model.sunnyge.parts.PPillarAttachment;
import option.loneterrace.shape.sunnyge.model.sunnyge.parts.PPillarFoot;
import option.loneterrace.shape.sunnyge.model.sunnyge.parts.PProjectingPillar;

public class MsUnitPillarCreator
extends SNYTerraceUnitCreator {
    @Override
    public void create(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        if (!this.mPartsFigureService.isUseRoof(sNYEntities, terraceInfo)) {
            return;
        }
        if (basicInfo.mKetaType == KetaType.FREE && (terracesInfo.mEnforcementType == EnforcementType.STD || terracesInfo.mEnforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI)) {
            if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.TSUKURITSUKE || sNYEntities.mBasicInfo.mSubProductType == SubProductType.ALMI_BALCONY_PILLAR || sNYEntities.mBasicInfo.mSubProductType == SubProductType.ALMI_BALCONY_ROOF) {
                this.createHalfStandard(abstractTerraceUnitItem, parts);
            }
        } else if (terracesInfo.mEnforcementType == EnforcementType.IRISUMI) {
            this.createIrisumi(abstractTerraceUnitItem, parts);
        } else if (terracesInfo.mEnforcementType == EnforcementType.DESUMI) {
            this.createDesumi(abstractTerraceUnitItem, parts);
        } else if (terracesInfo.mEnforcementType == EnforcementType.BUBUN_IRISUMI) {
            this.createBubunIrisumi(abstractTerraceUnitItem, parts);
        } else if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.ALMI_BALCONY_PILLAR) {
            this.createAlmiBalconyPillar(abstractTerraceUnitItem, parts);
        } else if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.ALMI_BALCONY_ROOF) {
            this.createAlmiBalconyRoof(abstractTerraceUnitItem, parts);
        } else {
            this.createStandard(abstractTerraceUnitItem, parts);
            if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.HALF_KAKOI) {
                this.createHalfStandard(abstractTerraceUnitItem, parts);
            }
            if (terracesInfo.mEnforcementType == EnforcementType.DOMA_YUKA_W && terraceInfo.mIsMaster.booleanValue()) {
                this.createDomaYukaKaikouCenterPole(abstractTerraceUnitItem, parts);
            }
            if (terracesInfo.mEnforcementType == EnforcementType.DOMA_YUKA_D) {
                this.createDomaYukaDehabaCenterPole(abstractTerraceUnitItem, parts);
            }
            if (terracesInfo.mEnforcementType == EnforcementType.BUBUN_KAKOI && terraceInfo.mIsMaster.booleanValue()) {
                this.createBubunKakoiCenterPole(abstractTerraceUnitItem, parts);
            }
        }
    }

    private void createStandard(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        float f = sNYEntities.mPartsFigureInfo.mHeight.floatValue();
        float f2 = terraceInfo.mDepth.floatValue();
        float f3 = abstractTerraceUnitItem.getWidthL();
        float f4 = abstractTerraceUnitItem.getWidthR();
        float f5 = -f2;
        float f6 = sNYEntities.mPartsFigureInfo.mBottomHeight.floatValue();
        Color color = SNYColor.getColor(this.mShapeColorManager.getColor(0));
        if (terracesInfo.mEnforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI) {
            f5 = -terracesInfo.mDepth.floatValue();
        }
        if (!this.mPartsFigureService.isPrevRoof(abstractTerraceUnitItem)) {
            this.createPillar(f3, f5, f6, f, color, vector);
        } else {
            f3 = -terraceInfo.mWidth.floatValue() / 2.0f;
            this.createPillar(f3, f5, f6, f, color, vector);
        }
        if (!this.mPartsFigureService.isNextRoof(abstractTerraceUnitItem)) {
            this.createPillar(f4, f5, f6, f, color, vector);
        }
        if (terracesInfo.mEnforcementType == EnforcementType.HANEDASHI && terraceInfo.mIsStarting.booleanValue()) {
            float f7;
            float f8;
            float f9;
            float f10 = sNYEntities.mPartsFigureInfo.mWallHeight.floatValue() + sNYEntities.mPartsFigureInfo.mTooshiHeight.floatValue() - 70.0f;
            if (terracesInfo.mLeftHanedashiLen.floatValue() != 0.0f) {
                f5 = 35.0f;
                this.createPillar(f3, f5, f6, f10, color, vector);
                f3 = -terraceInfo.mWidth.floatValue() / 2.0f + terracesInfo.mLeftHanedashiLen.floatValue() - 35.0f;
                this.createPillar(f3, f5, f6, f10, color, vector);
                f9 = -terraceInfo.mWidth.floatValue() / 2.0f - 35.0f - 22.5f;
                f8 = -terraceInfo.mWidth.floatValue() / 2.0f + terracesInfo.mLeftHanedashiLen.floatValue();
                f7 = f10;
                this.createHanedashizai(f9, f8, f5, f7, color, vector);
            }
            if (terracesInfo.mRightHanedashiLen.floatValue() != 0.0f) {
                f5 = 35.0f;
                this.createPillar(f4, f5, f6, f10, color, vector);
                f3 = terraceInfo.mWidth.floatValue() / 2.0f - terracesInfo.mRightHanedashiLen.floatValue() + 35.0f;
                this.createPillar(f3, f5, f6, f10, color, vector);
                f9 = terraceInfo.mWidth.floatValue() / 2.0f - terracesInfo.mRightHanedashiLen.floatValue();
                f8 = terraceInfo.mWidth.floatValue() / 2.0f + 35.0f + 22.5f;
                f7 = f10;
                this.createHanedashizai(f9, f8, f5, f7, color, vector);
            }
        }
    }

    private void createHalfStandard(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo cfr_ignored_0 = sNYEntities.mTerracesInfo;
        float f = sNYEntities.mPartsFigureInfo.mKutaiUniversalPillarHeight1.floatValue();
        float f2 = sNYEntities.mPartsFigureInfo.mKutaiUniversalPillarDepth1.floatValue();
        float f3 = abstractTerraceUnitItem.getWidthL();
        float f4 = abstractTerraceUnitItem.getWidthR();
        float f5 = -f2;
        float f6 = sNYEntities.mPartsFigureInfo.mBottomHeight.floatValue();
        Color color = SNYColor.getColor(this.mShapeColorManager.getColor(0));
        if (abstractTerraceUnitItem.getPrev() == null) {
            this.createPillar(f3, f5, f6, f, color, vector);
        } else {
            f3 = -terraceInfo.mWidth.floatValue() / 2.0f;
            this.createPillar(f3, f5, f6, f, color, vector);
        }
        if (abstractTerraceUnitItem.getNext() == null) {
            this.createPillar(f4, f5, f6, f, color, vector);
        }
    }

    private void createStandardFreely(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo cfr_ignored_0 = sNYEntities.mTerracesInfo;
        float f = abstractTerraceUnitItem.getWidthL();
        float f2 = abstractTerraceUnitItem.getWidthR();
        float f3 = sNYEntities.mPartsFigureInfo.mBottomHeight.floatValue();
        Color color = SNYColor.getColor(this.mShapeColorManager.getColor(0));
        if (abstractTerraceUnitItem.getPrev() == null) {
            this.createPillar(f, -sNYEntities.mPartsFigureInfo.mKutaiUniversalPillarDepth1.floatValue(), f3, sNYEntities.mPartsFigureInfo.mKutaiUniversalPillarHeight1.floatValue(), color, vector);
        } else {
            f = -terraceInfo.mWidth.floatValue() / 2.0f;
            this.createPillar(f, -sNYEntities.mPartsFigureInfo.mKutaiUniversalPillarDepth1.floatValue(), f3, sNYEntities.mPartsFigureInfo.mKutaiUniversalPillarHeight1.floatValue(), color, vector);
        }
        if (abstractTerraceUnitItem.getNext() == null) {
            this.createPillar(f2, -sNYEntities.mPartsFigureInfo.mKutaiUniversalPillarDepth1.floatValue(), f3, sNYEntities.mPartsFigureInfo.mKutaiUniversalPillarHeight1.floatValue(), color, vector);
        }
    }

    private void createDesumi(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo cfr_ignored_0 = sNYEntities.mTerracesInfo;
        float f = sNYEntities.mPartsFigureInfo.mHeight.floatValue();
        float f2 = terraceInfo.mDepth.floatValue();
        float f3 = abstractTerraceUnitItem.getWidthL();
        float f4 = abstractTerraceUnitItem.getWidthR();
        float f5 = -f2;
        float f6 = sNYEntities.mPartsFigureInfo.mBottomHeight.floatValue();
        Color color = SNYColor.getColor(this.mShapeColorManager.getColor(0));
        if (terraceInfo.mBuildingType != BuildingType.CORNER) {
            if (sNYEntities.mBasicInfo.mKetaType == KetaType.FREE) {
                f5 = -sNYEntities.mPartsFigureInfo.mKutaiUniversalPillarDepth1.floatValue();
                f = sNYEntities.mPartsFigureInfo.mKutaiUniversalPillarHeight1.floatValue();
            }
            if (abstractTerraceUnitItem.getPrev() == null) {
                this.createPillar(f3, f5, f6, f, color, vector);
            } else if (abstractTerraceUnitItem.getPrev().getTerraceInfo().mBuildingType != BuildingType.CORNER) {
                f3 = -terraceInfo.mWidth.floatValue() / 2.0f;
                this.createPillar(f3, f5, f6, f, color, vector);
            }
            if (abstractTerraceUnitItem.getNext() == null) {
                this.createPillar(f4, f5, f6, f, color, vector);
            } else if (abstractTerraceUnitItem.getNext().getTerraceInfo().mBuildingType == BuildingType.CORNER) {
                f3 = terraceInfo.mWidth.floatValue() / 2.0f;
            }
        } else {
            float f7 = terraceInfo.mWidth.floatValue();
            if (sNYEntities.mBasicInfo.mKetaType == KetaType.FREE) {
                f5 = -sNYEntities.mPartsFigureInfo.mKutaiUniversalPillarDepth1.floatValue();
                f7 = f2 - (float)((double)(f2 - sNYEntities.mPartsFigureInfo.mKutaiUniversalPillarDepth1.floatValue()) * Math.tan(Math.toRadians(45.0)));
                f = sNYEntities.mPartsFigureInfo.mKutaiUniversalPillarHeight1.floatValue();
            }
            this.createPillar(f7, f5, f6, f, color, vector);
        }
    }

    private void createIrisumi(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        float f = sNYEntities.mPartsFigureInfo.mHeight.floatValue();
        float f2 = terraceInfo.mDepth.floatValue();
        float f3 = abstractTerraceUnitItem.getWidthL();
        float f4 = abstractTerraceUnitItem.getWidthR();
        float f5 = -f2;
        float f6 = sNYEntities.mPartsFigureInfo.mBottomHeight.floatValue();
        Color color = SNYColor.getColor(this.mShapeColorManager.getColor(0));
        if (terraceInfo.mBuildingType != BuildingType.CORNER) {
            if (sNYEntities.mBasicInfo.mKetaType == KetaType.FREE) {
                f5 = -sNYEntities.mPartsFigureInfo.mKutaiUniversalPillarDepth1.floatValue();
                f = sNYEntities.mPartsFigureInfo.mKutaiUniversalPillarHeight1.floatValue();
            }
            if (abstractTerraceUnitItem.getPrev() == null) {
                this.createPillar(f3, f5, f6, f, color, vector);
            } else if (abstractTerraceUnitItem.getPrev().getTerraceInfo().mBuildingType == null) {
                f3 = -terraceInfo.mWidth.floatValue() / 2.0f;
                this.createPillar(f3, f5, f6, f, color, vector);
            }
            if (abstractTerraceUnitItem.getNext() == null) {
                this.createPillar(f4, f5, f6, f, color, vector);
            } else {
                BuildingType cfr_ignored_0 = abstractTerraceUnitItem.getNext().getTerraceInfo().mBuildingType;
            }
        } else {
            float f7 = terraceInfo.mDepth.floatValue();
            float f8 = -terracesInfo.mDepth.floatValue();
            if (sNYEntities.mBasicInfo.mKetaType == KetaType.FREE) {
                f7 = f2 - (float)((double)(f2 - sNYEntities.mPartsFigureInfo.mKutaiUniversalPillarDepth1.floatValue()) * Math.tan(Math.toRadians(45.0)));
                f8 = -f7;
                f = sNYEntities.mPartsFigureInfo.mKutaiUniversalPillarHeight1.floatValue();
            }
            this.createPillar(f7, f8, f6, f, color, vector);
            float f9 = f7;
            float f10 = f8 - 35.0f;
            float f11 = sNYEntities.mPartsFigureInfo.mYukaHeight.floatValue();
            float f12 = f;
            this.createAttachment(f9, f10, f11, f12, 0.0f, color, vector);
            f9 = f7 + 35.0f;
            f10 = f8;
            this.createAttachment(f9, f10, f11, f12, 90.0f, color, vector);
        }
    }

    private void createBubunIrisumi(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        float f = sNYEntities.mPartsFigureInfo.mHeight.floatValue();
        float f2 = terraceInfo.mDepth.floatValue();
        float f3 = -terraceInfo.mWidth.floatValue() / 2.0f;
        float f4 = terraceInfo.mWidth.floatValue() / 2.0f;
        float f5 = -f2;
        float f6 = sNYEntities.mPartsFigureInfo.mBottomHeight.floatValue();
        Color color = SNYColor.getColor(this.mShapeColorManager.getColor(0));
        if (abstractTerraceUnitItem.getPrev() == null) {
            this.createPillar(f3, f5, f6, f, color, vector);
        } else {
            f3 = -terraceInfo.mWidth.floatValue() / 2.0f;
            this.createPillar(f3, f5, f6, f, color, vector);
        }
        if (abstractTerraceUnitItem.getNext() == null) {
            this.createPillar(f4, f5, f6, f, color, vector);
        }
        if (terracesInfo.mEnforcementDirType == EnforcementDirType.L && terraceInfo.mIsLeftEnd.booleanValue()) {
            f5 = terraceInfo.mLeftDepth.floatValue() - terraceInfo.mDepth.floatValue();
            f = this.mPartsFigureService.getYaneuraHeight(sNYEntities, terraceInfo.mDepth.floatValue(), f5);
            this.createPillar(f3, f5, f6, f - 10.0f, color, vector);
        }
        if (terracesInfo.mEnforcementDirType == EnforcementDirType.R && terraceInfo.mIsRightEnd.booleanValue()) {
            f5 = terraceInfo.mRightDepth.floatValue() - terraceInfo.mDepth.floatValue();
            f = this.mPartsFigureService.getYaneuraHeight(sNYEntities, terraceInfo.mDepth.floatValue(), f5);
            this.createPillar(f4, f5, f6, f - 10.0f, color, vector);
        }
    }

    private void createAlmiBalconyPillar(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo cfr_ignored_0 = sNYEntities.mTerracesInfo;
        float f = sNYEntities.mPartsFigureInfo.mHeight.floatValue();
        float f2 = terraceInfo.mDepth.floatValue();
        float f3 = abstractTerraceUnitItem.getWidthL();
        float f4 = abstractTerraceUnitItem.getWidthR();
        float f5 = -f2;
        float f6 = sNYEntities.mPartsFigureInfo.mBottomHeight.floatValue() - 550.0f + 450.0f;
        Color color = SNYColor.getColor(this.mShapeColorManager.getColor(0));
        if (abstractTerraceUnitItem.getPrev() == null) {
            this.createPillar(f3, f5, f6, f, color, vector);
        } else {
            f3 = -terraceInfo.mWidth.floatValue() / 2.0f;
            this.createPillar(f3, f5, f6, f, color, vector);
        }
        if (abstractTerraceUnitItem.getNext() == null) {
            this.createPillar(f4, f5, f6, f, color, vector);
        }
    }

    private void createAlmiBalconyRoof(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo cfr_ignored_0 = sNYEntities.mTerracesInfo;
        float f = sNYEntities.mPartsFigureInfo.mHeight.floatValue();
        float f2 = terraceInfo.mDepth.floatValue();
        float f3 = abstractTerraceUnitItem.getWidthL();
        float f4 = abstractTerraceUnitItem.getWidthR();
        float f5 = -f2;
        float f6 = sNYEntities.mPartsFigureInfo.mBottomHeight.floatValue() - 250.0f + 450.0f;
        Color color = SNYColor.getColor(this.mShapeColorManager.getColor(0));
        if (abstractTerraceUnitItem.getPrev() == null) {
            this.createPillar(f3, f5, f6, f, color, vector);
            this.createPillarFoot(f3, f5, f6, color, vector);
        } else {
            f3 = -terraceInfo.mWidth.floatValue() / 2.0f;
            this.createPillar(f3, f5, f6, f, color, vector);
            this.createPillarFoot(f3, f5, f6, color, vector);
        }
        if (abstractTerraceUnitItem.getNext() == null) {
            this.createPillar(f4, f5, f6, f, color, vector);
            this.createPillarFoot(f4, f5, f6, color, vector);
        }
        if (sNYEntities.mTerraceInfoList.size() > 1 && GdMutableTypeUtil.matchOR(terraceInfo.mWidthType, TerraceWidthType.T15, TerraceWidthType.T20)) {
            f3 = 0.0f;
            f = sNYEntities.mPartsFigureInfo.mYukaHeight.floatValue() - 155.0f;
            this.createPillar(f3, f5, f6, f, color, vector);
            this.createPillarFoot(f3, f5, f6, color, vector);
        }
    }

    private void createDomaYukaKaikouCenterPole(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        float f = sNYEntities.mPartsFigureInfo.mHeight.floatValue();
        float f2 = 0.0f;
        float f3 = -terraceInfo.mDepth.floatValue();
        float f4 = sNYEntities.mPartsFigureInfo.mBottomHeight.floatValue();
        Color color = SNYColor.getColor(this.mShapeColorManager.getColor(0));
        f2 = terracesInfo.mEnforcementDirType == EnforcementDirType.L ? terraceInfo.mWidth.floatValue() / 2.0f - terraceInfo.mRightWidth.floatValue() : -terraceInfo.mWidth.floatValue() / 2.0f + terraceInfo.mLeftWidth.floatValue();
        this.createPillar(f2, f3, f4, f, color, vector);
    }

    private void createDomaYukaDehabaCenterPole(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo cfr_ignored_0 = sNYEntities.mTerracesInfo;
        float f = sNYEntities.mPartsFigureInfo.mKutaiUniversalPillarHeight1.floatValue();
        float f2 = terraceInfo.mBackDepth.floatValue();
        float f3 = abstractTerraceUnitItem.getWidthL();
        float f4 = abstractTerraceUnitItem.getWidthR();
        float f5 = -f2;
        float f6 = sNYEntities.mPartsFigureInfo.mBottomHeight.floatValue();
        Color color = SNYColor.getColor(this.mShapeColorManager.getColor(0));
        if (abstractTerraceUnitItem.getPrev() == null) {
            this.createPillar(f3, f5, f6, f, color, vector);
        }
        if (abstractTerraceUnitItem.getNext() == null) {
            this.createPillar(f4, f5, f6, f, color, vector);
        }
    }

    private void createBubunKakoiCenterPole(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        float f = sNYEntities.mPartsFigureInfo.mHeight.floatValue();
        float f2 = 0.0f;
        float f3 = -terraceInfo.mDepth.floatValue();
        float f4 = sNYEntities.mPartsFigureInfo.mBottomHeight.floatValue();
        Color color = SNYColor.getColor(this.mShapeColorManager.getColor(0));
        f2 = terracesInfo.mEnforcementDirType == EnforcementDirType.L ? -terraceInfo.mWidth.floatValue() / 2.0f + terraceInfo.mLeftWidth.floatValue() : terraceInfo.mWidth.floatValue() / 2.0f - terraceInfo.mRightWidth.floatValue();
        this.createPillar(f2, f3, f4, f, color, vector);
    }

    private void createPillar(float f, float f2, float f3, float f4, Color color, List<Parts> list) {
        PPillar pPillar = new PPillar();
        pPillar.set(f, f2, f3, f4, color);
        list.add(pPillar);
    }

    private void createPillar(float f, float f2, float f3, float f4, float f5, Color color, List<Parts> list) {
        PPillar pPillar = new PPillar();
        pPillar.setAngle(f, f2, f3, f4, f5, color);
        list.add(pPillar);
    }

    private void createProjectionPillar(float f, float f2, float f3, float f4, Color color, List<Parts> list) {
        PProjectingPillar pProjectingPillar = new PProjectingPillar();
        pProjectingPillar.set(f, f2, f3, f4, color);
        list.add(pProjectingPillar);
    }

    private void createHanedashizai(float f, float f2, float f3, float f4, Color color, List<Parts> list) {
        PHanedashizai pHanedashizai = new PHanedashizai();
        pHanedashizai.set(f, f2, f3, f4, color);
        list.add(pHanedashizai);
    }

    private void createPillarFoot(float f, float f2, float f3, Color color, List<Parts> list) {
        PPillarFoot pPillarFoot = new PPillarFoot();
        pPillarFoot.set(f, f2, f3, 0.0f, color);
        list.add(pPillarFoot);
    }

    private void createAttachment(float f, float f2, float f3, float f4, float f5, Color color, List<Parts> list) {
        PPillarAttachment pPillarAttachment = new PPillarAttachment();
        pPillarAttachment.set(f, f2, f3, f4, f5, color);
        list.add(pPillarAttachment);
    }
}

