/*
 * Decompiled with CFR 0.152.
 */
package option.loneterrace.shape.sunnyge.model.sunnyge.creator;

import java.awt.Color;
import java.util.Vector;
import model.parts.Parts;
import option.loneterrace.common.entity.BasicInfo;
import option.loneterrace.common.entity.PartsFigureUnitInfo;
import option.loneterrace.common.entity.SNYEntities;
import option.loneterrace.common.entity.TerraceInfo;
import option.loneterrace.common.entity.TerracesInfo;
import option.loneterrace.common.entity.type.TypeTerraceDepthInfo;
import option.loneterrace.common.service.common.SNYColor;
import option.loneterrace.common.type.BuildingType;
import option.loneterrace.common.type.EnforcementDirType;
import option.loneterrace.common.type.EnforcementType;
import option.loneterrace.common.type.RoofFigureType;
import option.loneterrace.common.type.StrengthType;
import option.loneterrace.common.type.TerraceDepthType;
import option.loneterrace.shape.sunnyge.model.sunnyge.creator.SNYTerraceUnitCreator;
import option.loneterrace.shape.sunnyge.model.sunnyge.item.AbstractTerraceUnitItem;
import option.loneterrace.shape.sunnyge.model.sunnyge.item.MsItemTerrace;
import option.loneterrace.shape.sunnyge.model.sunnyge.parts.PNobuchi;

public class MsUnitNobuchiCreator
extends SNYTerraceUnitCreator {
    @Override
    public void create(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        if (!this.mPartsFigureService.isUseRoof(sNYEntities, terraceInfo)) {
            return;
        }
        if (terraceInfo.mDepthType == TerraceDepthType.T2) {
            return;
        }
        EnforcementType enforcementType = terracesInfo.mEnforcementType;
        if (terraceInfo.mBuildingType != BuildingType.CORNER && (enforcementType == EnforcementType.DESUMI || enforcementType == EnforcementType.IRISUMI)) {
            enforcementType = EnforcementType.STD;
        }
        if (enforcementType == EnforcementType.STD || enforcementType == EnforcementType.HANEDASHI || enforcementType == EnforcementType.DOMA_YUKA_D || enforcementType == EnforcementType.DOMA_YUKA_W || enforcementType == EnforcementType.BUBUN_IRISUMI || enforcementType == EnforcementType.BUBUN_KAKOI) {
            this.createStandard(abstractTerraceUnitItem, parts);
        } else if (enforcementType == EnforcementType.IRISUMI) {
            this.createIrisumi(abstractTerraceUnitItem, parts);
        } else if (enforcementType == EnforcementType.DESUMI) {
            this.createDesumi(abstractTerraceUnitItem, parts);
        } else if (enforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI) {
            this.createKutaiDehabaChigai(abstractTerraceUnitItem, parts);
        }
    }

    private void createStandard(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        double d = terraceInfo.mWidth.floatValue() / 2.0f;
        double d2 = -d + 5.0;
        double d3 = d - 5.0;
        double d4 = 0.0;
        double d5 = 10.0;
        double d6 = Math.tan(Math.toRadians(10.0));
        double[] dArray = this.getNobuchiPich(sNYEntities.mBasicInfo, terracesInfo, terraceInfo);
        int n = dArray.length;
        double d7 = sNYEntities.mPartsFigureInfo.mWallHeight.floatValue() + sNYEntities.mPartsFigureInfo.mTooshiHeight.floatValue();
        double d8 = 0.0;
        int n2 = 0;
        while (n2 < n) {
            d4 = (d8 -= dArray[n2]) * d6 + d7 - 8.0;
            vector.add(this.createNobuchi(d2, d3, d8, d4, d5, 0.0));
            ++n2;
        }
    }

    private void createIrisumi(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        double d = terraceInfo.mDepth.floatValue();
        double d2 = terraceInfo.mWidth.floatValue() / 2.0f;
        double d3 = -d2 + 5.0;
        double d4 = d2 - 5.0;
        double d5 = 0.0;
        double d6 = 10.0;
        double d7 = Math.tan(Math.toRadians(10.0));
        double[] dArray = this.getNobuchiPich(sNYEntities.mBasicInfo, terracesInfo, terraceInfo);
        int n = dArray.length;
        double d8 = sNYEntities.mPartsFigureInfo.mWallHeight.floatValue() + sNYEntities.mPartsFigureInfo.mTooshiHeight.floatValue();
        double d9 = 0.0;
        double d10 = 0.0;
        int n2 = 0;
        while (n2 < n) {
            d3 = d10 += dArray[n2];
            d4 = d3 + (d - d10) + 139.0;
            d9 = -d10;
            d5 = -d10 * d7 + d8 - 8.0;
            vector.add(this.createNobuchi(d3, d4, d9, d5, d6, 0.0));
            ++n2;
        }
        d3 = 0.0;
        d10 = 0.0;
        n2 = 0;
        while (n2 < n) {
            d4 = (d3 += dArray[n2]) + (d - d3) + 139.0;
            d9 = -d - 139.0;
            d5 = -d3 * d7 + d8 - 8.0;
            vector.add(this.createNobuchi(d3, d4, d9, d5, d6, 90.0));
            ++n2;
        }
    }

    private void createDesumi(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        double d = terraceInfo.mWidth.floatValue() / 2.0f;
        double d2 = -d + 5.0;
        double d3 = d - 5.0;
        double d4 = 0.0;
        double d5 = 10.0;
        double d6 = Math.tan(Math.toRadians(10.0));
        double[] dArray = this.getNobuchiPich(sNYEntities.mBasicInfo, terracesInfo, terraceInfo);
        int n = dArray.length;
        double d7 = sNYEntities.mPartsFigureInfo.mWallHeight.floatValue() + sNYEntities.mPartsFigureInfo.mTooshiHeight.floatValue();
        double d8 = 0.0;
        int n2 = 0;
        while (n2 < n) {
            d2 = -97.5;
            d3 = -(d8 -= dArray[n2]);
            d4 = d8 * d6 + d7 - 8.0;
            vector.add(this.createNobuchi(d2, d3, d8, d4, d5, 0.0));
            ++n2;
        }
        double d9 = 0.0;
        int n3 = 0;
        while (n3 < n) {
            d2 = d9 += dArray[n3];
            d3 = d9 * 2.0 + 97.5;
            d8 = -d9;
            d4 = -d9 * d6 + d7 - 8.0;
            vector.add(this.createNobuchi(d2, d3, d8, d4, d5, 90.0));
            ++n3;
        }
    }

    private void createKutaiDehabaChigai(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        double d = terraceInfo.mDepth.floatValue();
        double d2 = terraceInfo.mWidth.floatValue() / 2.0f;
        double d3 = -d2 + 5.0;
        double d4 = d2 - 5.0;
        double d5 = 0.0;
        double d6 = 10.0;
        double d7 = Math.tan(Math.toRadians(10.0));
        double[] dArray = this.getNobuchiPich(sNYEntities.mBasicInfo, terracesInfo, terraceInfo);
        int n = dArray.length;
        double d8 = sNYEntities.mPartsFigureInfo.mKutaiKutaiW.floatValue();
        double d9 = sNYEntities.mPartsFigureInfo.mWallHeight.floatValue() + sNYEntities.mPartsFigureInfo.mTooshiHeight.floatValue();
        if (terraceInfo.mIsMaster.booleanValue()) {
            PartsFigureUnitInfo partsFigureUnitInfo = this.mPartsFigureService.findOnePartsFigureUnitInfo(sNYEntities.mPartsFigureUnitInfoList, terraceInfo);
            double d10 = 0.0;
            double d11 = 0.0;
            if (partsFigureUnitInfo != null) {
                d10 = partsFigureUnitInfo.mLeftKutaiDehabaWidth.floatValue();
                d11 = partsFigureUnitInfo.mRightKutaiDehabaWidth.floatValue();
            }
            d = terracesInfo.mDepth.floatValue();
            d8 = terracesInfo.mEnforcementDirType == EnforcementDirType.R ? d - (double)terraceInfo.mRightDepth.floatValue() : d - (double)terraceInfo.mLeftDepth.floatValue();
            double d12 = 0.0;
            int n2 = 0;
            while (n2 < n) {
                d5 = (d12 -= dArray[n2]) * d7 + d9 - 10.0;
                double d13 = d3;
                double d14 = d4;
                if (terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
                    if (Math.abs(d12) <= d8) {
                        d13 = d3 + d10;
                    }
                } else if (Math.abs(d12) <= d8) {
                    d14 = d4 - d11;
                }
                vector.add(this.createNobuchi(d13, d14, d12, d5, d6, 0.0));
                ++n2;
            }
        } else {
            d8 = terracesInfo.mDepth.floatValue() - terraceInfo.mDepth.floatValue();
            double d15 = 0.0;
            int n3 = 0;
            while (n3 < n) {
                d5 = (d15 -= dArray[n3]) * d7 + d9 - 10.0;
                if (!(Math.abs(d15) <= d8)) {
                    vector.add(this.createNobuchi(d3, d4, d15, d5, d6, 0.0));
                }
                ++n3;
            }
        }
    }

    private PNobuchi createNobuchi(double d, double d2, double d3, double d4, double d5, double d6) {
        Color color = SNYColor.getColor(this.mShapeColorManager.getColor(0));
        PNobuchi pNobuchi = new PNobuchi();
        pNobuchi.set(d, d2, d3, d4, d5, d6, color);
        return pNobuchi;
    }

    protected double[] getNobuchiPich(BasicInfo basicInfo, TerracesInfo terracesInfo, TerraceInfo terraceInfo) {
        if (terracesInfo.mEnforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI) {
            TerraceDepthType terraceDepthType = this.mPartsFigureService.getDepthType(terracesInfo.mDepthType, terracesInfo.mDepth);
            return this.getNobuchiPich(basicInfo.mRoofFigureType, terraceDepthType, basicInfo.mStrengthType, 0.0f);
        }
        TerraceDepthType terraceDepthType = this.mPartsFigureService.getDepthType(terraceInfo.mDepthType, terraceInfo.mDepth);
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneStdByType(terraceDepthType);
        float f = typeTerraceDepthInfo.length.floatValue() - terraceInfo.mDepth.floatValue();
        return this.getNobuchiPich(basicInfo.mRoofFigureType, terraceDepthType, basicInfo.mStrengthType, f);
    }

    double[] getNobuchiPich(RoofFigureType roofFigureType, TerraceDepthType terraceDepthType, StrengthType strengthType, float f) {
        double[] dArray = null;
        if (roofFigureType == RoofFigureType.F) {
            if (terraceDepthType == TerraceDepthType.T3) {
                dArray = new double[]{434.0};
            } else if (terraceDepthType == TerraceDepthType.T4) {
                dArray = new double[]{584.0};
            } else if (terraceDepthType == TerraceDepthType.T5) {
                dArray = new double[]{495.0, 478.0};
            } else if (terraceDepthType == TerraceDepthType.T6) {
                dArray = new double[]{595.0, 578.0};
            } else if (terraceDepthType == TerraceDepthType.T7) {
                dArray = strengthType == StrengthType.T600 ? new double[]{530.0, 507.0, 507.0} : new double[]{695.0, 678.0};
            } else if (terraceDepthType == TerraceDepthType.T8) {
                dArray = new double[]{795.0, 778.0};
            } else if (terraceDepthType == TerraceDepthType.T9) {
                dArray = new double[]{895.0, 879.0};
            } else if (terraceDepthType == TerraceDepthType.T10) {
                dArray = new double[]{995.0, 878.0};
            } else if (terraceDepthType == TerraceDepthType.T12) {
                dArray = new double[]{1196.0, 1177.0};
            } else if (terraceDepthType == TerraceDepthType.T15) {
                dArray = new double[]{1495.0, 1477.0};
            }
        } else if (roofFigureType == RoofFigureType.R) {
            if (terraceDepthType == TerraceDepthType.T3) {
                dArray = new double[]{534.0};
            } else if (terraceDepthType == TerraceDepthType.T4) {
                dArray = new double[]{834.0};
            } else if (terraceDepthType == TerraceDepthType.T5) {
                dArray = new double[]{576.0, 558.0};
            } else if (terraceDepthType == TerraceDepthType.T6) {
                dArray = new double[]{726.0, 708.0};
            } else if (terraceDepthType == TerraceDepthType.T7) {
                dArray = new double[]{876.0, 858.0};
            } else if (terraceDepthType == TerraceDepthType.T8) {
                dArray = new double[]{1026.0, 1008.0};
            } else if (terraceDepthType == TerraceDepthType.T9) {
                dArray = new double[]{1176.0, 1158.0};
            } else if (terraceDepthType == TerraceDepthType.T10) {
                dArray = new double[]{1326.0, 1308.0};
            }
        }
        if (dArray != null && f != 0.0f && dArray.length > 0 && f > 0.0f) {
            dArray[0] = dArray[0] - (double)f;
        }
        return dArray;
    }
}

